/* $Header: cpulib.c,v 6.4 86/09/14 20:23:31 peter Exp $ */
/* (C) Copyright 1985 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"

#include <sys/param.h>

#if (OP_SYS == SYSV)
#include <signal.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#define cbUserPage (ctob(USIZE))
#endif

#if (MFG == SIEMENS)
#include <sys/types.h>
#include <signal.h>
#include <sys/param.h>
#include <sys/vtimes.h>
#endif /* (MFG == SIEMENS) */

#include <sys/dir.h>
#include <sys/user.h>

#if (OP_SYS == BSD42)
#define cbUserPage (NBPG*UPAGES)
#endif /* (OP_SYS == BSD42) */

export uint4 vcbUserPage = cbUserPage;

typedef union {
	long	lng;
	struct { short	shortHi, shortLo; } shorts;
	struct { char	chHiHi, chHiLo, chLoHi, chLoLo; } chars;
	} SELECTU;



#ifndef X_ListRegisters
/* L I S T   R E G I S T E R S */

export void ListRegisters(sbRegs)
SBT	sbRegs;
{
    int		i;
    pSER	se;
    MODER	amode;

    vmode->cnt = 1;
    vmode->df = dfNil;
    vmode->len = -1;
    GetMode(vmode);
    if (vmode->df == dfNil)
	amode = *vmode;

    if ((v->pid == pidNil) AND (v->fnCore == fnNil))
	UError("No process.");

    ColOn();
    se = v->cpu->rgReg;
    for (i = 0; i < v->cpu->iregMax; i++, se++) {
	if ( (sbRegs != sbNil)
	      AND (!FHdrCmp(sbRegs, SbFIss(se->asym.iss))) ) 
	    continue;	/* not interesting */
	PadTo((i%4) * 20);
	DisplaySe(se, vmode, true, true, true);
	if (amode.df == dfNil)
	    *vmode = amode;
	if (i%4 == 3)
	    printf("\n");
    } /* for */
    if (i%4 != 0)
	printf("\n");
    ColOff();
} /* ListRegisters */
#endif /* X_ListRegisters */


#ifndef X_GetByte
/* G E T   B Y T E */

export uint1 GetByte(adr, space)
ADRT	adr;
int2	space;
{
    SELECTU	select;
    ADRT        adrOnWord;

    adrOnWord = adr & ~v->cpu->alignment;
    select.lng = Access(accRead, adrOnWord, space, 0);

    if (v->cpu->byteSex == vcpuHost->byteSex) {
	switch (adr & v->cpu->alignment) {
	    case 0:	return(select.chars.chHiHi);
	    case 1:	return(select.chars.chHiLo);
	    case 2:	return(select.chars.chLoHi);
	    case 3:	return(select.chars.chLoLo);
	} /* switch */
    } else {
	switch (adr & v->cpu->alignment) {
	    case 0:	return(select.chars.chLoLo);
	    case 1:	return(select.chars.chLoHi);
	    case 2:	return(select.chars.chHiLo);
	    case 3:	return(select.chars.chHiHi);
	} /* switch */
    } /* if */
} /* GetByte */
#endif /* X_GetByte */


#ifndef X_PutByte
/* P U T   B Y T E */

export void PutByte(adr, space, val)
ADRT    adr;
int2    space;
uint1	val;
{
    SELECTU	select;
    ADRT	adrOnWord;

    adrOnWord = adr & ~v->cpu->alignment;
    select.lng = Access(accRead, adrOnWord, space, 0);

    if (v->cpu->byteSex == vcpuHost->byteSex) {
	switch (adr & v->cpu->alignment) {
	    case 0:	select.chars.chHiHi = val; break;
	    case 1:	select.chars.chHiLo = val; break;
	    case 2:	select.chars.chLoHi = val; break;
	    case 3:	select.chars.chLoLo = val; break;
	} /* switch */
    } else {
	switch (adr & v->cpu->alignment) {
	    case 0:	select.chars.chLoLo = val; break;
	    case 1:	select.chars.chLoHi = val; break;
	    case 2:	select.chars.chHiLo = val; break;
	    case 3:	select.chars.chHiHi = val; break;
	} /* switch */
    } /* if */

    Access(accWrite, adrOnWord, space, select.lng);
} /* PutByte */
#endif /* X_PutByte */


#ifndef X_GetBlock
/* G E T   B L O C K */

export void GetBlock(adrSrc, space, adrDest, cb)
FAST ADRT	adrSrc, adrDest;
int2	space, cb;
{
    int2	*pShort;
    int4	*pLong;
    char        *pCh;
    ADRT	adrSave = adrDest;
    SELECTU	select;

    if (((adrSrc ^ adrDest) & v->cpu->alignment) == 0) {
	/* addresses are in sync RE alignment */

	while (adrSrc & v->cpu->alignment) {
	    /* they're off alignment - move both to next boundary */
	    pCh = (char *) adrDest;	/* point to receiving area */
	    *pCh = GetByte(adrSrc++, space);
	    adrDest++;
	} /* while */

	if (cb == 2) {
	    /* special check for shorts */
	    select.lng = GetWord(adrSrc, space);
	    pShort = (int2 *) adrDest;
	    if (v->cpu->byteSex == vcpuHost->byteSex)
		*pShort = select.shorts.shortHi;
	    else
		*pShort = select.shorts.shortLo;
	    return;
	} /* if */

	pLong = (int4 *) adrDest;	/* point to receiving area */
	while (cb >= v->cpu->cbInt) {
	    *pLong++ = GetWord(adrSrc, space);
	    adrSrc += v->cpu->cbInt;
	    cb -= v->cpu->cbInt;
	} /* while */
	adrDest = (ADRT) pLong;
    } /* if */

    /* This last loop handles odd bytes OR blocks which were
     * not in sync RE alignment.
     */
    pCh = (char *) adrDest;	/* point to receiving area */
    while (cb--)
	*pCh++ = GetByte(adrSrc++, space);
} /* GetBlock */
#endif /* X_GetBlock */


#ifndef X_PutBlock
/* P U T   B L O C K */

export void PutBlock(adrDest, space, adrSrc, cb)
ADRT    adrDest, adrSrc;
int2	space, cb;
{
    int2	*pShort;
    int		*pLong;
    char        *pCh;
    SELECTU	select;

    if (((adrSrc ^ adrDest) & v->cpu->alignment) == 0) {

	/* addresses are in sync RE alignment */
	while (adrSrc & v->cpu->alignment) {
	    /* they're off alignment - move both to next boundary */
	    pCh = (char *) adrDest;	/* point to receiving area */
	    *pCh = GetByte(adrSrc++, space);
	    adrDest++;
	} /* while */

	if (cb == 2) {
	    /* special check for shorts */
	    pShort = (short *) adrSrc;
	    select.lng = GetWord(adrDest, space);
	    if (v->cpu->byteSex == vcpuHost->byteSex)
		select.shorts.shortHi = *pShort;
	    else
		select.shorts.shortLo = *pShort;
	    PutWord(adrDest, space, select.lng);
	    return;
	} /* if */

	pLong = (int4 *) adrSrc;	/* point to receiving area */
	while (cb >= v->cpu->cbInt) {
	    PutWord(adrDest, space, *pLong++);
	    adrDest += v->cpu->cbInt;
	    cb -= v->cpu->cbInt;
	} /* while */
	adrSrc = (ADRT) pLong;
    } /* if */

    /* This last loop handles odd bytes OR blocks which were
     * not in sync RE alignment.
     */
    pCh = (char *) adrSrc;	/* point to receiving area */
    while (cb--)
	PutByte(adrDest++, space, *pCh++);
} /* PutBlock */
#endif /* X_PutBlock */


#ifndef X_AdrFReg
/* A D R   F   R E G */

export ADRT AdrFReg(reg)
int	reg;
{
    if (vrgOffset[reg] == NAR)
	return(adrNil);

    if (v->os->adrReg0 == 0) {
	return(reg);
    } else {
	if (vrgOffset[reg] == NAR)
	    return(adrNil);
	if (v->os->adrReg0 == adrNil)
	    return(vrgOffset[reg]);
	else
	   return((ADRT)(v->os->adrReg0 + v->cpu->cbRegister * vrgOffset[reg]));
    } /* if */
} /* AdrFReg */
#endif /* X_AdrFReg */


#ifndef X_GetReg
/* G E T   R E G  */

export REGT GetReg(reg)
int2	reg;
{
    if ((reg == upc) AND (v->acntx.pc != adrNil))
	return(v->acntx.pc);	/* this is valid */
    else
	return(GetUser(AdrFReg(reg)));
} /* GetReg */
#endif /* X_GetReg */


#ifndef X_PutReg
/* P U T   R E G  */

export void PutReg(reg, val)
int2	reg;
REGT	val;
{
    ADRT	adr;

    adr = AdrFReg(reg);
    if (adr == adrNil)
	return;

    /* keep our globals up to date */
    switch (reg) {
	case upc:	v->acntx.pc = val;
			/* PC is set at continuation time, not here */
			return;

	case ufp:	v->acntx.fp = val;
			if (v->cpu->fApIsFp)
			    v->acntx.ap = val;
			break;
	case usp:	v->acntx.sp = val;	break;
	case uap:	v->acntx.ap = val;
			if (v->cpu->fApIsFp)
			    v->acntx.fp = val;
			break;
    } /* switch */

    PutUser(AdrFReg(reg), val);
} /* PutReg */
#endif /* X_PutReg */


#ifndef X_ReadPc
/* R E A D   P C */

export void ReadPc()
{
#if 0
    if (v->os->adrUser != adrNil) {
	if (v->os->adrReg0 != 0)
	    v->os->adrReg0 = GetUser(v->os->adr_u_ar0) - v->os->adrUser;
    } else {
	v->os->adrReg0 = GetUser(v->os->adr_u_ar0) & (vcbUserPage-1);
    } /* if */
#endif

    if (v->os->adr_u_ar0 != 0) {
	if (v->os->adrUser != adrNil)
	    v->os->adrReg0 = GetUser(v->os->adr_u_ar0) - v->os->adrUser;
	else
	    v->os->adrReg0 = GetUser(v->os->adr_u_ar0) & (vcbUserPage-1);
    } /* if */

    v->acntx.pc = adrNil;	/* to force re-reading of pc */
    v->acntx.pc = GetReg(upc);
} /* ReadPc */
#endif /* X_ReadPc */


#ifndef X_SetCntx
/* S E T   C N T X */

export void SetCntx()
{
    v->acntx.fp = GetReg(ufp);
    v->acntx.sp = GetReg(usp);
    if (v->cpu->fApIsFp)
	v->acntx.ap = v->acntx.fp;
    else
	v->acntx.ap = GetReg(uap);
    v->acntx.fEndOfStack = false;
} /* SetCntx */
#endif /* X_SetCntx */


#ifndef X_SaveState
/* S A V E   S T A T E */

export SBT SaveState()
{
    int2	i;
    SBT		sbSave;
    REGT	*rgReg;

    /* Save all of the registers for the current process */

    sbSave = (SBT) malloc(uregMax * v->cpu->cbRegister);
    rgReg = (REGT *) sbSave;

    for (i = 0; i < uregMax; i++) {
	if ( (i == uap) AND (v->cpu->fApIsFp) )
	    continue;
	rgReg[i] = GetReg(i);
    }   /* for */
    if (v->cpu->fApIsFp)
	rgReg[uap] = rgReg[ufp];

    return(sbSave);
} /* SaveState */
#endif /* X_SaveState */


#ifndef X_RestoreState
/* R E S T O R E   R E G S */

export void RestoreState(sbSave)
SBT	sbSave;
{
    int2	i;
    REGT	*rgReg;

    /* Restore all of the registers for the current process */

    rgReg = (REGT *) sbSave;
    for (i = 0; i< uregMax; i++) {
	if ((i == uap) AND (v->cpu->fApIsFp))
	    continue;
	PutReg(i, rgReg[i]);
    } /* for */

    v->acntx.pc = rgReg[upc];
    v->acntx.fp = rgReg[ufp];
    v->acntx.sp = rgReg[usp];
    v->acntx.ap = rgReg[uap];
    free(sbSave);
} /* RestoreState */
#endif /* X_RestoreState */


#ifndef X_MoveBytes
/* M O V E   B Y T E S */

export void MoveBytes(adrDest, adrSrc, cb)
ADRT	adrDest, adrSrc;
FAST int2	cb;
{
    FAST SBT	sb1, sb2;

    sb1 = (SBT)adrSrc;
    sb2 = (SBT)adrDest;
    while (cb--)
	*sb2++ = *sb1++;
} /* MoveBytes */
#endif /* X_MoveBytes */


#ifndef X_ValFReg
/* V A L   F   R E G */

export VALU ValFReg(se, cb)
pSER	se;
int2	cb;
{
    uint4	along;
    VALU	val;

    along = GetReg((int) se->asym.value);

    if (cb == v->cpu->cbChar) {
	val.valUChar = along & 0xff;
    } else if (cb == v->cpu->cbShort) {
	val.valUShort = along & 0xffff;
    } else if (cb == v->cpu->cbLong) {
	val.valULong = along;
    } else if (cb == v->cpu->cbDouble) {
	union { struct{ uint4 long1, long2;} longs; double adouble;}doublestuff;
	if (v->cpu->byteSex == byteSexBig) {
	    doublestuff.longs.long1 = along;
	    doublestuff.longs.long2 = GetReg((int) se->asym.value + 1);
	} else {
	    doublestuff.longs.long2 = along;
	    doublestuff.longs.long1 = GetReg((int) se->asym.value + 1);
	} /* if */
	val.valDouble = doublestuff.adouble;
    } else {
	/* I wonder what it is????? */
	val.valULong = along;
    } /* if */
    return(val);
} /* ValFReg */
#endif /* X_ValFReg */


#ifndef X_StoreReg
/* S T O R E   R E G */

export void StoreReg(seDest, seSrc)
pSER	seDest, seSrc;
{
    int2	cb = CbFSe(seDest);
    uint4	along;
    ADRT	adr = seDest->asym.value;

    along = seSrc->val.valLong;		/* KLUDGE!???? */
    if (cb == v->cpu->cbShort) {
	PutReg((int)adr, along & 0x000000ff);
    } else if (cb == v->cpu->cbShort) {
	PutReg((int)adr, along & 0x0000ffff);
    } else {
	PutReg((int)adr, along);
    } /* if */
} /* StoreReg */
#endif /* X_StoreReg */


#ifndef X_ValFUser
/* V A L   F   U S E R */

export VALU ValFUser(se)
pSER	se;
{
    uint4	along;
    VALU	val;
    int2	cb;

    cb  = CbFSe(se);
    along = GetUser((int) se->asym.value);
    if (cb == v->cpu->cbChar) {
	val.valUChar = along;
    } else if (cb == v->cpu->cbShort) {
	val.valUShort = along;
    } else {
	val.valULong = along;
    } /* if */
    return(val);
} /* ValFUser */
#endif /* X_ValFUser */


#ifndef X_StoreUser
/* S T O R E   U S E R */

export void StoreUser(seDest, seSrc)
pSER	seDest, seSrc;
{
    int2	cb = CbFSe(seDest);
    uint4	along;
    ADRT	adr = seDest->asym.value;

    along = seSrc->val.valLong;		/* KLUDGE!???? */
    if (cb == v->cpu->cbChar) {
	PutUser((int)adr, along & 0x000000ff);
    } else if (cb == v->cpu->cbShort) {
	PutUser((int)adr, along & 0x0000ffff);
    } else {
	PutUser((int)adr, along);
    } /* if */
} /* StoreUser */
#endif /* X_StoreUser */


#ifndef X_InstallBp
/* I N S T A L L   B P */

export void InstallBp(bp)
pBPR	bp;
{
    uint2	value;

    if (bp->inst != 0)
	Panic("Double set of breakpoint.");

    GetBlock(bp->adr, spaceText, (ADRT)&bp->inst, v->cpu->cbBp);
    PutBlock(bp->adr, spaceText, (ADRT)&v->cpu->instBp, v->cpu->cbBp);
} /* InstallBp */
#endif /* X_InstallBp */


#ifndef X_RemoveBp
/* R E M O V E   B P */

export void RemoveBp(bp)
pBPR	bp;
{
    uint4	value = bp->inst;

    if ((v->pid != pidNil) AND (value != 0))
	PutBlock(bp->adr, spaceText, (ADRT)&bp->inst, v->cpu->cbBp);
    bp->inst = 0;
} /* RemoveBp */
#endif /* X_RemoveBp */


#ifndef X_SavePcFp
/* S A V E   P C   F P */

export void SavePcFp()
{
    v->acntx.sp -= v->cpu->cbPointer;
    PutWord(v->acntx.sp, spaceData, v->acntx.pc + v->adrText);
    v->acntx.sp -= v->cpu->cbPointer;
    PutWord(v->acntx.sp, spaceData, v->acntx.fp);
} /* SavePcFp */
#endif /* X_SavePcFp */


#ifndef X_SetCallProc
/* S E T   C A L L   P R O C */

export void SetCallProc(adr, sp, cArg)
ADRT	adr, sp;
int2	cArg;
{
    /* Given the callee's address, the current SP and count of arguments,
     * do whatever is necessary so that we can 'continue' into a
     * procedure call from the command line.
     */

    PutReg(upc, adr);
    v->acntx.sp -= v->cpu->cbPointer;
    /* we will pretend we are calling from location `_end_' */
    PutBlock(v->acntx.sp, spaceData, (ADRT)&v->adrBreak, v->cpu->cbPointer);
    v->acntx.pc = adr;
} /* SetCallProc */
#endif /* X_SetCallProc */


#ifndef X_CallProcedure
/* C A L L   P R O C E D U R E */

export void CallProcedure(adrProc, seFirst, cArg)
ADRT	adrProc;
pSER	seFirst;
int	cArg;
{
    int		cbArg;
    ADRT	adrValue;
    pSER	se;

    SavePcFp();		/* save pc and fp for stack trace info */
    v->acntx.fp = v->acntx.sp;	/* FP becomes new sp value */
    PutReg(ufp, v->acntx.fp);

    /* push arg's in reverse order -- they currently are on the top of
     *	the yacc expression evaluation stack where they were pushed
     *	by the parser.
     */
    for (se = seFirst + cArg - 1; se >= seFirst; se--) { 
	cbArg = CbFSe(se);
	if (cbArg < v->cpu->cbInt) {
	    Coerce(vseCnInt, se);	/* KLUDGE */
	    cbArg = v->cpu->cbInt;
	} else if ((se->ti.bt == btFloat) AND (se->ti.tq0 == tqNil)) {
	    Coerce(vseCnDouble, se);
	    cbArg = v->cpu->cbDouble;
	} /* if */
	adrValue = AdrFSe(se);
	v->acntx.sp -= cbArg;
	PutBlock(v->acntx.sp, spaceData, adrValue, cbArg);
    } /* for */

    /* set pc/stack/etc so we can "continue" into proc call */
    SetCallProc(adrProc, v->acntx.sp, cArg);
    PutReg(usp, v->acntx.sp);	/* and save the goodies */
} /* CallProcedure */
#endif /* X_CallProcedure */


#ifndef X_SeFReturn
/* S E   F   R E T U R N */

export void SeFReturn(seRet, seProc)
pSER	seRet, seProc;
{
    /* Get the return value from the stack after a cmd line proc call */

    RemoveTq(seProc, tqNil);
    seRet->asym.iss = IssFSb("$result");
    if (!FSpecial(seRet))
	Panic("Can't find $result!");

    CopyTy(seRet, seProc);
    seRet->val = ValFSe(seRet);
    seRet->ti.fConstant = true;
    seRet->asym.value = seRet->val.valAdr;
    seRet->asym.sc = scNil;
    seRet->asym.iss = seProc->asym.iss;
} /* SeFReturn */
#endif /* X_SeFReturn */


#ifndef X_GetArgN
/* G E T   A R G   N */

export void GetArgN(cntx, se, iarg)
pCNTXR	cntx;
pSER	se;
int2	iarg;
{
    *se = *vseInt;
    se->asym.value = cntx->ap + (iarg + 1) * v->cpu->cbRegister;
} /* GetArgN */
#endif /* X_GetArgN */


#ifndef X_DispUnknown
/* D I S P   U N K N O W N */

export void DispUnknown(cntx, ipd)
pCNTXR	cntx;
int2	ipd;
{
    int		cParam, i;
    ADRT	ap;
#define cParamMax 6

    /* we print first N (N<=8) parameters */
    ap = cntx->ap + v->cpu->cbInt;	/* step over return address */
    cParam = Min( cParamMax, GetWord(ap, spaceData));
    printf("%s(", SbFIpd(ipd));
    for (i=0; i < cParam-1; i++) {
	ap += v->cpu->cbInt;
	printf("%s, ", SbFAdr(GetWord(ap, spaceData), true));
    } /* if */
    printf("%s)\n", SbFAdr(GetWord(ap, spaceData), true));
} /* DispUnknown */
#endif /* X_DispUnknown */

#ifndef X_FixPc
/* F I X   P C */

export void FixPc()
{
    uint4	value = 0;
    ADRT	pc;
    pBPR	bp;

    if ((v->sigOrig == v->os->sigTrap) AND (v->cpu->fBackupOnBpt)) {

	bp = BpFAdr(v->acntx.pc - v->cpu->cbBp, true);
	if ((v->fDoingSingle)
	   AND ((bp == bpNil) OR (bp->inst == 0)) ) {
	    /* WE don't have a hard BPT there - but what
	     * if the USER does???  For the moment, there's
	     * not much we can do.....
	     */
	    return;
	} /* if */

	value = 0;
	if (v->acntx.pc != ADR_TEXT_BASE)
	    GetBlock(v->acntx.pc - v->cpu->cbBp, spaceText,
			    (ADRT)&value, v->cpu->cbBp);

	if (value == v->cpu->instBp) {
	    /* back up, if we are at a breakpoint */
	    v->acntx.pc -= v->cpu->cbBp;
	    PutReg(upc, v->acntx.pc);
	} /* if */
    } /* if */
} /* FixPc */
#endif /* X_FixPc */


#ifndef X_FinishCpu
/* F I N I S H   C P U */

export void FinishCpu()
{
    /* do any CPU dependent clean up necessary */
} /* FinishCpu */
#endif /* X_FinishCpu */


#ifndef X_InitRegisters
/* I N I T   R E G I S T E R S */

export void InitRegisters(cpu)
pCPUR	cpu;
{
    int		i;
    char	sb[10];
    pSER	se;

    cpu->rgReg = vrgReg;
    se = vrgReg;
    InitSpc(se++, "result", 0, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "fp", ufp, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "sp", usp, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "ap", uap, stExpr, scRegister, tqNil, btInt, false);
    InitSpc(se++, "pc", upc, stExpr, scRegister, tqNil, btInt, false);

    for (i = 0; i < 16; i++) {
	sprintf(sb, "r%d", i);
	InitSpc(se++, SbFAlloc(sb), (uint4)i, stExpr,
		scRegister, tqNil, btInt, false);
    } /* for */

    cpu->iregMax = se - vrgReg;
} /* InitRegisters */
#endif /* X_InitRegisters */


#ifndef X_InitCpu
/* I N I T   C P U */

export void InitCpu(cpu)
pCPUR	cpu;
{
    int		i;
    pSER	se;

#if (CPU != HOST_CPU)
    if (cpu == vcpuHost)
	InitHostCpu(cpu);
#endif /* (CPU != HOST_CPU) */

    cpu->cBadMax = 10;

    cpu->cbChar = 1;
    cpu->cbShort = sizeof(short);
    cpu->cbInt = sizeof(int);
    cpu->cbLong = sizeof(long);
    cpu->cbPointer = sizeof(char *);
    cpu->cbFloat = sizeof(float);
    cpu->cbDouble = sizeof(double);
    cpu->cbRegister = cpu->cbPointer;

    cpu->bitSex = BIT_SEX;
    cpu->byteSex = BYTE_SEX;
    cpu->instBp = BPT_INST;
    cpu->cbBp = CB_BP;
    cpu->alignment = ALIGNMENT_MASK;
    cpu->fApIsFp = FPISAP;
    cpu->fBackupOnBpt = BPT_BACKUP;
    cpu->fCalleeStackCleanup = CALLEE_STACK_CLEANUP;

    InitRegisters(cpu);
} /* InitCpu */
#endif /* X_InitCpu */


#if (CPU != HOST_CPU)
/* I N I T   C P U */

export void InitHostCpu(cpu)
pCPUR	cpu;
{
    cpu->bitSex = BIT_SEX;
    cpu->byteSex = BYTE_SEX;
    cpu->alignment = ALIGNMENT_MASK;
} /* InitHostCpu */
#endif /* (CPU != HOST_CPU) */
