/* $Header: csupport.c,v 6.2 86/09/11 18:13:45 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/* This module supplies major support to the C expression evaluator. */

#include "cdb.h"

export FLAGT vfInFalse;

/* a bunch of types for expression evaluation */

SER	aseAdr,    aseCnAdr,    aseChar,  aseCnChar;
SER	aseUChar,  aseCnUChar,  aseShort, aseCnShort;
SER	aseUShort, aseCnUShort, aseInt,   aseCnInt;
SER	aseUInt,   aseCnUInt,   aseLong,  aseCnLong;
SER	aseULong,  aseCnULong,  aseFloat, aseCnFloat;
SER	aseDouble, aseCnDouble, aseInit;
SER	aseLogical,  aseCnLogical,  aseComplex, aseCnComplex;

export pSER	vseInit = &aseInit;
export pSER	vseAdr = &aseAdr;
export pSER	vseCnAdr = &aseCnAdr;
export pSER	vseChar = &aseChar;
export pSER	vseCnChar = &aseCnChar;
export pSER	vseUChar = &aseUChar;
export pSER	vseCnUChar = &aseCnUChar;
export pSER	vseShort = &aseShort;
export pSER	vseCnShort = &aseCnShort;
export pSER	vseUShort = &aseUShort;
export pSER	vseCnUShort = &aseCnUShort;
export pSER	vseInt = &aseInt;
export pSER	vseCnInt = &aseCnInt;
export pSER	vseUInt = &aseUInt;
export pSER	vseCnUInt = &aseCnUInt;
export pSER	vseLong = &aseLong;
export pSER	vseCnLong = &aseCnLong;
export pSER	vseULong = &aseULong;
export pSER	vseCnULong = &aseCnULong;
export pSER	vseFloat = &aseFloat;
export pSER	vseCnFloat = &aseCnFloat;
export pSER	vseDouble = &aseDouble;
export pSER	vseCnDouble = &aseCnDouble;
export pSER	vseLogical = &aseLogical;
export pSER	vseCnLogical = &aseCnLogical;
export pSER	vseComplex = &aseComplex;
export pSER	vseCnComplex = &aseCnComplex;


/* map basic types into the type names */
SBT	vmpBtSb[] = {
	"undefined",
	"address",
	"char",
	"unsigned char",
	"short",
	"unsigned short",
	"int",
	"unsigned int",
	"long",
	"unsigned long",
	"float",
	"double",
	"struct",
	"union",
	"enum",
	"typedef",
	"long long",
	"unsigned long long",
	"set",
	"range",
	"complex",
	"logical",
	"subRange",
	"void",
	};


/* I N I T   S E */

export void InitSe()
{
    int		i;

    /* Set up all of the constant SE's */
    aseInit.isymRef = isymNil;
    aseInit.isymTypedef = isymNil;
    aseInit.asym.iss = issNil;
    aseInit.asym.value = -1;
    aseInit.asym.sc = scNil;
    aseInit.asym.st = stExpr;	/* changes at end of InitSe */
    aseInit.asym.index = 0;
    aseInit.ti.bt = btNil;
    aseInit.ti.fConstant = false;
    aseInit.ti.tq0 = tqNil;
    aseInit.ti.tq1 = tqNil;
    aseInit.ti.tq2 = tqNil;
    aseInit.ti.tq3 = tqNil;
    aseInit.ti.tq4 = tqNil;
    aseInit.ti.tq5 = tqNil;

    for (i=0; i < idimMax; i++) {
	aseInit.rgRng[i].iaux = iauxNil;
	aseInit.rgRng[i].dnLow = 0;
	aseInit.rgRng[i].dnHigh = 0;
    } /* for */

#define SetupSe(se, bx, f) {*se=aseInit;se->ti.bt=bx;se->ti.fConstant=f;}
    /* set up standard type descriptors */
    SetupSe(vseAdr, btAdr, false);
    vseAdr->ti.tq0 = tqPtr;
    SetupSe(vseCnAdr, btULong, true);
    SetupSe(vseChar, btChar, false);
    SetupSe(vseCnChar, btChar, true);
    SetupSe(vseUChar, btUChar, false);
    SetupSe(vseCnUChar, btUChar, true);
    SetupSe(vseShort, btShort, false);
    SetupSe(vseCnShort, btShort, true);
    SetupSe(vseUShort, btUShort, false);
    SetupSe(vseCnUShort, btUShort, true);
    SetupSe(vseInt, btInt, false);
    SetupSe(vseCnInt, btInt, true);
    SetupSe(vseUInt, btUInt, false);
    SetupSe(vseCnUInt, btUInt, true);
    SetupSe(vseLong, btLong, false);
    SetupSe(vseCnLong, btLong, true);
    SetupSe(vseULong, btULong, false);
    SetupSe(vseCnULong, btULong, true);
    SetupSe(vseFloat, btFloat, false);
    SetupSe(vseCnFloat, btFloat, true);
    SetupSe(vseDouble, btDouble, false);
    SetupSe(vseCnDouble, btDouble, true);
    SetupSe(vseLogical, btLogical, false);
    SetupSe(vseCnLogical, btLogical, true);
    SetupSe(vseComplex, btComplex, false);
    SetupSe(vseCnComplex, btComplex, true);

    aseInit.asym.st = stNil;
} /* InitSe */


/*  G E T   A D R */

export void GetAdr(se)
pSER	se;
{
    SBT		sbName;
    int2	ipd;

    /* Given an SER containing only a name, search for it in the
     * current context and return a full-blown SER.
     */

    if (se->asym.st != stStr)
	return;	/* we already looked it up */

    sbName = SbFIss(se->asym.iss);
    if (  ((*sbName == '$') AND FSpecial(se) )
       OR ((v->ipd != ipdNil) AND FLocal(se, v->ipd, v->stackdepth))
       OR			FGlobal(se) 
       OR			FEnum(se) ) {
	/* everything was done by routines */
    } else if ((ipd = IpdFName(sbName)) != ipdNil) {
	SeFSym(se, SymFIsym(v->rgPd[ipd].isym), true);
    } else if (FSpecial(se)) {
	/* routine did everything */
    } else {
	UError("Unknown name \"%s\".", sbName);
    } /* if */
} /* GetAdr */


/* G E T   V A L */

export void GetVal(se)
pSER	se;
{
    /* First look up the thing named in the SER and then get its value */

    GetAdr(se);
    se->val = ValFSe(se);
    se->asym.st = stExpr;
} /* GetVal */


/* G E T   O R I G */

export void GetOrig(se)
pSER	se;
{
    if (! (se->ti.fConstant)
       OR (se->asym.st == stStr)) {
	GetVal(se);
    } /* if */
} /* GetOrig */


/* F   B I N   O P   L E G A L   F   T Y */

local FLAGT FBinOpLegalFSe(se)
pSER	se;
{
    /* Determine if the given SER could legally be used in a binary operation */

#if 0
    if ((se->ti.tq0 == tqPtr)
     OR (se->ti.tq0 == tqArray))
#endif
    if (se->ti.tq0 != tqNil)
	return(true);

    switch (se->ti.bt) {
	default:
	case btNil:
	case btUnion:
	case btStruct:	return(false);
	case btAdr:
	case btInt:
	case btUInt:
	case btUShort:
	case btShort:
	case btLong:
	case btULong:
	case btChar:
	case btUChar:
	case btFloat:
	case btDouble:
	case btLogical:
	case btComplex:
	case btEnum:	return(true);
    } /* switch */
} /* FBinOpLegalFSe */


/* M A X   F   S E   S E */

local FLAGT MaxFSeSe(seMax, se1, se2)
pSER	seMax, se1, se2;
{
    int2	cb1, cb2;

    /* Return the 'larger' type of the two given.
     * E.g. float + int OR int + float will return float.
     */

    if (!FBinOpLegalFSe(se1) OR !FBinOpLegalFSe(se2))
	return(false);

    cb1 = CbFSe(se1);
    cb2 = CbFSe(se2);

    /* the rule here is that the physically large size wins */
    if (cb1 > cb2) {
	CopyTy(seMax, se1);
    } else if (cb2 > cb1) {
	CopyTy(seMax, se2);
    } else {
	/* same size - look to for type preference */
	if ((se2->ti.tq0 != tqNil)  /* <--- is this right?? KLUDGE */
	   OR (se2->ti.bt == btFloat)
	   OR (se2->ti.bt == btDouble))
	    CopyTy(seMax, se2);
	else
	    CopyTy(seMax, se1);
    } /* if */
    return(true);
} /* MaxFSeSe */


/*  R E S  F  O P S     */

export void ResFOps(seRet, se1, se2)
pSER	seRet, se1, se2;
{
    int2   	fDoIntOp, fConstant, cb1, tq1, tq2;
    SER		ase;

    /* Determine the resultant type of an expression.
     * If pointers and/or arrays are invloved, allow for
     * expression multiplication, etc.
     */

    GetOrig(se1);
    GetOrig(se2);

    fDoIntOp = MaxFSeSe(seRet, se1, se2);

    if (!fDoIntOp)
	UError("Cannot allow that combination of operand(s) and operator.");

    /* Do the pointer crap - ^%##&%#*&^%$#*^@#&!!!!!!! */

    tq1 = se1->ti.tq0;
    tq2 = se2->ti.tq0;
    fConstant = (tq1 == tqNil) AND (tq2 == tqNil);

    if (((tq1 == tqPtr) OR (tq1 == tqArray)) AND (tq2 == tqNil)) {

	Coerce(vseCnLong, se2);
	CopyTy(seRet, se1);
	ase = *se1;
	RemoveTq(&ase);
	se2->val.valLong *= CbFSe(&ase);
	if (tq1 == tqArray)
	    seRet->ti.tq0 = tqPtr;

    } else if (((tq2 == tqPtr) OR (tq2 == tqArray)) AND (tq1 == tqNil)) {

	Coerce(vseCnLong, se1);
	CopyTy(seRet, se2);
	ase = *se2;
	RemoveTq(&ase);
	se1->val.valLong *= CbFSe(&ase);
	if (tq2 == tqArray)
	    seRet->ti.tq0 = tqPtr;

    } else if ((tq2 == tqPtr OR tq2 == tqArray)
	   AND (tq1 == tqPtr OR tq1 == tqArray)) {

	/* massive kludge - not kosher - etc. */
	ase = *se1;
	RemoveTq(&ase);
	cb1 = CbFSe(&ase);
	Coerce(vseCnULong, se1);
	Coerce(vseCnULong, se2);
	se1->val.valULong /= cb1; /* we ASSUME they are of the same array! */
	se2->val.valULong /= cb1;
	fConstant = true;
	CopyTy(seRet, vseCnInt);

    } else if ((seRet->ti.tq0 == tqProc) AND (seRet->ti.tq1 == tqNil)) {

	RemoveTq(seRet);
	seRet->ti.bt = btAdr;

    } /* if */

    Coerce(seRet, se1);
    Coerce(seRet, se2);
    seRet->asym.st = stExpr;
    seRet->asym.iss = issNil; /* it no longer has a name, it is just a value */
    seRet->ti.fConstant = fConstant;
} /* ResFOps */


#define DoCoerce(btX, valX)\
case btX: switch (btFrom) {\
    case btAdr:seFrom->val.valX = val.valAdr; break;\
    case btChar:seFrom->val.valX = val.valChar; break;\
    case btUChar:seFrom->val.valX = val.valUChar; break;\
    case btShort:seFrom->val.valX = val.valShort; break;\
    case btUShort:seFrom->val.valX = val.valUShort; break;\
    case btInt:seFrom->val.valX = val.valInt; break;\
    case btEnum: case btUInt:seFrom->val.valX = val.valUInt; break;\
    case btLong:seFrom->val.valX = val.valLong; break;\
    case btULong:seFrom->val.valX = val.valULong; break;\
    case btFloat:seFrom->val.valX = val.valFloat; break;\
    case btDouble:seFrom->val.valX = val.valDouble; break;\
    case btLogical:seFrom->val.valX = val.valUInt; break;\
} /* switch */


/* C O E R C E */

export void Coerce(seTo, seFrom)
pSER	seTo, seFrom;
{
    int2	tqTo, tqFrom;
    int2	btTo, btFrom;
    VALU	val;

    /* Coerce seFrom to the same type as seTo */

    tqTo = seTo->ti.tq0;
    tqFrom = seFrom->ti.tq0;

    btTo = (tqTo == tqNil) ? seTo->ti.bt : btAdr;
    btFrom = (tqFrom == tqNil) ? seFrom->ti.bt : btAdr;

    val = seFrom->val;
    ZeroBlock(&seFrom->val, sizeof(VALU));

    /* The following switch is much hairier than it looks!
     * see macro define above for DoCoerce.
     */

    switch (btTo) {
	default:		UError("unknown basic type (%d) in Coerce.");
	case btNil:		UError("Result type undefined.");
	case btTypedef:		Panic("btTypedef in Coerce.");
	case btStruct:
	case btComplex:
	case btUnion:		/* We allow this to 'happen as it will' .... */
				break;
	case btEnum:
	DoCoerce(btUInt, valUInt);	break;
	DoCoerce(btChar, valChar);	break;
	DoCoerce(btUChar, valUChar);	break;
	DoCoerce(btInt, valInt);	break;
	DoCoerce(btLong, valLong);	break;
	DoCoerce(btULong, valULong);	break;
	DoCoerce(btShort, valShort);	break;
	DoCoerce(btUShort, valUShort);	break;
	DoCoerce(btFloat, valFloat);	break;
	DoCoerce(btDouble, valDouble);	break;
	DoCoerce(btLogical, valUInt);	break;
	DoCoerce(btAdr, valAdr);	break;
    } /* switch */

    CopyTy(seFrom, seTo);
} /* Coerce */


/* A S S I G N */

export void Assign(seDest, seSrc)
pSER	seDest, seSrc;
{
    int2	cb1, cb2;
    pSER	seT;

    /* Assign (with fear and loathing) the source value to the
     * destination location.
     * Perform implict coersions, etc.
     */

    if ((seDest->ti.fConstant) OR (seDest->ti.tq0 == tqArray))
	UError("You may not assign to a constant");

    if (seDest->asym.sc == scCdbLocal) {
	/* make the special take on the type of seSrc */
	SpecialSideEffects(seDest, seSrc); /* some specials have side effects */
	CopyTy(seDest, seSrc);
	if (seDest->ti.tq0 == tqArray) {
	    RemoveTq(seDest);
	    AddTq(seDest, tqPtr);
	} /* if */
	seDest->ti.fConstant = false;
	if (CbFSe(seDest) > cbVALU)
	  UError("You may not assign more than %d bytes to a special variable.",
		cbVALU);
	seT = (pSER) seDest->asym.value;
	*seT = *seDest;
    } /* if */

    GetOrig(seSrc);
    Coerce(seDest, seSrc);

    cb1 = CbFSe(seSrc);
    if (!vfInFalse) {
	if (cb1 <= v->cpu->cbDouble) {
	    WriteVal(seDest, seSrc);
	} else {
	    cb2 = CbFSe(seSrc);
	    if (cb1 != cb2) {
		printf("WARNING: X=Y: X is %d bytes and Y is %d bytes\n",
		    cb1, cb2);
		cb1 = Min(cb1, cb2);
		printf("  Moving %d bytes\n", cb1);
	    } /* if */
	    BlockTransfer(seDest->asym.value, seSrc->asym.value,
			spaceData, cb1);
	} /* if */
    } /* if */
} /* Assign */


/* M I N */

export int Min(x, y)
int	x, y;
{
    return((x<y) ? x : y);
} /* Min */


/* M A X */

export int Max(x, y)
int	x, y;
{
    return((x>y) ? x : y);
} /* Max */


/* Z E R O   B L O C K */

export void ZeroBlock(sb, cb)
FAST SBT	sb;
FAST int2	cb;
{
    while (cb--)
	*sb++ = 0;
} /* ZeroBlock */


/* S B   F   B T */

export SBT SbFBt(bt)
int2	bt;
{
    if (bt < 0 OR bt >= btMax)
	Panic("Bt out of bounds.");
    return(vmpBtSb[bt]);
} /* SbFBt */


/* S E   F   S Y M */

export void SeFSym(se, sym, fRecurse)
pSER	se;
pSYMR	sym;
FLAGT	fRecurse;
{
    int2	tq, i, bt, idim, idimTemp;
    char	sbBuf[100];
    pAUXU	aux;
    SER		ase;
    pSYMR	symCommon;

    /* Given a SYMR, develop a full-blown SER. */

    *se = *vseInit;	/* initialize */
    se->asym = *sym;	/* get the base symbol */
    se->val.valAdr = 0;	/* more or less sets field to 0 */

    aux = AuxFIaux(se->asym.index);	/* point into AUX info universe */
    switch (se->asym.st) {
	default:
		Panic("Bad st in SeFSym (%d).", se->asym.st);
		break;

	case stCommon:
		DoCommon(se, sym);
		break;

	case stBlock:		/* probably a typedef'd struct/union */
		break;	/* all done */

	case stProc:		/*     "      "  Procedure */
		if (aux == auxNil)
		    return;	/* was generated by normal text label */
		aux++;	/* skip past isymLast */
		/* fall through into main code */

	case stGlobal:		/* external symbol */
	case stStatic:		/* static */
	case stParam:		/* procedure argument */
	case stLocal:		/* local variable */
	case stMember:		/* member of something */
	case stTypedef:		/* Type definition */
		se->ti = (aux++)->ti;
		bt = se->ti.bt;

		/* pick up reference pointer, if any */
		if ( (bt == btStruct)
		   OR (bt == btUnion)
		   OR (bt == btEnum)
		   OR (bt == btTypedef) )
		    se->isymRef = (aux++)->isym;

		/* collect dimensions */
		idim = 0;
		for (i=0; i < itqMax; i++) {
		    if (tqArray == TqFSe(se, i)) {
			se->rgRng[idim].iaux = (aux++)->iaux;
			se->rgRng[idim].dnLow = (aux++)->dn;
			se->rgRng[idim].dnHigh = (aux++)->dn;
			idim++;
		    } /* if */
		} /* for */

		/* collect and fix up the bit field info */
		if (se->asym.sc == scBits) {
		    se->bitsWidth = (aux++)->width;
		    se->bitsOffset = se->asym.value;
		    se->asym.value = 0; /* will be filled in with struct adr */
		} /* if */

		/* follow and collect type info */
		if ((bt == btTypedef)
		   AND (fRecurse OR (se->asym.iss == issNil))) {
		    /* WOW! Real Recursion!! (neato!) */
		    se->isymTypedef = se->isymRef;
		    sym = SymFIsym(se->isymRef);
		    SeFSym(&ase, sym, true);
		    se->isymRef = ase.isymRef; /* get THEIR ref value */
		    se->ti.bt = ase.ti.bt;	/* get underlying type */

		    /* Tack on THEIR tq info */
		    idimTemp = 0;
		    for (i = 0; i < itqMax; i++) {
			if ((tq = TqFSe(&ase, i)) == tqNil)
			    break;
			AddTq(se, tq);
			if (tq == tqArray) {
			    /* add this to the dimensions we already have */
			    if (idim >= idimMax)
				UError("%s has more than %d dimensions.",
				    SbFIss(se->asym.iss), idimMax);
			    se->rgRng[idim++] = ase.rgRng[idimTemp++];
			} /* if */
		    } /* for */

		} /* if */
		break;
    } /* switch */

    bt = se->ti.bt;
    if ( (bt == btStruct OR bt == btUnion OR bt == btEnum)
       AND (se->isymRef == isymNil) )
	se->ti.bt = btUChar;	/* the type was never defined! */

    if ((se->ti.tq0 == tqArray) OR (se->ti.tq0 == tqProc))
	se->val.valAdr = se->asym.value;

    if ((se->asym.st == stMember) AND (se->ti.lc == lcFortran)) {
	DoCommon(&ase, sym);
	se->asym.value = (se->asym.value / 8) +  ase.asym.value;
    } else if (se->asym.sc == scAbs) {
	se->val.valInt = se->asym.value;
    } else if ((se->asym.st == stGlobal)
		OR (se->asym.st == stStatic)
		OR (se->asym.st == stCommon)) {
	se->asym.value += v->adrData;
    } /* if */
} /* SeFSym */


/* C O P Y   T Y */

export void CopyTy(seDest, seSrc)
pSER	seDest, seSrc;
{
    FLAGT	fConstant = seDest->ti.fConstant;
    SYMR	asym;
    VALU	val;
    
    val = seDest->val;

    /* Copy ONLY the type information */

    asym = seDest->asym;
    *seDest = *seSrc;
    seDest->asym = asym;
    seDest->val = val;
    seDest->ti.fConstant = fConstant;
} /* CopyTy */


/* T Q   F   S E */

export int TqFSe(se, cnt)
pSER	se;
int2	cnt;
{
    switch (cnt) {
	default: Panic("tq out of bounds.");
	case 0:	return(se->ti.tq0);
	case 1:	return(se->ti.tq1);
	case 2:	return(se->ti.tq2);
	case 3:	return(se->ti.tq3);
	case 4:	return(se->ti.tq4);
	case 5:	return(se->ti.tq5);
    } /* switch */
} /* TqFSe */


/* A D D   T Q */

export void AddTq(se, tq)
pSER	se;
int2	tq;
{
    if (se->ti.tq0 == tqNil)
	se->ti.tq0 = tq;
    else if (se->ti.tq1 == tqNil)
	se->ti.tq1 = tq;
    else if (se->ti.tq2 == tqNil)
	se->ti.tq2 = tq;
    else if (se->ti.tq3 == tqNil)
	se->ti.tq3 = tq;
    else if (se->ti.tq4 == tqNil)
	se->ti.tq4 = tq;
    else if (se->ti.tq5 == tqNil)
	se->ti.tq5 = tq;
    else
	UError("Type of %s is too complex.", SbFIss(se->asym.iss));
} /* AddTq */


/* R E M O V E   T Q */

export void RemoveTq(se)
pSER	se;
{
    se->ti.tq0 = se->ti.tq1;
    se->ti.tq1 = se->ti.tq2;
    se->ti.tq2 = se->ti.tq3;
    se->ti.tq3 = se->ti.tq4;
    se->ti.tq4 = se->ti.tq5;
    se->ti.tq5 = tqNil;
} /* RemoveTq */


/* C B   F   S E */

export int CbFSe(se)
pSER	se;
{
    int2	cb, tq;

    /* Determine the size in bytes of the type given */

    if (se == seNil)
	return(0);

    if (se->asym.sc == scBits)
	return(-1);	/* a bit field */

    cb = 0;
    tq = se->ti.tq0;
    if ((tq == tqPtr) OR (tq == tqProc) OR (tq == tqRef)) {
	cb = v->cpu->cbPointer;
    } else {
	switch (se->ti.bt) {
	    case btAdr:		cb = v->cpu->cbPointer;	break;
	    case btLogical:	/* for now, f77 treats logical as an int */
	    case btEnum:
	    case btInt:
	    case btUInt:	cb = v->cpu->cbInt;	break;
	    case btUShort:
	    case btShort:	cb = v->cpu->cbShort;	break;
	    case btLong:
	    case btULong:	cb = v->cpu->cbLong;	break;
	    case btChar:
	    case btUChar:	cb = 1	;		break;
	    case btFloat:	cb = v->cpu->cbFloat;	break;
	    case btComplex:	/* f77 treats logical as a pair of floats */
	    case btDouble:	cb = v->cpu->cbDouble;	break;
	    case btUnion:
	    case btStruct:	{
				int4	isymSave = v->isym;
				cb = SymFIsym(se->isymRef)->value;
				SymFIsym(isymSave);
				};
	} /* switch */
    } /* if */

    if (tq == tqArray) {
	int	x, i;

	x = 1;
	/* this STILL may not be quite right..... */
	for (i = itqMax-1; i >= 0; i--) {
	    tq = TqFSe(se, i);
	    if (tq == tqNil) {
		continue;
	    } else if (tq != tqArray) {
		/* we hit a pointer or proc, throw out count, reset cb */
		cb = v->cpu->cbPointer;
		x = 1;
	    } else {
		x *= se->rgRng[i].dnHigh - se->rgRng[i].dnLow + 1;
	    } /* if */
	} /* for */
	cb *= x;
    } /* if */

    return(cb);
} /* CbFSe */
