#
/****************************************************************************

	DEBUGGER - 68000 instruction printout

****************************************************************************/

#include "cdb.h"


char *badop = "\t???";
char *IMDF;				/* immediate data format */

char *bname[16] = { "ra", "sr", "hi", "ls", "cc", "cs", "ne",
		    "eq", "vc", "vs", "pl", "mi", "ge", "lt", "gt", "le" };

char *shro[4] = { "as", "ls", "rox", "ro" };

char *bit[4] = { "btst", "bchg", "bclr", "bset" };

int vcbScale[] = { 1, 2, 4, 8 };

int omove(),obranch(),oimmed(),oprint(),oneop(),soneop(),oreg(),ochk();
int olink(),omovem(),oquick(),omoveq(),otrap(),oscc(),opmode(),shroi();
int extend(),biti();

int obkpt(), ocallm(), ocas(), ochk2(), olmul(), otrapcc(), obits();
int cpgen(), cpscc(), cpdbcc(), cptrap(), cpbcc(), cpsave(), cprest();


struct opdesc
{			
	unsigned short mask, match;
	int (*opfun)();
	char *farg;
} opdecode[] =
{					/* order is important below */
  0xF000, 0x1000, omove, "b",		/* move instructions */
  0xF000, 0x2000, omove, "l",
  0xF000, 0x3000, omove, "w",
  0xF000, 0x6000, obranch, 0,		/* branches */
  0xFF00, 0x0000, oimmed, "or",		/* op class 0  */
  0xF9C0, 0x00C0, ochk2, 0,		/* 68020 */
  0xFF00, 0x0200, oimmed, "and",
  0xFF00, 0x0400, oimmed, "sub",
  0xFFC0, 0x06C0, ocallm, 0,		/* 68020 */
  0xFF00, 0x0600, oimmed, "add",
  0xFF00, 0x0A00, oimmed, "eor",
  0xFF00, 0x0C00, oimmed, "cmp",
  0xF100, 0x0100, biti, 0,
  0xFF00, 0x0800, biti, 0,
  0xF9C0, 0x08C0, ocas, 0,		/* 68020 */
  0xFFC0, 0x40C0, oneop, "move_from_sr", /* op class 4 */
  0xFF00, 0x4000, soneop, "negx",
  0xFF00, 0x4200, soneop, "clr",
  0xFFC0, 0x44C0, oneop, "move_to_ccr",
  0xFF00, 0x4400, soneop, "neg",
  0xFFC0, 0x46C0, oneop, "move_to_sr",
  0xFF00, 0x4600, soneop, "not",
  0xFFF8, 0x4808, olink, "link",			/* 68020 */
  0xFFC0, 0x4800, oneop, "nbcd",
  0xFFF8, 0x4840, oreg, "\tswap\td%ld",
  0xFFF8, 0x4848, obkpt, 0,				/* 68020 */
  0xFFC0, 0x4840, oneop, "pea",
  0xFFF8, 0x49C0, oreg, "\textb\td%ld",			/* 68020 */
  0xFFF8, 0x4880, oreg, "\textw\td%ld",
  0xFFF8, 0x48C0, oreg, "\textl\td%ld",
  0xFB80, 0x4880, omovem, 0,
  0xFFC0, 0x4AC0, oneop, "tas",
  0xFF00, 0x4A00, soneop, "tst",
  0xFFC0, 0x4C00, olmul, "mul",
  0xFFC0, 0x4C10, olmul, "div",
  0xFFF0, 0x4E40, otrap, 0,
  0xFFF8, 0x4E50, olink, 0,
  0xFFF8, 0x4E58, oreg, "\tunlk\ta%ld",
  0xFFF8, 0x4E60, oreg, "\tmove\ta%ld,usp",
  0xFFF8, 0x4E68, oreg, "\tmove\tusp,a%ld",
  0xFFFF, 0x4E70, oprint, "reset",
  0xFFFF, 0x4E71, oprint, "nop",
  0xFFFF, 0x4E72, oprint, "stop",
  0xFFFF, 0x4E73, oprint, "rte",
  0xFFFF, 0x4E75, oprint, "rts",
  0xFFFF, 0x4E76, oprint, "trapv",
  0xFFFF, 0x4E77, oprint, "rtr",
  0xFFC0, 0x4E80, oneop, "jsr",
  0xFFC0, 0x4EC0, oneop, "jmp",
  0xF140, 0x4100, ochk, "chk",		/* 68020 modified */
  0xF1C0, 0x41C0, ochk, "lea",
  0xF0C0, 0x50C0, oscc, 0,
  0xF100, 0x5000, oquick, "addq",
  0xF100, 0x5100, oquick, "subq",
  0xF0F8, 0x50F8, otrapcc, 0,
  0xF000, 0x7000, omoveq, 0,
  0xF1C0, 0x80C0, ochk, "divu",
  0xF1C0, 0x81C0, ochk, "divs",
  0xF1F0, 0x8100, extend, "sbcd",
  0xF000, 0x8000, opmode, "or",
  0xF1C0, 0x91C0, opmode, "sub",
  0xF130, 0x9100, extend, "subx",
  0xF000, 0x9000, opmode, "sub",
  0xF1C0, 0xB1C0, opmode, "cmp",
  0xF138, 0xB108, extend, "cmpm",
  0xF100, 0xB000, opmode, "cmp",
  0xF100, 0xB100, opmode, "eor",
  0xF1C0, 0xC0C0, ochk, "mulu",
  0xF1C0, 0xC1C0, ochk, "muls",
  0xF1F8, 0xC188, extend, "exg",
  0xF1F8, 0xC148, extend, "exg",
  0xF1F8, 0xC140, extend, "exg",
  0xF1F0, 0xC100, extend, "abcd",
  0xF000, 0xC000, opmode, "and",
  0xF1C0, 0xD1C0, opmode, "add",
  0xF130, 0xD100, extend, "addx",
  0xF000, 0xD000, opmode, "add",
  0xF8C0, 0xE8C0, obits, 0,
  0xF100, 0xE000, shroi, "r",
  0xF100, 0xE100, shroi, "l",
  0xF1C0, 0xF000, cpgen, 0,
  0xF1F8, 0xF048, cpdbcc, 0,
  0xF1F8, 0xF078, cptrap, 0,
  0xF1C0, 0xF040, cpscc, 0,
  0xF1C0, 0xF080, cpbcc, 0,
  0xF1C0, 0xF100, cpsave, 0,
  0xF1C0, 0xF140, cprest, 0,
  0, 0, 0, 0
};

export int vcbInst;

static long ladr; /* instruction pointer */
int spacehint = -1;

export void PrintInstruction(adr)
long adr;
{
	register int inst;
	register struct opdesc *p;
	register int (*fun)();
	pBPR	bp;

	if ((bp = BpFAdr(adr, true)) != bpNil)
	    RemoveBp(bp); /* don't show then them the break */

	IMDF = "#%ld."; /* what to do ?? ERR */

	ladr = adr;
	inst = instfetch(2) & 0xffff;
	for (p = opdecode; p->mask; p++)
	    if ((inst & p->mask) == p->match)
		break;

	if (p->mask != 0)
	    (*p->opfun)(inst, p->farg);
	else
	    printf(badop);
	vcbInst = ladr - adr;
} /* PrintInstruction */

long
instfetch(size)
int size;
{
	long l;

	l = GetWord(ladr, spaceText);
	if (size==2)
	    l = (short)(l>>16);
	ladr += size;
	return(l);
}

printc(c) {
    printf("%c",c);
}

getdisp(size)
{
    switch(size) {
    case 0:
    case 1:
	return(0);
    case 2:
	return(instfetch(2));
    case 3:
	return(instfetch(4));
/*
    default:
	Panic("Bad addressing operand.");
*/
    }
}

fullformat(reg, index)
long reg, index;
{
    long base;
    long outer;

    base = getdisp((index>>4)&0x3);
    outer = getdisp(index&0x3);

    printf("(");
    if(index&0x07) {
	printf("[");
    }

    if((base != 0) || ((index&0x80) && ((index&0x40)||(index&0x04)))) {
	if((index&0x30) == 0x30)
	    printf("0x%08x", base);
	else
	    printf("0x%04x", base);
	if(((index&0x80)==0x00)||(((index&0x40)==0x00)&&((index&0x04)==0x00)))
	    printf(",");
    }

    if((index&0x80) == 0x00)
	if(reg == (-1))
	    printf("pc");
	else
	    printf("a%d", reg);

    if((index&0x04) && ((index&0x07) != 0))
	printf("]");

    if((index&0x40) == 0x00) {
	if((index&0x04) || ((index&0x80) == 0x00))
	    printf(",");
	printf("%c%d", (index&0x8000)?'a':'d', (index>>12)&0x7);
	if(index&0x0600) {
	    printf("*%d", vcbScale[(index>>9)&0x3]);
	}
    }

    if(((index&0x04) == 0x00) && ((index&0x07) != 0))
	printf("]");

    if((index & 0x03) && outer != 0) {
	if((index&0x03) == 0x03)
	    printf("%#8x", outer);
	else
	    printf("%#4x", outer);
    }

    printf(")");
}

printea(mode, reg, size)
long mode, reg;
int size;
{
    register long index,disp;
    register long i; /* random temp */

    switch ((int)(mode)) {
      default:	printf("???"); break;

      case 0:	printf("d%ld",reg);
		    break;

      case 1:	printf("a%ld",reg);
		    break;

      case 2:	printf("a%ld@",reg);
		    break;

      case 3:	printf("a%ld@+",reg);
		    break;

      case 4:	printf("a%ld@-",reg);
		    break;

      case 5:	{ int offset = instfetch(2);
		    if (reg == 6) {
			char * sb;
			/* we try to find a nice name for this fp(x) */
			sb = SbFStackOffset(ladr, 1, offset);
			if (sb != 0)
			    printf("%s", sb);
			else
			    printf("a%ld@(%ld.)", reg, offset);
		    } else {
			printf("a%ld@(%ld.)", reg, offset);
		    } /* if */
		break;
		}

      case 6:	index = instfetch(2);
		    disp = (char)(index&0377);
/* (CPU == M68020) */
		    if(index&0x0700) {
			if(index&0x0100) {
			    fullformat(reg, index);
			}
			else {
			    printf("a%d@(%d,%c%ld%c*%d)", reg, disp,
			      (index&0100000)?'a':'d',(index>>12)&07,
			      (index&04000)?'l':'w', vcbScale[(index>>9)&0x03]);
			}
			break;
		    }
/* (CPU == M68020) */
		    printf("a%d@(%d,%c%ld%c)", reg, disp,
		      (index&0100000)?'a':'d',(index>>12)&07,
		      (index&04000)?'l':'w');
		    break;

      case 7:	switch ((int)(reg)) {
		  default:	printf("???"); break;

		  case 0:	index = instfetch(2);
				printf("%x:w",index);
				break;

		  case 1:	index = instfetch(4);
				if(spacehint == spaceText) {
				    PrintPosition(index, fmtProc+fmtLn);
				    break;
				} else {
				    printf("%s",
					SbFNearest(index, true, true, false));
				}
				break;

		  case 2:	printf("pc@(%ld.)",instfetch(2));
				break;

		  case 3:	index = instfetch(2);
				disp = (char)(index&0377);
/* (CPU == M68020) */
				if(index&0x0700) {
				    if(index&0x0100) {
					fullformat(-1L, index);
				    }
				    else {
					printf("pc@(%d,%c%ld%c*%d)",
					    disp,
					    (index&0100000)?'a':'d',
					    (index>>12)&07,
					    (index&04000)?'l':'w',
					    vcbScale[(index>>9)&0x03]);
				    }
				    break;
				}
/* (CPU == M68020) */
				printf("pc@(%ld,%c%ld:%c)", disp,
				(index&0100000) ? 'a' : 'd', (index>>12)&07,
				(index&04000) ? 'l' : 'w');
				break;

		  case 4:	index = instfetch(size==4?4:2);
				printf(IMDF, index);
				break;
	    } /* switch */
	    break;
    } /* switch */
}

printEA(ea,size)
long ea;
int size;
{
	printea((ea>>3)&07,ea&07,size);
}

mapsize(inst)
long inst;
{
	inst >>= 6;
	inst &= 03;
	return((inst==0) ? 1 : (inst==1) ? 2 : (inst==2) ? 4 : -1);
}

char suffix(size)
register int size;
{
	return((size==1) ? 'b' : (size==2) ? 'w' : (size==4) ? 'l' : '?');
}

omove(inst, s)
long inst;
char *s;
{
	int size;

	printf("\tmov%c\t",*s);
	size = ((*s == 'b') ? 1 : (*s == 'w') ? 2 : 4);
	printea((inst>>3)&07,inst&07,size);
	printc(',');
	printea((inst>>6)&07,(inst>>9)&07,size);
}

obranch(inst,dummy)
long inst;
{
	long disp = inst & 0377;
	char *s; 
	int pcrel = ladr;

	s = "s ";
	if (disp > 127) disp |= ~0377;
	else if (disp == 0) { s = " "; disp = instfetch(2); }
/* 68020 */
	else if (disp == 0xff) { s = " "; disp = instfetch(4); }
/* 68020 */
	printf("\tb%s%s\t",bname[(int)((inst>>8)&017)],s);
	PrintPosition(disp+pcrel, fmtProc+fmtLn);
	/*printf("ps2:%x",disp+pcrel);*/
	/*psymoff(disp+inkdot(2), ISYM, "");*/
}

oscc(inst,dummy)
long inst;
{
	printf("\ts%s\t",bname[(int)((inst>>8)&017)]);
	printea((inst>>3)&07,inst&07,1);
}

biti(inst, dummy)
long inst;
{
	printf("\t%s\t", bit[(int)((inst>>6)&03)]);
	if (inst&0x0100) printf("d%ld,", inst>>9);
	else { printf(IMDF, instfetch(2)); printc(','); }
	printEA(inst);
}

opmode(inst,opcode)
long inst;
{
	register int opmode = (int)((inst>>6) & 07);
	register int reg = (int)((inst>>9) & 07);
	int size;

	size = (opmode==0 || opmode==4) ?
		1 : (opmode==1 || opmode==3 || opmode==5) ? 2 : 4;
	printf("\t%s%c\t", opcode, suffix(size));
	if (opmode>=4 && opmode<=6)
	{
		printf("d%d,",reg);
		printea((inst>>3)&07,inst&07, size);
	}
	else
	{
		printea((inst>>3)&07,inst&07, size);
		printf(",%c%d",(opmode<=2)?'d':'a',reg);
	}
}

shroi(inst,ds)
long inst;
char *ds;
{
	int rx, ry;
	char *opcode;
	if ((inst & 0xC0) == 0xC0)
	{
		opcode = shro[(int)((inst>>9)&03)];
		printf("\t%s%s\t", opcode, ds);
		printEA(inst);
	}
	else
	{
		opcode = shro[(int)((inst>>3)&03)];
		printf("\t%s%s%c\t", opcode, ds, suffix(mapsize(inst)));
		rx = (int)((inst>>9)&07); ry = (int)(inst&07);
		if ((inst>>5)&01) printf("d%d,d%d", rx, ry);
		else
		{
			printf(IMDF, (rx ? rx : 8));
			printf(",d%d", ry);
		}
	}
}		

oimmed(inst,opcode) 
long inst;
register char *opcode;
{
	register int size = mapsize(inst);
	long const;

	if (size > 0)
	{
		const = instfetch(size==4?4:2);
		printf("\t%s%c\t", opcode, suffix(size));
		printf(IMDF, const); printc(',');
		printEA(inst,size);
	}
	else printf(badop);
}

oreg(inst,opcode)
long inst;
register char *opcode;
{
	printf(opcode, (inst & 07));
}

extend(inst, opcode)
long	inst;
char	*opcode;
{
	register int size = mapsize(inst);
	int ry = (inst&07), rx = ((inst>>9)&07);
	char c;

	c = ((inst & 0x1000) ? suffix(size) : ' ');
	printf("\t%s%c\t", opcode, c);
	if (*opcode == 'e')
	{
		if (inst & 0x0080) printf("d%ld,a%ld", rx, ry);
		else if (inst & 0x0008) printf("a%ld,a%ld", rx, ry);
		else printf("d%ld,d%ld", rx, ry);
	}
	else if ((inst & 0xF000) == 0xB000) printf("a%ld@+,a%ld@+", ry, rx);
	else if (inst & 0x8) printf("a%ld@-,a%ld@-", ry, rx);
	else printf("d%ld,d%ld", ry, rx);
}

olink(inst,dummy)
long inst;
{
	printf("\tlink\ta%ld,", inst&07);
	if(inst&0x08)
	    printf(IMDF, instfetch(4));		/* 68020 */
	else
	    printf(IMDF, instfetch(2));
}

otrap(inst,dummy)
long inst;
{
	printf("\ttrap\t");
	printf(IMDF, inst&017);
}

oneop(inst,opcode)
long inst;
register char *opcode;
{
	if( *opcode == 'j' ) spacehint = spaceText;
	printf("\t%s\t",opcode);
	printEA(inst);
	spacehint = -1;
}

pregmask(mask)
register int mask;
{
	register int i;
	register int flag = 0;

	printf("#<");
	for (i=0; i<16; i++)
	{
		if (mask&1)
		{
			if (flag) printc(','); else flag++;
			printf("%c%d",(i<8)?'d':'a',i&07);
		}
		mask >>= 1;
	}
	printf(">");
}

omovem(inst,dummy)
long inst;
{
	register int i, list = 0, mask = 0100000;
	register int reglist = (int)(instfetch(2));

	if ((inst & 070) == 040)	/* predecrement */
	{
		for(i = 15; i > 0; i -= 2)
		{ list |= ((mask & reglist) >> i); mask >>= 1; }
		for(i = 1; i < 16; i += 2)
		{ list |= ((mask & reglist) << i); mask >>= 1; }
		reglist = list;
	}
	printf("\tmovem%c\t",(inst&100)?'l':'w');
	if (inst&02000)
	{
		printEA(inst);
		printc(',');
		pregmask(reglist);
	}
	else
	{
		pregmask(reglist);
		printc(',');
		printEA(inst);
	}
}

ochk(inst,opcode)
long inst;
register char *opcode;
{
	printf("\t%s\t",opcode);
	printEA(inst, (inst&0x80)?2:4);
	printf(",%c%ld",(*opcode=='l')?'a':'d',(inst>>9)&07);
}

soneop(inst,opcode)
long inst;
register char *opcode;
{
	register int size = mapsize(inst);

	if (size > 0)
	{
		printf("\t%s%c\t",opcode,suffix(size));
		printEA(inst);
	}
	else printf(badop);
}

oquick(inst,opcode)
long inst;
register char *opcode;
{
	register int size = mapsize(inst);
	register int data = (int)((inst>>9) & 07);

	if (data == 0) data = 8;
	if (size > 0)
	{
		printf("\t%s%c\t", opcode, suffix(size));
		printf(IMDF, data); printc(',');
		printEA(inst);
	}
	else printf(badop);
}

omoveq(inst,dummy)
long inst;
{
	register int data = (int)(inst & 0377);

	if (data > 127) data |= ~0377;
	printf("\tmoveq\t"); printf(IMDF, data);
	printf(",d%ld", (inst>>9)&07);
}

oprint(inst,opcode)
long inst;
register char *opcode;
{
	printf("\t%s",opcode);
}

/*** 68020 instructions ***/

obkpt(inst)
long inst;
{
    printf("\tbkpt\t%d", inst&0x07);
}

ocallm(inst)
long inst;
{
	/* also RTM */
	/* FIXME */
}

ocas(inst)
long inst;
{
	/* FIXME */
}

ochk2(inst)
long inst;
{
	/* also the cmp2 instruction */
	/* FIXME */
}

olmul(inst, opcode)
long inst;
register char *opcode;
{
	long extra = instfetch(2);

	printf("\t%s", opcode);

	printEA(inst, 0);
	/* FIXME */
}

char *trapccname[16] = {
    "t",  "f",  "hi", "ls",
    "cc", "cs", "ne", "eq",
    "vc", "vs", "pl", "mi",
    "ge", "lt", "gt", "le"
};

otrapcc(inst)
long inst;
{
    long operand;

    printf("\ttrap\t%s", trapccname[(inst>>8)&0x0f]);

    switch(inst&0x07) {
    case 0x02:
	operand = instfetch(2);
	printf(",#0x%04x", operand);
	break;
    case 0x03:
	operand = instfetch(4);
	printf(",#0x%08x", operand);
	break;
    case 0x04:
	operand = 0;
	break;
    }
}	

char *bitfld[8] = {
	"bftst",
	"bfextu",
	"bfchg",
	"bfexts",
	"bfclr",
	"bfffo",
	"bfset",
	"bfins"
};

obits(inst)
long inst;
{
    long extra = instfetch(2);

    printf("%s", bitfld[(inst>>8)&0x0f]);
    if((inst&0x0700) == 0x0700)
	printf("d%d,", (extra>>12)&0x07);

    printEA(inst, 0);

    if(extra&0x0800)
	printf("{d%d:", (extra>>6)&0x7);
    else
	printf("{%d:", (extra>>6)&0x1f);
    if(extra&0x0020)
	printf("d%d}", extra&0x7);
    else
	printf("%d}", extra&0x1f);

    if((inst&0x0700) != 0x0700 && (inst&0x0100))
	printf(",d%d", (extra>>12)&0x07);
}

cpgen(inst)
long inst;
{
    long extra;

    extra = instfetch(2);
    printf("\tcpGEN\t%d,0x%04x,", (inst>>9)&0x07, extra&0xffff);
    printEA(inst, 0);
}


cpdbcc(inst)
long inst;
{
    long extra;
    long disp;
    int pcrel = ladr;

    extra = instfetch(2);
    disp = instfetch(2);
    printf("\tcpDBcc\t%d,d%d,0x%04x,", (inst>>9)&0x07, inst&0x07, extra&0xffff);
    PrintPosition(disp+pcrel, fmtProc+fmtLn);
}


cptrap(inst)
long inst;
{
    long extra;
    long operand;

    extra = instfetch(2);
    printf("\tcpDBcc\t%d,0x%04x,", (inst>>9)&0x07, extra&0xffff);
    switch(inst&0x07) {
    case 0x02:
	operand = instfetch(2);
	break;	
    case 0x03:
	operand = instfetch(4);
	break;	
    case 0x04:
	break;
    }
}


cpscc(inst)
long inst;
{
    long extra;

    extra = instfetch(2);
    printf("\tcpScc\t%d,0x%04x,", (inst>>9)&0x07, extra&0xffff);
    printEA(inst, 0);
}


cpbcc(inst)
long inst;
{
}


cpsave(inst)
long inst;
{
}


cprest(inst)
long inst;
{
}

