/* $Header: dummy.c,v 6.3 86/09/15 09:32:05 peter Exp $ */
/* CDB 6.0 (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */

/* The stub routines satisfy various external references to missing options */

#include "cdb.h"

/* P R I N T   V E R S I O N */

export void PrintVersion(x)
int	x;
{
#include "vers.h"

    if (x == 1) {
	printf("CDB %d.%d ", major, minor);
	printf("(C) Copyright 1984 by Third Eye Software, Inc.\n");
    } else {
	printf("\n\n");
	printf("\tCDB Release %d.%d, local release %d.\n",major, minor, load);
	printf("\tLoaded on %s by %s\n", date, user);
	printf("\tThis debugger is configured for\n");
	printf("\t*** %s ***\n", SYS_NAME);
    } /* if */
} /* PrintVersion */


#ifndef LANG_FORTRAN
export void F_PxSe() {}
export pSYMR F_SymFAdr() {}
export void PxCommon() {}
export void DoCommon() {}
#endif /* LANG_FORTRAN */

#ifndef WINDOWS
export void ClearTargetScreen() { }
export void SetSrcWw() { }
export void CenterWw() { }
export void UpLine() { }
export void MakeActive() { }
export void InitAllWw() { }
export void RestoreAllWw() { }
export void WwCmd() { }
export void EdOpenFile() { }
export void JumpScrollWw() { }
export void MarkLine() { }
export void ShowBp() { }
export void Highlight() { }
#endif /* WINDOWS */

#ifndef REMOTE
export void CloseComm() { }
export void InitComm() { }
export void XBlockTransfer() { }

export void CreateTarget()
{
    OsCreateTarget();
}

export int SendSignal(sig)
int	sig;
{
    return(kill(v->pid, sig));
}

export int Ptrace(pt, pid, adr, value)
int	pt,  pid, value;
char	*adr;
{
    return(ptrace(pt, pid, adr, value));
}

export int Wait(pstatus)
int	*pstatus;
{
    return(wait(pstatus));
}

#endif /* REMOTE */

#ifndef MULTI
char * vsbMultiErr = "Debugger is not equipped with multiprocess option.";
export void FreeProcess() {}
export pPRR PrFAttachProcess() {UError(vsbMultiErr);}
export pPRR PrFExec() {UError(vsbMultiErr);}
#endif /* MULTI */
