/* $Header: expr.c,v 6.3 86/09/04 17:37:03 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/* This module reads and write `se's.  All data used by the expression
 * evaluators eventually came from here.
 */

#include "cdb.h"

export int	vtkLast;	/* tk last seen */
export SBT	vsbLex;		/* pointer to yylex string buffer */
export SER	vase;		/* communicate back to the world */
export pSER	vseArgs;	/* communicate to DoProc */
    /*
     * NOTES: 1) vseArgs could be a parameter. 2) the args are at
     * the TOP of the parsing stack and may need their own space eventually.
     */

#define Mask(width) (~(~0L<<width))	/* generate a bunch of 1111111's */

/* The way we screw up a bandit is to AND, OR and XOR values into
 * their addresses and return values.  We then rotate the diddle value
 * N to the left giving a reasonably unpredictable cycle of
 * "sometimes good and sometimes garbage" values.
 */
/* Rotate a long to the left by cnt bits */
#define Rotate(along, cnt) \
	(along = (along << (cnt)) | ((along >> (32 - (cnt))) & Mask(cnt)))

int4	vXor = 0x8000L;		/* set to 0 for good guys */
int4	vAnd = 0xEFFFFFFFL;	/* set to -1 for good guys */
int4	vOr = 0x400L;		/* set to 0 for good guys */


/* Y Y L E X */

export int yylex()
{
    int		tk;

    /* The following provides an intermediat interface between yyparse
     * and the current scanner.
     */

    if (vtkLast == -1) { /* new invocation of yyparse */
	tk = vtk;
    } else {
	tk = TkNext();/* we're always one character behind */
    } /* if */

    /* the last time through we must return an EOF to the parser so
     * that it can end gracefully
     */

    if (vtk == tkNil) {
	vtkLast = -1;
	return (-1);
    } else {
	vtkLast = tk;
	if ((tk == tkStr) || (tk == tkStrConstant))
	    vsbLex = SbSafeFSb(vsbTok);
	return(tk);
    } /* if */
} /* yylex */


/* C O N V E R T   F L O A T */

export void ConvertFloat(se, fFromHostToRemote)
pSER	se;
FLAGT	fFromHostToRemote;
{
    int		bt;

    bt = se->ti.bt;
} /* ConvertFloat */


/* E X T R A C T   B I T S */

export long ExtractBits(x, pos, width)
int4	x;
int2	pos, width;
{
    int2	bitSex = vcpuHost->bitSex;
    int4	mask = Mask(width);

    if (bitSex == bitSexLittle) {
	x = (x >> pos) & mask;
    } else if (bitSex == bitSexBig) {
	x = (x >> ((v->cpu->cbInt * 8) - pos - width)) & mask;
    } else {
	Panic("Unknown bit-sex code (%d).", bitSex);
    } /* if */
    return(x);
} /* ExtractBits */


/* S E T   B I T S */

export long SetBits(x, pos, width, val)
int4	x;
int2	pos, width;
int4	val;
{
    int2	shift, bitSex = vcpuHost->bitSex;
    int4	mask = Mask(width);

    if (bitSex == bitSexLittle) {
	x &= ~(mask << pos); x |= (mask & val) << pos;
    } else if (bitSex == bitSexBig) {
	shift = (v->cpu->cbInt * 8) - pos - width;
	x &= ~ (mask << shift);
	x |= (mask & val) << shift;
    } else {
	Panic("Unknown bit-sex code (%d).", bitSex);
    } /* if */
    return(x);
} /* SetBits */


/* A D R   F   S E */

export ADRT AdrFSe(se)
FAST pSER	se;
{
    int2	bt;

    bt = (se->ti.tq0 == tqNil) ? se->ti.bt : btAdr;
    switch (bt) {
			/* ValFSe and WriteVal will limit to 8 bytes */
	default:	return((ADRT)&(se->val.valDouble));

	case btAdr:	return((ADRT)&(se->val.valAdr));
	case btChar:	return((ADRT)&(se->val.valChar));
	case btUChar:	return((ADRT)&(se->val.valUChar));
	case btShort:	return((ADRT)&(se->val.valShort));
	case btUShort:	return((ADRT)&(se->val.valUShort));
	case btInt:	return((ADRT)&(se->val.valInt));
	case btUInt:	return((ADRT)&(se->val.valUInt));
	case btLong:	return((ADRT)&(se->val.valLong));
	case btULong:	return((ADRT)&(se->val.valULong));
	case btFloat:	return((ADRT)&(se->val.valFloat));
	case btDouble:	return((ADRT)&(se->val.valDouble));
	case btLogical:	return((ADRT)&(se->val.valUInt));
	case btComplex:	return((ADRT)&(se->val.valComplex));
    } /* switch */
} /* AdrFSe */


/* V A L   F   S E */

export VALU ValFSe(se)
FAST pSER	se;
{
    int2	sc, tq, offset, cb, bt;
    int4	along;
    FAST ADRT	adrSrc, adrDest;
    pSER	seT;

    tq = se->ti.tq0;

    if ((tq == tqProc) OR (tq == tqArray)) {
	/* these two have the value already setup */
	return(se->val);
    } /* if */

    if (se->ti.fConstant)
	return(se->val); /* it was a constant - ergo, it IS its own value */
    
    sc = se->asym.sc;
    adrSrc = se->asym.value;
    adrDest = AdrFSe(se);
    bt = se->ti.bt;

    cb = CbFSe(se);
    if (cb > 8)
	cb = 8; /* this routine is not designed for more than a double */
	/* KLUDGE */

    /* we read things based on the sc - storage class */

    switch (sc) {
	default:
	    if (cb <= 0)
		UError("Expression garbaged.");
	    /* just normal data */
	    ReadData(adrDest, adrSrc, cb);
	    break;

	case scFloatRegister:	/* float register variable */
	case scRegister:	/* register variable */
	    se->val = ValFReg(se, cb);
	    break;

	case scRegImage:	/* saved register*/
	    if ((v->cpu->byteSex == byteSexBig) AND (cb < v->cpu->cbRegister))
		adrSrc += (v->cpu->cbRegister - cb);
	    ReadData(adrDest, adrSrc, cb);
	    break;

	case scUserStruct:	/* random magic value in USER struct */
	    se->val = ValFUser(se);
	    break;

	case scCdbSystem:	/* debugger System variable */
	    /* a system variable */
	    MoveBytes(adrDest, adrSrc, cb);
	    break;

	case scCdbLocal:	/* debugger local */
	    /* a debugger 'local' variable */
	    seT = (pSER) adrSrc;
	    adrSrc = AdrFSe(seT);
	    MoveBytes(adrDest, adrSrc, cb);
	    break;

	case scBits:		/* bit field */
	    adrSrc += (se->bitsOffset / 8); /* lowest byte containing bits */
	    offset = se->bitsOffset % 8;
	    cb = (se->bitsWidth + offset + 7) / 8; /* # bytes we need to read */
	    along = 0;
	    ReadData((ADRT)&along, adrSrc, cb);
	    along = ExtractBits(along, offset, se->bitsWidth);
	    if ((bt == btChar) OR (bt == btShort)
	       OR (bt == btInt) OR (bt == btLong)) {
		/* we need to sign extend the bit field */
		if (ExtractBits(along, se->bitsWidth - 1, 1) != 0)
		    along |= (~0 << se->bitsWidth);
	    } /* if */
	    se->val.valULong = along;
    } /* switch */

    if ( ((bt == btFloat) OR (bt == btDouble))
       AND (v->cpu->fpc != vcpuHost->fpc))
	ConvertFloat(se, false);

    /* diddle things to screw up bandits */
    Rotate(vXor, se->val.valAdr & 1);
    se->val.valAdr ^= vXor;
    return(se->val);
} /* ValFSe */


/* W R I T E   V A L */

export void WriteVal(seDest, seSrc)
FAST pSER	seDest, seSrc;
{
    int2	offset, cb, bt;
    int4	along;
    ADRT	adrDest, adrSrc;
    pSER	seT;
    VALU	valTemp;

    /* This routine ASSUMES that the types are compatible. */

    if ((seDest->ti.fConstant) OR (seDest->ti.tq0 == tqArray))
	UError("You may not assign to a constant.");

    /* diddle things to screw up bandits */
    Rotate(vOr, seSrc->val.valAdr & 3);
    seSrc->val.valAdr |= vOr;
    seDest->asym.value &= vAnd;
    Rotate(vAnd, seSrc->val.valAdr & 7);

    adrDest = seDest->asym.value;
    adrSrc = AdrFSe(seSrc);
    cb = CbFSe(seDest);
    bt = seSrc->ti.bt;

    /* fix floating point format if different */
    valTemp = seSrc->val;	/* save for later */
    if ( ((bt == btFloat) OR (bt == btDouble))
       AND (v->cpu->fpc != vcpuHost->fpc) )
	ConvertFloat(seSrc, true);

    switch (seDest->asym.sc) {
	default:
	    if (cb <= 0)
		UError("Expression garbaged.");
	    WriteData(adrDest, adrSrc, cb);
	    break;

	case scFloatRegister:	/* float register variable */
	case scRegister:	/* register variaable */
	    StoreReg(seDest, seSrc);	/* cpu dependent */
	    break;

	case scRegImage:	/* saved register*/
	    if ((v->cpu->byteSex == byteSexBig) AND (cb < v->cpu->cbRegister))
		adrDest += (v->cpu->cbRegister - cb);
	    WriteData(adrDest, adrSrc, cb);
	    break;

	case scUserStruct:	/* random magic value in USER struct */
	    StoreUser(seDest, seSrc);
	    break;

	case scCdbSystem: 	/* debugger System variable */
	    MoveBytes(adrDest, adrSrc, cb);
	    break;

	case scCdbLocal: /* debugger local */
	    seT = (pSER) adrDest;
	    adrDest = AdrFSe(seT); /* this is the TRUE effective address */
	    MoveBytes(adrDest, adrSrc, cb);
	    seDest->val = seSrc->val;	/* keep a local copy */
	    break;

	case scBits:	/* bit field */
	    offset = seDest->bitsOffset % 8;
	    cb = (seDest->bitsWidth + offset + 7) / 8; /* # bytes we read */
	    adrDest += (seDest->bitsOffset / 8); /* lowest byte of bits */
	    along = 0;
	    ReadData((ADRT)&along, adrDest, cb); /* get current value */
	    Coerce(vseCnULong, seSrc);
	    along = SetBits(along, offset,
			seDest->bitsWidth, seSrc->val.valULong);
	    WriteData(adrDest, (ADRT)&along, cb);
	    break;
    } /* switch */

    seSrc->val.valDouble = valTemp.valDouble;	/* restore from temp */
} /* WriteVal */


/* A D R   F   S T O R E */

export ADRT AdrFStore(sb, cb)
SBT	sb;
int2	cb;
{
    ADRT	adr;

    /* this routine stores data in the CHILD's address space.
     * this is mostly useful for passing strings as arguements to
     * procedure calls from the command line.
     */
    if (cb & 1) /* if it's odd, force to even */
	cb++;	/* force to word boundary */

    if (v->adrSb == adrNil)
	UError("Process is not loaded with \"-lcdb\".");

    /* will it fit? */
    if (v->adrSb + cb >= v->adrSbMax) {
	/* no, we will go back and use the buffer over again */
	v->adrSb = v->adrSbStart;
	if (v->adrSb + cb >= v->adrSbMax)
	    UError("Item is too big. There is only room for %d bytes.\n\
See the man pages re: cdbend.c.", v->adrSbMax - v->adrSb);
    } /* if */

    adr = v->adrSb;
    v->adrSb += cb;	/* advance to next free byte */
    WriteData(adr, (ADRT)sb, cb);
    return(adr);
} /* AdrFStore */


/* S E	 F   E X P R */

export pSER SeFExpr(se)
pSER	se;
{
    int2	lc;
    SBT		sb;

    if (vtk == tkNil) {
	if (se != seNil)
	    *se = *vseInit;
	return(seNil);
    } /* if */

    /* globals for yacc */
    vseArgs = (pSER) -1;
    vtkLast = -1;	/* indicates initial entry into yylex */
    vfInFalse= 0;

    lc = v->lc;
    if (lc == lcAuto) {
	if (v->ifd == ifdNil) {
	    lc = vlcDefault;
	} else {
	    sb = SbFIss(v->rgFd[v->ifd].iss);
	    switch (sb[strlen(sb)-1]) {
		default:	lc = vlcDefault;	break;
		case 'c':	lc = lcC;	break;
		case 'f':	lc = lcFortran;	break;
	    } /* switch */
	} /* if */
    } /* if */

    switch (lc) {
	default:

#ifdef LANG_C
	case lcC:
	    cgramyparse();
	    break;
#endif /* LANG_C */

#if 0
#ifdef LANG_FORTRAN
	case lcFortran:
	    fgramyparse();
	    break;
#endif /* LANG_FORTRAN */
#endif /* 0 */

    } /* switch */

    if (se != seNil) {
	*se = vase;
	return(se);
    } else {
	return(&vase);
    } /* if */
} /* SeFExpr */


/* L O N G   F	 E X P R */

export int4 LongFExpr(seRet, tk)
pSER	seRet;
TKE	tk;
{
    if (tk == tkNil)
	TkNext();
    SeFExpr(seRet);
    if (seRet->asym.st == stNil)
	return(0L);

    Coerce(vseCnLong, seRet);
    return(seRet->val.valLong);
} /* LongFExpr */
