#include <stdio.h>

main(argc, argv)
char **argv;
{
	int	value;
	int	result;

	if(argc < 2) {
		fprintf(stderr, "Usage: %s number\n");
		exit(1);
	}


	value = atoi(argv[1]);
	if(value > 15) {
		fprintf(stderr, "Number too big\n");
		exit(1);
	}

	result = fib(value);

	fprintf(stdout, "Fib(%d) = %d\n", value, result);
	exit(0);
}

fib(n)
{
	int	pid;
	int	status;
	int	result;

	if((pid = fork()) < 0) {
		exit(0);
	}

	if(pid == 0) {
		if(n <= 0)
			exit(0);
		if(n == 1)
			exit(1);
		exit(fib(n-1)+fib(n-2));
	}
	else {
		wait(&status);
		result = (status>>8)&0xff;
		return(result);
	}
}
