/* $Header: format.c,v 6.2 86/09/01 17:19:46 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/* This file does the data formatting.
 * WARNING - DisplaySe is a ---> SWAMP <----.
 * Only Masochists should venture forth into this stuff.
 */

#include "cdb.h"
#include <setjmp.h>

export FLAGT	vfInDisplay = false;
export FLAGT	vfBadAddress = false;
export char vsbFmt[60]; /* format spec for addresses */
static char vsbAdr[60]; /* where we stick last address formatted - SbFAdr */

export int vcNest;	/* nesting level for printing structures and unions */
export SBT vsbSpaces =
"                                                                             ";

#if 0
/* Don't remove this section - it is picked up by 'make ext.h' */
exportdefine PrintNest(cNest, cb) if (cNest) printf("%.*s", cNest*cb, vsbSpaces)
#endif


/* S B   F   A D R */

export SBT SbFAdr(adr, fMask)
ADRT    adr;
FLAGT   fMask;
{
    /* Format an address in the current, user-defined format */

    if (vsbFmt[0] == chNull)
#ifdef V7_PRINTF
        strcpy(vsbFmt, "0x%lx");
#else
        strcpy(vsbFmt, "%#lx");
#endif /* V7_PRINTF */
    if (fMask AND (v->cpu->cbPointer == 2))
        adr &= 0x0000ffffL;
    sprintf(vsbAdr, vsbFmt, adr);
    return(vsbAdr);
} /* SbFAdr */


/* S B   F   B I N A R Y */

export SBT SbFBinary(value, cbits)
FAST uint4	value;
int	cbits;
{
    FAST int	i;
    FAST SBT	sb;
    static char	sbBuf[40];

    /* generate a string of 0/1's for the given value */

    sb = sbBuf;
    value <<= 32 - cbits;
    for (i = 32-cbits+1; i <= 32; ++i, value <<= 1) {
	*sb++ = (value & 0x80000000) ? '1' : '0';
	if ((i % 4) == 0)
	    *sb++ = ' ';
    } /* for */
    sb[-1] = chNull;	/* overwrite last ' ' */
    return(sbBuf);
} /* SbFBinary */


/* D F   F   S E */

export DFE DfFSe(se, fAlternate)
pSER	se;
FLAGT	fAlternate;
{
    int2	tq;

    /* Determine the `natural' display format for the given value */

    if (se->asym.st == stCommon)
	return(dfCommon);

    tq = se->ti.tq0;
    if ((tq == tqPtr) OR (tq == tqArray)) {
	if ( fAlternate
	   AND ((se->ti.bt == btChar) OR (se->ti.bt == btUChar))
	   AND (TqFSe(se, 1) == tqNil) ) {
	    return((tq == tqPtr) ? dfPStr : dfStr);	/* so it looks pretty */
	} else if (tqProc == TqFSe(se, 1)) {
	    return(dfProc);
	} /* if */
	return(dfAdr);	/* use address display mode */
    } /* if */
    
    switch (se->ti.bt) {
	case btNil:	return(dfNil);
	case btUnion:
	case btStruct:	return( (fAlternate) ? dfStruct : dfAdr );
	case btUChar:
	case btUShort:
	case btUInt:
	case btULong:	return(dfUnsigned);
	case btShort:
	case btInt:
	case btLong:	return(dfDecimal);
	case btFloat:
	case btDouble:	return(dfGFloat);
	case btComplex: return(dfComplex);
	case btLogical:	return(dfBoolean);
	case btEnum:	return(dfEnum);
	case btChar:	if ((tq == tqArray) AND fAlternate)
			    return(dfStr);
			 else
			    return(dfChar);
    } /* switch */
    return(dfDecimal);
} /* DfFSe */


/* C B   F   C H */

export int CbFCh(ch)
char    ch;
{
    /* Return the size in byte associated with a given format character */

    switch (ch) {
	case 'A':	return(v->cpu->cbPointer);
        case 'b':
        case 'c':       return(v->cpu->cbChar);
        case 'e':
        case 'f':
        case 'g':       return(v->cpu->cbFloat);
        case 'E':
        case 'F':
        case 'G':       return(v->cpu->cbDouble);
        case 'D':
        case 'O':
        case 'U':
        case 'X':       return(v->cpu->cbLong);
    } /* switch */
    return(-1);	/* says to use current size */
} /* CbFCh */


/* D F   F   C H */

export DFE DfFCh(ch)
char    ch;
{
    /* Return the display format associated with a given character */

    switch (ch) {
	case 'A':	return(dfAdr);
        case 'B':       return(dfBinary);
        case 'a':       return(dfStr);
        case 'C':
        case 'c':       return(dfChar);
        case 'b':
        case 'D':
        case 'd':       return(dfDecimal);
        case 'E':
        case 'e':       return(dfEFloat);
        case 'F':
        case 'f':       return(dfFFloat);
        case 'G':
        case 'g':       return(dfGFloat);
	case 'I':	return(dfCompiler);
	case 'i':	return(dfInstruction);
        case 'N':       return(dfStandard);
        case 'n':       return(dfNil);
        case 'O':
        case 'o':       return(dfOctal);
        case 'P':       return(dfProc);
        case 'p':       return(dfProcLine);
        case 'S':       return(dfStruct);
        case 's':       return(dfPStr);
        case 'U':
        case 'u':       return(dfUnsigned);
	case 't':	return(dfType);
        case 'X':
        case 'x':       return(dfHex);
    } /* switch */
    return(dfNil);
} /* DfFCh */


/* G E T   M O D E */

export void GetMode(mode)
pMODER  mode;
{
    char        ch;
    TKE         tk;

    /* Get a display mode (if any) from the current command line */

    /* NOTE: we assume WE get next token!! */
    tk = TkNext();

    if (tk == tkNil) {
        return;
    } else if (tk == tkNumber) {
        mode->cnt = atoi(vsbTok);
        tk = TkNext();
    } else {
        mode->cnt = 1;
    } /* if */

    if (tk == tkStr) {
        ch = vsbTok[0];
        /* determine # of bytes based on format */
        mode->len = CbFCh(ch);
        /* mode->len = -1; */
        mode->df = DfFCh(ch);
	if ((mode->df == dfNil) AND (ch != 'n'))
	    UError("Unknown display mode.");
        if (vsbTok[1] != chNull)
            mode->len = (vsbTok[1] == 'b') ? 1 : 
                        (vsbTok[1] == 's') ? 2 :
                        (vsbTok[1] == 'l') ? 4 : atoi(&vsbTok[1]);
        tk = TkNext();
    } /* if */
} /* GetMode */


/* I N C   F   S E   M O D E */

export int IncFSeMode(se, mode, multiplier)
pSER    se;
pMODER  mode;
int	multiplier;
{
    int		i, df;

    if ((se->asym.sc == scCdbLocal)	/* we do NOT allow inc's of specials */
       OR (mode->df == dfType))
        return;

    se->asym.iss = issNil;
    df = mode->df;
    if ((df == dfInstruction) OR (df == dfCompiler)) {
	i = vcbInst;
	if (se->asym.sc == scRegister) {
	    ValFSe(se); /* get current value */
	    se->asym.sc = scData;	/* make it NOT a register */
	    se->ti.fConstant = true;
	    se->val.valAdr = se->val.valInt; /* KLUDGE ?? */
	    se->asym.value = se->val.valAdr;
	    se->ti.bt = btAdr;
	} /* if */
	v->adrInst = se->val.valAdr + i;
    } else if (se->asym.sc == scRegister) {
        i = 1;
    } else if (mode->df == dfStr) {
	if (mode->len < 0) {
	    i = -mode->len;
	    mode->len = -1;
	} else {
	    i = mode->cnt * mode->len;
	} /* if */
    } else if (mode->df == dfPStr) {
	i = mode->cnt * v->cpu->cbPointer;
    } else if ((df == dfProc) OR (df == dfProcLine)) {
	i = 0;
    } else {
	i = mode->cnt * mode->len;
    } /* if */

    i *= multiplier;  /* multiplier is either 1 or -1 */
    se->asym.value += i;
    se->val.valAdr += i;
} /* IncFSeMode */


/* D I S P L A Y   S E */

export void DisplaySe(se, mode, fShowAdr, fIndirect, fAlternate)
pSER	se;
pMODER  mode;
FLAGT   fShowAdr, fIndirect, fAlternate;
{
    int2	modval, width, cPrint, cb, len, lenSave;
    int2	cntStruct, fmt, cnt, i, ipd, iln;
    int		*envSave;
    uint4	mask;
    FLAGT       fCharArray, fLocal, fDoStd, fCheckNull, fRandomLength, fDefault;
    char        ch, sbBuf[100];
    SBT		sbVar;
    DFE         df;
    MODER	amodeT;
    ADRT	adrWorking;
    SER		aseT, aseSave, *seSave;
    VALU	val;
    jmp_buf	envDisplaySe;   /* for error recovery */

    df = dfNil;
    envSave = venv;

    if (setjmp(envDisplaySe)) {
	/* we bomnbed out. see if this was for (char *)/n situation */
	if (fDefault AND (df == dfPStr)) {
	    fDefault = false;
	    df = dfHex;
	    printf(" ");
	    goto Pstr_SecondPass;
	} else if (fDefault AND (df == dfFFloat
				OR df == dfEFloat
				OR df == dfGFloat)) {
	    printf("<<invalid float or double (NAN)>>\n");
	} else if (vfBadAddress) {
	    printf("<<bad address>>\n");
	} /* if */
	venv = envSave;
	vfInDisplay = false;
	return;
	/* UError(sbNil);	/* hand it back up to next level */
    } else {
	venv = envDisplaySe;
	vfInDisplay = true;
	vfBadAddress = false;
    } /* if */

Pstr_SecondPass:

    fDoStd = false;	/* says to use user supplied formatting if possible */
    fDefault = false;
    modval = 1;
    seSave = se;
    aseT = *se;	/* we work out on a copy, not the original */
    se = &aseT;

    /* if the mode is supplied, we change the type of se */
    if ((df != dfNil) OR (mode == modeNil)) {
	mode = &amodeT;
        cnt = 1;
	len = -1;
	cntStruct = 1;
	fDefault = true;
    } else {
        df = mode->df;
        cnt = mode->cnt;
        cntStruct = mode->len;
	if ((df == dfStruct) OR (df == dfNil) OR (df == dfStandard))
	    mode->len = -1;
	len = mode->len;

        /* this may not be right, but we need to force the size of what we
         * are looking at to be the size we requested in the format.
         * this way, when we say `sbWord/c;<cr>;<cr>;.='H' ' we actually
         * do the `correct' character assignment.
         */
        if (len > 0) {
            switch (len) {
                case 1: CopyTy(se, vseChar);
			if ((df == dfUnsigned)
			   OR (df == dfHex)
			   OR (df == dfOctal))
			    se->ti.bt = btUChar;
			break;
                case 2: CopyTy(se, vseShort);
			if ((df == dfUnsigned)
			   OR (df == dfHex)
			   OR (df == dfOctal))
			    se->ti.bt = btUShort;
			break;
                case 4: CopyTy(se, vseLong);
			if ((df == dfUnsigned)
			   OR (df == dfHex)
			   OR (df == dfOctal))
			    se->ti.bt = btULong;
			break;
            } /* switch */
        } /* if */
    } /* if */

    aseSave = *se;	/* for use during looping */

    if (df == dfStandard) {
	fDoStd = true;
	df = dfNil;
    } /* if */

    lenSave = len;
    fCharArray = false;

    if (df == dfNil) {
	/* they did not specify display format */
	if (! fIndirect) {
	    df = dfAdr;
	    len = v->cpu->cbPointer;
	} else {
	    df = DfFSe(se, fAlternate);
	    if (df == dfPStr) {
		len = -1;
	    } else if (df == dfStr) {
		if (se->ti.tq0 == tqNil) {
		    len = -1;
		} else {
		    fCharArray = true;
		    len = CbFSe(se);
		} /* if */
	    } else {
		len = CbFSe(se);
	    } /* if */
	} /* if */

	/* remember this stuff */
	mode->df = df;
	mode->cnt = cnt;
	mode->len = len;
    } /* if */

    if ((!fIndirect) AND (len == -1))
	mode->len = len = v->cpu->cbPointer;

    fRandomLength = (len == -1);
    if ( fRandomLength
       AND (df != dfStr)
       AND (df != dfPStr)
       AND (df != dfCompiler)
       AND (df != dfInstruction))
        mode->len = len = CbFSe(se);

    cb = len;
    mask = 0xffffffff;
    if (df == dfBinary) {
	modval = 1;
	if (len <= 4) {
	    width = (len+1) * 8 + 2;
	    len *= 8;
	} else {
	    /* they gave us bits */
	    width = len + 2 + len / 8;
	    mode->len = (len + 7) / 8; /* round up to the next byte */
	} /* if */
    } else if (df == dfPStr) {
	cb = v->cpu->cbPointer;
    } else if (df == dfStr) {
	cb = v->cpu->cbChar;
	if (fRandomLength)
	    mode->len = 0;	/* we will stuff final count in here for Inc */
    } else if (df == dfProcLine) {
        fShowAdr = false;
    } else if (fShowAdr
		AND (len == -1)
		AND ! ((df == dfInstruction) OR (df == dfCompiler)) ) {
	cnt = 1;
	mask = 0xffffffff;
    } else {
        /* here we try to skull out a good width for this size */
        width = 7;
        modval = 8;
	mask = (len == 1) ? 0x000000ff : 0x0000ffff;
        if (len >= 4) {
            width = 14;
            modval = 4;
	    mask = 0xffffffff;
        } /* if */
    } /* if */

    if (cnt == 1)
        width = 0; /* we don't try to add anything if there's just one */

    if ((df == dfInstruction)
       OR (df == dfCompiler)) {
	/* this is a little kludgey */
	ValFSe(se);	/* get the value of the thing */
	se->ti.fConstant = true;	/* lock it in place */
	if (cnt > 1) {
	    /* even weirder - we force the thing to change altogether */
	    se->asym.sc = scData;	
	    se->asym.value = se->val.valAdr;
	    *seSave = *se;
	    aseSave = *se;
	    se = seSave;
	} /* if */
    } else if (df == dfType) {
	fIndirect = false;
	fShowAdr = false;
	cnt = 1;
    } /* if */

    amodeT = *mode;
    mode = &amodeT;
    amodeT.cnt = 1;

    cPrint = 0;
    while (cnt--) {
	if (fIndirect) {
	    val = ValFSe(se);
	} else {
	    val.valAdr = se->asym.value;
	    if (df != dfType)
		CopyTy(se, vseCnAdr);
	} /*if */

        if (fShowAdr
	   AND fIndirect
	   AND (df != dfStruct)
	   AND (df != dfCompiler)
	   AND (df != dfInstruction)
	   AND (!se->ti.fConstant OR (se->asym.sc != scNil))
	   AND (cPrint % modval == 0)) {
            if ((cnt == 0)	/* i.e. we are not doing multiple values */
               AND ((sbVar = SbFIss(se->asym.iss)) != sbNil)
	       AND (*sbVar != chNull))
                printf("%s = ", sbVar);
             else
/* printf("%s  ", SbFNearest(se->asym.value, true, true, false)); */
                printf("%s  ", SbFAdr(se->asym.value, true));
	} else if ((se->asym.sc == scRegister) AND fShowAdr AND !fIndirect) {
	    printf("$r");
        } /* if */

	se->val = val;
	se->ti.fConstant = true;
        switch (df) {
	    case dfCompiler:
		Coerce(vseCnAdr, se);
		SetViewPosition(se->val.valAdr);
		fmt = fmtLn + fmtLine;
		if (v->rgFd[v->ifd].fNoSource) {
		    fmt += fmtProc;
		} else if (v->slop == 0) {
		    Highlight(true);
		    PrintPosition(adrNil, fmtProc+fmtLn+fmtLine);
		    Highlight(false);
		} /* if */
		PrintPosition(adrNil, fmt+fmtInst);
		break;

	    case dfInstruction:
		Coerce(vseCnAdr, se);
		PrintPosition(se->val.valAdr, fmtProc+fmtLn+fmtInst+fmtLine);
		break;

            case dfType:
		PxSe(se, fAlternate);
                break;

            case dfBinary:
		Coerce(vseCnULong, se);
                printf("%*s", width, SbFBinary(se->val.valULong, len));
                break;

            case dfAdr:
		Coerce(vseCnAdr, se);
                printf("%*s", width, SbFAdr(se->val.valAdr, true));
                break;

            case dfDecimal:
		Coerce(vseCnLong, se);
                printf("%*ld", width, se->val.valLong);
                break;

            case dfUnsigned:
		Coerce(vseCnULong, se);
		se->val.valULong &= mask;
                printf("%*lu", width, se->val.valULong);
                break;

            case dfOctal:
		Coerce(vseCnULong, se);
		se->val.valULong &= mask;
#ifdef V7_PRINTF
                sprintf(sbBuf, "0%lo", se->val.valULong);
                printf("%*s", width, sbBuf);
#else
                printf("%#*lo", width, se->val.valULong);
#endif /* V7_PRINTF */
                break;

            case dfHex:
		Coerce(vseCnULong, se);
		se->val.valULong &= mask;
#ifdef V7_PRINTF
                sprintf(sbBuf, "0x%lo", se->val.valULong);
                printf("%*s", width, sbBuf);
#else
                printf("%#*lx", width, se->val.valULong);
#endif /* V7_PRINTF */
                break;

            case dfChar:
		Coerce(vseCnChar, se);
                if (  (se->val.valUChar < ' ')
		   OR (se->val.valUChar > chRCB) ) {
#if (CPU == PDN)
		    ch = AsciiFEbcdic(se->val.valUChar);
#else
		    ch = se->val.valUChar & 0177;
#endif /* (CPU == PDN) */
		    ch += (ch < ' ') ? 0100 : (ch > chRCB) ? -0100 : 0;
#ifdef V7_PRINTF
                    printf("'^%c' (0%o)", ch, se->val.valUChar);
#else
                    printf("'^%c' (%#x)", ch, se->val.valUChar);
#endif /* V7_PRINTF */
		} else {
		    printf("'%c'", se->val.valChar);
		} /* if */
                break;

            case dfFFloat:
            case dfEFloat:
            case dfGFloat:
		Coerce(vseCnDouble, se);
		if (lenSave == -1) {
		    if (df == dfFFloat)
			printf("%*f", width, se->val.valDouble);
		    else if (df == dfEFloat)
			printf("%*e", width, se->val.valDouble);
		    else
			printf("%*g", width, se->val.valDouble);
		} else {
		    if (df == dfFFloat)
			printf("%*.*f", width, lenSave, se->val.valDouble);
		    else if (df == dfEFloat)
			printf("%*.*e", width, lenSave, se->val.valDouble);
		    else
			printf("%*.*g", width, lenSave, se->val.valDouble);
		} /* if */
                break;

	    case dfBoolean:
		Coerce(vseCnULong, se);
                printf("%*s", width, se->val.valULong?"TRUE":"FALSE");
		break;

	    case dfComplex:
		printf("(%f,%f)", se->val.valComplex.valReal,
			se->val.valComplex.valImaginary);
		break;

	    case dfEnum:
		PxEnum(se);
                break;

	    case dfStruct:
		PxStruct(se, cntStruct, true, fAlternate, fDoStd);
                break;

	    case dfCommon:
		PxCommon(se, true, fAlternate);
                break;

            case dfProc:
		Coerce(vseCnAdr, se);
                if (se->val.valAdr == 0)
		    printf("<null proc pointer>");
		else
		    printf("%s()", 
			SbFNearest(se->val.valAdr, true, false, false));
		venv = envSave;
                break;

            case dfProcLine:
		Coerce(vseCnAdr, se);
                PrintPosition(se->val.valAdr, fmtFile+fmtProc+fmtLn+fmtLine);
		venv = envSave;
		vcmdDef = cmdNil;
		vfInDisplay = false;
		return;		/* probably a kludge */
                break;

            case dfPStr:
		Coerce(vseCnAdr, se);
                se->asym.value = se->val.valAdr;
		/* and fall into string stuff */

            case dfStr: 
		adrWorking = se->asym.value;
                fCheckNull = fCharArray;
                if (fRandomLength) {
                    if (adrWorking == 0) {
			printf("<null pointer>");
			break;
                    } /* if */
		    fCheckNull = true;
		    len = 128;
		    if (se->ti.lc == lcFortran)
			len = Min(len, CbFSe(se));
                } /* if */
		fLocal = (se->asym.sc == scCdbSystem); /* from OUR space */
		printf("\"");
                for (i=0; i != len; i++) {
                    ch = (fLocal) ? (* ((char *) adrWorking+i))
#if (CPU == PDN)
			 : ChFRemote(GetByte((ADRT)(adrWorking+i), spaceData));
#else
				: GetByte((ADRT)(adrWorking+i), spaceData);
#endif /* (CPU == PDN) */
                    if ((ch == chNull) AND fCheckNull)
                        break;
                    if (ch < ' ')
                        printf("^%c", ch+0100);
                     else printf("%c", ch);
                } /* for */
		printf("\"");
                break;
        } /* switch */
	*se = aseSave;

	if (fRandomLength) {
	    i += 1;	/* if we did /s or /a, this moves us past the chNull */
	    if (df == dfStr)
		mode->len = -i;	/* remember size for IncFSeMode */
	} /* if */

        if (cnt) {
	    /* we are doing more than one */
	    IncFSeMode(se, mode, 1);
	    aseSave = *se;	/* save this */
            if ( ((++cPrint % modval) == 0)
               OR (df == dfPStr)
	       OR (df == dfStr)
	       OR (df == dfCompiler)
	       OR (df == dfInstruction)
	       OR (df == dfStruct) ) {
                printf("\n");
            } /* if */
        } /* if */

    } /* while */

    if (fDoStd)
	mode->df = dfStandard;
    vfInDisplay = false;
    venv = envSave;
} /* DisplaySe */


/* P X   E N U M */

export void PxEnum(se)
pSER	se;
{
    int		valInt;

    /* Print the symbolic name of the value as a member of a specific ENUM */

    valInt = se->val.valInt;
    if (se->isymRef == isymNil) {
	/* they don't have enough info to figure out name */
	printf("%d", valInt);
	return;
    } /* if */

    SetNextSym(se->isymRef+1);
    while (FNextSym(stMember, stNil, stNil, stEnd, false, sbNil, nil)) {
	if (v->sym->value == valInt) {
	    printf("%s", SbFIss(v->sym->iss));
	    return;
	} /* if */
    } /* while */
    printf("Value %d is not defined for 'enum %s'", valInt,
		SbFIss(SymFIsym(se->isymRef)->iss) );
} /* PxEnum */


/* P X   S T R U C T */

export void PxStruct(seStruct, cntStruct, fDoVal, fAlternate, fDoStd)
pSER	seStruct;
int2	cntStruct;
FLAGT	fDoVal, fAlternate, fDoStd;
{
    int2	bt;
    int4	isymSave;
    char	sbProc[100];
    SBT		sbType, sbName;
    SER		aseField;
    pSYMR	sym;

    /* Itterate through all members of a struct or union,
     * printing either their type or their value.
     * Recurse as necessary.
     */

    if (seStruct->isymRef == isymNil)
	UError("There is insufficient information to do a structure dump.");

    if (seStruct->ti.tq0 != tqNil) {
	printf("\"%s\" is of type:\n", SbFIss(seStruct->asym.iss));
	PxSe(seStruct, false);
	printf("\nWhich is not appropriate for format mode 'S'.\n");
	UError(sbNil);
    } /* if */

    bt = seStruct->ti.bt;
    if ((bt != btStruct) AND (bt != btUnion))
	UError("\"%s\" is not a struct or a union.", SbFIss(seStruct->asym.iss));
    
    sym = SymFIsym(seStruct->isymRef);

    sbType = SbFIss(sym->iss);
    if ((sbType == sbNil)
       AND (seStruct->isymTypedef != isymNil)) {
	sbType = SbFIss(SymFIsym(seStruct->isymTypedef)->iss);
    } /* if */

    if (!fDoStd AND fDoVal AND fAlternate AND (v->pid != pidNil)) {
	/* Try calling a user defined print routine for this struct/union.
	 * Its name is of the form "_structname".
	 */
	fflush(stdout);
	sprintf(sbProc, "_%s", sbType);
	if (FCallUserProc(sbProc, 2, seStruct->asym.value, cntStruct))
	    return;
    } /* if */

    /* now that we know whether the user is supplying his own,
     * we put out the standard lead in.
     */
    MoreOn();

    PrintNest(vcNest, 4);
    if ( ((sbName = SbFIss(seStruct->asym.iss)) != sbNil)
       AND (*sbName != chNull))
	printf("%s = ", sbName);
     else
	printf("%s ", SbFAdr(seStruct->asym.value, true));

    if (bt == btStruct)
	printf("struct ");
    else if (bt == btUnion)
	printf("union ");
    
    if (sbType != sbNil)
	printf("%s ", sbType);
    printf("{\n");

    vcNest++;
    SetNextSym(seStruct->isymRef + 1);
    while (FNextSym(stMember, stNil, stNil, stEnd, false, sbNil, nil)) {

	isymSave = v->isym;
	SeFSym(&aseField, v->sym, true);
	AdjustFieldOffset(seStruct, &aseField);
	bt = aseField.ti.bt;

	if ( (aseField.ti.tq0 == tqNil)
	   AND ((bt == btStruct) OR (bt == btUnion)) ) {
	    if (fDoVal)
		DisplaySe(& aseField, modeNil, false, true, fAlternate);
	    else
		PxSe(& aseField, fAlternate);
	} else {
	    PrintNest(vcNest, 4);
	    if (fDoVal)
		DisplaySe(& aseField, modeNil, true, true, fAlternate);
	    else
		PxSe(& aseField, fAlternate);
	} /* if */
	printf(";\n");

	SymFIsym(isymSave);

    } /* while */

    vcNest--;
    PrintNest(vcNest, 4);
    printf("}");
    if (seStruct->asym.iss != issNil)
	printf(" %s", SbFIss(seStruct->asym.iss));
    MoreOff();
} /* PxStruct */


/* P X   P R O C */

export void PxProc(ipd, fDoName, fAlternate)
int2	ipd;
FLAGT	fDoName, fAlternate;
{
    int2	ifd, iln, slop, i;
    int4	isym;
    SER		ase, *se = &ase;

    printf("%s(", fDoName ? SbFIpd(ipd) : "");

    if (v->rgPd[ipd].iline == 0) {
	printf(")");
	return;
    } /* if */

    i = 0;
    isym = v->rgPd[ipd].isym + 1;
    while (FNextLocal(false, true, isym)) {
	if (i++ > 0)
	    printf(", ");
	printf("%s", SbFIss(v->sym->iss));
	isym = v->isym + 1;
    } /* while */
    printf(")");

    isym = v->rgPd[ipd].isym + 1;
    while (FNextLocal(false, true, isym)) {
	isym = v->isym + 1;
	SeFSym(se, v->sym, true);
	printf("\n");
	PxSe(se, fAlternate);
	printf(";");
    } /* while */
} /* PxProc */


/* P X   S E */

export void PxSe(se, fAlternate)
pSER	se;
FLAGT	fAlternate;
{
    int2	i, idim, ipd, cPtr, tq, tqLast, st, sc, bt;
    SBT		sbName;
    FLAGT	fDidName, fNeedRP, fDoProc;
    pRNGR	rng;
    SER		ase;

    /* Print the TYPE of the given SE */
    if (se->ti.lc == lcFortran) {
	F_PxSe(se, fAlternate);
	return;
    } /* if */

    tqLast = tqNil;
    fDidName = false;
    st = se->asym.st;
    sc = se->asym.sc;
    bt = se->ti.bt;
    tq = se->ti.tq0;

    /* print storage class */
    if (st == stGlobal) {
	printf("<global> ");
	if (sc == scAbs)
	    printf("<absolute> ");
    } else if (st == stStatic)
	printf("static ");
    else if (  (sc == scRegister)
	    OR (sc == scFloatRegister)
	    OR (sc == scRegImage))
	printf("register ");
    else if ((sc == scCdbSystem) OR (sc == scCdbLocal))
	printf("<special> ");

    if ((se->isymTypedef != 0)
       AND (tq == tqNil)) {
	SeFSym(& ase, &(se->asym), false); /* get JUST the first level */
	/* KLUDGE!!!!! */
	printf("%s %s\n", SbFIss(SymFIsym(se->isymTypedef)->iss),
			SbFIss(se->asym.iss));
	if (! fAlternate)
	    return;	/* they wanted the short form */
    } /* if */

    if ( (tq == tqNil)
       AND (fAlternate)
       AND ((bt == btStruct)
       OR (bt == btUnion)) ) {
	PxStruct(se, -1, false, fAlternate, true);
	fDidName = true;
    } else if (se->asym.st == stCommon) {
	PxCommon(se, false, fAlternate);
	fDidName = true;
    } else {
	/* print type name */
	printf("%s ", SbFBt(bt));
	if ((bt == btEnum)
	   OR (bt == btStruct)
	   OR (bt == btUnion)) {
	    printf("%s ", SbFIss(SymFIsym(se->isymRef)->iss));
	}
    } /* if */

    /* first we total up the dimensions */
    for (idim = 0, i = itqMax-1; i >= 0; i--) {
	if (tqArray == TqFSe(se, i))
	    idim++;
    } /* for */

    sbName = SbSafeFIss(se->asym.iss);
    fNeedRP = false;
    tqLast = tqNil;
    fDoProc = false;
    for (i = itqMax-1; i >= 0; i--) {

	if ((tq = TqFSe(se, i)) == tqNil)
	    continue;

	if (fDoProc) {
	    printf("(");
	    fNeedRP = true;
	} /* if */

	switch (tq) {
	    case tqPtr:
		printf("*");
		break;

	    case tqProc:
		fDoProc = true;
		break;

	    case tqArray:
		if (! fDidName) {
		    printf("%s", sbName);
		    fDidName = true;
		} /* if */
		idim--;
		rng = se->rgRng + idim;
		if (rng->dnLow > rng->dnHigh)
		    printf("[]");
		 else
		    printf("[%d]", rng->dnHigh + 1);	/* KLUDGE - C only */
		break;
	} /* switch */

	tqLast = tq;
    } /* for */

    if (fDoProc) {
	if (fNeedRP) {
	    printf("%s)", sbName);
	    fDidName = true;
	} /* if */
	ipd = IpdFAdr(se->asym.value);
	if (ipd != ipdNil)
	    PxProc(ipd, ! fDidName, fAlternate);
	else
	    printf("%s()", sbName);
	fDidName = true;
    } /* if */

    if (!fDidName)
	if (se->asym.iss != issNil)
	    printf("%s", sbName);
    if (se->asym.sc == scBits)
	printf(" : %d", se->bitsWidth);
} /* PxSe */
