/* $Header: history.c,v 5.4 86/06/02 23:24:54 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/* This file contains routines that will allow redirection of input
 * from a history buffer and from a unix file
 */

#define		h_SIZE 21
#define		LINE_SIZE 256
#define error printf

static struct {
	char	string [LINE_SIZE];
	int	number;
} h_buffer [h_SIZE];

static int 	h_index;		/* index into the buffer */
static int	h_number;		/* sequence number */

static int	h_count;		/* # in buff now */ 
static int	h_init;			/* initialize history */

extern char * redo();

/*
 *	Routines:
 *
 *		h_insert (string)	insert string in history buffer
 *		h_get (index)		return assoc. with index
 *		h_set (index)		set h_p to the indexth
 *						string and set history.
 *		h_print (index)	print the indexth string
 *		h_modify (index)	modify the indexth string
 *						with "redo", set historyp
 *						to the new string and set
 *						history.
 *
 */



/* this routine will insert the string in the next available position in
 *	the history buffer and assign it the next sequence number.
 */

h_insert (string)

	char * string;

{
	register int	empty;
	register char	*pstring;

	if (!h_init) {

		h_index= -1;
		h_init= 1;

	}

	/* remove leading blanks */
	pstring= string - 1;
	empty = 1;
	while (empty && ++pstring && *pstring)
	    empty= (*pstring == '\t' || *pstring == ' ');

	if (!empty) {

		h_index++;
		h_index%= h_SIZE;
		if (h_count != h_SIZE)
			h_count++;
		
		strcpy (h_buffer[h_index].string, pstring);

		/* make sure it is terminated with a \n */
		if (pstring [strlen (pstring) - 1] != '\n')
			strcat (h_buffer[h_index].string, "\n");
		h_buffer [h_index].number= ++ h_number;

	}

} /* h_insert */

char *
h_search (str, len)

char *str;
int len;

{
	register int i, j;

	for (i= 0, j= h_index; i < h_count; i++)
		if (!strncmp (str, h_buffer [j].string, len)) {

			return (h_buffer [j].string);

		 } else {

			j= j - 1;
			if (j < 0) j= h_SIZE;

		}

	return ((char *) 0);

}


char *
h_get (index)

	int index;

{
	register int i;

	if (!h_init) {

		h_index= -1;
		h_init= 1;

	}


	for (i= 0; i < h_count; i++)
		if (h_buffer [i]. number == index)
			return (h_buffer [i].string);

	return ((char *) 0);


} /* h_get */




#define isnum(x) ((x >= '0') && (x <= '9'))
h_set (buf)

char *buf;

{
	register char	*pbuf;
	register char	*insert;
	register int	delnum;
	register int	num;

	if (!h_init) {

		h_index= -1;
		h_init= 1;

	}

	pbuf= buf + 1;
	if (*pbuf == '#') {

		if (h_index == -1) {

			error ("History element not available\n");
			strcpy (buf, "\n");
			return (1);

		}

		insert= h_get (h_number);
		delnum= 2;

	} else if (isnum (*pbuf)) {

		num= 0;

		while (isnum (*pbuf))
			num = (num * 10) + (*(pbuf++) - '0');

		insert= h_get (num);
		if (insert == (char *) 0) {
			error ("History element out of range: %d\n", num);
			strcpy (buf, "\n");
			return (1);
		}
		delnum= pbuf - buf;

	} else {

		while (*pbuf && *pbuf != ' ' && *pbuf != '\t' && *pbuf != '\n')
			pbuf++;

		insert= h_search (buf + 1, pbuf-buf-1);
		if (insert == (char *) 0) {
			error ("History element not found\n");
			strcpy (buf, "\n");
			return (1);
		}
		delnum= pbuf-buf;

	}

	copydown (buf, 0, delnum);
	copyup (buf, 0, strlen (insert) - 1);
	strncpy (buf, insert, strlen (insert) - 1);

	return (0);

} /* h_set */





h_print ()

{
	register int i;

	if (!h_init) {

		h_index= -1;
		h_init= 1;

	}

	i= h_number - (h_SIZE - 2);
	for (i= (i > 0 ? i : 1); i <= h_number; i++)

		printf ("%3d  %s", i, h_get (i));

} /* h_print */




h_modify (buf)

char *buf;

{
	if (!h_init) {

		h_index= -1;
		h_init= 1;

	}

	*buf= '%';
	if (buf [1] == '%')
		buf [1]= '#';

	if (h_set (buf))
		return (1);

	else {
		redo (buf);
	}

	return (0);

} /* h_modify */

/* the following routine will recieve a pointer to a line and allow the
 *	user to modify it, if he presses ctrl-y at any time a null will
 *	be returned, else the poiter to the original string will be
 *	returned
 */

char *redo (realline)
char *realline;
{
	char line_buff [3] [LINE_SIZE];
	register char *line; /* new line */
	register char *in;   /* mod line */
	register char *last;
	register char *traverse;	/* traverse ptr for input line */
	register int  len;	/* length of input line */
	register int  pos;	/* pos we are up to in input line */
	register int temp;

	line= &line_buff [0] [0]; /* new line */
	in= &line_buff [1] [0];   /* mod line */
	last= &line_buff [2] [0];
	if (strlen (realline) > 255)
		UError ("Redo: line too large.");

	printf ("REDO (type '?' for help):\n");
	strcpy (line, realline);
	strcpy (last, realline);
	*in= ' '; *(in + 1)= 0;

	while (*in) {
		traverse=	in;
		pos=	0;
		len=	strlen (in);
		while (*traverse) {
			switch (*traverse) {

			case ' ':
				traverse++;
				pos++;
				continue;

			case 'i':
			case 'I':
				copyup (line, pos, len - pos - 1);
				strncpy (line + pos, ++traverse, len - pos - 1);
				break;

			case 'd':
			case 'D':
				copydown (line, pos, 1);
				copydown (in, pos, 1);
				len--;
				continue;

			case 'r':
			case 'R':
				*traverse= 'i';
				temp= strlen (in) - pos -1;
				copyup (in, pos, temp);
				len+= temp;
				for (; temp; temp--)
					*(traverse+temp-1)= 'd';
				continue;

			case '':
				return (realline);

			case '?':
				if (traverse == in) {
				    printf ("REDO help:\n");
				    printf ("	? - display help\n");
				    printf ("	<CR> - accept line\n");
				    printf ("	i - insert\n");
				    printf ("	r - replace\n");
				    printf ("	d - delete\n");
printf("REDO is a one line positional editor.  Use one of the above\n");
printf("commands underneath the desired position.  I and r are followed by\n");
printf("the string you want inserted or replaced and the d's go under the\n");
printf("characters you want deleted.  D's may be followed by an i or r\n");
printf("but an i or r must be the last commands on a line. <CR> must be\n");
printf("the only character on a line to accept the line.\n");
				    break;
				};

			default:
				printf ("ERROR: you must enter ?,i,r,d\n");
				strcpy (line, last);
				break;

			}; break;};

		strcpy(last, line);
		printf ("OLD: %s\nMOD: ",line);
		gets (in);
		in[255]= 0;
	}; /* while */

	strcpy (realline, line);

	return (realline);

} /* redo.c */





/* this routine will copy a string upwards making room in the middle of
	of it for another string */

copyup (line, pos, num)

	register	char	*line;
	register	int	pos;	/* position to start at */
	register	int	num;	/* number of spaces to open up */

{
	register	int	len;
	register	char	*newend;
	register	char	*oldend;

	len=	strlen (line);
	if (len < pos) {
		for (oldend= line + len; len != pos; len++)
			*oldend++ = ' ';
		*oldend= 0;
	};
	newend=	line + num + len;
	for (oldend= line + len;oldend != (line + pos - 1);oldend--, newend--)
		*newend=	*oldend;

} /* copyup */





/* this routine will copy a string downwards deleting part of the string */


copydown (line, pos, num)

	register	char	*line;
	register	int	pos;	/* position to start at */
	register	int	num;	/* number of spaces to delete */

{
	register	int	len;
	register	char	*newpos;
	register	char	*oldpos;

	len=	strlen (line);
	if (len <= pos) return;
	newpos=	line + pos;
	for (oldpos= line + pos + num; (newpos == line) || *(newpos - 1); oldpos++, newpos++)
		*newpos=	*oldpos;

} /* copydown */
