/* $Header: lib.c,v 6.2 86/08/12 22:28:00 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"
#include <setjmp.h>
#include <varargs.h>
#include <signal.h>

jmp_buf venvFixer;

#define OFF	-1
local int	vcLines = OFF;
local int	vcMoreUsers = 0;	/* count of nesting calls to MoreOn */
export int	vcLinesMax = 22;
local int	vcColUsers = 0;		/* cont of nesting calls to ColOn */
local int	vcCol = OFF;


/* F   B L O C K   C M P */

export int FBlockCmp(sb1, sb2, cb)
register char	*sb1, *sb2;
register int	cb;
{
    while (*sb1++ == *sb2++) {
	if (--cb == 0)
	    return(1);
    } /* while */
    return(0);
} /* FBlockCmp */


/* S B   C O N C A T */

export char * SbConcat(sbDest, sb1)
register char	*sbDest;
char	*sb1;
{
    static char	sbBuf1[400], sbBuf2[400];
    register char *sb;
    register char **psb = &sb1;
    char 	*sbRet;

    if (sbDest == 0) {
	/* thay want default buffer */
	while (*psb && (*psb != sbBuf1))
	    psb++;
	sbDest = (*psb == sbBuf1) ? sbBuf2 : sbBuf1;
	ZeroBlock(sbDest, sizeof(sbBuf1));
	psb = &sb1;
    } /* if */

    sbRet = sbDest;
    while ((sb = *(psb++)) != 0) {
	while (*sbDest++ = *sb++)
	    ;
	sbDest--; /* back up to the ending '\0' */
    } /* while */
    *sbDest = '\0';

    return(sbRet);
} /* SbConcat */


/* L O N G   F   R O U N D */

export int4 LongFRound(x, y)
int4	x, y;
{
    return( ((x + y - 1) / y) * y );
} /* LongFRound */


/* C O L   O N */

export void ColOn()
{
    /* enable column counting */
    if (++vcColUsers == 1)
	vcCol = 0;
} /* ColOn */


/* C O L   O F F */

export void ColOff()
{
    /* disable column counting */
    if (--vcColUsers == 0)
	vcCol = OFF;
} /* ColOff */


/* P A D   T O */

export void PadTo(col)
int	col;
{
    if (col <= vcCol)
	return;

    printf("%.*s", col - vcCol, vsbSpaces);
} /* PadTo */


/* C L E A R   C O L */

export void ClearCol()
{
    vcColUsers = 0;
    vcCol = OFF;
} /* ClearPad */


/* M O R E   O N */

export void MoreOn()
{
    /* enable the 'more' simulation in printf */
    if (++vcMoreUsers == 1)
	vcLines = 0;
} /* MoreOn */


/* M O R E   O F F */

export void MoreOff()
{
    /* disable the 'more' simulation in printf */
    if (--vcMoreUsers == 0)
	vcLines = OFF;
} /* MoreOff */


/* C L E A R   M O R E */

export void ClearMore()
{
    vcMoreUsers = 0;
    vcLines = OFF;
} /* ClearMore */


export FLAGT vfOutputSuppress = false;

/* P R I N T F */

/*VARARGS1*/
export int printf(format, va_alist)
char	*format;
va_dcl
{
    FAST int	cb;
    va_list	ap;
    FILE	ioT;
    char	sbBuffer[cbLineMax];

#ifndef _IOSTRG
#define _IOSTRG	0
#endif

#if (OP_SYS == SYSV)
#define TYPE (unsigned char *)
#else
#define TYPE
#endif

    if (vfOutputSuppress)
	return;

    ioT._cnt = sizeof(sbBuffer);
    ioT._base = ioT._ptr = TYPE sbBuffer;
    ioT._flag = _IOWRT + _IOSTRG;	/* a writable 'string' channel */
    ioT._file = _NFILE;

    va_start(ap);
#if (MFG != SEQUENT) && (MFG != SIEMENS)
    cb = _doprnt(format, ap, &ioT);
    va_end(ap);
    putc('\0', &ioT);		/* null terminated */
#else
    /* I just love companies that produce "standard" systems...... */
    _doprnt(format, ap, &ioT);
    va_end(ap);
    putc('\0', &ioT);		/* null terminated */
    cb = strlen(sbBuffer);
#endif /* (MFG != SEQUENT) && (MFG != SIEMENS) */

    if (vfOutput AND (vfpOutput != NULL))
	fwrite(sbBuffer, 1, cb, vfpOutput);

    fwrite(sbBuffer, 1, cb, stdout);

    if (vcLines != OFF) {
	/* they are asking us to simulate MORE */
	if ((sbBuffer[cb-1] == '\n')
	   AND (++vcLines >= vcLinesMax)) {
	    char	ch;
	    vcLines = 0;
	    ch = ChFChoice("More? [yQq] ", "yQq");
	    if (ch == 'Q') {
		UError(sbNil);
	    } else if (ch == 'q') {
		longjmp(venvFixer, 1);
	    } /* if */
	    vcLines = 0;
	} /* if */
    } /* if */

    if (vcCol != OFF) {
	/* keep track of column */
	if (sbBuffer[cb-1] == '\n') {
	    vcCol = 0;
	} else {
	    /* mini kludge - we will deal with tabs later */
	    vcCol += strlen(sbBuffer);
	} /* if */
    } /* if */

    if (v->sbComm != sbNil)
	fflush(stdout);
    return(cb);
} /* printf */


/* F P R I N T F */

/*VARARGS2*/
export int fprintf(fp, format, va_alist)
FILE	*fp;
char	*format;
va_dcl
{
    FAST int	cb;
    va_list	ap;
    FILE	ioT;
    char	sbBuffer[cbLineMax];

    ioT._cnt = sizeof(sbBuffer);
    ioT._base = ioT._ptr = TYPE sbBuffer;
    ioT._flag = _IOWRT + _IOSTRG;	/* a writable 'string' channel */
    ioT._file = _NFILE;

    va_start(ap);
#if (MFG != SEQUENT) && (MFG != SIEMENS)
    cb = _doprnt(format, ap, &ioT);
    va_end(ap);
    putc('\0', &ioT);		/* null terminated */
#else
    /* I just love companies that produce "standard" systems...... */
    _doprnt(format, ap, &ioT);
    va_end(ap);
    putc('\0', &ioT);		/* null terminated */
    cb = strlen(sbBuffer);
#endif /* (MFG != SEQUENT) && (MFG != SIEMENS) */

    fwrite(sbBuffer, 1, cb, fp);

    if (fp == stdout) {
	if (vfOutput AND (vfpOutput != NULL))
	    fwrite(sbBuffer, 1, cb, vfpOutput);

	if (vcLines != OFF) {
	    /* they are asking us to simulate MORE */
	    if ((sbBuffer[cb-1] == '\n')
	       AND (++vcLines >= vcLinesMax)) {
		char	ch;
		vcLines = 0;
		ch = ChFChoice("More? [yQq] ", "yQq");
		if (ch == 'q') {
		    UError(sbNil);
		} else if (ch == 'Q') {
		    longjmp(venvFixer, 1);
		} /* if */
		vcLines = 0;
	    } /* if */
	} /* if */

	if (vcCol != OFF) {
	    /* keep track of column */
	    if (sbBuffer[cb-1] == '\n') {
		vcCol = 0;
	    } else {
		/* mini kludge - we will deal with tabs later */
		vcCol += strlen(sbBuffer);
	    } /* if */
	} /* if */
    } /* if */

    return(cb);
} /* fprintf */


/* F I X E R */

export void Fixer()
{
    signal(SIGINT, SIG_IGN);

    /* check the communications state to remote */
    if (vcsRemote != csNil) {
	signal(SIGINT, Fixer);
	if (vfInWait) {
	    /* do something that generates the remote interrupt */
	    SendSignal(SIGINT);
	    return;
	} /* if */
	vfInterruptPending = true;
	return;
    } /* if */

    vcNest = 0;
    if (v != prNil)
	v->fRunAssert = true;

    if ((vfpPlayback != NULL)
       AND (vcStepPlayback == 0))
	vcStepPlayback = 1;	/* gives them a chance to regain control */
    printf("\n");
    signal(SIGINT, Fixer);
    longjmp(venv, 2);
} /* Fixer */


/* S E T   P R O M P T */

/* VARARGS1 */
export void SetPrompt(sbMsg, arg1, arg2, arg3, arg4)
SBT	sbMsg;
int	arg1, arg2, arg3, arg4;
{
    sprintf(vsbPrompt, sbMsg, arg1, arg2, arg3, arg4);
} /* SetPrompt */


/* P A N I C */

/* VARARGS1 */
export void Panic(sbMsg, arg1, arg2, arg3, arg4)
SBT	sbMsg;
int	arg1, arg2, arg3, arg4;
{
    printf("CDB error - ");
    if (sbMsg != sbNil)
	printf(sbMsg, arg1, arg2, arg3, arg4);
    printf("\n");
    longjmp(venv, 1);
} /* Panic */


/* S Y S   P A N I C */

/* VARARGS1 */
export void SysPanic(sbMsg, arg1, arg2, arg3, arg4)
SBT	sbMsg;
int	arg1, arg2, arg3, arg4;
{
    int		err;

    err = errno;
    printf("CDB error - ");
    if (sbMsg != sbNil)
	printf(sbMsg, arg1, arg2, arg3, arg4);
    printf("\n");

    if (err != 0)
	printf("%s\n", SbFError(err));
    longjmp(venv, 1);
} /* Panic */


/* U   E R R O R */

/* VARARGS1 */
export void UError(sbMsg, arg1, arg2, arg3, arg4)
SBT	sbMsg;
int	arg1, arg2, arg3, arg4;
{
    if (sbMsg != sbNil) {
	printf(sbMsg, arg1, arg2, arg3, arg4);
	printf("\n");
    } /* if */
    longjmp(venv, 1);
} /* UError */


/* The following routines exist in  AT&T Land, but not Berzerkeley */

/* s t r c h r */

export char * strchr(sb, ch)
register char	*sb, ch;
{
    /* find first instance of ch in sb, return nil if not found */
    while ((*sb != '\0') && (*sb != ch))
	sb++;
    return((*sb == '\0') ? (char *)0 : sb);
} /* strchr */


/* s t r r c h r */

export char * strrchr(sb, ch)
register char	*sb, ch;
{
    register char 	*sbBack;

    sbBack = sb + strlen(sb);
    while (*sbBack != ch && sbBack != sb)
	sbBack--;
    return((*sbBack == ch) ? sbBack : (char *)0);
} /* strrchr */


/* s t r c s p n */

export int strcspn(sbSpan, sbNot)
register char	*sbSpan, *sbNot;
{
    register int	cSpan;
    register char	*sbSave;

    /* return count of chars from start of sbSpan that do NOT occur in sbNot */
    cSpan = 0;
    sbSave = sbNot;
    while (*sbSpan != '\0') {
	while (*sbNot != '\0') {
	    if (*sbNot == *sbSpan)
		return(cSpan);
	    sbNot++;
	} /* while */
	sbSpan++;
	cSpan++;
	sbNot = sbSave;
    } /* while */
    return(cSpan);
} /* strcspn */
