/* $Header: list.c,v 5.23 86/07/18 06:13:40 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

/* These routines list various things */

#include "cdb.h"

#define cScreenMax 21

/* L I S T   F I L E S */

local void ListFiles(sbFile)
SBT	sbFile;
{
    int2	i;
    SBT		sb;
    FLAGT	fAll = false;
    pFDR	fd;

    if (sbFile != sbNil) {
	fAll = true;
	if (*sbFile == '*')
	    sbFile = sbNil;
    } /* if */

    MoreOn();

    printf("     File name            Address   First procedure\n");
    for (i=0, fd = v->rgFd; i < v->hdr.ifdMax; fd++, i++) {
	sb = SbFIss(fd->iss);
	if ((sbFile != sbNil)
	   AND (!FHdrCmp(sbFile, sb)))
	    continue;
	if (!fAll AND ((i == ifdTemp) OR (fd->iline == 0)))
	    continue;	/* has no symbols */
	printf("%3d: %-15s%s  %10s   %s\n",
		    i, sb, (fd->iline == 0) ? " " : "*",
		    SbFAdr(fd->adr, true), SbFIpd(fd->ipd));
    } /* for */
    MoreOff();
} /* ListFiles */


/* L I S T   P R O C S */

local void ListProcs(sbProc)
SBT	sbProc;
{
    int2	i, j;
    int4	iline;
    SBT		sb;
    FLAGT	fAll = false;
    ADRT	dadr, dadrLast;
    pLINER	line;
    pPDR	pd;


    if (sbProc != sbNil) {
	fAll = true;
	if (*sbProc == '*')
	    sbProc = sbNil;
    } /* if */

    MoreOn();
    for (i = 0, pd = v->rgPd; i < v->hdr.ipdMax; pd++, i++) {
	sb = SbFIpd(i);
	if ((sbProc != sbNil)
	   AND (!FHdrCmp(sbProc, sb)))
	    continue;
	iline = pd->iline;
	if (!fAll AND (iline == 0))
	    continue;	/* has no symbols */
	printf("%3d: %-15s%s  %s", i,
			sb, (iline == 0) ?" " : "*", SbFAdr(pd->adr, true));

	if ((v->debuglevel > 0) AND (iline != 0)) {
	    printf("	%d", iline);

	    dadrLast = 0;
	    for (j = 0; iline < v->hdr.ilineMax; j++, iline++) {
		line = LineFIline(iline);
		dadr = line->dadr;
		if (line->dadr < dadrLast)
		    break;
		printf("%s%3d %3d: 0x%lx", (i % 4) ? "\t" : "\n\t",
				iline, line->iln, dadr);
		dadrLast = dadr;
	    } /* for */
	} /* if */

	printf("\n");
    } /* for */
    MoreOff();
} /* ListProcs */


/* L I S T   G L O B A L S */

local void ListGlobals(sbGlobal)
SBT	sbGlobal;
{
    int2	c;
    int4	isym;
    FLAGT	fData;
    SBT		sb;
    SER		ase, *se = &ase;
    pSYMR	sym;
    MODER	amode, amodeSave;

    amode.len = -1;
    if ((v->pid == pidNil) AND (v->fnCore == fnNil)) {
	fData = false;
	amode.df = dfHex;
	printf("No process - accessing exec/core file\n");
    } else {
	amode.df = dfNil;
	fData = true;
    } /* if */

    TkPeek();
    if (vtk == tkSlash OR vtkPeek == tkSlash) {
	if (vtkPeek == tkSlash)
	    TkNext();
	else
	    sbGlobal = sbNil;
	GetMode(&amode);
    } /* if */

    amode.cnt = 1;
    amodeSave = amode;

    MoreOn();

    c = 0;
    if (v->ifd != ifdNil) {

	SetNextSym(v->rgFd[v->ifd].isym+1);
	while (FNextSym(stStatic, stNil, stNil, stFile, false, sbNil, nil)) {
	    isym = v->isym;
	    sb = SbFIss(v->sym->iss);
	    if ((sbGlobal != sbNil)
	       AND (!FHdrCmp(sbGlobal, sb)) )
		continue;

	    SeFSym(se, v->sym, true);
	    if (c++ == 0)
		printf("---- Statics global to file \"%s\"----\n",
			SbFIss(v->rgFd[v->ifd].iss) );
	    if (!fData)
		printf("%-20s @ ", SbFIss(se->asym.iss));
	    amode = amodeSave;
	    DisplaySe(se, &amode, true, fData, fData);
	    printf("\n");
	    SymFIsym(isym);
	} /* while */

    } /* if */

    if (c != 0)
	printf("\n---- Globals ----\n");
    SetNextSym(v->hdr.isymGl);
    while (FNextSym(stGlobal, stNil, stNil, stNil, false, sbNil, nil)) {
	isym = v->isym;
	sb = SbFIss(v->sym->iss);
	if ((sbGlobal != sbNil)
	   AND (!FHdrCmp(sbGlobal, sb)) )
	    continue;

	SeFSym(se, v->sym, true);
	if (!fData)
	    printf("%-20s @ ", SbFIss(se->asym.iss));
	amode = amodeSave;
	DisplaySe(se, &amode, true, fData, fData);
	printf("\n");
	SymFIsym(isym);
    } /* while */

    MoreOff();
} /* ListGlobals */


/* L I S T   L O C A L S */

local void ListLocals(sbProc, cnt)
SBT	sbProc;
int2	cnt;
{
    int2	ipd;
    CNTXR	acntx;

    if ((v->pid == pidNil) AND (v->fnCore == fnNil))
	UError("No child process.");

    MoreOn();
    ipd = (sbProc == sbNil) ? v->ipd : IpdFName(sbProc);

    CntxFIpd(&acntx, &ipd, cnt);
    if (acntx.fEndOfStack)
	UError("Procedure \"%s\" is not active on the stack.",
		SbFIpd(ipd));

    if ((ipd == ipdNil) OR (v->rgPd[ipd].iline == 0))
	UError("I don't have symbols for this procedure.");

    DispFrame(&acntx, cnt, true, true);
    MoreOff();
} /* ListLocals */


/* L I S T   T Y P E D E F S */

local void ListTypedefs(sb)
SBT	sb;
{
    int		i;
    pTDR	td;
    SER		ase;

    MoreOn();
    for (i = 0, td = v->rgTd; i < v->hdr.itdMax; td++, i++) {
	if ((sb != sbNil) AND !FHdrCmp(sb, SbFIss(td->iss)))
	    continue;
	printf("typedef ");
	SeFSym(&ase, SymFIsym(td->isym), true);
	PxSe(&ase, false);
	printf(";\n");
    } /* for */
    MoreOff();
} /* ListTypedefs */


/* L I S T   S O M E T H I N G */

export void ListSomething()
{
    int2	cnt;
    char	chCmd, *sbArg, sbName[20];
    TKE		tk;
    FLAGT	fDidit;

    tk = TkNext();
    if ((vcbTok == 1) AND (tk != tkNumber)) {
	fDidit = false;
	sbArg = sbNil;
	chCmd = vsbTok[0];
	if (tkSemi != TkPeek()) {
	    tk = TkNext();
	    sbArg = vsbTok;
	    if (*sbArg == chNull)
		sbArg = sbNil;
	} /* if */

	fDidit = true;
	switch (chCmd) {
	    default:	fDidit = false; break;
	    case 'a':   ListAssert(); break;
	    case 'b':   ListBp(); break;
	    case 'd':   ListDir(); break;
	    case 'f':   ListFiles(sbArg); break;
	    case 'g':   ListGlobals(sbArg); break;
	    case 'p':   ListProcs(sbArg); break;
	    case 'P':	ListPr(prNil); break;
	    case 'r':   ListRegisters(sbArg); break;
	    case 's':   ListSpecials(sbArg); break;
	    case 't':   ListTypedefs(sbArg); break;
	    case 'z':   ListSa(); break;
	} /* switch */
	if (fDidit)
	    return;
    } /* if */

    if (tk == tkStr) {
	strcpy(sbName, vsbTok);
	cnt = -1;
	if ((TkNext() == tkDot)
	   AND (TkNext() == tkNumber))
	    cnt = atoi(vsbTok);
	/* list the named proc at the given level */
	ListLocals(sbName, cnt);
    } else if (tk == tkNumber) {
	/* list the given stack depth level */
	cnt = atoi(vsbTok);
	ListLocals("-", cnt);
    } else {
	/* list the current proc at the given level */
	ListLocals(sbNil, v->stackdepth);
    } /* if */
} /* ListSomething */
