static char *sccsid = "$Header: main.c,v 6.5 86/09/18 08:00:12 peter Exp $";

#include <setjmp.h>
#include <signal.h>
#include <ctype.h>
#include <varargs.h>

#include "cdb.h"

/* --- KLUDGES --- */
extern jmp_buf venvFixer;
export int	*venv;
export int	vfFPConv = false;	/* floating point conversion required */
#define NAN	0x80000000

/* --- end KLUDGES --- */


#define chPid	'\\'	/* indicates that exec name is actually a PID */

#if 0
export int2	viprMax; /* actually defined in waitSingle.c OR waitMulti.c */
export FLAGT	vfAttach; /* actually defined in waitSingle.c OR waitMulti.c */
export pCPUR	vcpuHost;

exportdefine dprint(x, y) {if (x <= v->debuglevel) printf y; fflush(stdout);}
exportdefine cbLineMax 1024
exportdefine iwwNil	-1

#endif

export char	vsbOptions[2048];	/* default per process options */
export SBT	vsbDefaultFile = sbNil;
static MODER	amode;
export pMODER	vmode;	/* default mode record */
export char	**venvpParent;
export int1	vcaseMod = 0;	    /* has 0 or 040 for case sensitive search */
export SBT	vsbDebugName;		/* name debuger was invoked by */
export int2	vpidCdb = pidNil;	/* our own process id */
export int	vcActive = 0;		/* number of *active* processes */
export char	vsbPrompt[100];
export ADRT	vadrUser = ADR_USER;	/* address of u. in kernel */
export ADRT	vadrReg0 = ADR_REG0;	/* offset to Register 0 */
export ADRT	vadrUar0 = ADR_U_AR0;	/* offset to u.u_ar0 */
export int	vcsRemote = csNil;	/* comm state of remote */
export FLAGT	vfInWait = false;	/* in XWait on remote process */
export FLAGT	vfInterruptPending = false; /* we have a SIGINT for remote */

export FLAGT	vfWindows = false;	/* use windows instead of tty mode */
export FILE	*vfpWwSrc = stdout;	/* dumb window used for source */
export int	vfnTarget = fnNil;	/* alternate device for target */
export int	viwwTarget = iwwNil;	/* window target is in  */
export int	viwwSrc = iwwNil;	/* window source is displayed in */
export SBT	vsbDevSrc;		/* device for source display */
export int	viwwCmd = iwwNil;	/* window commands are in  */
export SBT	vsbDevWw;		/* device for comm to window manager */

/* the following must remain INT's! */
export int	vlcDefault = lcC;	/* default language code */
export int	vfUseCache = false;	/* use caching for remote comm */
export int	vfCommDebug = false;	/* watch remote comm messages */


/* P R I N T   U S A G E */

local void PrintUsage()
{
MoreOn();
printf("Usage: cdb [options] objectfile\n");
printf("Options are:\n");
printf("    -B N	Baud rate for remote line.\n");
printf("    -C file	Set core file.\n");
printf("    -d dir	Add directory to list to be searched for sources.\n");
printf("    -D		Ignore all currently specified alternate directories.\n");
printf("    -e entry	Specify entry label (default is main).\n");
printf("    -E file	Create top level process from file.\n");
printf("    -f N	Use floating point format conversion N.\n");
printf("    -L (c|f)	Set default language code.\n");
printf("    -m file	Default specification file.\n");
printf("    -p file	Command playback from file.\n");
printf("    -P pid	Debug existing process with given process id.\n");
printf("    -r file	Command recording to file.\n");
printf("    -R file	Output recording to file.\n");
printf("    -S		Perform stty's each time target starts and stops.\n");
printf("    -t device	Device name for remote debug connection.\n");
printf("    -Ttext offset  Offset for all text addresses.\n");
printf("    -Tdata offset  Offset for all data addresses.\n");
printf("    -V		Print debugger version information.\n");
printf("    -W		Use windows interface.\n");
printf("\nDebugging & Internal options (use with caution!):\n");
printf("    -u #	Override compiled in address of \"u.\".\n");
printf("    -U #	Override compiled in offset of \"u_ar0\".\n");
printf("    -wC# dev	Commands in window #, on device dev.\n");
printf("    -wS# dev	Source code in window #, on device dev.\n");
printf("    -wT# dev	Taregt output in window #, on device dev).\n");
printf("    -x level	Set internal debugging printout level.\n");
printf("    -X		Show all remote communications transactions.\n");
printf("    -Z N	Set demo timer to N seconds.\n");
    MoreOff();
    exit(1);
} /* PrintUsage */


/* M A I N */

export void main(argc, argv, envp)
int	argc;
char	*argv[];
char	*envp[];
{
    int		cMainArgs, i, iExec, x;
    FLAGT	fUsedArg, fSingle, fInitComm, fExecWm, fTryGraphics;
    SBT		sbArg, sbTemp;
    char	sbCmd[100], *rgSbExec[100];

    PrintVersion(1);

    venv = venvFixer;
    if (setjmp(venvFixer)) {
	/* in case we hit an error during initialization */
	printf("Cannot continue\n");
	exit(1);
    } /* if */

    /* General Initiialization */

    venvpParent = envp;
    vpidCdb = getpid();
    vsbDebugName = SbFBase(argv[0]);
    vcaseMod = 040; /* start out with case INsensitive searches */
    vfRecord = false;	/* we aren't recording (yet) */
    fTryGraphics = true;

    /* do NOT reverse the order of these init's! */
    InitSe();		/* init special default SE's for expression eval */
    InitCpu(vcpuHost);	/* init global cpu record */
    InitSpecials();	/* init system specials (_FILE, _LINE, etc.) */
    InitProcessTable();

    /* setup the default display record */
    vmode = &amode;
    vmode->cnt = 1;
    vmode->len = vcpuHost->cbInt; /* kludge? */
    vmode->df = dfDecimal;
    vmode->imap = 0;

    /* set default lc based on first character of program name */
    sbTemp = strrchr(vsbDebugName, '/');
    if (sbTemp == sbNil)
	sbTemp = vsbDebugName;
    else
	sbTemp++;	/* increment past '/' */

    switch (*sbTemp) {
	case 'x':
	    AddOptions(vsbOptions, "-x 100" , "-X", "-t TEST", sbNil);
	    /* and fall through */

	default:
	case 'c':
	    vlcDefault = lcC;
	    break;

	case 'f':
	    vlcDefault = lcFortran;
	    AddOptions(vsbOptions, "-e MAIN", sbNil);
	    break;
    } /* switch */

    iExec = 0;
    cMainArgs = 0;
    for (i = 1; i < argc; i++) {
	sbArg = argv[i];
	if (*sbArg != '-') {
	    if (*sbArg == '?')
		PrintUsage();

	    switch (cMainArgs) {
		default:
		    if (viprMax > 1)
			PrintUsage();
		    /* fall through */

		case 1:
		    if (viprMax > 1) {
			AddOptions(vsbOptions, "-C", sbArg, sbNil);
			break;
		    } /* if */
		    /* fall through */

		case 0:
		    rgSbExec[iExec++] = sbArg;
		    break;
	    } /* switch */
	    cMainArgs++;

	} else {

	    while (*++sbArg != chNull) {   /* move off '-' or last switch */
		/* point to a potential argument */
		sbTemp = (sbArg[1] != chNull) ? sbArg+1 : argv[i+1];
		fUsedArg = true; /* set FALSE if option does NOT use arg */

		switch (*sbArg) {
		    /* first we do options that are not the generic case */
		    default:
			PrintUsage();

		    case '.':
			Purchase(sbArg+1);
			exit(0);

		    case 'A':
			UError("You may not use 'A' on the command line.");
			break;

		    case 'E':
			rgSbExec[iExec++] = sbTemp;
			break;

		    case 'm':
			vsbDefaultFile = sbTemp;
			break;

		    case 'P':	/* Process id */
			sbCmd[0] = chPid;
			sbCmd[1] = chNull;
			strcat(sbCmd, sbTemp);
			rgSbExec[iExec++] = SbFAlloc(sbCmd);
			break;

		    case 'p':	/* playback file */
			SetPlayback(sbTemp, true, fSingle);
			break;

		    case 'R':	/* output record file */
			SetOutput(sbTemp);
			break;

		    case 'r':	/* command record file */
			SetRecord(sbTemp);
			break;

		    case 'T':
			AddOptions(vsbOptions, sbArg, argv[i+1], sbNil);
			sbArg[1] = chNull;	/* pretend arg was one letter */
			break;

		    case 'w':
			fTryGraphics = false;
			x = atoi(sbArg+2);
			vfWindows = true;
			switch (sbArg[1]) {
			    default:	PrintUsage();

			    case 'C':
				viwwCmd = x;
				vsbDevWw = argv[i+1];
				break;
			    case 'S':
				viwwSrc = x;
				vsbDevSrc = argv[i+1];
				break;
			    case 'T':
				viwwTarget = x;
				if ((vfnTarget =
					open(argv[i+1], O_RDWR, 0666)) < 0)
				    UError("Trouble opening %s: %s.",
					    argv[i+1], SbFError(errno));
			} /* switch */
			sbArg[1] = chNull;
			break;

		    case 'V':
			fUsedArg = false;
			PrintVersion();
			exit(0);
			break;

		    case 'W':
			fUsedArg = false;
			vfWindows = true;
			fExecWm = true;
			break;

#if (CPU == PDN)
		    case 'z':
			fUsedArg = false;
			vfPdnExtStart = !vfPdnExtStart;
			break;
#endif /* (CPU == PDN) */

		    case 'Z':	/* Have demo move forward in X second steps */
			vfComment = true;
			fSingle = true;
			SetDemoTimer(atoi(sbTemp));
			break;

	    /* --------- Generic option handling --------------- */

		    /* Generic options with no argument go here */
		    case 'X':	/* debug remote comm */
		    case 'S':	/* Use stty calls on stop/start of child */
			fUsedArg = false;
			sbTemp = sbNil;

			/* and fall through */

		    /* Generic options with 1 argument go here */
		    case 'B':	/* baud rate */
		    case 'C':	/* core file */
		    case 'd':	/* alternate directory */
		    case 'e':	/* alternate entry point */
		    case 't':	/* name of device for remote cdb */
		    case 'u':	/* set address of u. */
		    case 'U':	/* set offset of u.u_ar0 */
		    case 'x':	/* set dprint level */
			sbCmd[0] = '-';
			sbCmd[1] = *sbArg;
			sbCmd[2] = chNull;
			AddOptions(vsbOptions, sbCmd, sbTemp, sbNil);
			break;

		} /* switch */

		if (fUsedArg) {
		    if (sbArg[1] == chNull)
			i++;	/* eat next word - it was the arg we used */
		    break;	/* and fall out of the loop */
		} /* if */
	    } /* while there are more switches in this bunch */
	} /* if it starts with a - */
    } /* for all command line arguments */

    Validate();		/* perform validation */

    if (iExec == 0) {
	/* come on.... ya gotta give us something! */
	printf("Program to debug (<return> to see switches): ");
	sbCmd[0] = chNull;
	gets(sbCmd);
	if (sbCmd[0] == chNull) {
	    printf("\nYou need to supply a program name.\n\n");
	    PrintUsage();
	} /* if */
	rgSbExec[iExec++] = SbFAlloc(sbCmd);
    } /* if */

    /* Create the top level processes */
    for (i = 0; i < iExec; i++) {
	sbArg = rgSbExec[i];
	if (*sbArg == chPid)
	    PrFAttachProcess(atoi(sbArg+1));
	else
	    PrFInitPr(sbArg);
    } /* for */
    v = vrgPr[0];	/* we start off with first program they mentioned */

    if (vfWindows)
	InitAllWw(fExecWm, fTryGraphics, argv);

    if (setjmp(venvFixer) == 0) {
	/* first time */
	if ((v->fnCore != fnNil) OR (v->pid != pidNil)) {
	    FDoCommand("L", true);	/* put them at the 'stop' location */
	} else {
	    sprintf(sbCmd, "e %s", v->sbInit); /* first line to execute */
	    FDoCommand(sbCmd, true);
	    v->acntx.pc = v->adrInit;
	} /* if */
    } /* if */

    venv = venvFixer;
    InitSignals();	/* don't dump on the customers! */
    vcNest = 0; 	/* nesting level for printing structure indents */
    vfAnalyzeStop = false;
    ClearMore();	/* Reset the state of psuedo-more */
    ClearCol();		/* Reset the state of column counting */

    DebugIt(true);

    CdbExit(0);
} /* main */


/* S A V E   A L L */

export void SaveAll()
{
    char	sbFile[100];
    FLAGT	fNeedFile;
    FILE	*fp;

    sprintf(sbFile, "%s.rc", v->sbExec);
    fp = fopen(sbFile, "w");
    if (fp == NULL) {
	printf("Cannot open save file.\n%s: %s\n", sbFile, SbFError(errno));
	return;
    } /* if */

    fNeedFile = FSaveBp(fp);
    fNeedFile |= FSaveAssertions(fp);

    fclose(fp);
    if (!fNeedFile)
	unlink(sbFile);	/* nothing was writtne out */
} /* SaveAll */


/* C D B   E X I T */

export void CdbExit(value)
int	value;
{
#if (OP_SYS == SYSV)
#include <fcntl.h>

    if (fcntl(0, F_SETFL, fcntl(0, F_GETFL, 0) & ~O_NDELAY) == -1)
	SysPanic("fcntl on ~O_NDELAY");
    sleep(1); /* to disturb the ether and make O_NDELAY go away */
#endif (OP_SYS == SYSV)

    if (setjmp(venvFixer) != 0) {
	/* we failed during shutdown - Bailout! */
	exit(value);
    } /* if */

    ReapChildren();

    CloseComm();
    if (vfWindows)
	RestoreAllWw();
    exit(value);
} /* CdbExit */


/* L O N G   F   S B */

export int4 LongFSb(sb)
SBT	sb;
{
    int		tk;
    char	sbTok[100];

    vcbTok = sizeof(sbTok);
    tk = TkFStr(&sb, sbTok, &vcbTok, true);
    if (tk != tkNumber)
	return(NAN);
    return(yylval.val.valLong);
} /* LongFSb */


/* A D D   O P T I O N S */

/* VARARGS2 */
export void AddOptions(sbOption, va_alist)
SBT	sbOption;
va_dcl
{
    va_list	ap;
    SBT		sb;

    va_start(ap);

    while ((sb = va_arg(ap, SBT)) != sbNil) {
	strcat(sbOption, sb);
	strcat(sbOption, " ");
    } /* while */

    va_end(ap);
} /* AddOptions */


/* A P P L Y   O P T I O N S */

export void ApplyOptions(pr, sbOptions)
pPRR	pr;
SBT	sbOptions;
{
    int		i, argc;
    FLAGT	fUsedArg;
    SBT		sbArg, sbOpt;
    char	*argv[100];

    DoArgs(pr->sbExec, sbOptions, argv, false);
    for (argc = 0; argv[argc] != sbNil; argc++)
	;

    fUsedArg = true;
    for (i = 1; i < argc; i++) {
	sbOpt = argv[i];
	if (*sbOpt != '-') {
	    /* can this happen ????? - for now we will ignore it */
	} else {
	    while (*++sbOpt != chNull) {   /* move off '-' or last switch */
		/* point to a potential argument */
		sbArg = (sbOpt[1] != chNull) ? sbOpt+1 : argv[i+1];
		fUsedArg = true; /* set FALSE if option does NOT use arg */

		switch (*sbOpt) {
		    default:
			printf("ApplyOptions: Unkown option \"%c\"\n");
			fUsedArg = false;
			break;

		    case 'A': /* */
			pr->iBaud = atoi(sbArg);
			fUsedArg = false;
			break;

		    case 'B': /* baud rate */
			pr->iBaud = atoi(sbArg);
			break;

		    case 'C':	/* name of core file  */
			pr->sbCore = SbFAlloc(sbArg);
			break;

		    case 'D':	/* thow out alternate directories */
			pr->idirMac = 0;
			fUsedArg = false;
			break;

		    case 'd':	/* alternate directory */
			AddDir(pr, sbArg);
			break;

		    case 'E':	/* REAL name of executable */
			pr->sbExec = SbFAlloc(sbArg);
			break;

		    case 'e':	/* entry point */
			pr->sbInit = SbFAlloc(sbArg);
			pr->adrInit = adrNil;
			break;

		    case 'f':	/* floating point format conversion */
			/* KLUDGE */
			vfFPConv = true;		/* convert for target */
			fUsedArg = false;
			break;

		    case 'L':	/* Language code */
			pr->lc = (*sbArg == 'f') ? lcFortran : lcC;
			break;

		    case 'P':
		printf("You may not specify 'P pid' in the defaults file\n");
			break;

		    case 'S':	/* Toggle stty calls on child start/stop */
			pr->fStty = ! pr->fStty;
			fUsedArg = false;
			break;

		    case 't':	/* name of device for remote cdb */
			pr->sbComm = sbArg;
			pr->fStty = false;	/* no piont in doing this */
			break;

		    case 'T':
			if ( strcmp( "Ttext", sbArg) == 0 ){	/* text adrs */
			    sbOpt[1] = chNull;
			    if ((pr->adrText = LongFSb(sbArg) == NAN))
			     printf("Ttext requires a number as an argument\n");
			    break;
			} else if ( strcmp( "Tdata", sbArg) == 0 ){
			    sbOpt[1] = chNull;
			    if ((pr->adrData = LongFSb(sbArg) == NAN))
			     printf("Tdata requires a number as an argument\n");
			    break;
			} /* if */
			break;

		    case 'u':	/* set address of u. */
			vadrUser = LongFSb(sbArg);
			if ((vadrUser = LongFSb(sbArg) == NAN))
			    printf("Tdata requires a number as an argument\n");
			break;

		    case 'U':	/* set offset of u.u_ar0 */
			if ((vadrUar0 = LongFSb(sbArg) == NAN))
			    printf("Tdata requires a number as an argument\n");
			break;

		    case 'x':	/* set dprint level */
			pr->debuglevel = atoi(sbArg);
			break;

		    case 'X':
			pr->fCommDebug = true;
			fUsedArg = false;
			break;
		} /* switch */

		if (fUsedArg) {
		    if (sbOpt[1] == chNull)
			i++;	/* eat next word - it was the arg we used */
		    break;	/* and fall out of the loop */
		} /* if */
	    } /* while */
	} /* if */
    } /* for */
    if (pr->sbInit == sbNil)
	pr->sbInit = SbFAlloc("main");
} /* ApplyOptions */
