/* $Header: math.c,v 6.1 86/08/05 17:44:50 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"

/*
 * This file is a giant macro generating procedures that do all
 * operators on all types.
 */

#define DoCase(OP, XX) seRet->val.XX = se1->val.XX OP se2->val.XX; break
#define DoNormal(OP)	switch (bt) {\
	case btChar:	DoCase(OP,valChar);\
	case btUChar:	DoCase(OP,valUChar);\
	case btShort:	DoCase(OP,valShort);\
	case btUShort:	DoCase(OP,valUShort);\
	case btInt:	DoCase(OP,valInt);\
	case btEnum: case btUInt:	DoCase(OP,valUInt);\
	case btLong:	DoCase(OP,valLong);\
	case btULong:	DoCase(OP,valULong);\
	case btFloat:	DoCase(OP,valFloat);\
	case btDouble:	DoCase(OP,valDouble);\
	case btAdr:	DoCase(OP,valAdr);\
    } /* switch */

#define DoException(OP)	   switch (bt) {\
	case btAdr:	DoCase(OP,valAdr);\
	case btChar:	DoCase(OP,valChar);\
	case btUChar:	DoCase(OP,valUChar);\
	case btShort:	DoCase(OP,valShort);\
	case btUShort:	DoCase(OP,valUShort);\
	case btInt:	DoCase(OP,valInt);\
	case btEnum: case btUInt:	DoCase(OP,valUInt);\
	case btLong:	DoCase(OP,valLong);\
	case btULong:	DoCase(OP,valULong);\
	case btFloat:	UError ("Float not allowed in 'OP'."); break;\
	case btDouble:	UError ("Double not allowed in 'OP'."); break;\
    } /* switch */

#define DoProc(Name, Do, op) void Name(seRet, se1, se2)\
	pSER	seRet, se1, se2;\
	{\
	    int2 bt;\
	    ResFOps(seRet, se1, se2);\
	    bt = (seRet->ti.tq0 != tqNil ? btAdr : seRet->ti.bt);\
	    Do(op)\
	    if (bt == btAdr) {\
		seRet->ti.fConstant = true; \
		seRet->asym.value = seRet->val.valAdr; \
	    }\
	}


/* We have to expand MUL because Sun STILL hasn't fixed their compiler! */

/* M U L */

void Mul(seRet, se1, se2)
pSER	seRet, se1, se2;
{
#define OP *
    int2 bt;
    ResFOps(seRet, se1, se2);
    
    bt = (seRet->ti.tq0 != tqNil ? btAdr : seRet->ti.bt);
    switch (bt) {
	case btChar:
#if (MFG != SUN)
	/* The Sun compiler goes into an infinite loop on expressions of
	 * the form "charA = charB * charC".  So we just fall through
	 * into the unsigned char code.  This will probably not cause
	 * anybody to lose any sleep.
	 */
	DoCase(OP,valChar);
#endif /* (MFG != SUN) */
	case btUChar:	DoCase(OP,valUChar);
	case btShort:	DoCase(OP,valShort);
	case btUShort:	DoCase(OP,valUShort);
	case btInt:	DoCase(OP,valInt);
	case btEnum: case btUInt:	DoCase(OP,valUInt);
	case btLong:	DoCase(OP,valLong);
	case btULong:	DoCase(OP,valULong);
	case btFloat:	DoCase(OP,valFloat);
	case btDouble:	DoCase(OP,valDouble);
	case btAdr:	DoCase(OP,valAdr);
    } /* switch */
    if (bt == btAdr)
	seRet->ti.fConstant = true;
} /* Mul */

DoProc(Div, DoNormal,/)
DoProc(Add, DoNormal,+)
DoProc(Subtract, DoNormal,-)
DoProc(LOr, DoNormal,||)
DoProc(LAnd, DoNormal,&&)
DoProc(LT, DoNormal,<)
DoProc(LE, DoNormal,<=)
DoProc(GT, DoNormal,>)
DoProc(GE, DoNormal,>=)
DoProc(EQ, DoNormal,==)
DoProc(NE, DoNormal,!=)

DoProc(RShift, DoException,>>)
DoProc(LShift, DoException,<<)
DoProc(BOr, DoException,|)
DoProc(BAnd, DoException,&)
DoProc(XOr, DoException,^)
DoProc(Mod, DoException,%)

/* now for UNARY operators */

#undef DoCase
#define DoCase(op,XX) seRet->val.XX = op se->val.XX; break

#undef DoProc
#define DoProc(Name, Do, op) void Name(seRet, se)\
	pSER	seRet, se;\
	{\
	    int2 bt;\
	    GetOrig(se);\
	    Coerce(se, seRet);\
	    seRet->asym.st = stExpr;\
	    seRet->ti.fConstant |= (seRet->ti.tq0 == tqNil);\
	    bt = (seRet->ti.tq0 != tqNil ? btAdr : seRet->ti.bt);\
	    Do(op)\
	}

DoProc(Bang, DoException,!)
DoProc(Tilda, DoException,~)
