/* $Header: osV.c,v 6.1 86/09/15 09:33:13 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"
#include <errno.h>
#include <signal.h>
#include <setjmp.h>
#include <termio.h>
#include <varargs.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/dir.h>
#include <sys/user.h>

#include <core.h>
#include <a.out.h>

#define cbUserPage      ctob(USIZE)

export char	**venvpParent;
typedef int	*pENVR;	/* KLUDGE?? */
jmp_buf	venvFixer;   /* for error recovery */
SAR	vmpSigSa[NSIG];	/* signal action array */

#if 0
exportdefine cArgsMax	100
#endif

char	*vargvChild[cArgsMax];

struct termio	histty, mytty;
static char	vsbPattern[300];

SBT	vmpSigSb[] = {
	sbNil,
	"hangup",
	"interrupt",
	"quit",
	"illegal instruction",
	"breakpoint",
	"IOT instruction",
	"EMT instruction",
	"floating point exception",
	"kill",
	"bus error",
	"segmentation violation",
	"bad argument to system call",
	"write on a pipe with no one to read it",
	"alarm clock",
	"software termination signal from kill",
	"user defined signal 1",
	"user defined signal 2",
	"child stop or exit",
	"power fail",
	};
int visigSbMax = sizeof(vmpSigSb) / sizeof(SBT);


/* I N I T   P A T T E R N */

export void InitPattern(sbPattern)
SBT	sbPattern;
{
    strcpy(vsbPattern, sbPattern);
} /* InitPattern */


/* I   F   P A T T E R N */

export int IFPattern(sbLine)
FAST SBT	sbLine;
{
    FAST int2	cbLine, cbPattern, i;

    /* Return the index of the Pattern within the line */

    i = 0;	/* the index of sbPattern in sbLine */
    cbLine = strlen(sbLine);
    cbPattern = strlen(vsbPattern);
    while (cbLine >= cbPattern) {
	if (FHdrCmp(vsbPattern, sbLine, cbPattern))
	    return(i);
	i++;
	sbLine++;
	cbLine--;
    } /* while */
    return(-1);
} /* IFPattern */


/* S B   F   S I G N A L */

export SBT SbFSignal(sig)
int2	sig;
{
    SBT		sb;
    static char sbTemp[100];

    if (sig < visigSbMax && sig>0) {
	sb = vmpSigSb[sig];
    } else {
	sprintf(sbTemp, "signal %d", sig);
	sb = sbTemp;
    } /* if */
    return(sb);
} /* SbFSignal */


/* S E T   J M P */

export int SetJmp(env)
pENVR	env;
{
    return(setjmp(env));
} /* SetJmp */


/* L O N G   J M P */

export void LongJmp(env)
pENVR	env;
{
    longjmp(env);
} /* LongJmp */


/* S W I T C H   T T Y S */

local void SwitchTtys(tty1, tty2)
struct termio	*tty1, *tty2;
{
    ioctl(0, TCGETA, tty1);  /* save state */
    if (! FBlockCmp(tty1, tty2, sizeof(*tty1)))
	ioctl(0, TCSETAW, tty2);	/* restore state */
} /* SwitchTtys */


/* S E T   M Y   T T Y */

export void SetMyTty()
{
    SwitchTtys(&histty, &mytty);
} /* SetMyTty */


/* S E T   H I S   T T Y */

export void SetHisTty()
{
    SwitchTtys(&mytty, &histty);
} /* SetHisTty */


/* I N I T   M Y   T T Y */

export void InitMyTty()
{
    ioctl(0, TCGETA, &mytty);  /* get my state */
    histty = mytty;	/* to start with, he is same as me */
} /* InitMyTty */


/* S E T   D E M O   T I M E R */

export void SetDemoTimer(cSeconds)
int	cSeconds;
{
#if 0
    /* 4.2 code - never really done for System V */

    /* this helps setup for timed-out demo code */
    struct sgttyb	tty;
    gtty(0, &tty);
    if (cSeconds > 0)
	tty.sg_flags |= CBREAK;
    else
	tty.sg_flags &= ~CBREAK;
    stty(0, &tty);

    vsleepDemo = cSeconds;
#endif
} /* SetDemoTimer */


/* F   T I M E D   I N P U T */

export FLAGT FTimedInput(cSeconds)
int	cSeconds;
{
#if 0
    /* 4.2 code - never really done for System V */

    int		x, mRead, mWrite, mExcept;
    char	buf[100];

    /* return 'true' if cSeonds elapse and no keys struck */
    struct timeval tv;

    mRead = 1;		/* interested in stdin */
    mWrite = 0;
    mExcept = 0;
    tv.tv_sec = cSeconds;
    tv.tv_usec = 0;
    x = select(1, &mRead, &mWrite, &mExcept, &tv);
    return(x== 0);
#endif
} /* FTimedInput */


/* S B   F   E R R O R */

export SBT SbFError(error)
int	error;
{
    extern char *sys_errlist[];
    extern int   sys_nerr;

    if (error < 0 OR error >= sys_nerr)
	UError("Unknown error number (%d).", error);
    return(sys_errlist[error]);
} /* SbFError */


/* O O P S */

export void Oops(sig)
int	sig;
{
    signal(sig, Oops);
    if (vfInDisplay)
	UError(sbNil);

UError("\nSorry, Cdb has encountered a \"%s\" error. Try a different command.",
	SbFSignal(sig));
} /* Oops */


/* A L A R M */

local void Alarm()
{
    signal(SIGALRM, Alarm);
} /* Alarm */


/* I N I T   S I G N A L S */

export void InitSignals()
{
    signal(SIGALRM, Alarm);
    signal(SIGINT, Fixer);
    signal(SIGILL, Oops);
    signal(SIGFPE, Oops);
    signal(SIGBUS, Oops);
    signal(SIGSEGV, Oops);
    signal(SIGSYS, Oops);
    signal(SIGPIPE, Oops);
} /* InitSignals */


/* O S   C R E A T E   T A R G E T */

export void OsCreateTarget()
{
    int2	sig, fn;

    if (v->fnExec != fnNil)
	close(v->fnExec);	/* in case it is PURE or SPLIT I&D */
    v->fnExec = fnNil;

    if ((v->pid = fork()) == 0) {
	signal(SIGINT, SIG_DFL);
	if (setjmp(venv)) {
	    printf("Exec failed\n");
	    exit(1);
	} /* if */
	for (sig=1; sig<NSIG; sig++)
	    signal(sig, SIG_DFL);	/* start out with default response */

	if (vfnTarget != fnNil) {
	    /* set up the target with the specified device */
	    close(0);
	    dup(vfnTarget);
	    close(1);
	    dup(vfnTarget);
	    close(2);
	    dup(vfnTarget);
	} /* if */

	if (vfWindows)
	    ClearTargetScreen();

	for (fn = 3; fn < _NFILE; fn++)
	    close(fn);

	DoArgs(v->sbExec, v->sbArgsChild, vargvChild, true);
	SetHisTty();
	Ptrace(ptChild, 0, (char *)0, 0); /* Hi, Mom! */
	execv(v->sbExec, vargvChild);

	/* if we get here, we are child BUT exec failed */
	perror(v->sbExec);
	exit(1);
    } /* if */
} /* OsCreateTarget */


/* I N I T   S A */

export void InitSa()
{
    FAST int	i;
    pSAR	sa;

    sa = vmpSigSa;
    for (i=0; i < NSIG; i++, sa++) {
	sa->fIgnore = true;
	sa->fReport = true;
	sa->fStop = true;
    } /* for */

    /* now we set some of them to NOT report, ignore or stop! */
    /* the 'Q' option shuts up the printout of the signal settings */

    SaMaintain(SIGALRM, "isrQ", sbNil); /* we don't stop, report or Ignore */
    SaMaintain(SIGKILL, "isrQ", sbNil);
    SaMaintain(SIGTERM, "isrQ", sbNil);
    SaMaintain(SIGCLD, "isrQ", sbNil);
} /* InitSa */


/* I N I T   C O R E */

export void InitCore(pr)
pPRR	pr;
{
    int		sig;
    long	cbText, cbData, cbStack;
    static char auserCore[cbUserPage];
    struct user *userCore = (struct user *) auserCore;
    struct stat statbuf;

    if (pr->sbCore == sbNil) {
	pr->fnCore = fnNil;
	return;
    } /* if */

    pr->fnCore = open(pr->sbCore, 0);	/* open it read-only */
    if (pr->fnCore < 0) {
	printf("%s not accessible\n", pr->sbCore);
	pr->fnCore = fnNil;
	return;
    } /* if */

    fstat(pr->fnCore, &statbuf);
    if (pr->mtimeExec > statbuf.st_mtime) {
	printf("WARNING: `%s' is older than `%s' - ignoring %s.\n",
	    pr->sbCore, pr->sbExec, pr->sbCore);
	goto Failed;
    } /* if */

    /* we do have a corefile! */
    if ((read(pr->fnCore, userCore, cbUserPage) != cbUserPage)) {
	printf("Can't read '%s' - ignoring it\n", pr->sbCore);
	goto Failed;
    } /* if */

    if (pr->hdr.magic != userCore->u_exdata.ux_mag) {
	printf("WARNING: `%s' cannot be the core file for %s - ignoring %s\n",
		pr->sbCore, pr->sbExec, pr->sbCore);
	goto Failed;
    } /* if */

#if (MFG == ARETE)
    pr->sig = *(int *)(auserCore + 0xf04);
#else
    pr->sig = userCore->u_arg[0];
#endif
    if (pr->sig != 0)
	printf("Child died due to \"%s\"\n", SbFSignal(pr->sig));

    cbText = ctob(userCore->u_tsize);
    cbData = ctob(userCore->u_dsize);
#if (MFG == ARETE || MFG == PLEXUS)
    cbStack = ctob(userCore->u_ssize) - cbUserPage;
#else
    cbStack = ctob(userCore->u_ssize);
#endif

    /* core files for read only programs do NOT contain the instructions! */
#if (MFG == INTEL)
    /* Intel 386 stuff */
    pr->mapCore.b1 = pr->mapExec.b2;
#else
    /* Normal COFF stuff */
    pr->mapCore.b1 = (pr->hdr.magic==magicReadOnly) ?
		LongFRound(cbText,TXTRNDSIZ) :
		(pr->hdr.magic == magicDemand) ? cbText : 0L;
#endif

    pr->mapCore.e1 = cbData + ((pr->hdr.magic==magicImpure) ?
		cbText : pr->mapCore.b1);
    pr->mapCore.f1 = cbUserPage;

#if (MFG == PLEXUS)
    {
	ADRT usrstack = (ADRT)userCore->u_usrstack;

	/* use default end of user stack for old machines */
	if (usrstack == NULL) usrstack = cbStorageMax;
	pr->mapCore.b2 = usrstack - cbStack;
	pr->mapCore.e2 = usrstack;
    }
#else
    pr->mapCore.b2 = cbStorageMax - cbStack;
    pr->mapCore.e2 = cbStorageMax;
#endif
    pr->mapCore.f2 = cbUserPage +
		((pr->hdr.magic==magicReadOnly || pr->hdr.magic == 0413)
				 ? cbData : pr->mapCore.e1);
    return;

Failed:
    close(pr->fnCore);
    pr->fnCore = fnNil;
    pr->sbCore = SbFAlloc("no core");
} /* InitCore */


/* I N I T   O S */

export void InitOs(pr)
pPRR	pr;
{
    int2	ipd;
    int4	cbData, cbText;
    struct aouthdr	aoutSym;
    struct filehdr	fileSym;
    struct scnhdr	scnSym;
    struct user		auser;

    pr->os = (pOSR) malloc(cbOSR);
    pr->os->adrTty = (ADRT) malloc(sizeof(struct termio));
    pr->os->sigTrap = SIGTRAP;
    pr->os->sigMax = NSIG;
    pr->os->mpSigSa = vmpSigSa;
    pr->os->fIntegerOffsets = INTEGER_OFFSETS;
    pr->os->fClearFp = CLEAR_FP;

    if (vadrUar0 == adrNil)
	vadrUar0 = (ADRT)&(auser.u_ar0) - (ADRT)&auser;
    pr->os->adr_u_ar0 = vadrUar0;
    pr->os->adrUser = vadrUser;
    pr->os->adrReg0 = vadrReg0;
    pr->os->adrEntry = (ADRT)&(auser.u_exdata.ux_entloc) - (ADRT)&auser;
    pr->os->dadrEntMax = 4;

    InitSignals(pr);
    InitSa(pr);		/* set default signal handling */

    /* set up mapExec */
    lseek(v->fnExec, 0L, seekBegin);
    if (read(v->fnExec, &fileSym, sizeof(fileSym)) != sizeof(fileSym)
        || read(v->fnExec, &aoutSym, sizeof(aoutSym)) != sizeof(aoutSym)
        || read(v->fnExec, &scnSym, sizeof(scnSym)) != sizeof(scnSym))
	SysPanic("Cannot read header of %s.", v->sbExec);

    pr->hdr.magic = aoutSym.magic;
    cbData = aoutSym.dsize;
    cbText = aoutSym.tsize;

    /* text section */
    pr->mapExec.f1 = scnSym.s_scnptr;
    pr->mapExec.b1 = scnSym.s_paddr;
    pr->mapExec.e1 = scnSym.s_paddr + scnSym.s_size;

    /* Data section */
    if (read(v->fnExec, &scnSym, sizeof(scnSym)) != sizeof(scnSym))
	SysPanic("Cannot read second section header.");

    pr->mapExec.f2 = scnSym.s_scnptr;
    pr->mapExec.b2 = scnSym.s_paddr;
    pr->mapExec.e2 = scnSym.s_paddr + scnSym.s_size;

    if (pr->adrBreak == adrNil) {
	ipd = IpdFName("_end_");
	if (ipd != ipdNil)
	    pr->adrCall = pr->adrBreak = pr->rgPd[ipd].adr;
    } /* if */

    InitCore(pr);
} /* InitOs */


