/* $Header: procedure.c,v 6.2 86/09/14 20:23:51 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"

#include <setjmp.h>


/* C A R G   F   I P D */

export int CargFIpd(ipd)
int2	ipd;
{
    int2	carg = 0;
    int4	isym;

    if (v->rgPd[ipd].iline == 0)
	return(0);

    isym = v->rgPd[ipd].isym + 1;
    while (FNextLocal(false, true, isym)) {
	carg++;
	isym = v->isym + 1;	/* point one past current sym */
    } /* if */
    return(carg);
} /* CargFIpd */


/* D O   P R O C */

export void DoProc(seRet, seProc, seFirst, seMac)
pSER	seRet, seProc, seFirst, seMac;
{
    int2	ipd, cbArg, cArg, x, sigSave;
    pBPR	bp;
    ADRT	adr, adrSave;
    char	sbCmdSave[300];
    char	*sbSaveState;
    int		*envSave;
    jmp_buf	envProc;

    if (v->adrCall == adrNil)
	UError("You must load with \"-lcdb\" to invoke procedure calls.");

    if (v->pid == pidNil)
	UError("No child process.");

#if (CPU == I80386)
    UError("Kernel bug prevents procedure calls for the moment.");
#endif
#if (MFG == PYRAMID)
    UError("Procedure calls are not yet implemented on Pyramid machines.");
#endif /* (MFG == PYRAMID) */

    /* save register values and prepare for errors */
    if ((x = setjmp(envProc)) == 0) {
	envSave = venv;
	sigSave = v->sig;
	venv = envProc;
	sbSaveState = SaveState();
    } else {
	if (x != 2)
	    goto keepgoing;	/* They did NOT hit a ^C */
	/* error city, wonder what went wrong??? */
	if (v->pid != pidNil)
	    RestoreState(sbSaveState);
	v->sig = sigSave;
	venv = envSave;
	if (--v->cNestProc == 0)
	    ClearBp(BpFAdr(v->adrBreak, true));
	UError("Exiting procedure call state.");
    } /* if */

    adrSave = AdrFIpdIln(v->ipd, v->iln);
    adr = seProc->asym.value;

    /* see if they did a reasonable call */
    ipd = IpdFAdr(adr);
    cArg = seMac - seFirst;
    if (cArg < CargFIpd(ipd)) {
	printf("WARNING: Too few parameters!\n");
	PxProc(ipd, true, true);
	fflush();
    } /* if */

    CallProcedure(adr, seFirst, cArg);	/* CPU specific */

    if (v->cNestProc == 0)
	bp = BpFAddBp(v->adrBreak, 1, "Q", 3);  /* and set a break there */
    v->cNestProc++;	/* count of proc call nesting */

    strcpy(sbCmdSave, v->sbCmd); /* so it doesn't get clobbered by proc call */
    SetCmd(sbNil);

    /* and away we go........ */
    RunProcess(ptResume, psRunning, true);

keepgoing:
    while ((v->bp == bpNil) OR (v->adrBreak != v->bp->adr))
	DebugIt(false);

    if (--v->cNestProc == 0)
	ClearBp(bp);

    SeFReturn(seRet, seProc);	/* CPU specific */

    RestoreState(sbSaveState);	/* this un-does the stack fiddling */
    v->sig = sigSave;
    venv = envSave;	/* return to normal error handling */
    strcpy(v->sbSave, sbCmdSave);	/* restore command line */
    SetCmd(v->sbSave);
    SetViewPosition(adrSave);
} /* DoProc */


/* F   C A L L   U S E R   P R O C */

export FLAGT FCallUserProc(sbProc, cArg, arg1)
SBT	sbProc;
int2	cArg;
int4	arg1;
{
#define cArgMax	20
    int2	i, ipd;
    int4	*parg;
    SER		*se, rgSe[cArgMax], aseProc, aseRet;


#if (MFG == PYRAMID) || (CPU == I80386)
    return(false);
#endif /* (MFG == PYRAMID) */

    ipd = IpdFName(sbProc);
    if (ipd == ipdNil)
	return(false);	/* nope! */

    if (cArg > cArgMax)
	UError("No more than %d arguments when calling from the debugger.",
			cArgMax);

    /* turn args into SE's */
    for (i = 0, parg = &arg1, se = rgSe; i < cArg; i++, se++, parg++) {
	*se = *vseCnInt;
	se->val.valInt = *parg;
    } /* for */

    SeFSym(&aseProc, SymFIsym(v->rgPd[ipd].isym), true); /* get proc goodies */
    DoProc(&aseRet, &aseProc, rgSe, rgSe + cArg);
    return(true);
} /* FCallUserProc */
