/* $Header: process.c,v 5.41 86/07/25 12:53:11 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"
#include <ctype.h>

extern FILE * FpFSb();
extern char *gets();

export pPRR	v;	/* THE master global */
local pPRR	vprUserSet = prNil;
export pPRR	*vrgPr;
export int2	viprMax;	/* number of slots in process table */

local PRR	vaprDefault;	/* default, phony record for "v" to point at */
local SBT	vsbGrepFile = "/usr/tmp/cdbgrep";
local char	vchA = chNull;

SBT vmpPsSb[] = { "Nil",
		"No process",
		"Stopped",
		"Running",
		"Dying",
		"Forking",
		"Execing",
		"Continuing"
		};


/* I N I T   P R O C E S S   T A B L E */

export void InitProcessTable()
{
    int		ipr;
    FILE	*fp;
    SBT		sb;
    char	buffer[256];

    vrgPr = (pPRR *) malloc(viprMax * cbPRR);

    for (ipr = 0; ipr < viprMax; ipr++)
	vrgPr[ipr] = prNil;

    /* set up a phony process descriptor for us to point at */
    v = &vaprDefault;
    v->ipd = ipdNil;
    v->ifd = ifdNil;
    v->iln = ilnNil;
    v->slop = 0;
    v->rgFd = (pFDR) malloc(cbFDR);
    v->fnExec = fnNil;
    v->fnCore = fnNil;
    v->fnCdb = fnNil;
    v->hdr.ifdMax = 1;
} /* InitProcessTable */


/* S B   O P T I O N S   F   D E F A U L T */

export SBT SbOptionsFDefault(sbExec)
SBT	sbExec;
{
    int		i, cb;
    FILE	*fp;
    char	*sb, *sbEnd, sbBuffer[1024];
    static char	sbReturn[2048];

    /* look to see if there are default for this file */

    if (vsbDefaultFile == sbNil)
	return(sbNil);

    fp = FpFSb(vsbDefaultFile, "r");
    if (fp == NULL)
	UError("%s: %s.", vsbDefaultFile, SbFError(errno));

    for (i = 1; i <= 2; i++) {
	while (sb = fgets(sbBuffer, sizeof(sbBuffer), fp)) {
	    if (*sb == '#')	/* ignore comments */
		continue;
	    sbEnd = sb;
	    while (! isspace(*sbEnd))	/* skip over name */
		sbEnd++;
	    *sbEnd = chNull;	/* so we can do comparison */
	    if ( FSbCmp(sbExec, sb)
	       OR ((i == 2) AND (*sb == '*')) ) {
		/* found the name we are looking for */
		strcpy(sbReturn, sbEnd + 1);
		cb = strlen(sbReturn);
		sbReturn[cb-1] = chNull;	/* clip off "\n" */
		while (sb = fgets(sbBuffer, sizeof(sbBuffer), fp)) {
		    if (*sb == '#')	/* ignore comments */
			continue;
		    else if (*sb != '\t')
			break;	/* all done for this entry */
		    strcat(sbReturn, sb);
		    cb = strlen(sbReturn);
		    sbReturn[cb-1] = chNull;	/* clip off "\n" */
		} /* while */
		return(sbReturn);
	    } /* if */
	} /* while */
	fseek(fp, 0L, seekBegin);
	sbExec = strrchr(sbExec, '/');
	if ((sbExec == sbNil) OR (sbExec[1] == chNull))
	    break;
	sbExec++;	/* get past the '/' */
    } /* for */

    return(sbNil);
} /* SbOptionsFDefault */


/* S B   F   P S */

export SBT SbFPs(ps)
int2	ps;
{
    if ((ps < 0) OR (ps >= psMax))
	return("unknown");
    return(vmpPsSb[ps]);
} /* SbFPs */


/* L I S T   P R */

export void ListPr(prIn)
pPRR	prIn;
{
    int2	i, iMax;
    pPRR	pr;

    i = 0;
    iMax = viprMax;

    if (prIn != prNil) {
	i = IprFPr(prIn);
	iMax = i + 1;
    } /* if */

    printf("    #    PID   PPID  Status        CBEF Name and Arguments\n");
    for (; i < iMax; i++) {
	pr = vrgPr[i];
	if (pr != prNil) {
	    printf("%s%2d%7d%7d  %-13s %1d%1d%1d%1d %s %s\n",
		(pr == vprUserSet) ? ">> " : "   ",
		i, pr->pid, pr->pidParent, SbFPs(pr->ps),
		pr->fDebugChildren, !pr->fRemoveBpsOnFork,
		pr->fStopOnExec, pr->fStopOnFork,
		pr->sbExec, pr->sbArgsChild ? pr->sbArgsChild : "");
	} /* if */
    } /* for */
} /* ListPr */


/* R E A P   C H I L D R E N */

export void ReapChildren()
{
    int2	i;
    pPRR	pr;

    for (i=0; i < viprMax; i++) {
	if ((pr = vrgPr[i]) != prNil) {
	    if (pr->pid != pidNil) {
		if (pr->pidParent == vpidCdb) {
		    Ptrace(ptTerm, pr->pid, 0, 0);
		} else {
		    SetGlobalPr(pr);
		    if (pr->ps == psRunning) {
			SendSignal(2);
			Waiter(wtProcess, v->pid);
			v->sig = 0;	/* phony signal, don't pass it */
		    } /* if */
		    RemoveAllBp();
		    FreeProcess(pr);
		} /* if */
	    } /* if */
	} /* if */
    } /* for */
} /* ReapChildren */


/* P R	 F   F N */

export pPRR PrFFn(fn)
int2	fn;
{
    int2	i;

    for (i=0; i < viprMax; i++) {
	if ((vrgPr[i] != prNil)
	  AND (vrgPr[i]->fnComm == fn))
	    return(vrgPr[i]);
    } /* for */
    return(prNil);
} /* PrFFn */


/* I P R   F   P R */

export int2 IprFPr(pr)
pPRR	pr;
{
    int2	ipr;

    if (pr == prNil)
	Panic("IprFPr: nil pr.");

    for (ipr = 0; pr != vrgPr[ipr]; ipr++)
	;
    return(ipr);
} /* IprFPr */


/* P R	 F   I P R */

export pPRR PrFIpr(ipr)
int2	ipr;
{
    if ((ipr < 0) OR (ipr >= viprMax))
	return(prNil);
    return(vrgPr[ipr]);
} /* PrFPid */


/* P R	 F   S B */

export pPRR PrFSb(sb)
SBT	sb;
{
    int2	i;

    for (i=0; i < viprMax; i++) {
	if ((vrgPr[i] != prNil)
	  AND (FSbCmp(vrgPr[i]->sbName, sb)) )
	    return(vrgPr[i]);
    } /* for */
    return(prNil);
} /* PrFSb */


/* P R	 F   P I D */

export pPRR PrFPid(pid)
int2	pid;
{
    int2	i;

    for (i=0; i < viprMax; i++) {
	if ((vrgPr[i] != prNil)
	  AND (vrgPr[i]->pid == pid))
	    return(vrgPr[i]);
    } /* for */
    return(prNil);
} /* PrFPid */


/* S E T   G L O B A L	 P R */

export void SetGlobalPr(pr)
FAST	pPRR	pr;
{
    int4	ipr, ilnSave, ipdSave, ifdSave, slopSave;
    ADRT	adrSave;
    static pPRR	prSave = prNil;

    if (pr != prNil) {
	prSave = v;
    } else {
	if (prSave != prNil) {
	    pr = prSave;
	    prSave = prNil;
	} /* if */
	
	if (pr->sbExec == sbNil) {
	    for (ipr = 0; ipr < viprMax; ipr++) {
		if (vrgPr[ipr] != prNil) {
		    pr = vrgPr[ipr];
		    break;
		} /* if */
	    } /* for */
	    if (pr == prNil) {
		v = (prSave != prNil) ? prSave : &vaprDefault;
		vprUserSet = v;
		if (vcActive > 1)
		    SetPrompt("%s (%d) >", vsbDebugName, IprFPr(v));
		return;
	    } /* if */
	} /* if */
    } /* if */

    vprUserSet = v;
    if (v == pr)
	return; /* we are already set up */
    
    if (vcActive > 1)
	SetPrompt("%s (%d) >", vsbDebugName, IprFPr(pr));

    /* close currently open files of old global process */
    if (v != prNil) {
	if (v->fnCdb != fnNil) {
	    close(v->fnCdb);
	    v->fnCdb = fnNil;
	} /* if */
	if (v->fnExec != fnNil) {
	    close(v->fnExec);
	    v->fnExec = fnNil;
	} /* if */
	if (v->fnCore != fnNil) {
	    close(v->fnCore);
	    v->fnCore = fnNil;
	} /* if */
    } /* if */

    v = pr;
    vprUserSet = v;
    if (v == &vaprDefault)
	return;

    if ((v->fnCdb == fnNil) AND (v->sbCdb != sbNil))
	pr->fnCdb = open(pr->sbCdb, O_RDONLY);

    /* now we do a little dance to restore their viewing context */
    ifdSave = v->ifd;
    ipdSave = v->ipd;
    ilnSave = v->iln;
    slopSave = v->slop;
    adrSave = v->adrInst;
    v->ifd = ifdNil;	/* this forces reopen */
    if (ifdSave != ifdNil)
	OpenIfd(ifdSave);
    v->ipd = ipdSave;
    v->iln = ilnSave;
    v->slop = slopSave;
    v->adrInst = adrSave;
} /* SetGlobalPr */


/* P R	 F   A L L O C */

export pPRR PrFAlloc()
{
    int2	i;
    pPRR	pr;

    /* find a free process slot and initialize it. */

    for (i=0; i < viprMax; i++)
	if (vrgPr[i] == prNil)
	    break;
    if (i == viprMax)
	UError("Too many processes (> %d).", viprMax);

    /* First we ZERO EVERYTHING!!!!! */
    vrgPr[i] = (pPRR) calloc(1, cbPRR);	/* get a zeroed block */
    pr = vrgPr[i];
    pr->fnCdb = pr->fnComm = pr->fnExec = pr->fnCore = fnNil;
    pr->adrInit = pr->adrBreak = pr->adrCall = adrNil;
    pr->adrSb = pr->adrSbStart = pr->adrSbMax = adrNil;
    pr->adrStartLow = pr->adrStartHigh = adrNil;
    pr->adrText = pr->adrData = 0;
    pr->fStty = vfWindows;	/* if not windows, user must set himself */
    pr->as = asSuspended;
    pr->fAtSyscall = false;
    pr->fForkedProcess = false;
    pr->fDebugChildren = (viprMax > 1);
    return(pr);
} /* PrFAlloc */


/* D E A L L O C   P R */

export void DeallocPr(pr, fSaveLocals)
pPRR	pr;
FLAGT	fSaveLocals;
{
    if (v == pr)
	SetGlobalPr(vrgPr[0]);

    if (pr->pidParent == vpidCdb)
	/* We DON'T remove first level process records */
	return;

    vrgPr[IprFPr(pr)] = prNil;	/* clear our slot in the table */

    if (!pr->fForkedProcess) {
	if (pr->fnExec != fnNil)
	    close(pr->fnExec);
	if (pr->sbExec != sbNil)
	    free(pr->sbExec);

	if (pr->fnCdb != fnNil)
	    close(pr->fnCdb);
	if (pr->sbCdb != sbNil)
	    free(pr->sbCdb);

	if (pr->fnCore != fnNil)
	    close(pr->fnCore);
	if (pr->sbCore != sbNil)
	    free(pr->sbCore);

	/* free symbol table stuff */
	if (pr->isymCacheMax == pr->hdr.isymMax) {
	    /* it means we did it in a single alloc - semi- KLUDGE */
	    free(pr->symCache - pr->hdr.cbSymOffset);
	} else {
	    free(pr->symCache);
	    free(pr->lineCache);
	    free(pr->auxCache);
	    free(pr->sbCache);
	} /* if */

	free(pr->os->adrTty);
	free(pr->os);
    } /* if */

    /* free assertions, breakpoints, local variables and our DOT */
    /* these are always copied when we fork */
    if (pr->rgAd != 0)
	free(pr->rgAd);
    if (pr->rgBp != 0)
	free(pr->rgBp);
    if (pr->seDot != seNil)
	free(pr->seDot);
    if (pr->sbArgsChild != sbNil)
	free(pr->sbArgsChild);

    if (!fSaveLocals AND (pr->rgLv != 0))
	free(pr->rgLv);

    free(pr);
} /* DeallocPr */


/* P R   F   I N I T   P R */

export pPRR PrFInitPr(sbExec)
SBT	sbExec;
{
    char	sbOptions[2048];
    pPRR	pr;
    
    sbOptions[0] = chNull;
    AddOptions(sbOptions, vsbOptions, SbOptionsFDefault(sbExec), sbNil);

    pr = PrFAlloc();	/* get a process slot */
    pr->sbExec = SbFAlloc(sbExec);
    ApplyOptions(pr, sbOptions);
    InitPr(pr);
    return(pr);
} /* PrFInitPr */


/* I N I T   P R */

export void InitPr(pr)
pPRR	pr;
{
    int2	ipd, fnExec;
    int4	mtimeCdb, cbl;
    FLAGT	fTranslate;
    ADRT	adr;
    char	ch, *sb, sbCmd[200];
    SER		ase;
    pPRR	prSave;
    static FLAGT fFirstTime = true;

    prSave = v;
    v = pr;

    sb = SbFSearch(pr->sbExec, 5);
    if (sb == sbNil)
	UError(vsbFilename);

    fnExec = open(sb, O_RDONLY);
    if (fnExec < 0)
	UError("%s: %s.", sb, SbFError(errno));

    if (! FSbCmp(sb, pr->sbExec)) {
	printf("Using \"%s\" as executable.\n", sb);
	free(pr->sbExec);	/* get rid of old name */
	pr->sbExec = SbFAlloc(sb);
    } /* if */
    pr->fnExec = fnExec;
    pr->mtimeExec = AgeFFn(pr->fnExec);

    strcpy(sbCmd, pr->sbExec);	/* build file name for symbol table */
    strcat(sbCmd, ".cdb");
    pr->sbCdb = SbFAlloc(sbCmd);

    fTranslate = false;
    pr->fnCdb = open(pr->sbCdb, O_RDONLY);
    if (pr->fnCdb < 0) {
	fTranslate = true;
    } else if (pr->mtimeExec > AgeFFn(pr->fnCdb)) {
	fTranslate = true;
	close(pr->fnCdb);
    } else {
	/* check version stamp */
	if (read(pr->fnCdb, &(pr->hdr), cbHDRR) != cbHDRR)
	    Panic("Cannot read header of %s.", pr->sbCdb);
	if (pr->hdr.vstamp != CURRENT_VERSION) {
	    fTranslate = true;
	    close(pr->fnCdb);
	} /* if */
    } /* if */

    if (fTranslate) {	/* needs recreating for some reason */
	printf("Translating %s to %s ...", pr->sbExec, pr->sbCdb);
	fflush(stdout);

	/* Translate to the Hindi, thank you very much */
	sprintf(sbCmd, "cdbtrans %s", pr->sbExec);
	if (system(sbCmd) != 0) {
	    printf("\nTranslation failed\n");
	    exit(1);
	} /* if */
	pr->fnCdb = open(pr->sbCdb, O_RDONLY);
	mtimeCdb = AgeFFn(pr->fnCdb);

	printf("Done\n");

	if (read(pr->fnCdb, &(pr->hdr), cbHDRR) != cbHDRR)
	    Panic("Cannot read header of %s.", pr->sbCdb);
	if (pr->hdr.vstamp != CURRENT_VERSION) {
	    printf("\n\
Problem: The symbol table translator (\"cdbtrans\") that is invoked seems to\n\
be a different version than this debugger wants to work with.\n\
Please mention this problem to your system administrator.\n");
	    exit(1);
	} /* if */
    } /* if */

    pr->isymLo = pr->isymLim = 0;
    pr->iauxLo = pr->iauxLim = 0;
    pr->ilineLo = pr->ilineLim = 0;
    pr->issLo = pr->issLim = 0;
    vfCacheSymbols = true;	/* we do this by default */

    if (pr->isymCacheMax == 0) {
	/* then they want a total read of the ".cdb" file */
	cbl = CblFFn(pr->fnCdb);	/* get file size */
	adr = (ADRT) malloc((int)cbl);
	if (adr == 0) {
	    UError("Ran out of memory, please specify cache sizes.");
	    exit(1);
	} /* if */

	lseek(pr->fnCdb, 0L, seekBegin);	/* rewind to beginning */
	if (read(pr->fnCdb, (char *)adr, cbl) < 0)
	    Panic("Symbol table read failed: %s.", SbFError(errno));
	close(pr->fnCdb);
	pr->fnCdb = fnNil;

	pr->symCache = (pSYMR) (adr + pr->hdr.cbSymOffset);
	pr->isymLim = pr->isymCacheMax = pr->hdr.isymMax;

	pr->auxCache = (pAUXU) (adr + pr->hdr.cbAuxOffset);
	pr->iauxLim = pr->iauxCacheMax = pr->hdr.iauxMax;

	pr->lineCache = (pLINER) (adr + pr->hdr.cbLineOffset);
	pr->ilineLim = pr->ilineCacheMax = pr->hdr.ilineMax;

	pr->sbCache = (SBT) (adr + pr->hdr.cbSsOffset);
	pr->issLim = pr->issCacheMax = pr->hdr.issMax;

	pr->rgFd = (pFDR) (adr + pr->hdr.cbFdOffset);
	pr->rgPd = (pPDR) (adr + pr->hdr.cbPdOffset);
	pr->rgTd = (pTDR) (adr + pr->hdr.cbTdOffset);
	vfCacheSymbols = false;
    } else {
	Panic("Peter hasn't finished the non-virtual code yet...");

	pr->isymLim = pr->isymCacheMax;
	pr->symCache = (pSYMR) malloc(pr->isymCacheMax*cbSYMR);

	if (pr->ilineCacheMax == 0)
	    pr->ilineCacheMax = pr->hdr.ilineMax;
	pr->ilineLim = pr->ilineCacheMax;
	pr->lineCache = (pLINER) malloc(pr->ilineCacheMax*cbLINER);

	if (pr->iauxCacheMax == 0)
	    pr->iauxCacheMax = pr->hdr.iauxMax;
	pr->iauxLim = pr->iauxCacheMax;
	pr->auxCache = (pAUXU) malloc(pr->iauxCacheMax*cbAUXU);

	if (pr->issCacheMax == 0)
	    pr->issCacheMax = pr->hdr.issMax;
	pr->issLim = pr->issCacheMax;
	pr->sbCache = malloc(pr->issCacheMax);

	/* force cache init's */
	LineFIline(0);
	SymFIsym(0);
	AuxFIaux(0);
	SbFIss(0);
    } /* if */

    if (pr->rgFd[1].adr != 0)
	pr->rgFd[0].adr = 0; /* to prevent inifinite loop in IfdFAdr */

    pr->cpu = (pCPUR) malloc(cbCPUR);
    InitCpu(pr->cpu);	/* fill in cpu goodies */
    InitOs(pr);		/* perform OS specific initializations */

    if (pr->fnCore != fnNil) {
	ReadPc();
	SetCntx();	/* to make process globals be correct */
    } /* if */

    ipd = IpdFName(v->sbInit);
    if (ipd == ipdNil) {
	/* no luck finding specified procedure */
	pr->adrInit = pr->hdr.entrypoint;
    } else {
	pr->adrInit = AdrFPreamble(pr->rgPd[ipd].adr);
    } /* if */

    /* set up procedure-call-from-the-command-line addresses */
    ipd = IpdFName("_cdbend");
    if (ipd != ipdNil) {
	/* we do the file lookup to set the correct context for label search */
	pr->ifd = IfdFAdr(pr->rgPd[ipd].adr);
	pr->adrBreak = AdrFLabel("cdbBreak");
	if (pr->adrBreak == adrNil) {
	    pr->adrCall = pr->adrBreak = pr->rgPd[ipd].adr;
        } else {
            pr->adrCall = AdrFLabel("cdbCall");
        } /* if */

	/* set up string space */
        ase = *vseInt;
        ase.asym.iss = IssFSb("_cdbbuffer");
        pr->adrSb = pr->adrSbStart = (FGlobal(&ase)) ? ase.asym.value : adrNil;
        ase.asym.iss = IssFSb("_cdbbufMax");
        pr->adrSbMax = (FGlobal(&ase)) ? ase.asym.value : adrNil;
    } /* if */
    if ((pr->adrCall == adrNil) AND (ADR_CALL == 0))
		/* we will just use a random address */
	pr->adrBreak = pr->adrCall = pr->adrInit;

    /* set up string-save-buuffer addresses */
    ase = *vseInt;
    ase.asym.iss = IssFSb("_cdbbuffer");
    pr->adrSb = pr->adrSbStart = (FGlobal(&ase)) ? ase.asym.value : adrNil;
    ase.asym.iss = IssFSb("_cdbbufMax");
    pr->adrSbMax = (FGlobal(&ase)) ? ase.asym.value : adrNil;

    pr->ipdFork = IpdFName("fork");
    pr->ifd = ifdNil;
    pr->ipd = ipdNil;
    pr->iln = 0;
    pr->slop = 0;
    pr->ps = psNoChild;
    pr->pid = pidNil;
    pr->pidParent = vpidCdb;	/* will be changed if different */
    pr->seDot = (pSER) malloc(cbSER);	/* create our own stack element */

    if (pr->sbComm != sbNil)
	InitComm(pr);

    if (fFirstTime) {
	/* We haven't done master RC file yet - do it */
	sb = getenv("HOME");
	if (sb != sbNil) {
	    sprintf(sbCmd, "%s/.cdbrc", sb);
	    PlaybackFile(sbCmd);
	} /* if */
	fFirstTime = false;
    } /* if i*/

    /* Do any rc file that may exist for this executable */
    sprintf(sbCmd, "%s.rc", pr->sbExec);
    fnExec = open(sbCmd, O_RDONLY);
    if ((fnExec >= 0) AND (pr->mtimeExec < AgeFFn(fnExec)))
	PlaybackFile(sbCmd);

    v = prSave;
} /* InitPr */
