/* $Header: pt.c,v 6.4 86/09/14 20:23:55 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include <signal.h>
#include <setjmp.h>
#include "cdb.h"

export FLAGT	vfAnalyzeStop = false;


/* S B   F   N E X T   A R G */

export SBT SbFNextArg(psbIn)
SBT	*psbIn;
{
    char	chExit;
    SBT		sb, sbRet, sbTemp;

    sb = *psbIn;

    /* skip white space */
    while (*sb == ' ' OR *sb == '\t')
	sb++;

    if (*sb == chNull)
	return(sbNil);	/* that's all, folks! */

    sbRet = sb;
    sbTemp = sb;

    if ((*sb != '"') AND (*sb != '\'')) {

	/* eat all non-white space characters */
	while ((*sb != chNull)
	   AND (*sb != ' ')
	   AND (*sb != '\t')) {
	    if ((*sb == '"') OR (*sb =='\'')) {
		chExit = *sb++;
		goto DoString;	/* I know, it's a horrible hack!!! */
	    } /* if */
	    *sbTemp++ = *sb++;
	} /* while */

    } else {

	chExit = *sb;	/* remember starting character */
	*sbTemp++ = *sb++;	/* so caller knows it's magic */
DoString:
	/* collect arg involving string literal */

	while ((*sb != chNull) AND (*sb != chExit)) {
	    /* this routine will walk us over all escape sequences */
	    *sbTemp++ = ChFEscape(&sb, true);
	} /* while */
	if (*sb != chExit)
	    UError("String constant in arg list is missing ending %c.", chExit);
    } /* if */

    *sbTemp = chNull;
    *psbIn = sb + 1;	/* point them at next available character */
    return(sbRet);
} /* SbFNextArg */


/* D O	 A R G S */

export void DoArgs(sbProgram, sbArgs, argv, fReassign)
SBT	sbProgram, sbArgs;
char	**argv;
FLAGT	fReassign;
{
    int		i;
    SBT		sbFile, sbArgCur;
    static char	sbBuffer[1024];

    for (i = 0; i < cArgsMax; i++)
	argv[i] = sbNil;

    *argv++ = sbProgram; /* set the filename */

    if (sbArgs == sbNil)
	return;

    strcpy(sbBuffer, sbArgs);	/* copy it to a safe place to hack on it */
    sbArgs = sbBuffer;
    sbArgs[strlen(sbArgs)+1] = chNull; /* this puts a SECOND null at end */

    /* eat the arguments */
    while ((sbArgs != sbNil)
       AND (*sbArgs != chNull)) {

	sbArgCur = SbFNextArg(&sbArgs);
	if (sbArgCur == sbNil)
	    break;

	if ((*sbArgCur == '"') OR (*sbArgCur == '\'')) {
	    /* it's a string literal */
	    *argv++ = sbArgCur + 1;	/* cut off the ' or " */
	    continue;
	} /* if */

	/* check for indirection */
	if (!fReassign
	   OR ((*sbArgCur != '<') AND (*sbArgCur != '>')) ) {
	    *argv++ = sbArgCur;	/* we just pass it on */
	} else {
	    /* find that file name */
	    sbFile = sbArgCur + 1;  /* initially we assume `<foo' vs `< foo' */
	    if ((sbArgCur[1] == '>') OR (sbArgCur[1] == '&'))
		sbFile++;

	    if (*sbFile == chNull) {
		/* there was white space between < and sbFile */
		sbFile = SbFNextArg(&sbArgs);
		if (sbFile == sbNil) {
		    printf("Illegal indirection\n");
		    exit(1);
		} /* if */
	    } /* if */

	    if (*sbArgCur == '<') {
		/* changing stdin */
		close(0);
		if (open(sbFile, O_RDONLY) < 0) {
		    perror(sbFile);
		    exit(1);
		} /* if */

	    } else if (*sbArgCur == '>') {

		if (sbArgCur[1] == '>') {
		    /* changing stderr */
		    close(2);
		} else {
		    /* changing stdout */
		    close(1);
		} /* if */

		if ( (open(sbFile, O_WRONLY) < 0) 
		   AND (creat(sbFile, 0666) < 0) ) {
		    perror(sbFile);
		    exit(1);
		} /* if */

		if (sbArgCur[1] == '&') {
		    /* changing BOTH stdout AND stderr */
		    close(2);
		    dup(1);	/* duplicate stdout's decriptor into stderr's */
		} /* if */

	    } /* if */
	} /* if */
    } /* while */
    *argv = sbNil;
} /* DoArgs */


/* A N A L Y Z E   S T O P */

export void AnalyzeStop()
{
    int2	statLo, statHi, psSave;
    SAR		asa;
    pBPR	bpFork;
    SBT		sbSave;
    FLAGT	fNewCommands;

    /* The current process is examined to determine the reason it stopped.
     * If it was do a break which is being ignored, we continue it
     * automatically.
     */

    v->sigOrig = statHi = v->status >> 8;
    v->sig = 0;
    statLo = v->status & 0377;
    v->bp = bpNil;

    if (statLo == 0) {	/* child terminated */

	if (statHi != 0)
	    printf("Process %d exited with %d\n", v->pid, statHi);
	else
	    printf("Process %d terminated normally\n", v->pid);
	v->pid = pidNil;

	KillChild();	/* go bury the corpse */

    } else if ((statLo & 0177) != 0177) {  /* terminated on signal */

	if (v->ps == psDying) {
	    v->ps = psNoChild;
	    return;	/* this was expected */
	} /* if */

	v->sigOrig = v->sig = v->status & 0x7f;
	printf("Child terminated on signal %d - %s", v->sigOrig,
			SbFSignal(v->sigOrig));
	if (v->status & 0200) {
	    printf("(core dumped)");
	    if (v->fnCore != fnNil)
		close(v->fnCore);
	    free(v->sbCore);
	    v->sbCore = SbFAlloc("./core");
	    InitCore(v, nil);
	} /* if */

	v->pid = pidNil;
	printf(" at %s\n", SbFAdr(v->acntx.pc, true));
	SetViewPosition(v->acntx.pc);
	ShowViewPosition(fmtProc+fmtLn+fmtLine+fmtEol);
	KillChild();	/* it's already dead, but this does general stuff */

    } else {	/* child stopped */

#if (SYS == MX2)
	if (v->sigOrig == SIGBPT)
	    v->sigOrig = SIGTRAP;
#endif /* (SYS == MX2) */

	sbSave = sbNil;
	fNewCommands = false;
	psSave = v->ps;
	v->ps = psStopped;
	ReadPc();	/* get a cleaned up pc */

	asa = v->os->mpSigSa[v->sigOrig]; /* get a COPY of this action record */
	if (! asa.fIgnore)
	    v->sig = v->sigOrig;

	if (v->sigOrig != v->os->sigTrap) {

	    if (asa.sbSa[0] != 0) {
		fNewCommands = true;
		sbSave = SbFAlloc(v->sbCmd);	/* save current stuff */
		SetCmd(asa.sbSa);
		asa.fStop = true;	/* THEY must continue if desired */
	    } /* if */

	    if (v->fDoingSingle AND !asa.fStop) {
		if (asa.fReport) {
		    SetViewPosition(v->acntx.pc);
		    printf("\n%s\n", SbFSignal(v->sigOrig));
		    ShowViewPosition(fmtProc+fmtLn+fmtLine+fmtEol);
		} /* if */
		Ptrace(ptSingle, v->pid, (char *)1, v->sig);
		v->ps = psRunning;
		return;
	    } /* if */

	    if (asa.fStop)
		v->bp = vbpStop;	/* primarily used to alert SingleStep */
	} else {

	    /* We have received the signal SIGTRAP.
	     * We need to go through a series of test to determine
	     * what this means.  
	     */

	    FixPc(); /* modifies v->acntx.pc to point AT the break, if any */

	    /* we first attempt to map a breakpoint to this address */
	    v->bp = BpFProcess(v->acntx.pc);

	    if (v->bp == bpNil) {
		bpFork = BpFForkSave(v->pidParent, v->acntx.pc);
		if (bpFork != bpNil) {
		    RemoveBp(bpFork);
		    v->bp = vbpStop;
		} /* if */
	    } /* if */

	    if (v->bp == bpNil) {

		/* a trap signal, but no breakpoint */
		asa.fReport = false;
		asa.fStop = false;
		switch (psSave) {
		    case psRunning:
			/* There are only three ways that we can arrive here:
			 *	1. We single stepped a process.
			 *	   a.  Normal instruction step.
			 *	   b.  Step over trap in execve.
			 *	2. One of our processes did an exec().
			 *	3. Some commie mutant sent SIGTRAP to
			 *	   one of process.
			 *
			 * If #1 is true, we simply stop.
			 * If #2 is true, then the PC must be within N
			 * byte of the start address.  If it isn't, we
			 * assume case #3 and ignore it.
			 */
			if (!v->fDoingSingle OR v->fAtSyscall) {
			    ADRT	adr;

			    if (v->os->adrEntry != adrNil) {
				adr = GetUser(v->os->adrEntry);
				if ((v->acntx.pc >= adr)
				   AND (v->acntx.pc< adr + v->os->dadrEntMax)) {
				       if (v->pidParent != vpidCdb) {
					    /* We seem to have done an exec().
					     * Change our symbol table.
					     */
					    v = PrFExec(v);
					    if (v->fStopOnExec) {
						asa.fStop = true;
						asa.fReport = true;
					    } /* if */
					} else {
					    asa.fStop = true;
					} /* if */
					ExecInit(! v->fDoingSingle);
				}/* if */
			    } /* if */
			} /* if */

			if (v->fDoingSingle)
			    asa.fStop = true;
			break;

		    case psExec:
			asa.fStop = true;
			break;

		    case psFork:
			asa.fStop = v->fStopOnFork;
			break;

		    default:

			Panic("SIGTRAP for process %d with ps of %s.", 
				v->pid, SbFPs(psSave));
		} /* switch */

	    } else if (v->bp == vbpContinue) {

		/* we hit a break, but the continue count said to ignore it */
		asa.fReport = false;
		asa.fStop = false;

	    } else if (v->bp == vbpStop) {

		/* we hit a temporary break */
		asa.fReport = false;
		asa.fStop = true;
		v->bp = bpNil;

	    } else if (v->bp->adr == v->adrBreak) {

		/* Return from a Procedure Call from the Command Line */
		SetCntx();
		return;	/* special kludge for proc-calls from the cmd line */

	    } else {

		/* a vanilla flavored break */
		if (v->bp->sbBp[0] != chNull) {
		    fNewCommands = true;
		    SetCmd(v->bp->sbBp);
		} /* if */

	    } /* if */

	} /* if - end of SIGTRAP code */

	if ((v->sbCmd != sbNil) AND (*v->sbCmd == 'Q'))
	    asa.fReport = false;

	v->fAtSyscall = false;
	if (asa.fStop == false) {
	    v->ps = psContinue;
	    return;
	} /* if */

	SetCntx();	/* we'll be here for awhile, get rest of goodies */
	SetViewPosition(v->acntx.pc);
	if (asa.fReport) {
	    printf("\n%s\n", SbFSignal(v->sigOrig));
	    ShowViewPosition(fmtProc+fmtLn+fmtLine+fmtEol);
	} /* if */

	if (fNewCommands) {
	    /* process any commands that we were handed */
	    vfAnalyzeStop = true;
	    FDoCommand(v->sbCmd, false);
	    vfAnalyzeStop = false;
	    SetCmd(sbSave);
	    if (sbSave != sbNil)
		free(sbSave);
	} /* if */
    } /* if */
} /* AnalyzeStop */


/* R U N   P R O C E S S */

export void RunProcess(pt, ps, fWait)
int2	pt, ps;
FLAGT	fWait;
{
    pBPR	bpRun;

    vfCacheValid = false;
    v->fMachineStep = false;

    if (v->pid == pidNil)
	UError("No process.");

    AllBpInstall();	/* make sure they are all in */

    if ((v->fRunAssert)
       AND (v->as == asActive)
       AND (v->ps != psFork)
       AND (v->iadMac > 0)) {
	/* do the assertions */
	if (FDoAssert(pt)	/* an assertion came up true */
	   OR (v->pid == pidNil)	/* the child died during assertions */
	   OR (v->bp != bpNil) )	/* we hit a breakpoint */
	    return;
    } /* if */

    /* hit the GO button */
    v->ps = ps;
    if (v->fStty)
	SetHisTty();

    /* get us off any break we might be on */
    while ((bpRun = BpFAdr(v->acntx.pc, true)) != bpNil) {
	RemoveBp(bpRun);	/* pull it out */
	while ((bpRun->adr == v->acntx.pc)
	   AND (v->ps == ps)) {
	    v->fDoingSingle = true;
	    Ptrace(ptSingle, v->pid, (char *)v->acntx.pc, v->sig);
	    Waiter(wtProcess, v->pid);
	} /* while */
	AllBpInstall();	/* make sure they are all in */
	if (v->bp != bpNil)
	    return;
	if (pt == ptSingle)
	    return; /* we have already single stepped it for them */
    } /* while */

    errno = 0;
    /* start/continue child */
    v->ps = ps;
    v->fDoingSingle = (pt == ptSingle);
    Ptrace(pt, v->pid, (char *)v->acntx.pc, v->sig);
    if (fWait)
	Waiter(wtProcess, v->pid);
} /* RunProcess */


/* K I L L   C H I L D */

export void KillChild()
{
    if (--vcActive < 0)	/* count of Active proceesses */
	vcActive = 0;

    if (v->pid != pidNil) {
	if (v->pid < 3) {
	    printf("Process %d (%s) is a system process.\n", v->pid, v->sbExec);
	    if (! YesNo("Do you REALLY want to kill it ?"))
		UError(sbNil);
	} /* if */
	RemoveAllBp();
	v->ps = psDying;
	Ptrace(ptTerm, v->pid, (char *)0, 0);
	Waiter(wtProcess, v->pid); /* wait for the obituary */
    } /* if */

    if (v->pidParent != vpidCdb) {
	/* not a direct child */
	DeallocPr(v, false);
	return;
    } /* if */

    v->pid = pidNil;
    v->fMachineStep = false;
    v->fDoingSingle = false;
    v->ps = psNoChild;
    v->acntx.pc = v->adrInit;
    v->sig = 0;
    v->acntx.fp = 0;
    v->acntx.fEndOfStack = true;
    RemoveAllBp(true);

    if (v->fnCore != fnNil) {
	ReadPc();
	SetCntx();	/* refresh from the core file */
    } /* if */

    if (v->fnExec == fnNil) {
	/* opening for writing keeps other people from using file */
	v->fnExec = open(v->sbExec, O_RDONLY);
	if (v->fnExec == -1) {
	    perror(v->sbExec);
	    v->fnExec = fnNil;
	} /* if */
    } /* if */
    if (viprMax > 1)
	SetGlobalPr(prNil);

    if (v->cNestProc != 0) {
	extern jmp_buf venvFixer;
	v->cNestProc = 0;
	venv = venvFixer;
	UError("Exiting procedure call state.");
    } /* if */
} /* KillChild */


/* N E W   C H I L D */

export void NewChild(sbArgs, fInit)
SBT	sbArgs;
FLAGT	fInit;
{
    FLAGT	fMaster, fDoingSingle;

    if (v->pidParent != vpidCdb)
	UError("You cannot 'run' a grandchild process!");

    fDoingSingle = v->fDoingSingle;
    KillChild(); /* in case there is already one out there */

    InitMyTty(); /* reads in my state to 'mytty' */

    if (sbArgs == sbNil) {
	v->sbArgsChild = sbNil; 	/* do the child with no arguments */
    } else {
	fMaster = (sbArgs == v->sbCmd);	/* this is the normal command line */
	while (*sbArgs == ' ' OR *sbArgs == '\011')
	    sbArgs++;	/* eat leading white space */
	if (*sbArgs != chNull) {
	    if (v->sbArgsChild != sbNil)
		free(v->sbArgsChild);
	    v->sbArgsChild = SbFAlloc(sbArgs);
	    if (fMaster) {
		/* eat it - this way we don't
		 * try to execute the arguments to the child
		 * as debugger commands
		 */
		SetCmd(sbNil);
	    } /* if */
	} /* if */
    } /* if */

    printf("running '%s", v->sbExec);
    if (v->sbArgsChild != sbNil)
	printf(" %s",  v->sbArgsChild);
    printf("'\n");

    v->fDoingSingle = fDoingSingle;
    fflush(stdout);
    CreateTarget();

    ++vcActive;		/* count of Active processes */
    v->ps = (v->os->adrEntry == adrNil) ? psExec : psRunning;
    Waiter(wtProcess, v->pid); /* wait for child to stop and report */
    if (v->os->adrEntry == adrNil)
	ExecInit(fInit);
} /* NewChild */


/* E X E C   I N I T */

export void ExecInit(fInit)
FLAGT	fInit;
{
    if (v->fDebugChildren)
	Ptrace(ptMultiChild, v->pid, 0, 0);	/* put our stamp on him */

    if (v->os->fClearFp)
	PutReg(ufp, (REGT)0);	/* some systems do not zero out the fp */

    if (fInit OR (v->as == asActive)) {
	/* we don't want assertions during initialization */
	BpFAddBp(v->adrInit, 0, sbNil, 0); /* at first USER instruction */

	v->fRunAssert = false;

	RunProcess(ptResume, psExec, true);

	v->fRunAssert = true;
	/* we should now have a fully initialized, stopped process,
	 * waiting at the first executable line of 'main' or whatever.
	 */

	if (v->adrStartLow == adrNil) {
	    int		ipd;
	    CNTXR	acntx;

	    /* init stack-walk stop variables. */
	    acntx = v->acntx;
	    NextFrame(&acntx);
	    ipd = IpdFAdr(acntx.pc);
	    v->adrStartLow = v->rgPd[ipd].adr;
	    v->adrStartHigh = v->rgPd[ipd +1].adr;
	} /* if */
    } /* if */
} /* ExecInit */
