
/* $Header: rptrace.h,v 5.8 85/12/21 16:15:09 peter Exp $ */
/* (C) Copyright 1984 Third Eye Software Inc. - All Rights Reserved */

/*
 *
 * The modules rptrace.c and cdbremote.c implement a simple, ASCII based
 * protocol for controlling a remote debug server.
 *
 * The host is in control of the conversation.  The entire exchange
 * is "host says something", "remote replies".
 *
 * All numbers are hexidecimal and are represented by the characters
 * [0..9,a..f].  The only non-printing character used is "new line"
 * <nl> (012) which is the "end-of-transmission" character.
 *
 * The symbol <pid> is the "process id" of the process in question.
 * It is aggreed upon during the "msgExec" transaction.
 *
 * The remote's messages are of the form:
 *	<status> '|' <pid> '|' <reply value> <nl>
 * The reply value is not always present.
 *
 *	Status		Meaning
 *	------		-------
 * -3	statusNewPid	The pid in the message is the result of an EXEC
 * -2	statusRetry	Re-transmit last message to remote
 * -1	statusPrint	Reply is string destined for command terminal screen
 *  0	statusOk	Execution ok, reply is defined by command last given
 *	> statusOk	(gtr than statusOk) same meanings as "errno" on host.
 *
 *
 * The host's messages are of the general form:
 *	<message identifier> | <pid> | <argument> | (argument> | ... <nl>
 *
 *	Messages from Host
 *	------------------
 *
 *	msgExec '|' <pid> '|' <program name> '|' "<args>" <nl>
 *		The <pid> passed is the host's vote for the process id,
 *		HOWEVER, if the remote returns statusNewPid, that <pid>
 *		will be the one	actually used for all future communications
 *		about this process. If the remote doesn't care, it should
 *		return the same <pid> as was passed by host.
 *		If <pid> is already in use, the remote should infer a
 *		msgQuit on that process.
 *
 *	msgQuit '|' <pid> <nl>
 *		Debugger is done working with process <pid>.
 *
 *	msgWait '|' <pid> <nl>
 *		Wait for process <pid> to do something. (Hit a
 *		breakpoint, die, etc.)  If <pid> == 0, we are waiting
 *		for ANY process to do something.
 *
 *	msgPtrace '|' <pid> '|' <request> '|' <address> '|' <value> <nl>
 *		The meanings, and expected responses, are exactly as
 *		outlined in "ptrace(2)" in the UNIX manual.  Request 9
 *		"single step" is NOT optional!
 *
 *	msgInput  '|' <pid> '|' "any ASCII string NOT containing a <nl>" <nl>
 *		The string is meant to be inserted into the TTY input
 *		queue for the target process. Not all systems allow this.
 *
 *	These next three commands facilitate block data handling.
 *
 *	msgRtoH   '|' <pid> '|' <source address> '|' <count> <nl>
 *		Transfer data FROM remote TO host.  The first field
 *		of the reply is the number of bytes
 *		actually being transfered.  The host will continue
 *		to request the unsent portions.  This allows the
 *		remote to cope with small buffer sizes.
 *
 *	msgHtoR   '|' <pid> '|' <destination address> '|' <count>
 *			'|' <data - two ASCII hex characters per byte> .... <nl>
 *		Transfer data FROM host TO remote.
 *
 *	msgMove   '|' <pid> '|' <destination address>
 *			'|' <source adrress> '|' <count> <nl>
 *		Transfer data WITHIN remote.
 *
 *	msgSignal '|' <pid> '|' <signal number> <nl>
 *		Send signal to a running process.  This is applicable only
 *		when the host is waiting for a response to msgWait.
 *
 *	msgDump   '|' <pid> <nl>
 *		Reply with statusPrint and any useful information in ascii
 *		for debugging DebugServer or its operating system interface.
 *
 *	msgLevel  '|' <pid> '|' <level><nl>
 *		Set debug level of DebugServer in target system.
 */

#define cbMsgMax 256	/* max bytes host OR remote can tx OR rx at one time */
#define chDelim	'|'	/* delimiter for arguments */

/* Maximum number of retires on a transmission */
#define cRetryMax	3

/* messages sent host-to-remote */
#define msgQuit		1
#define msgExec		2
#define msgPtrace	30
#define msgWait		4
#define msgRtoH		6
#define msgHtoR		7
#define msgMove		8
#define msgSignal	9
#define msgLevel	11

/* status values - first item in ALL remote-to-host messages */
/* values 0-90 are assumed to have the same meaning as shown in <errno.h> */
#define statusOk	0
#define	statusRetry	93

/* return values to WAIT */
#define rvTerminate	1
#define rvBreakpoint	2
#define rvInterrupt	3

/* requests for `ptrace' system call */
#define ptChild	 	0
#define ptReadI	 	1
#define ptReadD	 	2
#define ptReadUser      3
#define ptWriteI	4
#define ptWriteD	5
#define ptWriteUser     6
#define ptResume	7
#define ptTerm	  	8
#define ptSingle	9

/* the following are NEW ptrace requests add for multiprocess work */
#define ptMultiChild	10	/* we own you and your firstborn */
#define ptReleaseChild	11	/* go `way ya bother me, Kid.... */
#define ptPpid		12	/* give us pid of parent of this process */
#define ptCmdName	13	/* return name of executable */

#define ptMax		13	/* maximum acceptable ptrace command */
