/* $Header: signal.c,v 5.5 86/07/18 06:14:13 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"


/* S A	 M A I N T A I N */

export void SaMaintain(sig, sbOptions, sbCmds)
int	sig;
SBT	sbCmds, sbOptions;
{
    FLAGT	fCommands, fShowSignal;
    pSAR	sa;

    /* toggle options based on the flags:
     * r = report,  s = stop,  i = ignore signal, Q = do it quietly
     * c = get commands after switches
     */

    if (sig == v->os->sigTrap)
	printf( "WARNING: You are modifying the breakpoint signal!\n");

    fCommands = false;
    fShowSignal = ! v->fQuiet;

    sa = v->os->mpSigSa + sig;
    while (*sbOptions) {
	switch (*sbOptions) {
	    case 'r':
		sa->fReport = !sa->fReport;
		break;
	    case 's':
		sa->fStop = !sa->fStop;
		break;
	    case 'i':
		sa->fIgnore = !sa->fIgnore;
		break;
	    case 'Q':
		fShowSignal = false;
		break;
	    case 'c':
		fCommands = true;
		break;
	    default:
		printf("Unknown signal command: \"%c\"\n", *sbOptions);
		fShowSignal = true;
		goto ShowSignal;
	} /* switch */
	sbOptions++;
    } /* while */

    if (fCommands)
	strcpy(sa->sbSa, sbCmds);

ShowSignal:
    if (fShowSignal) {
	printf("   Stop  Ignore  Report  Name\n");
	printf("%2d  %c      %c       %c     %s\n", sig,
			(sa->fStop) ? 'T':'F',
			(sa->fIgnore) ? 'T':'F',
			(sa->fReport) ? 'T':'F',
			SbFSignal(sig));
	if (sa->sbSa[0] != chNull)
	    printf("\t%s\n", sa->sbSa);
    } /* if */
} /* SaMaintain */


/* L I S T   S A */

export void ListSa()
{
    int		sig;
    pSAR	sa;

    MoreOn();

    printf("   Stop  Ignore  Report  Name\n");
    for (sig=1;	sig < v->os->sigMax; sig++) {
	sa = v->os->mpSigSa + sig;
	printf("%2d  %c      %c       %c     %s\n", sig,
			(sa->fStop) ? 'T':'F',
			(sa->fIgnore) ? 'T':'F',
			(sa->fReport) ? 'T':'F',
			SbFSignal(sig));
	if (sa->sbSa[0] != chNull)
	    printf("\t%s\n", sa->sbSa);
    } /* for */

    MoreOff();
} /* ListSa */
