/* $Header: single.c,v 5.15 86/04/28 13:30:07 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include "cdb.h"


/* A D R   F   R E T U R N   P C */

local ADRT AdrFReturnPc()
{
    CNTXR	acntx;

    /* given the current context, return the return address */

    acntx = v->acntx;
    NextFrame(&acntx);
    if (acntx.fEndOfStack)
	return(adrNil);

    return(acntx.pc); /* get return */
} /* AdrFReturnPc */


/* S I N G L E   S T E P */

export void SingleStep(cmd, fQuiet)
CMDE	cmd;
FLAGT	fQuiet;
{
    int2	fmt, ipd, ipdBefore, iln, slop;
    ADRT	adr;
    FLAGT	fBigStep, fMachineStep;
    pBPR	bp;

    fBigStep = (cmd == cmdMachProc) OR (cmd == cmdLineProc);
    fMachineStep = (cmd == cmdMachSingle) OR (cmd == cmdMachProc);
    fmt = (fQuiet) ? fmtNil :
	(fmtProc + fmtLn + fmtLine + fmtEol + (fMachineStep ? fmtInst : 0));
    slop = -1; /* just to get us into loop first time */

    if (v->pid == pidNil) {
	/* we have no process, create one! */
	v->fDoingSingle = fMachineStep;
	NewChild(v->sbArgsChild, !fMachineStep);
	SetViewPosition(v->acntx.pc);
	ShowViewPosition(fmt);
	return;
    } /* if */

    /* The idea here is to loop until we get someplace interesting. This
     * usually means at an address that translates EXACTLY (slop == 0) to
     * a known line number.
     */

    while (slop != 0) {
        if (FAtCall(v->acntx.pc)) { /* at proc call */
	    /* follow the call - this way we don't have to deal with N ways
	     * to compute callee's address.
	     */
	    ipdBefore = IpdFAdr(v->acntx.pc);

	    RunProcess(ptSingle, psRunning, true);

	    if (v->bp != bpNil)
		return;	/* a REAL breakpoint */

	    ipd = IpdFAdr(v->acntx.pc);
	    if (ipdBefore != ipd) {
		/* The way we get here is if we were at a BREAK that
		 * was exactly on a proc call.  RunProcess stepped
		 * us off the call instruction so that it could
		 * replace the break.
		 */
	    } /* if */

	    if (!fBigStep) {
		if (fMachineStep)
		    break;
		if (v->rgPd[ipd].iline != 0) {
		    /* we have source for it */
		    adr = AdrFPreamble(v->acntx.pc); /* allows for intro code */
		    if (adr != v->acntx.pc) {
			/* temp BP after intro code */
			bp = BpFAddBp(adr, 0, sbNil, 0);
			if (bp->inst == 0)
			    InstallBp(bp);
			if (ipd == v->ipdFork)
			    SaveForkBp(bp);
			RunProcess(ptResume, psRunning, true);
		    } /* if */
		    break; /* go to the stuff at end of this procedure */
		} /* if */
		/* if we get here, then the proc call goes to the
		 * twilight zone - fall into fBigStep code
		 */
	    } /* if */

	    adr = RetFSp(v->acntx.sp);
	    if (!fMachineStep)
		adr = AdrFStackFix(adr);
	    bp = BpFAddBp(adr, 0, sbNil, 0);
	    if (bp->inst == 0)
		InstallBp(bp);
	    if (ipd == v->ipdFork)
		SaveForkBp(bp);
	    RunProcess(ptResume, psRunning, true);

	} else {	/* NOT at a procedure call */

	    RunProcess(ptSingle, psRunning, true);
	    if (v->bp != bpNil)
		return; /* a REAL breakpoint, so it MUST be kosher! */

	    if (!fMachineStep AND (v->rgPd[IpdFAdr(v->acntx.pc)].iline == 0) ) {
		/* They want to statement step in STARTING in non-symboled code.
		 * The only way to get here is to machine step into
		 * non-symboled code, or to get a signal of some sort.
		 * So we cross our fingers that the frame pointer
		 * is kosher and do a temporary uplevel break.
		 */
		adr = AdrFReturnPc(); /* get return */
		if (adr != adrNil)
		    BpFAddBp(adr, 0, sbNil, 0);
		RunProcess(ptResume, psRunning, true);
		slop = -1;
	    } /* if */
	} /* if */

	if ( (v->bp != bpNil) OR (v->pid == pidNil) )
	    return;
	if (fMachineStep)
	    break;
	IpdIlnFAdr(&iln, &slop, v->acntx.pc);
    } /* while */

    if ((v->pid != pidNil) AND (v->bp == bpNil)) {
	SetViewPosition(v->acntx.pc);
	ShowViewPosition(fmt);
    } /* if */

    v->fMachineStep = fMachineStep;
} /* SingleStep */
