/* $Header: sym.h,v 5.18 86/07/18 06:14:35 peter Exp $ */

/* (C) Copyright 1984 by Third Eye Software, Inc.
 *
 * Third Eye Software, Inc. grants reproduction and use rights to
 * all parties, PROVIDED that this copyright notice is maintained
 * in the copy.
 *
 * Third Eye makes no claims about the applicability of this
 * symbol table to a particular use.
 */

/* 
 * This file contains the definition of the Third Eye Symbol Table.
 *
 * Symbols are assumed to be in 'encounter order' - i.e. the order that
 * the things they represent were encountered by the compiler/assembler/loader.
 * EXCEPT for globals!	These are assumed to be bunched together,
 * probably right after the last 'normal' symbol.  Globals ARE sorted
 * in ascending order.
 *
 * -----------------------------------------------------------------
 * A brief word about Third Eye naming/use conventions:
 *
 * All arrays and index's are 0 based.
 * All "ifooMax" values are the highest legal value PLUS ONE. This makes
 * them good for allocating arrays, etc. All checks are "ifoo < ifooMax".
 *
 * "isym"	Index into the SYMbol table.
 * "ipd"	Index into the Procedure Descriptor array.
 * "ifd"	Index into the File Descriptor array.
 * "iss"	Index into String Space.
 * "cb"		Count of Bytes.
 * "rgPd"	array whose domain is "0..ipdMax-1" and RanGe is PDR.
 * "rgFd"	array whose domain is "0..ifdMax-1" and RanGe is FDR.
 */

#ifndef int4
#define int1	char
#define uint1	unsigned char
#define int2	short
#define uint2	unsigned short
#define int4	long
#define uint4	unsigned long
#define bits	unsigned int
typedef uint4	ADRT;
#endif

/* 
 * HDR structure.
 * As long as all the pointers are set correctly,
 * we don't care WHAT order the various sections come out in!
 *
 * A file produced solely for the use of CDB will probably NOT have
 * any instructions or data areas in it, as these are available
 * in the original.
 */

#define CURRENT_VERSION	7

typedef struct HDS {
	int2	magic;		/* magic numer as defined below */
	int2	vstamp;		/* version stamp */
	uint4	cbText;		/* text size in bytes, padded to FW boundary */
	uint4	cbData;		/* initialized data	"  "		*/
	uint4	cbBss;		/* uninitialized data	"  "		*/
	uint4	entrypoint;

	int4	ipdMax;		/* number of procedures */
	uint4	cbPdOffset;	/* offset to procedure array */
	int4	ifdMax;		/* number of files */
	uint4	cbFdOffset;	/* offset to file array */
	int4	ilineMax;	/* number of line numbers (0 if none) */
	uint4	cbLineOffset;	/* offset to start of LINE's*/
	int4	issMax;		/* max index into string space */
	uint4	cbSsOffset;	/* offset to start of string space */
	int4	isymMax;	/* number of symbols */
	uint4	cbSymOffset;	/* offset to start of symbols*/
	int4	isymGl;		/* lowest isym of a global */
	int4	isymGlMax;	/* highest isym of a global + 1 */
	int4	iauxMax;	/* number of auxillary symbols */
	uint4	cbAuxOffset;	/* offset to start of auxillary symbols*/
	int4	itdMax;		/* number of typedefs */
	uint4	cbTdOffset;	/* offset to start of typedef info */
	int4	ijokeDay;	/* index to joke of the day -
				 * if (ijokeDay == ijokeNil) then
				 *   ****'em if they can't take a joke.
				 */
	} HDRR, *pHDRR; 
#define cbHDRR sizeof(HDRR)
#define hdrNil ((pHDRR)0)
#define ijokeNil -1

/* magic number definitions */
#define magicNil	-1
#define magicLpd	0401		/* lpd (UNIX/RT) */
#define magicOverlay	0405		/* overlay */
#define magicImpure	0407		/* impure format */
#define magicReadOnly	0410		/* read-only text */
#define magicSplit	0411		/* separated I&D */
#define magicDemand	0413		/* demand load format */
#define magicSDemand	0415		/* short format,demand load(MegaTest) */

/* language codes as seen in ti.lc and fd.lc */
#define lcAuto		-1	/* used at runtime - never stored in bits */
#define lcC		0
#define lcFortran 	1


/*
 * The FDR and PDR structures speed mapping of address <-> name.
 * They are sorted in ascending memory order and are kept in
 * memory by CDB at runtime.
 */

/* 
 * File Descriptor
 *
 * There is one of these for EVERY FILE, whether compiled with
 * full debugging symbols or not.  The name of a file should be
 * the path name given to the compiler.	 This allows the user
 * to simply specify the names of the directories where the COMPILES
 * were done, and we will be able to find their files.
 * A field whose comment starts with "R - " indicates that it is a
 * runtime field and should be set to 0.
 */

typedef struct FDS {
	ADRT	adr;		/* memory address of beginning of file */
	int4	iss;		/* file name (of source, if known) */
	int4	issShort;	/* base file name of source */
	int4	isym;		/* beginning of symbols */
	int4	iline;		/* file's line symbols */
	int2	ipd;		/* start of procedures for this file */
	int2	ilnMac; 	/* R - number of text lines in file */
	uint4	*rgLn;		/* R - the line pointer array (if any) */
	bits	fWarned : 1;	/* R - they were warned about age problems */
	bits	fEdited : 1;	/* R - edited during debug session */
	bits	fNoSource : 1;	/* R - we couldn't find the source file */
	bits	lc : 2;		/* language code for this file */
	bits	reserved : 11;	/* reserved for future TES use */
	} FDR, *pFDR;
#define cbFDR sizeof(FDR)
#define fdNil ((pFDR)0)

#define ifdNil -1
#define ifdTemp 0	/* element 0 of rgFd is ALWAYS reserved for runtime */
#define ilnNil -1


/* 
 * Procedure Descriptor
 *
 * There is one of these for EVERY TEXT LABEL.
 * If a procedure is in a file with full symbols, then isym
 * will point to the PROC symbols, else it will point to the
 * global symbol for the label.
 */

typedef struct PDS {
	ADRT	adr;		/* memory address of beginning of proc */
	int4	isym;		/* beginning of symbols */
	int4	iline;		/* proc's line symbols */
	uint4	maskReg;	/* saved copy of saved register mask */
	ADRT	dadrRegBase;	/* delta base address of saved registers */
	} PDR, *pPDR;
#define cbPDR sizeof(PDR)
#define pdNil ((pPDR)0)
#define ipdNil	-1


/*
 * Line Numbers
 *
 * Line Numbers are segregated from the normal symbols because they
 * are [1] smaller (4 bytes vs 12) , [2] are of no interest to your
 * average loader, and [3] are never needed in the middle of normal
 * scanning and therefore slow things down.
 *
 * By definition, the first LINER for any given procedure will have
 * a delta address (dadr) of 0.  This conveniently allows deduction
 * of start-of-proc when building the PDR array.
 */

typedef struct LINES {
	uint2	iln;	/* line number, file relative, starting at 1 */
	uint2	dadr;	/* delta address from start of procedure */
	} LINER, *pLINER;
#define lineNil ((pLINER)0)
#define cbLINER sizeof(LINER)
#define ilineNil	-1L


/* The following are value definitions for the fields in the SYMR */

/*
 * Storage Classes
 */

#define scNil		0
#define scText		1	/* text symbol */
#define scData		2	/* initialized data symbol */
#define scBss		3	/* un-initialized data symbol */
#define scRegister	4	/* value of symbol is register number */
#define scAbs		5	/* value of symbol is absolute */
#define scUndefined	6	/* who knows? */
#define scCdbLocal	7	/* variable's value is IN se->va.?? */
#define scBits		8	/* this is a bit field */
#define scCdbSystem	9	/* variable's value is IN CDB's address space */
#define scRegImage	10	/* register value saved on stack */
#define scInfo		11	/* symbol contains debugger information */
#define scUserStruct	12	/* address in struct user for current process */
#define scFloatRegister	13	/* value of symbol is float register number */
#define scMax		32


/*
 *   Symbol Types
 */

#define stNil		0	/* Nuthin' special */
#define stGlobal	1	/* external symbol */
#define stStatic	2	/* static */
#define stParam		3	/* procedure argument */
#define stLocal		4	/* local variable */
#define stLabel		5	/* label */
#define stProc		6	/*     "      "	 Procedure */
#define stBlock		7	/* beginnning of block */
#define stEnd		8	/* end (of anything) */
#define stMember	9	/* member (of anything	- struct/union/enum */
#define stTypedef	10	/* type definition */
#define stFile		11	/* file name */
#define stRegReloc	12	/* register relocation */
#define stForward	13	/* forwarding address */
#define stCommon	14	/* Fortran common block */
    /* Psuedo-symbols - internal to debugger */
#define stStr		60	/* string */
#define stNumber	61	/* pure number (ie. 4 NOR 2+2) */
#define stExpr		62	/* 2+2 vs. 4 */
#define stType		63	/* post-coersion SER */
#define stMax		64


/*
 * The Symbol Structure
 */

typedef struct SYMS {
	int4	iss;		/* index into String Space of name */
	int4	value;		/* value of symbol */
	bits	st : 6;		/* symbol type */
	bits	sc  : 5;	/* storage class - text, data, etc */
	bits	index : 21;	/* index into sym/aux table */
	} SYMR, *pSYMR;
#define symNil ((pSYMR)0)
#define cbSYMR sizeof(SYMR)
#define isymNil 0L
#define issNil 0L


/* A U X I L L A R Y   T Y P E	 I N F O R M A T I O N */

/* definitions for fields in TIR */

/* type qualifiers for ti.tq0 -> ti.(itqMax-1) */
#define tqNil	0	/* bt is what you see */
#define tqPtr	1	/* pointer */
#define tqProc	2	/* procedure */
#define tqArray 3	/* duh */
#define tqRef	4	/* indicates Fortran REF param (ANSI C & C++, too) */
#define tqMax	8

/* basic types as seen in ti.bt */
#define btNil		0	/* undefined */
#define btAdr		1	/* address - integer same size as pointer */
#define btChar		2	/* character */
#define btUChar		3	/* unsigned character */
#define btShort		4	/* short */
#define btUShort	5	/* unsigned short */
#define btInt		6	/* int */
#define btUInt		7	/* unsigned int */
#define btLong		8	/* long */
#define btULong		9	/* unsigned long */
#define btFloat		10	/* float (real) */
#define btDouble	11	/* Double (real) */
#define btStruct	12	/* Structure (Record) */
#define btUnion		13	/* Union (variant) */
#define btEnum		14	/* Enumerated */
#define btTypedef	15	/* defined via a typedef, isymRef points */
#define btLongLong	16	/* E.g. ELXSI 64 bit integers */
#define btULongLong	17	/* E.g. ELXSI 64 bit integers */
#define	btSet		18	/* pascal type set */
#define	btRange		19	/* pascal type range */
#define btComplex	20	/* f77 type complex */
#define btLogical	21	/* f77 type logical */
#define btSubRange	22	/* defined on something of type btRange */
#define btVoid		23	/* void type */
#define btComplex16	24	/* f77 type complex */
#define btLog1		25	/* f77 type logical */
#define btLog2		26	/* f77 type logical */
#define btLog4		27	/* f77 type logical */
#define btInt1		28	/* f77 type logical */
#define btMax		64

/*
 * Type Information Record
 */

typedef struct {
	bits	reserved : 4;	/* reserved by Third Eye for future use */
	bits	continued : 1;  /* indicates additional info in next AUX */
	bits	lc  : 2;	/* language code */
	bits	bt  : 6;	/* basic type */
	bits	tq5 : 3;
	/* ---- 16 bit boundary ---- */
	bits	fConstant : 1; /* value IS value, not address */
	bits	tq0 : 3;
	bits	tq1 : 3;	/* type qualifiers - tqPtr, etc. */
	bits	tq2 : 3;
	bits	tq3 : 3;
	bits	tq4 : 3;
	} TIR, *pTIR;
#define cbTIR sizeof(TIR)
#define tiNil ((pTIR)0)
#define itqMax 6


typedef struct RNGS {	/* a range */
	int4	iaux;	/* aux of senior scalar */
	int4	dnLow;	/* lowest legal value */
	int4	dnHigh;	/* highest legal value */
	} RNGR, *pRNGR;
#define cbRNGR sizeof(RNGR)
#define rngNil ((pRNGR)0)

#define idimMax 4	/* maximum number of dimesions */

/*
 * Auxillary information occurs only if needed.
 * It ALWAYS occurs in this order when present.
 *
 *	    isymMac		used by stProc only
 *	    TIR			type info
 *	    TIR			additional TQ info (if first TIR was not enough)
 *	    isymRef		if (bt == btStruct/etc.) OR (bt == btTypedef)
 *	    RNGR		RNGR's are used to describe the array dimensions
 *	    ...			There are as many as there are "tqArray"s in TIR
 *	    RNGR		up to idimMax
 *	    width in bits	if (bit field), width in bits.
 */
#define cAuxMax (4 + idimMax*3)

/* a union of all possible info in the AUX universe */
typedef union {
	TIR	ti;
	int4	isym;
	int4	iss;
	int4	width;
	int4	iaux;
	int4	dn;
	} AUXU, *pAUXU;
#define cbAUXU sizeof(AUXU)
#define auxNil ((pAUXU)0)
#define iauxNil	0L


/* Type Def structure */
typedef struct TDS {
	int4	iss;	/* name of typedef */
	int4	isym;	/* location of type information */
	} TDR, *pTDR;
#define cbTDR	sizeof(TDR)
#define tdNil ((pTDR)0)

/*
 * The following table defines the meaning of each SYM field as
 * a function of the "st". (scD/B == scData OR scBss)
 *
 * Note: the value "isymMac" is used by symbols that have the concept
 * of enclosing a block of related information.	 This value is the
 * isym of the first symbol AFTER the End associated with the primary
 * symbol. For example if a procedure was at isym==90 and had an
 * isymMac==155, the associated end would be at isym==154, and the
 * symbol at 155 would probably (although not necessarily) be the
 * symbol for the next procedure or file.  This allows rapid skipping over
 * internal information of various sorts. "stEnd"s ALWAYS have the
 * isym of the primary symbol that started the block.
 * 

ST		SC	VALUE		INDEX
--------	------	--------	------
stFile		scText	address		isymMac
stLabel		scText	address		---
stGlobal	scD/B	address		iaux
stStatic	scD/B	address		iaux
stParam		scAbs	offset		iaux
stLocal		scAbs	offset		iaux
stProc		scText	address		iaux	(isymMac is first AUX)

stMember	scNil	ordinal		---	(if member of enum)
stMember	scNil	byte offset	iaux	(if member of struct/union)
stMember	scBits	bit offset	iaux	(bit field spec)

stBlock		scText	address		isymMac (text block)
stBlock		scNil	cb		isymMac (struct/union member define)
stBlock		scNil	cMembers	isymMac (enum member define)

stEnd		scText	address		isymStart
stEnd		scNil	-------		isymStart (struct/union/enum)

stTypedef	scNil	-------		iaux
stRegReloc	sc???	value		old register number
stForward	sc???	new address	isym to original symbol

 *
 */
