/* $Header: tk.c,v 5.14 86/05/28 08:04:42 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include <ctype.h>
#include "cdb.h"

#define cbNumMax 40
#define	chTab	'\t'
#define	chSpace	' '
#define chUnder	'_'
#define chDollar '$'
#define	chBackSlash '\\'
#define FOctal(ch) ((ch >= '0') && (ch <= '7'))

export int2	vcbTok, vcbPeek;
export TKE	vtk, vtkPeek;
export char	vsbTok[100], vsbTokPeek[100];

typedef struct {	/* keyword */
	SBT	sbKey;
	int2	tk;
	} KWR, *pKWR;
#define cbKWR	sizeof(KWR)
#define kwNil ((pKWR)0)

KWR vrgKwCdb[] = {
	"$in",	tkInside,
	"$arg",	tkArg,
	};
#define ikwCdbMax (sizeof(vrgKwCdb)/cbKWR)

KWR vrgKwC[] = {
	"sizeof",	tkSizeof,
	"unsigned",	tkUnsigned,
	"char",		tkChar,
	"short",	tkShort,
	"int",		tkInt,
	"long",		tkLong,
	"float",	tkFloat,
	"double",	tkDouble,
	"struct",	tkStruct,
	"union",	tkUnion,
	"enum",		tkEnum,
	};
#define ikwCMax (sizeof(vrgKwC)/cbKWR)

KWR vrgKwFor[] = {
	".NE.",	tkNotEqual,
	".EQ.",	tkEqual,
	".LT.",	tkLT,
	".LE.",	tkLE,
	".GT.",	tkGT,
	".GE.",	tkGE,
	".OR.", tkLOR,
	".AND.", tkLAND,
	".NOT.", tkBang,
	".TRUE.", tkNumber,
	".FALSE.", tkNumber,
	"integer",	tkInt,
	"character",	tkChar,
	"real",		tkFloat,
	"complex",	tkComplex,
	"logical",	tkLogical,
	};
#define ikwForMax (sizeof(vrgKwFor)/cbKWR)

/* leave isodigit as a routine so we can icrement arguments */

export int isodigit (ch)
char ch;
{
    return (isdigit(ch) && (ch!='8') && (ch!='9'));
} /* isodigit */


/* S E A R C H   T D */

export void SearchTd(ptk, sb)
TKE	*ptk;
SBT	sb;
{
    pTDR	td;
    int		i;

    if (! vfTypedefs)
	return;

    for (i = 0, td = v->rgTd; i < v->hdr.itdMax; i++, td++) {
	if (strcmp(sb, SbFIss(td->iss)) == 0) {
	    SeFSym(&yylval, SymFIsym(td->isym), true);
	    *ptk = tkTypedef;
	    return;
	} /* if */
    } /* for */
} /* SearchTd */


/* S E A R C H   K W */

export void SearchKw(ptk, sbKey, rgKw, ikwMax)
TKE	*ptk;
SBT	sbKey;
pKWR	rgKw;
int2	ikwMax;
{
    int		i;

    for (i=0; i < ikwMax; i++) {
	if (FSbCmp(sbKey, rgKw[i].sbKey)) {
	    *ptk = rgKw[i].tk;
	    return;
	} /* if */
    } /* for */
} /* SearchKw */


/* C H   F   E S C A P E */

export char ChFEscape(psbIn, fEatBackSlash)
SBT	*psbIn;
FLAGT	fEatBackSlash;
{
    int		i, intval;
    char	ch;

    ch = **psbIn;
    (*psbIn)++;
    if (fEatBackSlash) {
	if (ch != chBackSlash)
	    return(ch);	/* vanilla flavored char */
	ch = **psbIn;
	(*psbIn)++;
    } /* if */

    switch (ch) {
	case 'b':	return('\b');
	case 'f':	return('\f');
	case 'n':	return('\n');
	case 'r':	return('\r');
	case 't':	return('\t');

	case '0': case '1': case '2': case '3':
	case '4': case '5': case '6': case '7':
	    /* it is an arbitrary 1-3 octal digit thingie */
	    intval = 0;
	    for (i=0; i<3; i++) {
		intval = (intval * 8) + (ch - '0');
		ch = **psbIn;	/* look at NEXT character */
		if (!FOctal(ch))
		    break;
		(*psbIn)++;	/* is good digit, advance str pointer */
	    } /* for */
	    return(intval);
    } /* switch */
    return(ch);	/* by default we just ignore the backslash */
} /* ChFEscape */


/* T K   F   S T R */

export TKE TkFStr(psbCmd, sbTok, pcb, fIgnoreErrors)
SBT	*psbCmd, sbTok;
int2	*pcb;
FLAGT	fIgnoreErrors;
{
    int		i, cbMax;
    FLAGT	fFloat;
    char	ch, sbTemp[100], sbNum[300];
    SBT		sbCmd, sbStart, sbNumT;
    TKE		tk;

    /* given a string, copy first token to safe place and advance string */

    cbMax = *pcb;
    sbCmd = *psbCmd;
    if (sbCmd == sbNil)
	return(tkNil);

    while ((*sbCmd == chTab) OR (*sbCmd == chSpace))
	sbCmd++;	/* eat leading tabs and spaces */

    if (*sbCmd == chNull) {
	*pcb = 0;
	sbTok[0] = chNull;
	return(tkNil);
    } /* if */

    sbStart = sbCmd; /* remember where we started */

    tk = tkNil;
    ch = *sbCmd++;
    if (isalpha(ch)
	OR (ch == chUnder)
	OR (ch == chDollar)) {  /* string (var|command) token */
	tk = tkStr;
	while (isalnum(*sbCmd)
	       OR (*sbCmd == chUnder) 
	       OR (*sbCmd == chDollar))
	    sbCmd++;
    } else if ( isdigit(ch) OR ((ch == '.') AND (isdigit(*sbCmd))) ) {
	/* number */
	tk = tkNumber;
	sbNumT = sbNum;

	if ((ch == '0') && (*sbCmd != '.')) {

	    /* hex or octal */
	    if (*sbCmd == 'x') {
		/* it's a hex number */
	        sbCmd++;
	        while (isxdigit(*sbNumT++ = *sbCmd))
		    sbCmd++;
		*--sbNumT = '\0';
		if ((sbNumT - sbNum) >= cbNumMax)
		    UError("Hex constant has too many characters(> %d).",
				cbNumMax);
		sscanf (sbNum, "%lx", &yylval.val.valLong);
	    } else {
		/* it's octal */
		*sbNumT++ = ch;	/* get 0 so if it really is 0 we get a num */
	        while (isodigit(*sbNumT++ = *sbCmd))
		    sbCmd++;
		*--sbNumT = '\0';
		if ((sbNumT - sbNum) >= cbNumMax)
		    UError("Octal constant has too many characters(> %d).",
				cbNumMax);
		sscanf (sbNum, "%lo", &yylval.val.valLong);
	    } /* if octal or hex */

	} else { /* it's either an integer or float */

	    fFloat = (ch == '.'); /* of the form ".123" */
	    *sbNumT++ = ch;	/* save first digit OR '.' */
	    /* pick up digit string */
	    while (isdigit(*sbNumT++ = *sbCmd))
		sbCmd++;

	    if (*sbCmd == '.') {
		/* a float of the form "123.456" */
		*sbCmd++;	/* increment past the '.' */
		/* and the fractional part */
		while (isdigit(*sbNumT++ = *sbCmd))
		    sbCmd++;
		fFloat = true;
	    } /* if */

	    if ( ((*sbCmd == 'e') OR (*sbCmd == 'E'))
	       AND (isdigit(sbCmd[1])
		  OR (sbCmd[1] == '+')
		  OR (sbCmd[1] == '-')) ) {
		/* a float of the form "xxx.xxxeYY" OR "xxxEYYY" */
		*sbCmd++;	/* increment past the 'e' */
		if ((*sbCmd == '-') OR (*sbCmd == '+'))
		    *sbNumT++ = *sbCmd++; /* pick up the sign */
		/* and the fractional part */
		while (isdigit(*sbNumT++ = *sbCmd))
		    sbCmd++;
		fFloat = true;
	    } /* if */

	    *--sbNumT = '\0';
	    if ((sbNumT - sbNum) >= cbNumMax)
		UError("Numeric constant has too many characters(> %d).",
			    cbNumMax);

	    if (fFloat) { /* its a float */

		if ((sbNumT - sbNum) >= cbNumMax)
		    UError("Float constant has too many characters(> %d).",
				cbNumMax);
		sscanf (sbNum, "%lf", &yylval.val.valDouble);
		CopyTy(&yylval, vseCnDouble);
		tk = tkFltConstant;

	    } else { /* it's a good old regular number */

		if ((sbNumT - sbNum) >= cbNumMax)
		    UError("Integer constant has too many characters(> %d).",
				cbNumMax);
		sscanf (sbNum, "%ld", &yylval.val.valLong);

	    } /* if float or integer */
	} /* if */

	if (tk == tkNumber) {
	    if (*sbCmd == 'L' OR *sbCmd == 'l') { /* they wanted a long */
		sbCmd++;
		CopyTy(&yylval, vseCnLong);
	    } else if ((yylval.val.valLong & 0xffff8000) == 0) {
		yylval.val.valInt = yylval.val.valLong;
		CopyTy(&yylval, vseCnInt);
	    } else {
		CopyTy(&yylval, vseCnLong);
	    } /* if */
	} /* if find out long or short */

	yylval.ti.fConstant = true;

    } else if (! ispunct(ch)) {

	/* it's  <something else> !! */
	tk = tkOther;

    } else {

	/* hopefully an interesting operator or something */
	switch (ch) {
	    case '[':	tk = tkLSB;	break;
	    case ']':	tk = tkRSB;	break;
	    case '(':	tk = tkLP;	break;
	    case ')':	tk = tkRP;	break;
	    case '{':	tk = tkLCB;	break;
	    case '}':	tk = tkRCB;	break;
	    case '?':	tk = tkQuest;	break;
	    case '@':	tk = tkAt;	break;
	    case '$':	tk = tkDollar;	break;
	    case '#':	tk = tkHash;	break;
	    case ';':	tk = tkSemi;	break;
	    case ',':	tk = tkComma;	break;
	    case '~':	tk = tkTilda;	break;
	    case '_':	tk = tkUnderScore; break;
	    case '\\':	tk = tkBackSlash; break;

	    case '\'':	tk = tkCharConstant;
			sbTok[0] = ChFEscape(&sbCmd, true);
			if (!fIgnoreErrors AND (*sbCmd != '\''))
			    UError("Character constant is missing ending '.");
			sbCmd++;
			*pcb = 1;
			goto special;

	    case '"':	tk = tkStrConstant;
			i = 0;
			while ((*sbCmd != chNull) AND (*sbCmd != '"')) {
			    sbTok[i] = ChFEscape(&sbCmd, true);
			    i++;
			   if (i >= cbMax)
			    UError("String literals may not be larger than %d.",
					cbMax);
			} /* while */
			if (!fIgnoreErrors AND (*sbCmd != '"'))
			    UError("String constant is missing ending \".");
			sbCmd++;
			*pcb = i;
	   		goto special;

	    case '.':	tk = tkDot;
			if (v->lc != lcFortran)
			    break;

			/* pick up the Fortrash symbol */
			tk = tkNil;
			sbNumT = sbCmd;
			while (*sbNumT AND (*sbNumT != '.'))
			    sbNumT++;
			i = sbNumT - (sbCmd - 1);
			strncpy(sbTemp, sbCmd-1, i); /* get the whole thing */
			sbTemp[i] = chNull;
			SearchKw(&tk, sbTemp, vrgKwFor, ikwForMax);
			if (tk != tkNil) {
			    /* we have a hit */
			    sbCmd += i - 1;
			} /* if */
			break;

	    case ':':	tk = tkColon;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkAssign;
			} /* if */
			break;

	    case '+':	tk = tkPlus;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkAssPlus;
			} else if (*sbCmd == '+') {
			    sbCmd++;
			    tk = tkPlusPlus;
			} /* if */
			break;

	    case '-':	tk = tkMinus;
			if (*sbCmd == '>') {
			    sbCmd++;
			    tk = tkPtr;
			} else if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkAssMinus;
			} else if (*sbCmd == '-') {
			    sbCmd++;
			    tk = tkMinusMinus;
			} /* if */
			break;

	    case '*':	tk = tkStar;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkAssMult;
			} else if ((v->lc == lcC) AND (*sbCmd == '/')) {
			    sbCmd++;
			    tk = tkEndComment;
			} else if ((v->lc == lcFortran) AND (*sbCmd == '*')) {
			    sbCmd++;
			    tk = tkPower;
			} /* if */
			break;

	    case '/':	tk = tkSlash;
			if (*sbCmd == '/') {
			    sbCmd++;
			    tk = tkDiv;
			    if (*sbCmd == '=') {
				sbCmd++;
				tk = tkAssDiv;
			    } /* if */
			} else if (*sbCmd == '*') {
			    sbCmd++;
			    tk = tkStartComment;
			} /* if */
			break;

	    case '%':	tk = tkModulo;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkAssMod;
			} /* if */
			break;

	    case '&':	tk = tkBitAnd;
			if (*sbCmd == '&') {
			    sbCmd++;
			    tk = tkLAND;
			} else if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkAssBAND;
			} /* if */
			break;

	    case '|':	tk = tkBitOr;
			if (*sbCmd == '|') {
			    sbCmd++;
			    tk = tkLOR;
			} else if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkAssBOR;
			} /* if */
			break;

	    case '^':	tk = tkXOR;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkAssXOR;
			} /* if */
			break;

	    case '!':	tk = tkBang;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkNotEqual;
			} /* if */
			break;

	    case '=':	tk = tkAssign;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkEqual;
			} /* if */
			break;

	    case '<':	tk = tkLT;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkLE;
			} else if (*sbCmd =='<') {
			    sbCmd++;
			    tk = tkLShift;
			    if (*sbCmd == '=') {
				sbCmd++;
				tk = tkAssLeft;
			    } /* if */
			} else if (*sbCmd == '>') {
			    sbCmd++;
			    tk = tkNotEqual;
			} /* if */
			break;

	    case '>':	tk = tkGT;
			if (*sbCmd == '=') {
			    sbCmd++;
			    tk = tkGE;
			} else if (*sbCmd == '>') {
			    sbCmd++;
			    tk = tkRShift;
			    if (*sbCmd == '=') {
				sbCmd++;
				tk = tkAssRight;
			    } /* if */
			} /* if */
			break;
	} /* switch */
    } /* if */

    *pcb = sbCmd - sbStart;
    if (*pcb >= cbMax)
	UError("Token is too large.  May not exceed %d characters.", cbMax);
    strncpy(sbTok, sbStart, *pcb);

special:	/* used by character and string constant routines */
    sbTok[*pcb] = chNull;
    *psbCmd = sbCmd;

    if (tk == tkStr) {
	/* typedefs override commands */
	SearchTd(&tk, sbTok);
	if (tk != tkStr)
	    return(tk);

	/* commands override language keywords */
	SearchKw(&tk, sbTok, vrgKwCdb, ikwCdbMax);
	if (tk != tkStr)
	    return(tk);

	switch (v->lc) {
	    default:
	    case lcC:	     SearchKw(&tk, sbTok, vrgKwC, ikwCMax); break;
	    case lcFortran:  SearchKw(&tk, sbTok, vrgKwFor, ikwForMax); break;
	} /* switch */
    } /* if */
    return(tk);
} /* TkFStr */


/* T K   P E E K */

export TKE TkPeek()
{
    char	*sbCmd;

    /* used to peek at next token in global command line */
    sbCmd = v->sbCmd;
    vcbPeek = sizeof(vsbTokPeek);
    vtkPeek = TkFStr(&sbCmd, vsbTokPeek, &vcbPeek, true);
    return(vtkPeek);
} /* TkPeek */


/* T K   N E X T */

export TKE TkNext()
{
    /* used by most routines to eat next token in the global command line */

    vcbTok = sizeof(vsbTok);
    vtk = TkFStr(&v->sbCmd, vsbTok, &vcbTok, false);
    return(vtk);
} /* TkNext */
