/* $Header$ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include <signal.h>
#include <errno.h>

#include "cdb.h"

export int2	viprMax = 1;	/* we only allow room for one process */
export FLAGT	vfAttach = true;


/* P P I D   F   P I D */

export PpidFPid(pid)
int	pid;
{
    int		ppid;

    ppid = Ptrace(ptPpid, pid, 0, 0);
    if (ppid == -1)
	UError("Attempting to find parent of %d: %s.", pid, SbFError(errno));
    return(ppid);
} /* PpidFPid */


/* S B   E X E C   F   P I D */

export SBT SbExecFPid(pid)
int	pid;
{
    static char	sbCmd[257];

    Ptrace(ptCmdName, pid, sbCmd, 0);
    return(sbCmd);
} /* SbExecFPid */


/* F R E E   P R O C E S S */

export void FreeProcess(pr)
pPRR	pr;
{
    if (pr == prNil)
	return;

    SetGlobalPr(pr);

    RemoveAllBp(true);
    Ptrace(ptReleaseChild, pr->pid, (char *) 1, 0);
    if (pr->pidParent != vpidCdb) {
	DeallocPr(pr, false);
    } else {
	pr->pid = pidNil;
	pr->ps = psNoChild;
    } /* if */

    SetGlobalPr(prNil);
} /* FreeProcess */


/* C O P Y   P R */

export void CopyPr(pr1, pr2)
pPRR	pr1, pr2;
{
    int2	cb;

    /* Make pr1 identical to pr2 */

    *pr1 = *pr2;	/* this gets all of the normal fields */

    /* KLUDGE - need to create CopyOs, CopyCpu */

    /* KLUDGE - need to check ALL fields and make our own copies
     * so that DeallocPr is free to throw everything away.
     */
    
    pr1->fForkedProcess = true;

    /* setup tables */
    cb = pr1->ibpMax * cbBPR;	/* breakpoints */
    pr1->rgBp = (pBPR) malloc(cb);
    MoveBytes(pr1->rgBp, pr2->rgBp, cb);

    cb = pr1->ilvMax * cbSER;	/* local variables */
    pr1->rgLv = (pSER) malloc(cb);
    MoveBytes(pr1->rgLv, pr2->rgLv, cb);

    cb = pr1->iadMax * cbADR;	/* assertions */
    pr1->rgAd = (pADR) malloc(cb);
    MoveBytes(pr1->rgAd, pr2->rgAd, cb);

    pr1->seDot = (pSER)malloc(cbSER);
    pr1->sbArgsChild = SbFAlloc(pr2->sbArgsChild);
} /* CopyPr */


/* P R   F O R K */

export pPRR PrFFork(pidChild, fAttached)
int2	pidChild;
FLAGT	fAttached;
{
    int		pidParent;
    SBT		sbExec;
    pPRR	pr, prParent;

    /* A new child has come into the world.
     * Register it with the draft board.
     */

    /* First we have to find out who the parent is */
    pidParent = PpidFPid(pidChild);
    prParent = PrFPid(pidParent);

    if (fAttached AND (prParent != prNil)) {
	/* We know the family, but the kid has been
	 * away from home for a long time.
	 * Check his id at the door */
	sbExec = SbExecFPid(pidChild);
	if (! FSbCmp(sbExec, prParent->sbExec))
	    prParent = prNil;
    } /* if */

    if (prParent == prNil) {

	/* A stranger in a strange land */
	pr = PrFInitPr( SbExecFPid(pidChild) );

    } else {

	/* A friend of the family */
	pr = PrFAlloc();
	CopyPr(pr, prParent);

	if (pr->fRemoveBpsOnFork) {
	    SetGlobalPr(pr);
	    RemoveAllBp(true);
	    SetGlobalPr(prNil);
	} /* if */

	pr->fnComm = pr->fnCdb = pr->fnExec = pr->fnCore = fnNil;

    } /* if */

    pr->pid = pidChild;
    pr->pidParent = pidParent;
    pr->ps = psFork;
    if (vfNotify) {
	printf("New process\n");
	ListPr(pr);
    } /* if */

    ++vcActive;		/* count of Active proceesses */
    return(pr);
} /* PrFFork */


/* P R   F   A T T A C H   P R O C E S S */

export pPRR PrFAttachProcess(pid)
int2	pid;
{
    int		ret;
    SBT		sb;
    pPRR	pr, prSave;

    ret = Ptrace(ptMultiChild, pid, 0, 0);	/* make him ours */
    if (ret == -1)
	UError("Unable to attach to process %d: %s.", pid, SbFError(errno));

    /* Chicken and Egg problem: We can't call Waiter, because we
     * don't have a process record because we don't have the process
     * name because we haven't waited on the process yet.
     * Sooooooo, we send SIGINT, wait a couple of seconds and
     * hope that the process has stopped.
     */
    kill(pid, SIGINT);
    sleep(2);

    pr = PrFFork(pid, true);
    pr->ps = psStopped;

    prSave = v;
    SetGlobalPr(pr);
    ReadPc();
    SetCntx();
    SetViewPosition(pr->acntx.pc);
    v->pgrpSave = getpgrp(pid);
    /* setpgrp(pid, getpgrp(0)); /* make him the same process group as us */
    return(pr);
} /* PrFAttachProcess */


/* P R   F   E X E C */

export pPRR PrFExec(pr)
pPRR	pr;
{
    extern char * gets();
    int2	pidParent, pidChild = pr->pid;
    char	*sbExec, sbBuf[200];
    FLAGT	fStopOnExec;		/* stop immediately after exec */
    FLAGT	fStopOnFork;		/* stop BOTH process after fork */
    FLAGT	fRemoveBpsOnFork;	/* child does NOT get parent's BPs */
    FLAGT	fDebugChildren;		/* indicates we WANT the kids */
    pSER	rgLv;
    FLAGT	fDoingSingle;
    
    pidParent = pr->pidParent;	/* Remember Mom */

    sbExec = SbExecFPid(pr->pid);	/* Find out who we are */
    if (sbExec == sbNil) {
	printf("Unable to determine name of program for process #%d\n",
	    pidChild);
	printf("Please type name of executable: ");
	sbExec = gets(sbBuf);
	if ((sbExec == sbNil) OR (*sbExec == chNull)) {
	    Ptrace(ptReleaseChild, pidChild, (char *) 1, 0);
	    UError("Aborting debugging of process #%d.", pidChild);
	} /* if */
    } /* if */

    fStopOnExec = pr->fStopOnExec;
    fStopOnFork = pr->fStopOnFork;
    fRemoveBpsOnFork = pr->fRemoveBpsOnFork;
    fDebugChildren = pr->fDebugChildren;
    fDoingSingle = pr->fDoingSingle;
    rgLv = pr->rgLv;

    DeallocPr(pr, true);		/* kill old identity */

#if 0
    pr = PrFAlloc();		/* a clean slate */
    pr->sbExec = SbFAlloc(sbExec);	/* our new name */
    pr->sbCore = sbNil;
    pr->isymCacheMax = 0;
    InitPr(pr);
#endif
    pr = PrFInitPr(sbExec);
    pr->pid = pidChild;
    pr->pidParent = pidParent;

    pr->fStopOnExec = fStopOnExec;
    pr->fStopOnFork = fStopOnFork;
    pr->fRemoveBpsOnFork = fRemoveBpsOnFork;
    pr->fDebugChildren = fDebugChildren;
    pr->fDoingSingle = fDoingSingle;
    pr->rgLv = rgLv;
    pr->ps = psRunning;

    SetGlobalPr(pr);
    ReadPc();
    SetCntx();
#if 0
    SetGlobalPr(prNil);
#endif 0

    if (vfNotify) {
	printf("Process exec'ed\n");
	ListPr(pr);
    } /* if */
    return(pr);
} /* PrFExec */

#ifdef BILLB
int DeadChild, InGetchar;

/*
	This routine catches the child died signal and sets a flag to 
	that effect. If there is potential that the process is about
	to enter getchar after checking the DeadChild flag then an alarm 
	is started to prevent the hang.
*/
CatchChildSig()
{
	signal(SIGCLD,CatchChildSig);
	DeadChild++;
	if (InGetchar) alarm(1);
}
#endif BILLB





/* W A I T E R */

export void Waiter(wt, pid)
int2	wt, pid;
{
    extern char * gets();
    extern char * MouseGets();
    int		status;
    int2	waitReturn;
    SBT		sb;

    /* Wait for something to happen in a
     * SINGLE PROCESS environment
     */

    while (1) {
	switch (wt) {
	    case wtTty:
	    case wtAnything:
		vsbGet[0] = vsbGet[1] = vsbGet[2] = vsbGet[3] = chNull;
		vsbGet = gets(vsbGet);
		return;
		/* NOTREACHED */
		break;

	    case wtProcess:
		if (v->ps == psStopped)
		    return;	/* process is already stopped and analyzed */
		/* else fall through */

	    case wtAnyProcess:
		pid = v->pid;
		v->fQuiet = false;

		signal(SIGINT, SIG_IGN);	/* ignore INT */

		waitReturn = Wait(&status);

		if (v->fStty)
		    SetMyTty();
		signal(SIGINT, Fixer);	/* reconnect to the Fixer routine */
		v->sig = 0;	/* for safety reasons */

		if (waitReturn == -1) {
		    if (errno == EINTR) {
			printf("PANIC! received signal: %d (%s).\n",
			    status>>8, SbFSignal(status>>8));
			/* what do we do here?? */
			exit(1);
		    } else {	/* some sort of error occurred */
			perror(vsbDebugName);
			exit(1);
		    } /* if */
		} /* if */

		v->status = status;
		AnalyzeStop();
		if (v->ps == psContinue) {
		    RunProcess(ptResume, psRunning, false);
		    break;
		} else if (v->ps == psRunning) {
		    continue;
		} else {
		    return; /* either a normal bp OR a signal of some sort */
		} /* if */
	} /*switch */
    } /* while */
} /* Waiter */
