/* $Header: xptrace.c,v 6.1 86/08/05 17:46:51 peter Exp $ */
/* (C) Copyright 1984 by Third Eye Software, Inc. - All Rights Reserved */

#include <errno.h>
#include <sgtty.h>
#include <signal.h>
#include <syscall.h>
#include <sys/time.h>

#include "cdb.h"
#include "xptrace.h"

extern FILE *fdopen();
extern void Transmit();

int	vfnTx, vfnRx;
int	vlevelSave = 0;
FLAGT	vfTest = false;
FLAGT	vfExecKludge = false;

int	vsignal, vpidServer;
char	vsbRemoteDevice[100];	/* name of device connected to remote */

char	_sbRx[cbMsgMax];	/* buffer for received messages */
SBT	vsbRx;		/* points to next character in receive buffer */
#define cbRx sizeof(_sbRx)
char	vsbTxLast[cbMsgMax]; /* copy of last transmisson */
int	vpidLast;	/* pid of last process we received message from */



/* V A L   F   P S B   */

long ValFPsb(psb)
SBT	*psb;
{
    int		x = 0;
    char	ch, *sb = *psb;

    /* this routine eats a hex number from a string and advances
     * the string pointer to the next character AFTER the first
     * non-hex character.  E.g if we start with "1234|abcd",
     * we will return the integer value 0x1234 and leave the string
     * pointing to the 'a'.
     */

#define FHex(ch) (((ch >='0') AND (ch <= '9')) OR ((ch >= 'a') AND (ch <= 'f')))

    if ((sb == sbNil) OR (*sb == chNull))
	return(0);

    while (true) {
	ch = *sb++;
	if (! FHex(ch))
	    break;
	x = (x * 16) + ((ch <= '9') ? (ch - '0') : ((ch - 'a') + 10));
    } /* while */
    *psb = sb;
    return(x);
} /* ValFPsb */


/* S B   F   T X   M S G */

local void SbFTxMsg(sbTx)
SBT	sbTx;
{
    int		pid, msg, pt, value, count;
    long	adr, adr2;
    char	*sb, sbName[cbMsgMax], sbArgs[cbMsgMax];

    printf("TxHost: %s", sbTx);

    if (v->fCommDebug AND (v->debuglevel >= 100)) {
	sb = sbTx;
	msg = ValFPsb(&sb);	/* get message number */
	pid = ValFPsb(&sb);	/* get process id */

	switch (msg) {
	    default:
		printf("msg = %d, pid = %d\n", msg, pid);
		break;

	    case msgPtrace:
		pt = ValFPsb(&sb);
		adr = ValFPsb(&sb);
		value = ValFPsb(&sb);

		switch (pt) {
		    default:    printf("Unknown Ptrace request: %d", pt);
				break;

		    case  ptReadI:	printf("Read Text");	break;
		    case  ptReadD:	printf("Read Data");	break;
		    case  ptWriteI:	printf("Write Text");	break;
		    case  ptWriteD:	printf("Write Data");	break;
		    case  ptReadUser:	printf("Read User");	break;
		    case  ptWriteUser:	printf("Write User");	break;
		    case  ptSingle:	printf("Single Step");	break;
		    case  ptResume:	printf("****** Resume ******");	break;
		    case  ptTerm:	printf("Terminate");	break;
		} /* switch */
		printf("	pid: %d	adr: %#x	value: %d (%#x)\n",
			    pid, adr, value, value);
		break;

	    case msgWait:
		    printf("******* Waiting for process %d ********\n", pid);
		    break;

	    case msgExec:
		sscanf(sb, "%[^|]|%[^\n]", sbName, sbArgs);
		printf("Exec pid %d as %s with args \"%s\"\n",	
			pid, sbName, sbArgs);
		break;

	    case msgInput:
		printf("Input from host: \"%s\"", sb);
		break;

	    case msgRtoH:
		adr = ValFPsb(&sb);
		count = ValFPsb(&sb);
		printf("Remote to Host: pid: %d	from: %#x  count %d\n",
				adr, count);
		break;

	    case msgHtoR:
		adr = ValFPsb(&sb);
		count = ValFPsb(&sb);
		printf("Host to Remote: pid: %d	start at: %#x  count %d\n",
				adr, count);
		break;

	    case msgMove:
		adr = ValFPsb(&sb);
		adr2 = ValFPsb(&sb);
		count = ValFPsb(&sb);
		printf("Block Move: pid: %d  dest: %#x  src: %#x, count %d\n",
				adr, adr2, count);
		break;

	} /* switch */
    } /*  if */
} /* SbFTxMsg */


/* R E A D   S B */

export int ReadSb(fn, sb, cb, sbMatch)
int	fn, cb;
FAST SBT	sb;
SBT	sbMatch;
{
    FAST int	i, ret;
    int		cbMatch;
    char	ch;

    cbMatch = (sbMatch == sbNil) ? cb+1 : strlen(sbMatch);
    i = 0;
    while (--cb > 0) {
	ret = read(fn, &ch, 1);
	*sb++ = ch;
	i++;
	if (ret == 0)
	    return(0);
	if (ret < 0)
	    SysPanic("Read from Remote on %d.", fn);
	if (ch == '\n')
	    break;
	if ((i >= cbMatch)
	   AND (ch == sbMatch[cbMatch-1])) {
	    *sb = chNull;
	    if (FTailCmp(sbMatch, sb))
		return(i);
	} /* if */
    } /* while */
    *sb = chNull;
    return(i);
} /* ReadSb */


/* S E T   R E M O T E   L E V E L */

local void SetRemoteLevel(level)
int	level;
{
    char	sbBuf[100];

    sprintf(sbBuf, "%x|%x|%x\n", msgLevel, v->pid, level);
    vlevelSave = level;
    Transmit(sbBuf);
    RetFReply();
} /* SetRemoteLevel */


/* T R A N S M I T */

export void Transmit(sbTx)
SBT	sbTx;
{
    int		cbTx, cb;

    /* Transmit the string */
    if (vlevelSave != v->debuglevel)
	SetRemoteLevel(v->debuglevel);

    if (sbTx != vsbTxLast)
	strcpy(vsbTxLast, sbTx);	/* save for re-transmission */
    
    cbTx = strlen(sbTx);

    if (v->fCommDebug)
	SbFTxMsg(sbTx);

    if (v->fnComm <= 2)
	Panic("Transmit - v->fnComm: %d.", v->fnComm);

    vcsRemote = csWriting;
    cb = write((vfTest) ? vfnTx : v->fnComm, sbTx, cbTx);
    vcsRemote = csWriteDone;

    if (cb != cbTx)
	SysPanic("Transmit: %d bytes to go, %d went.", cbTx, cb);
} /* Transmit */


/* R E C E I V E */

export void Receive(fNewPid, sbMatch)
FLAGT	fNewPid;
SBT	sbMatch;
{
    int		cb, cRetry, status, pid;

    cRetry = 0;
    while (true) {
	vsbRx = _sbRx;

	vcsRemote = csReading;
	cb = ReadSb((vfTest) ? vfnRx : v->fnComm, vsbRx, cbRx, sbMatch);
	vcsRemote = csNil;
	if (vfInterruptPending)
	    Fixer();

	if (v->fCommDebug)
	    printf("RxHost: %s", vsbRx);

	status = 0;
	if (sscanf(vsbRx, "%x", &status) != 1)
	    Panic("bad target status %s", _sbRx);
	if ((vsbRx = strchr(vsbRx, chDelim)) == sbNil) /* skip status */
	    Panic("missing separator 1 %s", _sbRx);
	vsbRx++;

	if (sscanf(vsbRx, "%x", &pid) != 1)
	    Panic("bad target pid %s", _sbRx);
	if ((vsbRx = strchr(vsbRx, chDelim)) == sbNil) /* skip process id */
	    Panic("missing separator 2 %s", _sbRx);
	vsbRx++;

	if ((pid != v->pid) AND !fNewPid) {
	    /* This is from a different process than we wanted. */
	    Panic("Wanted data from %d, got it from %d", v->pid, pid);
	} /* if */

	switch (status) {
	    default:
		errno = status;	/* "OK" or error for caller */
		return;

	    case statusNewPid:
		v->pid = pid;	/* KLUDGE - This may not be correct */
		errno = 0;
		return;

	    case statusRetry:
		cRetry++;
		if (cRetry >= cRetryMax)
		    Panic("Excessive retries, Last Transmit was:\n%s\n",
			vsbTxLast);
		Transmit(vsbTxLast);
		break;

	    case statusPrint:
		/* this is output for OUR screen */
		/* we do NOT treat this as a response to our last command */
		printf("<%d> %s", pid, vsbRx);
		break;
	} /* switch */
    } /* while */
} /* Receive */


/* R E T   F   R E P L Y */

local int RetFReply()
{
    int		ret;

    /* Get response from remote.
     * ASSUME that there is a simple numerical reply.
     */

    Receive(false, sbNil);	/* get a string from remote */
    if (sscanf(vsbRx, "%x", &ret) != 1)
	Panic("Bad reply from target: %s", _sbRx);
    return(ret);
} /* RetFReply */


/* P T R A C E */

export int Ptrace(pt, pid, adr, value)
int	pt, pid;
char	*adr;
int	value;
{
    int		ret;
    char	sbPt[100];

    if (v->fnComm == fnNil)
	return( ptrace(pt, pid, adr, value) );

    switch (pt) {
	case ptReadI:
	case ptReadD:
	case ptReadUser:
	    sprintf(sbPt, "%x|%x|%x|%x|%x\n", msgPtrace, pid, pt, adr, value);
	    Transmit(sbPt);	/* send a message to junior */
	    ret = RetFReply();
#ifdef notdef
/* this would be needed in a BINARY protocol */
	    if (v->cpu->byteSex != vcpuHost ->byteSex)
		Translate(&ret, sizeof(ret));
#endif
	    return(ret);
	    break;

	case ptWriteI:
	case ptWriteD:
	case ptWriteUser:
#ifdef notdef
/* this would be needed in a BINARY protocol */
	    if (v->cpu->byteSex != vcpuHost ->byteSex)
		Translate(&value, sizeof(value));
#endif
	    /* and fall through */

	case ptResume:
	case ptTerm:
	case ptSingle:
	    sprintf(sbPt, "%x|%x|%x|%x|%x\n", msgPtrace, pid, pt, adr, value);
	    Transmit(sbPt);	/* send a message to junior */
	    return( RetFReply() );
	    break;

    } /* switch */

    Transmit(sbPt);	/* send a message to junior */
    return( RetFReply() );
} /* Ptrace */


/* S E N D   S I G N A L */

export int SendSignal(sig)
int2	sig;
{
    char	sbPt[100];

    if (v->fnComm == fnNil)
	return(kill(v->pid, sig));

    sprintf(sbPt, "%x|%x|%x\n", msgSignal, v->pid, sig);
    Transmit(sbPt);
    /* we DON'T wait for a reply since this is happening at
     * interrupt level.  The target should stop and return
     * status indictaing reciept of this signal.  This assumes
     * that the target has not stopped all by itself prior
     * to the signal.
     */
} /* SendSignal */


/* W A I T */

export int Wait(pstatus)
int	*pstatus;
{
    int		ret;
    char	sbTemp[20];

    if (v->fnComm == fnNil)
	return(wait(pstatus));

    /* here we do what is necessary to *look like* "wait (2)" */

    if (vfExecKludge) {
	*pstatus = (v->os->sigTrap << 8) + 0x7f;
	vfExecKludge = false;
	return(v->pid);
    } /* if */

    sprintf(sbTemp, "%x|%x\n", msgWait, v->pid);
    Transmit(sbTemp);
    vfInWait = true;
    ret = RetFReply();
    vfInWait = false;

#if 1
    *pstatus = ret;
#else
    switch (vsignal) {
	default:
	    Panic("Unexpected signal: %d", vsignal);

	case SIGTRAP:
	case SIGBUS:
	    *pstatus = (vsignal << 8) + 0x7f;
    } /* switch */
#endif

    return(v->pid);	/* KLUDGE - no good for multi-process remote */
} /* Wait */


/* C R E A T E   T A R G E T */

export void CreateTarget()
{
    int		ret;
    char	sbBuf[200];

    if (v->fnComm == fnNil) {
	OsCreateTarget();	/* cause a NATIVE process to be born */
	return;
    } /* if */

    if (vfTest) {
	close(v->fnExec);
	v->fnExec = fnNil;
    } /* if */

    v->pid = 1;
    sprintf(sbBuf, "%x|%x|%s|%s\n", msgExec, v->pid, v->sbExec, v->sbArgsChild);
    Transmit(sbBuf);

    Receive(true, sbNil);	/* get a string from remote */
    if (sscanf(vsbRx, "%x", &ret) != 1)
	Panic("Bad reply from target: %s", _sbRx);

    vfExecKludge = false;
    if (ret == -1) {
	vfExecKludge = true;
    } else if (ret > 0) {
	dprint(1, ("Bad exec in target.  Remote reports error: %d", ret));
	errno = ret;
    } /* if */
} /* CreateTarget */


/* X   B L O C K   M O V E */

export void XBlockMove(pid, adrDest, adrSrc, cb)
int	pid;
ADRT	adrDest, adrSrc;
int	cb;
{
    /* transfer a block WITHIN the remote machine */
    char	sbBuf[cbMsgMax];

    sprintf(sbBuf, "%x|%x|%x|%x|%x\n", msgMove, v->pid, adrDest, adrSrc, cb);
    Transmit(sbBuf);
    RetFReply();
} /* XBlockMove */


/* X   B L O C K   T R A N S F E R */

export void XBlockTransfer(pid, adrDest, adrSrc, cbIn, fTx)
int	pid;
ADRT	adrDest, adrSrc;
int	cbIn;
FLAGT	fTx;
{
    char	ch1, ch2, sbBuf[cbMsgMax];
    SBT		sbTx, sbRx, sbSrc, sbDest, sbT;
    short	val, cb, cbThisTime, cbSave;
    ADRT	adrDestIn;

    if (fTx) {
	/* write FROM host TO remote */
#ifdef notdef
/* this would be needed in a BINARY protocol */
	if (v->cpu->byteSex != vcpuHost ->byteSex)
	    Translate(adrSrc, cbIn);
#endif
    } else {
	/* read FROM remote TO host */
	adrDestIn = adrDest;
	cbSave = cbIn;
    } /* if */
    sbSrc = (SBT) adrSrc;

    while (cbIn >= 0) {
	int rcb;
	cb = Min(cbIn, (cbMsgMax-24)/2);
	if (fTx) {
	    cbThisTime = cb;
	    cbIn -= cb;
	    /* write FROM host TO remote */
	    sprintf(sbBuf, "%x|%x|%x|%x|", msgHtoR, pid, adrDest, cb);
	    sbTx = sbBuf + strlen(sbBuf);
	    while (cb--) {
		val = (*sbSrc & 0xf0) >> 4;
		*sbTx++ = val + ((val > 9) ? ('a'-10) : '0');
		val = *sbSrc++ & 0x0f;
		*sbTx++ = val + ((val > 9) ? ('a'-10) : '0');
	    } /* while */
	    *sbTx = '\n';
	    Transmit(sbBuf);
	    RetFReply();
	} else {
	    /* read FROM remote TO host */
	    sprintf(sbBuf, "%x|%x|%x|%x\n", msgRtoH, pid, adrSrc, cb);
	    Transmit(sbBuf);
	    Receive(false, sbNil);
	    if (sscanf(vsbRx, "%x", &rcb) != 1)
	    	Panic("bad target byte count %s", _sbRx);
	    if ((vsbRx = strchr(vsbRx, chDelim)) == sbNil) /* skip count */
	        Panic("missing separator 3 %s", _sbRx);
	    vsbRx++;
	    if ( rcb > cb )
		Panic("too many bytes transferred R to H");
	    cbThisTime = rcb;
	    cbIn -= rcb;
	    sbDest = (SBT) adrDest;
	    while (rcb--) {
		ch1 = *vsbRx++;
		ch2 = *vsbRx++;
		val = ((ch1 - ((ch1 > '9') ? ('a'-10) : '0')) << 4)
		    | (ch2 - ((ch2 > '9') ? ('a'-10) : '0'));
		if ((val & ~0x0ff) != 0 )
		    Panic("bad block transfer R to H");
		*sbDest++ = val;
	    } /* while */
	} /* if */
	adrSrc += cbThisTime;
	adrDest += cbThisTime;
    } /* while */

#ifdef notdef
/* this would be needed in a BINARY protocol */
    if ((!fTx) AND (v->cpu->byteSex != vcpuHost ->byteSex))
	Translate(adrDestIn, cbSave);
#endif
} /* XBlockTransfer */


#ifdef notdef
/* this would be needed in a BINARY protocol */
/* T R A N S L A T E */

local void Translate(adr, cb)
ADRT	adr;
int	cb;
{
    union STUFFU {
	long	lng;
	struct { short	shortLo, shortHi; } shorts;
	struct { char	chLoLo, chLoHi, chHiLo, chHiHi; } chars;
	}	stuffIn, stuffOut;

    /* given a pointer to a value, perform the motion between
     * the host and child.  This routine, and the people who
     * call it, assume that this translation is symmetrical.
     * We only perform this on data of 2 or 4 bytes.
     */

    if (cb == 2) {

	stuffIn.shorts.shortLo = *((short *)adr);
	stuffOut.chars.chLoLo = stuffIn.chars.chLoHi;
	stuffOut.chars.chLoHi = stuffIn.chars.chLoLo;
	*((short *)adr) = stuffOut.shorts.shortLo;

    } else if (cb == 4) {

	stuffIn.lng = *((long *)adr);
	stuffOut.chars.chLoLo = stuffIn.chars.chHiHi;
	stuffOut.chars.chLoHi = stuffIn.chars.chHiLo;
	stuffOut.chars.chHiLo = stuffIn.chars.chLoHi;
	stuffOut.chars.chHiHi = stuffIn.chars.chLoLo;
	*((long *)adr) = stuffOut.lng;

    } /* if */
} /* Translate */
#endif


/* C L O S E   C O M M */

export void CloseComm()
{
    int		ipr;
    char	sbBuf[cbMsgMax];

    if (v->fnComm != fnNil) {
	sprintf(sbBuf, "%x|%x\n", msgQuit, 0);
	Transmit(sbBuf);	/* send a message to junior */
    } /* if */

    if (vfTest) {
	close(vfnTx);
	close(vfnRx);
	kill(vpidServer, 9);
    } else {
	close(v->fnComm);
    } /* if */
} /* CloseComm */


/* I N I T   C O M M */

export void InitComm(pr)
pPRR	pr;
{
    int		rgFnPtoC[2], rgFnCtoP[2];
    char	sbTx[10], sbRx[10], sbLevel[10];

    if (FSbCmp(pr->sbComm, "TEST")) {

	vfTest = true;
	if (pipe(rgFnPtoC) != 0)
	    Panic("Failed on pipe open: %s", SbFError(errno));

	if (pipe(rgFnCtoP) != 0)
	    Panic("Failed on pipe open: %s", SbFError(errno));

	/* pipes - write 1, read 0 */

	if (vpidServer = fork()) {

	    /* parent */
	    v->fnComm = vfnTx = rgFnPtoC[1];
	    vfnRx = rgFnCtoP[0];
	    close(rgFnCtoP[1]);
	    close(rgFnPtoC[0]);

	} else {

	    /* child */
	    if (v->fnExec != fnNil)
		close(v->fnExec);
	    if (v->fnCore != fnNil)
		close(v->fnCore);
	    close(rgFnCtoP[0]);
	    close(rgFnPtoC[1]);

	    close(0);
	    dup(rgFnPtoC[0]);
	    close(rgFnPtoC[0]);

	    close(1);
	    dup(rgFnCtoP[1]);
	    close(rgFnCtoP[1]);

	    execl("remote", "remote", 0);

	    printf("Execl of remote failed: %d %d\n", sbTx, sbRx);
	    exit(1);

	} /* if */

    } else {

#if (! ANY_BSD)
	WARNING: This code is BSD specific.  Similar things may done for
	System V.
#endif

	struct sgttyb ttyarg;
	static int bauds[]={ 300, 600, 1200, 1800, 2400, 4800, 9600};
	static int bcode[]={B300,B600,B1200,B1800,B2400,B4800,B9600};
	int n;
	char sbLevel[20];

	vfTest = false;
	v->fnComm = open(pr->sbComm, O_RDWR, 0);
	if (v->fnComm == -1)
	    UError("Cannot open %s: %s.", pr->sbComm, SbFError(errno));

	n = OTTYDISC;
	ioctl(v->fnComm, TIOCSETD, &n);	/* set old line discipline */

	/* set baud rates, etc */

	ttyarg.sg_ispeed = 0;
	for (n = 0; n < sizeof(bauds)/sizeof(int); n++) {
	    if (bauds[n] == v->iBaud)
	        ttyarg.sg_ispeed = ttyarg.sg_ospeed = bcode[n];
	} /* for */

	if (ttyarg.sg_ispeed == 0 ) {
	    if (v->iBaud != 0) {
		fprintf(stderr, "Cannot set %d baud\n", v->iBaud);
		exit(1);
	    } /* if */
	    ttyarg.sg_ispeed = ttyarg.sg_ospeed = B9600;
	} /* if */

	ttyarg.sg_erase = 0177;
	ttyarg.sg_kill = 025;
	ttyarg.sg_flags = EVENP + ODDP + CBREAK;
	ioctl(v->fnComm, TIOCSETP, &ttyarg);
	
    /* here we do any necessary initial handshaking...... */

#if LOCAL_COMM_INIT
	InitShakeMTOS(v->fnComm);
#endif LOCAL_COMM_INIT

	/* flush any echo or info from starting target */
	sleep(1);
	ioctl(v->fnComm, TIOCFLUSH, NULL);	/* flush input */

	ttyarg.sg_flags &= ~CBREAK;		/* return to cooked */
	ioctl(v->fnComm, TIOCSETP, &ttyarg);

#if 0
    /* this might be useful if the UNIX kernel supports it */
    /* the bk(4) line discipline is supposed to be better for fast stuff */
	n = NETLDISC;
	ioctl(v->fnComm, TIOCSETD, &n);
#endif 0

    } /* if */

    /* Test the link and (as a side effect) set debuglevel */

    vlevelSave = v->debuglevel;
    sprintf(sbLevel, "%x|%x|%x\n", msgLevel, v->pid, v->debuglevel);
    Transmit(sbLevel);
    Receive(false, sbNil);
} /* InitComm */
