/* $Header: aux.c,v 1.8 86/08/06 15:10:31 peter Exp $ */
/* (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */

#include "trans.h"

export int4	viaux, viauxMac, viauxMax = 0;
export int4	viauxFile;
export int4	viauxProcPhony;		/* something for phony procs */
export int4	viauxGlobalPhony;	/* something for unknown globals */
export pAUXU	vrgAux;				/* aux table */


/* I N I T   A U X */

export void InitAux()
{
    AUXU	aaux;

    aaux.isym = 0;
    IauxFAdd(&aaux);

    /* build something for phony procedures to point at */
    aaux.isym = isymNil;
    viauxProcPhony = IauxFAdd(&aaux);
    aaux.isym = 0;
    aaux.ti.tq0 = tqProc;
    aaux.ti.bt = btInt;
    IauxFAdd(&aaux);
    viauxGlobalPhony = IauxFAdd(AuxFBt(btInt));
} /* InitAux */


/* I A U X   F   A D D */

export int4 IauxFAdd(aux)
pAUXU	aux;
{
    if (viauxMac >= viauxMax) {
	viauxMax *= 2;
	vrgAux = (pAUXU) realloc(vrgAux, viauxMax * cbAUXU);
	if (vrgAux == 0)
	    Panic("Ran out of memory - auxillary table expansion");
    } /* if */
    viaux = viauxMac++;
    vrgAux[viaux] = *aux;

    return(viaux);
} /* IauxFAdd */


/* C H A N G E   A U X */

export void ChangeAux(iaux, aux)
int4	iaux;
pAUXU	aux;
{
    if (iaux > viauxMac)
	Panic("Change non-existant aux (%d)", iaux);
    if (iaux < viauxFile)
	dprint(10, ("ChangeAux: %s %ld\n", vsbEnt, visym));
    dprint(10, ("ChangeAux:\t%ld\t%ld\n", iaux, viaux-iaux));
    vrgAux[iaux] = *aux;
} /* ChangeAux */


/* A U X   F   I A U X */

export pAUXU AuxFIaux(iaux)
{
    if (iaux >= viauxMac)
	Panic("Accessed non-existant aux (%d)", iaux);

    if (iaux < viauxFile)
	dprint(10, ("AuxFIaux: %s %ld\n", vsbEnt, visym));
    dprint(10, ("AuxFIaux:\t%ld\t%ld\n", iaux, viaux-iaux));
    return(vrgAux + iaux);
} /* AuxFIaux */


/* A D D   T Q */

export void AddTq(iaux, tq)
int	tq;
int4	iaux;
{
    AUXU	aaux;

    aaux = *AuxFIaux(iaux);
    if (aaux.ti.tq5 != tqNil)
	Panic("Type is too complex");

    aaux.ti.tq5 = aaux.ti.tq4;
    aaux.ti.tq4 = aaux.ti.tq3;
    aaux.ti.tq3 = aaux.ti.tq2;
    aaux.ti.tq2 = aaux.ti.tq1;
    aaux.ti.tq1 = aaux.ti.tq0;
    aaux.ti.tq0 = tq;

    ChangeAux(iaux, &aaux);
} /* AddTq */


/* A U X   F   B T */

export pAUXU AuxFBt(bt)
int	bt;
{
    static AUXU	aaux;

    aaux.isym = 0;	/* zero out the word */
    aaux.ti.bt = bt;
    aaux.ti.lc = vlc;
    return(&aaux);
} /* AuxFBt */


/* P A T C H   T Q */

export void PatchTq(iaux, tq)
int	tq;
int4	iaux;
{
    AUXU	aaux;

    aaux = *AuxFIaux(iaux);

    if (aaux.ti.tq0 == tqNil)
	aaux.ti.tq0 = tq;
    else if (aaux.ti.tq1 == tqNil)
	aaux.ti.tq1 = tq;
    else if (aaux.ti.tq2 == tqNil)
	aaux.ti.tq2 = tq;
    else if (aaux.ti.tq3 == tqNil)
	aaux.ti.tq3 = tq;
    else if (aaux.ti.tq4 == tqNil)
	aaux.ti.tq4 = tq;
    else if (aaux.ti.tq5 == tqNil)
	aaux.ti.tq5 = tq;
    else
	Panic("Type is too complex");

    ChangeAux(iaux, &aaux);
} /* PatchTq */


/*  A D D   D I M */

export void AddDim(dim)
int	dim;
{
    AUXU	aaux;

    aaux.iaux = 1;
    IauxFAdd(&aaux);
    aaux.dn = 0;
    IauxFAdd(&aaux);
    aaux.dn = dim - 1;
    IauxFAdd(&aaux);
} /* AddDim */


/* I A U X   F   C O P Y */

export int4 IauxFCopy(iauxType)
int4	iauxType;
{
    int2	cAux = 0;
    int4	iaux;
    AUXU	aaux;

    /* we figure out how many aux's we have and then do a block copy */
    aaux = *AuxFIaux(iauxType);
    if (FComplexBt(aaux.ti.bt))
	cAux++;
    if (aaux.ti.tq0 == tqArray) cAux += 3;
    if (aaux.ti.tq1 == tqArray) cAux += 3;
    if (aaux.ti.tq2 == tqArray) cAux += 3;
    if (aaux.ti.tq3 == tqArray) cAux += 3;
    if (aaux.ti.tq4 == tqArray) cAux += 3;
    if (aaux.ti.tq5 == tqArray) cAux += 3;

    iaux = IauxFAdd(&aaux);
    for (iauxType++; cAux; cAux--)
	IauxFAdd(AuxFIaux(iauxType++));

    return(iaux);
} /* IauxFCopy */
