/* $Header: init.c,v 1.16 86/06/26 12:17:02 peter Exp $ */
/* (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */

#include "trans.h"
#include <sys/stat.h>

export int	vfdSym; 	/* file descriptor to read from the file */
export char	*vsbStr;        /* string table buffer for OUR symbol table */
export int4	vcbStr; 	/* size of string table */
export HDRR	vahdr;
export ADRT	vadrFirstLine;

export int	*vmpIsymentIaux;		/* map V's no's to tes aux's */
export LDFILE	*vlfd;		/* loader file desc to access symtab */
export LDFILE	*vlfdLines;	/* loader file desc to access LINES */
export LDFILE	*vlfdStrings;	/* loader file desc to access STRINGS */
export int4	vcsym;          /* globally accessable length of symbol table */
export int4	vcbSsIn;        /* globally accessable size of string table */


/* I N I T   S Y M */

export void InitSym(sbFile, scale)
SBT	sbFile;
int	scale;
{
    int4	scaleSym, cLine, ret, cbSsOffset;
    AOUTHDR	opthead;	/* optional header info */
    SCNHDR	secthead;

    /* open the executable */
    if ((vlfd = ldopen(sbFile, NULL)) == NULL) {
	perror(sbFile);
	exit(1);
    } /* if */

    if (HEADER(vlfd).f_opthdr != sizeof(AOUTHDR))
	Panic("%s: bad optional header size (%d)\n", 
	    sbFile, HEADER(vlfd).f_opthdr);

    if (ldohseek(vlfd) == FAILURE)
	Panic("%s: bad optional header seek\n", sbFile);

    if (FREAD(&opthead, HEADER(vlfd).f_opthdr, 1, vlfd) != 1)
	Panic("%s: bad optional header read\n", sbFile);

    if (ldtbseek(vlfd) == FAILURE)
	Panic("%s: bad table seek\n", sbFile);

    /* Now we open two more streams for LINES and STRINGS */
    if ((vlfdLines = ldopen(sbFile, NULL)) == NULL) {
	perror(sbFile);
	exit(1);
    } /* if */

    if ((vlfdStrings = ldopen(sbFile, NULL)) == NULL) {
	perror(sbFile);
	exit(1);
    } /* if */

    vcsym = HEADER(vlfd).f_nsyms;
    if (vcsym == 0)
	Panic("%s is stripped.. There is nothing to translate!", sbFile);

    vahdr.cbText = opthead.tsize;
    vahdr.cbData = opthead.dsize;
    vahdr.cbBss = opthead.bsize;
    vahdr.entrypoint = opthead.entry;

    /* Make the tables proportionate to the size of the incoming symtab */

    scaleSym = (scale > 3) ? 3 : scale;

    /* string space */
    vcbSsIn = 0;
    cbSsOffset = HEADER(vlfd).f_symptr + (vcsym * SYMESZ);
    if (cbSsOffset > 0) {
	if (FSEEK(vlfdStrings, cbSsOffset, 0) != OKFSEEK)
	    Panic("Can't seek to string table");
	ret = FREAD((char *)&vcbSsIn, sizeof(vcbSsIn), 1, vlfdStrings);
	if ((ret != EOF) AND (ret != 1) AND (ret != 0))
	    Panic("Can't read string table: %ld", vcbSsIn);
    } /* if */

    InitSs((vcsym * 9) + vcbSsIn + 1000); /* exceeds theoretical maximum */

    /* file table */
    if (vifdMax == 0)
	vifdMax = 500;
    vrgFd = (pFDR) malloc(vifdMax * cbFDR);	
    if (vrgFd == fdNil)
	Panic("Ran out of memory - file table");

    /* proc table */
    if (vipdMax == 0)
	vipdMax = 1000;
    vrgPd = (pPDR) malloc(vipdMax * cbPDR);
    if (vrgPd == pdNil)
	Panic("Ran out of memory - procedure table");

    /* symbol table */
    if (visymMax == 0)
	visymMax = Max(2000, vcsym) * scaleSym;
    vrgSym = (pSYMR) malloc(visymMax * cbSYMR);
    if (vrgSym == symNil)
	Panic("Ran out of memory - symbol table");
    SymFAlloc(issNil, stNil, scNil, adrNil, 0L);

    /* global symbol table */
    if (visymGlMax == 0)
	visymGlMax = Max(1000, (vcsym / 4)) * scaleSym;
    vrgSymGlobal = (pSYMR) malloc(visymGlMax * cbSYMR);
    if (vrgSymGlobal == symNil)
	Panic("Ran out of memory - global symbol table");
    
    /* aux table */
    if (viauxMax == 0)
	viauxMax = Max(5000, vcsym) * scaleSym;
    vrgAux = (pAUXU) malloc(viauxMax * cbAUXU);
    if (vrgAux == auxNil)
	Panic("Ran out of memory - auxillary table");
    InitAux();

    /* line no table */
    if (vilineMax == 0) {
	if (ldshread(vlfdLines, 1, &secthead) != SUCCESS)
	    Panic("Could not read section header for line number info");
	vilineMax = Max(200, secthead.s_nlnno + 2);
    } /* if */
    vrgLine = (pLINER) malloc(vilineMax * cbLINER); 
    if (vrgLine == lineNil)
	Panic("Ran out of memory - line number table");

    if (vitdMax == 0)
	vitdMax = Max(2000, (vcsym /  20)) * scaleSym;
    vrgTd = (pTDR) malloc(vitdMax * cbTDR);	/* typedef table */
    if (vrgTd == 0)
	Panic("Ran out of memory - typedefs table");

    /* Next we set up a null line entry */
    vrgLine[0].iln = 0;
    vrgLine[0].dadr = 0;
    vilineMac++;

    vdot = 0;

    vmpIsymentIaux = (int4 *) malloc(vcsym * sizeof(int));
    if (vmpIsymentIaux == 0) {
	perror("Ran out of memory - symbol table map");
	exit(1);
    } /* if */
    ZeroBlock(vmpIsymentIaux, vcsym * sizeof(int));

} /* InitSym */
