/* $Header: ldlib.c,v 1.2 85/09/16 08:57:24 peter Exp $ */

/* NOTICE - This is hacked AT&T code!  For the purposes of the
 * Third Eye Software, Inc. COFF translator, it is functionally
 * equivalent.  I have just coded around a HUGE number of
 * expensive consistency checks that WE don't need.
 * If existence of this code makes you nervous, delete it and 
 * re-load the translator.
 */

/* *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING ***
 * This code ASSUMES that the ldptr used for reading SYMBOLS
 * is NOT THE SAME as the ldptr used for reading LINES!!
 * If they are, everything will break horribly!
 */

#include "trans.h"

static int	viVlnMax = 0;
static int	viVln = 0;
static LINENO	*vrgVLines;
static SYMENT	*vrgVSyms;


int ldlinit(ldptr, fcnindx)
LDFILE		*ldptr;
{
    extern int		fseek( );
    extern int		ldtbread( );
    extern int		ldshread( );

    static int		fFirstTime = true;
    SCNHDR		secthead;
    LINENO		line;
    long		endlnptr;

    if (vsyment->n_numaux != 1) {
      return(FAILURE);
    } else {
      if (fFirstTime) {
	fFirstTime = false;
	if (ldshread(ldptr, vsyment->n_scnum, &secthead) == SUCCESS) {
	  viVlnMax = secthead.s_nlnno;
	  viVln = 0;
	  if (FSEEK(ldptr, secthead.s_lnnoptr, BEGINNING) == OKFSEEK) {
	      vrgVLines = (LINENO *) malloc(viVlnMax * LINESZ);
	      if (FREAD(vrgVLines, LINESZ, viVlnMax, ldptr) != viVlnMax)
		  return(FAILURE);
	  }
	}
      } /* if */
      return(SUCCESS);
    }
}


int ldlitem(ldptr, linenum, lineent)
LDFILE		*ldptr;
int		linenum;
LINENO		*lineent;
{

  LINENO	*temp;

  viVln++;
  if (viVln >= viVlnMax)
    return(FAILURE);

  temp = (LINENO *) ((int)vrgVLines + viVln * LINESZ);

#if (CPU == CCI632) || (CPU == A3B2)

  if ((unsigned long)temp & 3) {
	/* we need to hand copy it */
	CopyBlock(lineent, temp, sizeof(*lineent));
  } else {
	*lineent = *temp;
  } /* if */

#else

    *lineent = *temp;

#endif (CPU == CCI632) || (CPU == A3B2)

    if (lineent->l_lnno != 0)
	return(SUCCESS);
    return(FAILURE);
}

#if 1
/* this version lets FREAD do its job in terms of buffering */

int ldtbread(ldptr, symnum, symentry)
LDFILE	*ldptr;
long	symnum;
SYMENT	*symentry;
{
    static int		isyment = 0, fFirstTime = true;
    extern int		fseek( );

    if (fFirstTime) {
	fFirstTime = false;
	if (FSEEK(ldptr, HEADER(ldptr).f_symptr, BEGINNING) != OKFSEEK)
	    return(FAILURE);
    } /* if */

    if (isyment != symnum)
	Panic("Symbol read assumption wrong: %ld instead of %ld",
		symnum, isyment);
    isyment++;

    if (FREAD(symentry, SYMESZ, 1, ldptr) != 1)
	return(FAILURE);
    return(SUCCESS);
}

#else

/* This version just reads the whole damn thing in in one shot */
int ldtbread(ldptr, symnum, symentry)
LDFILE	*ldptr;
long	symnum;
SYMENT	*symentry;
{
    static int		fFirstTime = true;
    extern int		fseek( );
    SYMENT		*temp;

    if (fFirstTime) {
	fFirstTime = false;
	if (FSEEK(ldptr, HEADER(ldptr).f_symptr, BEGINNING) != OKFSEEK)
	    return(FAILURE);
	vrgVSyms = (SYMENT *) malloc(vcsym * SYMESZ);
	if (FREAD(vrgVSyms, SYMESZ, vcsym, ldptr) != vcsym)
	    return(FAILURE);
    } /* if */

    temp = (SYMENT *) ((int) vrgVSym + symnum * SYMESZ);

#if (CPU == CCI632) || (CPU == A3B2)

    if ((unsigned long)temp & 3) {
	/* we need to hand copy it */
	CopyBlock(symentry, temp, sizeof(*symentry));
    } else {
	*symentry = *temp;
    } /* if */

#else

    *symentry = *temp;

#endif (CPU == CCI632) || (CPU == A3B2)

    return(SUCCESS);
}
#endif
