/* $Header: main.c,v 1.11 86/06/19 23:32:52 peter Exp $ */
/* (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */

/* ********************************************************** */
/* This is the symbol table translator for COFF style symbols */
/* ********************************************************** */

#include "trans.h"

export int	vfVerbose;		/* true if we want text out */
export int	vlevel;			/* debugging level */
export ADRT	vdot;			/* last known adr in TEXT space */

#if 0
exportdefine dprint(x, y) {if (vlevel >= x) printf y;}
#endif


/* M A I N */

export void main(argc, argv) 
int     argc;
char    *argv[];
{
    int		scale = 1;
    SBT		sbUsage, sbArg, sbProgram;
    FLAGT	fDidOne = false;
    pFDR	fd;
    pPDR	pd;

    sbUsage = "Usage: trans [-vup] [-s#] object_file\n";
    sbProgram = sbNil;

    while (*(++argv) != 0) {
	sbArg = *argv;
	if (*sbArg != '-') {
	    if (fDidOne)
		Panic("Too many files: %s", sbUsage);
	    fDidOne = true;
	    sbProgram = sbArg;
	} else {
	    switch (sbArg[1]) {
		case 'a':
		    vfPercentSigns = !vfPercentSigns;
		    vfNoUnderlines = !vfNoUnderlines;
		    break;
		case 'p':
		    vfPercentSigns = !vfPercentSigns;
		    break;
		case 'u':
		    vfNoUnderlines = !vfNoUnderlines;
		    break;
		case 'd':
		    vlevel = atoi(sbArg+2);
		    break;
		case 's':
		    scale = atoi(sbArg+2);
		    if ((scale <= 0) || (scale > 30)) {
			printf("Bad scaling parameter: %d > 30\n", scale);
			exit(1);
		    } /* if */
		    break;
		case 'S':
		    /* this is a redo with specific sizes */
		    sscanf(sbArg+2, "%d,%d,%d,%d,%d,%d,%d",
			&vifdMac, &vipdMac, &visymMac, &visymGlMac,
			&viauxMac, &vilineMac, &vissMac);
		    break;

		case 'v':
		    vfVerbose++;
		    break;
		case 'w':
		    vfWarnUndefined++;
		    break;
		default:
		    Panic("Illegal option.\n%s", sbUsage);
	    } /* switch */
	} /* if */
    } /* while */

    if (!fDidOne)
	Panic("%s", sbUsage);

    InitSym(sbProgram, scale);
    Map(sbProgram);
    EndFile();	/* end the last file done */

    DumpAll(sbProgram);

    if (vfVerbose)
	PrintAll();

    exit(0);
} /* main */


/* D U M P   A L L */

export void DumpAll(sbFile)
char	*sbFile;
{
    char	sbBuf[200];
    int		cGlobals, fn;
    long	cbOffset;
    extern struct exec	vhead;

    strcpy(sbBuf, sbFile);
    strcat(sbBuf, ".cdb");

    vahdr.vstamp = CURRENT_VERSION;
    vahdr.ijokeDay = ijokeNil;

    if ((fn = open(sbBuf, O_WRONLY+O_CREAT, 0666)) <= -1) {
	perror("can't open output file");
	exit(1);
    } /* if */

#define WRITE_IT(buf, size, count, msg) \
    if (write(fn, buf, (size) * (count)) != (size) * (count)) {\
	    perror(msg);\
	    exit(1);\
    } else {\
	cbOffset += (size) * (count);\
    } /* if */

    cbOffset = 0;
    WRITE_IT(&vahdr, cbHDRR, 1, "header")

    vahdr.ipdMax = vipd;
    vahdr.cbPdOffset = cbOffset;
    WRITE_IT(vrgPd, cbPDR, vipdMac, "procedures")

    vahdr.ifdMax = vifd + 1;
    vahdr.cbFdOffset = cbOffset;
    WRITE_IT(vrgFd, cbFDR, vifdMac, "files")

    vahdr.ilineMax = viline + 1;
    vahdr.cbLineOffset = cbOffset;
    WRITE_IT(vrgLine, cbLINER, vilineMac, "lines")

    vahdr.iauxMax = viauxMac;
    vahdr.cbAuxOffset = cbOffset;
    WRITE_IT(vrgAux, cbAUXU, viauxMac, "auxes")

    vahdr.isymMax = visymMac + visymGlMac; /* ALL symbols */
    vahdr.cbSymOffset = cbOffset;
    WRITE_IT(vrgSym, cbSYMR, visymMac, "symbols")

    vahdr.isymGl = visymMac;
    vahdr.isymGlMax = vahdr.isymMax;
    WRITE_IT(vrgSymGlobal, cbSYMR, visymGlMac, "globals")

    vahdr.itdMax = vitdMac;
    vahdr.cbTdOffset = cbOffset;
    WRITE_IT(vrgTd, cbTDR, vitdMac, "td's")

    vahdr.issMax = vissMac;
    vahdr.cbSsOffset = cbOffset;
    WRITE_IT(vsbNewStr, vissMac, 1, "strings");

    lseek(fn, 0L, 0);
    WRITE_IT(&vahdr, cbHDRR, 1, "header")
} /* DumpAll */


/* P A N I C */

/* VARARGS1 */
export void Panic(sbMsg, arg1, arg2, arg3, arg4)
SBT	sbMsg;
int	arg1, arg2, arg3, arg4;
{
    if (sbMsg != sbNil)
	printf(sbMsg, arg1, arg2, arg3, arg4);
    printf("\n");
    exit(1);
} /* Panic */
