/* (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */
/* $Header: map.c,v 1.9 86/09/07 11:46:11 peter Exp $ */

#include "trans.h"

export pSYMENTR vsyment;		/* current sysV symbol entry */
export pAUXENTR vauxent;		/* current sysV aux entry */
export SBT	vsbEnt;			/* current symbol's name */

export int4	vcsymCur;		/* upward count of symbols */
export FLAGT	vfNoUnderlines = NO_UNDERLINES;
export FLAGT	vfPercentSigns = PERCENT_SIGNS;
export FLAGT	vfBlockAdded = false;
export int4	vrgIsymBlock[20];
export int4	viBlock;


/* N E X T  S Y M E N T */

export pSYMENTR NextSyment()
{
    SBT			sb;
    static char 	sbBuffer[10];
    static SYMENTR	asyment;
    static AUXENTR	aauxent;

    vsyment = &asyment;
    vauxent = &aauxent;
    if (vcsymCur < 0)
	vcsymCur = 0;
    else
	vcsymCur += (vsyment->n_numaux + 1);

    if (ldtbread(vlfd, vcsymCur, vsyment) == FAILURE)
	Panic("Can't read %dth symbol", vcsymCur);

    if (vsyment->n_numaux) {
	if (ldtbread(vlfd, vcsymCur + 1, vauxent) == FAILURE)
	    Panic("Can't read %dth aux", vcsymCur);
     } else
	vauxent = 0;

#ifdef SYSV_0
    strcpy(sbBuffer, vsyment->n_name);
    sbBuffer[8] = 0;
    vsbEnt = sbBuffer;
#else
    vsbEnt = (SBT) ldgetname(vlfdStrings, vsyment);
#endif

    if ((!vfNoUnderlines) AND (*vsbEnt == '_'))
	vsbEnt++;

    if (vfPercentSigns) {
	for (sb = vsbEnt; *sb; sb++) {
	    if (*sb == '%')
		*sb = '$';
	} /* for */
    } /* if */

    return(vsyment);
} /* NextSyment */


/* M A P */

export void Map()
{
    FAST pSYMENTR syment;
    FAST pSYMR	sym;
    SBT		sb;
    FLAGT	fBfPending;
    pSYMR	symBlock;
    SYMENTR	asyment;
    int4	isym;
    int		sc, st, cauxLast;
    pPDR	pd;
    pFDR	fd;
    static int mpCoffSc[] = { scNil, scText, scData, scBss, scAbs };

    vcsymCur = -1;
    cauxLast = 0;
    fBfPending = false;

    DoFile(adrNil, "temp");
#if (MFG == CT)
    DoFile((ADRT)0, "dummy");
#endif /* (MFG == CT) */

    while ((vcsymCur + cauxLast) < vcsym) {

	NextSyment();
	cauxLast = vsyment->n_numaux + 1;

	if (fBfPending AND (vsyment->n_sclass != C_FCN)) {
	    fBfPending = false;

	    /* previous symbol was p;roc WITH info but NO BODY!! */
	    if (!vfDidLastFile) {
		if (vdotEnd == adrNil)
		    vdotEnd = vdot;
		EndFile(vdotEnd);
		vfDidLastFile = true;
	    } /* if */

	    sym->st = stProc;
	    sym->index = viauxProcPhony;
	    ProcInsert(isym, sym->value, 0);
	} /* if */

	sc = mpCoffSc[vsyment->n_scnum >= 0 ? vsyment->n_scnum : 0];
	st = stNil;
	isym = vcsymCur;
	switch (vsyment->n_sclass) {

	case C_FILE:
	    DoFile(vdotEnd, vauxent->x_file.x_fname);
	    break;

	case C_TPDEF:
	    DoTypedef();
	    st = stTypedef;
	    sc = scInfo;
	    goto dovar;	/* KLUDGE - is this right?? */
	    break;

	case C_STRTAG:
	    DoStruct(btStruct);
	    break;

	case C_UNTAG:
	    DoStruct(btUnion);
	    break;

	case C_ENTAG:
	    DoEnum();
	    break;

	case C_REG:
	    sc = scRegister;
	    goto DoLocal;

	case C_AUTO:
	    sc = scAbs;
DoLocal:
	    st = stLocal;
	    if (!vfBlockAdded) {
		sym = SymFAlloc(issNil, stBlock, scText,
				SymFIsym(visymProc)->value);
		PushIsym(visym);
		vfBlockAdded = true;
	    } /* if */
	    goto dovar;

	case C_EXT:
	    st = stGlobal;
	    if (sc == scText) {
		if (visymProc != isymNil)
		    EndProc(vsyment->n_value);
		goto dovar;
	    } else {
		sym = SymFGlobal(IssFSb(vsbEnt),stGlobal, sc, vsyment->n_value);
		goto doglobal;
	    } /* if */
	    break;

	case C_STAT:
	    if (vsyment->n_name[0] == '.') {
		sb = vsyment->n_name;
		if (FSbCmp(sb, ".text")) {

		    if (vfDidText)
			/* handles files with no file symbol */
			DoFile(adrNil, "phony file");

		    /* not all compiler/assembler/loaders put these out */
		    SymFIsym(visymFile)->value = vrgFd[vifd].adr = 
			    vsyment->n_value;
		    vrgFd[vifd].adr = vsyment->n_value;
		    vdotEnd = vsyment->n_value + vauxent->x_scn.x_scnlen;
		    vfDidText = true;
		    break;

		} else if (FSbCmp(sb, ".data") OR FSbCmp(sb, ".bss"))
		    break;	/* we get these by the bushelful */
	    } /* if */

	    if (sc == scText)
		vdot = vsyment->n_value;

	    st = stStatic;
	    goto dovar;

	case C_LABEL:
	    sc = scText;
	    st = stLabel;
	    vdot = vsyment->n_value;
	    goto dovar;

	case C_REGPARM:
	    sc = scRegister;
	    st = stParam;
	    if (CHECK_REG_PARAMS)
		vfAlsoEqual = false;
	    goto dovar;

	case C_ARG:
	    sc = scAbs;
	    st = stParam;
	    goto dovar;

dovar:
	    sym = SymFAlloc(IssFSb(vsbEnt), st, sc, vsyment->n_value);
	    if (st == stTypedef)
		AddTd(sym);

doglobal:
	    isym = visym;
	    asyment= *vsyment;
	    sym->index = IauxFSyment(&asyment);

#if 0
	    if ((sc == scText) AND (vsyment->n_type == 0)) {
		if (vsyment->n_sclass == C_EXT) {
#endif
	    if (sc == scText) {
		if (vsyment->n_sclass == C_EXT) {

		    if (vsyment->n_type != 0) {
			fBfPending = true;
			break;
		    } /* if */

		    /* it's a procedure with no type info */
		    if (!vfDidLastFile) {
			if (vdotEnd == adrNil)
			    vdotEnd = vdot;
			EndFile(vdotEnd);
			vfDidLastFile = true;
		    } /* if */

		    sym->st = stProc;
		    ProcInsert(isym, sym->value, 0);

		} else if (vsyment->n_sclass == C_STAT) {

		    /* it's a label */
		    sym->st = stLabel;

		} /* if */
	    } /* if */
#if 0
	    if ((vlc == lcFortran) AND (st == stParam))
		AddTq(sym->index, tqRef);
#endif
	    break;

	case C_FCN:
	    fBfPending = false;
	    if (FSbCmp(vsbEnt,".bf")) {
		DoProc(vsyment->n_value);
	    } else {
		EndProc(vsyment->n_value);
	    } /* if */
	    break;

	case C_BLOCK:
	    if (FSbCmp(vsbEnt, ".bb")) {
		DoLBrac(vsyment->n_value);
	    } else {
		DoRBrac(vsyment->n_value);
	    } /* if */
	    break;

	} /*switch */

    } /* while */

    FixFd();
} /* Map */
