/* $Header: misc.c,v 1.4 86/06/19 23:32:58 peter Exp $ */
/* (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */

#include "trans.h"

export int4	vissMac, vissMax;
export SBT	vsbNewStr, vsbMac, vsbMax;	/* new string table */

#define modHash		512

typedef struct HASHS {
	char	*sb;
	int	iss;
	struct HASHS	*hashNext;
} HASHR, *pHASHR;
#define cbHASHR sizeof(HASHR)
#define hashNil ((pHASHR)0)

HASHR		vrgHash[modHash];
pHASHR	vhashMac, vhashMax;


/* I N I T   S S */

export void InitSs(cb)
int	cb;
{
    /* setup string space */
    vissMax = cb;
    vsbNewStr = (SBT) malloc(vissMax);
    if (vsbNewStr == sbNil)
	Panic("Ran out of memory - string table");
    vsbMac = vsbNewStr;
    *vsbMac++ = 0;	/* start off with a null string */
    vissMac = 1;
} /* InitSs */


/* S B   F   I S S */

export SBT SbFIss(iss)
int4	iss;
{
    if ((iss < 0) OR (iss >= vissMac))
	Panic("Iss out of bounds (%ld)", iss);
    
    return(vsbNewStr + iss);
} /* SbFIss */


/* I S S   F   S B */

export int4 IssFSb(sb)
FAST SBT	sb;
{
    FAST pHASHR	hash;
    FAST pHASHR	hashPrev;
    FAST SBT	sbTemp;
    FAST int	sum;

    /* first do a hash to see if we already have it */
    sum = 0;
    if (sb != 0) {
	sbTemp = sb;

	while (*sbTemp)
	    sum += *sbTemp++;
    } /* if */
    hash = vrgHash + (sum % modHash);

    while (hash) {
	if ( (hash->sb != 0)
	   && (!strcmp(sb, hash->sb)) ) {
	    return(hash->iss);			/* GOT IT! */
	} /* if */
	hashPrev = hash;
	hash = hash->hashNext;
    } /* while */
    hash = hashPrev;

    /* we don't have it yet, create it */
    if (vhashMac >= vhashMax) {
	vhashMac = (pHASHR) malloc(3000 * cbHASHR);
	if (vhashMac == 0)
	    Panic("Ran out of memory - hash expansion");
	vhashMax = vhashMac + 3000;
    } /* if */
    hash->hashNext = vhashMac++;
    hash = hash->hashNext;

    if (vissMac + strlen(sb) > vissMax)
	Panic("Ran out of string space"); /* this error "can't happen" ... */

    sbTemp = hash->sb = vsbMac;
    hash->iss = vissMac;

    while (*(sbTemp++) = *(sb++))
	;

    vsbMac = sbTemp;
    vissMac = vsbMac - vsbNewStr;
    hash->hashNext = hashNil;

    return (hash->iss);
} /* IssFSb */


/* M A X */

export int Max(a, b)
int	a, b;
{
    return( (a > b) ? a : b );
} /* Max */


/* C O P Y   B L O C K */

export void CopyBlock (dest, src, size)
FAST char	*dest;
FAST char	*src;
FAST int	size;
{
    while (size--)
	*(dest++)= *(src++);
} /* CopyBlock */


/* Z E R O   B L O C K */

export void ZeroBlock (src, size)
FAST char	*src;
FAST int	size;
{
    while (size--)
	*(src++)= 0;
} /* ZeroBlock */


/* F   S B   C M P */

export FLAGT FSbCmp(sb1, sb2)
FAST char *sb1, *sb2;
{
    if (sb1 == 0 || sb2 == 0)
	return(false);

    while (*sb1 == *sb2) {
	if (*sb1 == '\0')
	    return(true);
	sb1++;
	sb2++;
    } /* while */

    return(false);
} /* FSbCmp */


/* D O   R   B R A C */

export void DoRBrac(adr)
ADRT	adr;
{
    vdot = adr;
    SymFAlloc(issNil, stEnd, scText, adr, vrgIsymBlock[--viBlock]);
    SymFIsym(vrgIsymBlock[viBlock])->index = visym + 1;
} /* DoRBrac */


/* D O   L   B R A C */

export void DoLBrac(adr)
ADRT	adr;
{
    pSYMR	sym;

    SymFAlloc(issNil, stBlock, scText, adr, 0L);
    vdot = adr;
    vrgIsymBlock[viBlock++] = visym;
} /* DoLBrac */


/* F   C O M P L E X   B T */

export FLAGT FComplexBt(bt)
int	bt;
{
    switch (bt) {
	case btUnion:
	case btStruct:
	case btEnum:
	case btTypedef:
	    return (true);

    default:
	    return (false);
    } /* switch */
} /* FComplexBt */
