/* $Header: print.c,v 1.6 86/06/19 23:33:01 peter Exp $ */
/* (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */

#include "trans.h"

int	vindent;


/* P R I N T   T Q */

local void PrintTq(tq)
int	tq;
{
    switch (tq) {
	case tqArray:	printf("Array of "); break;
	case tqPtr:	printf("Pointer to "); break;
	case tqProc:	printf("Function returning "); break;
	case tqRef:	printf("Reference to "); break;
    } /* switch */
} /* PrintTq */


/* P R I N T   B T */

local void PrintBt(bt)
int	bt;
{
    switch (bt) {
	default:	printf("Unknown-bt(%d)", bt);	break;
	case btAdr:	printf("Adr ");			break;
	case btChar:	printf("Char ");		break;
	case btUChar:	printf("UChar ");		break;
	case btShort:	printf("Short ");		break;
	case btUShort:	printf("UShort ");		break;
	case btInt:	printf("Int ");			break;
	case btUInt:	printf("UInt ");		break;
	case btLong:	printf("Long ");		break;
	case btULong:	printf("ULong ");		break;
	case btFloat:	printf("Float ");		break;
	case btDouble:	printf("Double ");		break;
	case btStruct:	printf("Struct ");		break;
	case btUnion:	printf("Union ");		break;
	case btEnum:	printf("Enum ");		break;
	case btTypedef: printf("User type ");		break;
	case btRange:	printf("Range ");		break;
	case btSubRange: printf("Subrange ");		break;
	case btComplex:	printf("Complex ");		break;
	case btLogical:	printf("Logical ");		break;
	case btVoid:	printf("Void ");		break;
    } /* switch */
} /* PrintBt */


/* I A U X   F   P R I N T   T Y P E */

local void IauxFPrintType(iaux)
int4	iaux;
{
    AUXU	aaux;

    aaux = *AuxFIaux(iaux++);
    PrintTq(aaux.ti.tq0);
    PrintTq(aaux.ti.tq1);
    PrintTq(aaux.ti.tq2);
    PrintTq(aaux.ti.tq3);
    PrintTq(aaux.ti.tq4);
    PrintTq(aaux.ti.tq5);
    if (aaux.ti.lc != lcC)
	printf("Fortran ");
    PrintBt(aaux.ti.bt);

    if (FComplexBt(aaux.ti.bt)) {
	printf("ref = %ld ", AuxFIaux(iaux++)->isym);
    } else if (aaux.ti.bt == btRange) {
	printf("[%ld", AuxFIaux(iaux++)->dn);
	printf("..%ld] ", AuxFIaux(iaux++)->dn);
    } else if (aaux.ti.bt == btSubRange) {
	iaux++;		/* step over iaux of parent */
	printf("[%ld", AuxFIaux(iaux++)->dn);
	printf("..%ld] ", AuxFIaux(iaux++)->dn);
    } /* if */

#define PRINTDIM(tq)\
    if (tq == tqArray) {\
	iaux++;	/* step over iaux of base scalar type */\
	printf("[%ld", AuxFIaux(iaux++)->dn);\
	printf(", %ld] ", AuxFIaux(iaux++)->dn);\
    }

    PRINTDIM(aaux.ti.tq5);
    PRINTDIM(aaux.ti.tq4);
    PRINTDIM(aaux.ti.tq3);
    PRINTDIM(aaux.ti.tq2);
    PRINTDIM(aaux.ti.tq1);
    PRINTDIM(aaux.ti.tq0);

    return(iaux);
} /* IauxFPrintType */


/* P R I N T   S Y M */

local void PrintSym(sym)
pSYMR	sym;
{
    int4	iaux;

    if (sym->iss != issNil)
	printf("\"%s\": ", SbFIss(sym->iss));
    else
	printf("\"\": ");

    switch (sym->st) {
	case stTypedef:
		break;

	case stParam:
	case stLocal:
	case stNil:
		printf("%ld, ", sym->value);
		break;
	case stProc:
		if (sym->index != viauxProcPhony)
		    vindent++;
	case stLabel:
	case stEnd:
	case stFile:
	case stCommon:
	case stBlock:
	case stStatic:
	case stGlobal:
		if (sym->value == adrNil)
		    printf("adrNil, ");
		else
		    printf("%#lx, ", sym->value);
		break;
	case stMember:
		printf("offset %ld, ", sym->value);
		break;
    } /* switch */

    switch (sym->st) {
	case stNil:	printf("stNil "); break;
	case stGlobal:	printf("Extern "); break;
	case stStatic:	printf("Static "); break;
	case stParam:	printf("Param "); break;
	case stLocal:	printf("Local "); break;
	case stLabel:	printf("Label "); break;
	case stCommon:	printf("Common "); vindent++; break;
	case stBlock:	printf("Block "); vindent++; break;
	case stProc:	printf("Procedure "); break;
	case stMember:	printf("Member "); break;
	case stEnd:	printf("End "); break;
	case stTypedef:	printf("Typedef "); break;
	case stFile:	printf("File name "); vindent++; break;
    } /* switch */

    switch (sym->sc) {
	case scNil:		printf("scNil "); break;
	case scText:		printf("Text "); break;
	case scData:		printf("Data "); break;
	case scBss:		printf("Bss "); break;
	case scRegister:	printf("Register "); break;
	case scAbs:		printf("Absolute "); break;
	case scUndefined:	printf("scUndefined "); break;
	case scInfo:		printf("Info "); break;
	case scBits:		printf("BitField "); break;
    } /* switch */

    iaux = sym->index;
    switch (sym->st) {
	default: printf("ref = %ld ", iaux);	break;

	case stLabel:
	    break;
	case stProc:
		printf("ref = %ld ", AuxFIaux(iaux++)->isym);
		/* fall through */

	case stMember:
		if (iaux == 0)	/* it MUST be an ENUM name */
		    break;
		/* fall through */

	case stStatic:
	case stGlobal:
	case stLocal:
	case stParam:
	case stTypedef:
		iaux = IauxFPrintType(iaux);
		if (sym->sc == scBits)
		    printf("width = %ld ", AuxFIaux(iaux)->width);
		break;
    } /* switch */
    printf("\n");

} /* PrintSym */


/* P R I N T   I N D E N T */

local void PrintIndent()
{
    register int	i;

    for (i = 0; i < vindent; i++)
	printf("    ");
} /* PrintIndent */


/* P R I N T   L I N E S */

local void PrintLines(iline)
register int	iline;
{
    int		i;
    ADRT	dadr, dadrLast;

    dadrLast = 0;
    for (i = 0; iline < vilineMac; i++, iline++) {
	dadr = vrgLine[iline].dadr;
	if (vrgLine[iline].dadr < dadrLast)
	    break;
	printf("%s%3d %3d: 0x%lx", (i % 4) ? "\t" : "\n\t",
			iline, vrgLine[iline].iln, dadr);
	dadrLast = dadr;
    } /* for */
} /* PrintLines */


/* P R I N T   F I L E S */

local void PrintFiles()
{
    register int	ifd;
    register pFDR	fd;
    
    for (ifd = 0, fd = vrgFd; ifd < vifdMac; ifd++, fd++) {
	printf("%3d: \"%s\" %#lx", ifd, SbFIss(fd->iss), fd->adr);
	if (fd->ipd != ipdNil)
	    printf("\t\"%s\"", SbFIss(SymFIsym(vrgPd[fd->ipd].isym)->iss) );
	printf("\n");
    } /* for */
} /* PrintFiles */


/* P R I N T   P R O C S */

local void PrintProcs()
{
    register int	ipd;
    pPDR	pd;

    pd = vrgPd;
    for (ipd = 0; ipd < vipdMac; ipd++, pd++) {
	printf("%3d: \"%s\" addr: %#lx  isym: %ld",
		ipd, SbFIss(SymFIsym(pd->isym)->iss), pd->adr, pd->isym);
	if (pd->iline > 0)
	    PrintLines(pd->iline);
	printf("\n");
    } /* for */
} /* PrintProcs */


/* P R I N T   A L L */

export void PrintAll() 
{
    register int	i;
    pTDR	td;

    printf("Header infomation:\n");

    printf("	vstamp:		%8ld\n", vahdr.vstamp);
    printf("	cbText:		%8ld\n", vahdr.cbText);
    printf("	cbData:		%8ld\n", vahdr.cbData);
    printf("	cbBss:		%8ld\n", vahdr.cbBss);
    printf("	ipdMax:		%8ld\n", vahdr.ipdMax);
    printf("	cbPdOffset:	%8ld\n", vahdr.cbPdOffset);
    printf("	ifdMax:		%8ld\n", vahdr.ifdMax);
    printf("	cbFdOffset:	%8ld\n", vahdr.cbFdOffset);
    printf("	ilineMax:	%8ld\n", vahdr.ilineMax);
    printf("	cbLineOffset:	%8ld\n", vahdr.cbLineOffset);
    printf("	issMax:		%8ld\n", vahdr.issMax);
    printf("	cbSsOffset:	%8ld\n", vahdr.cbSsOffset);
    printf("	isymMax:	%8ld\n", vahdr.isymMax);
    printf("	cbSymOffset:	%8ld\n", vahdr.cbSymOffset);
    printf("	isymGl:		%8ld\n", vahdr.isymGl);
    printf("	isymGlMax:	%8ld\n", vahdr.isymGlMax);
    printf("	iauxMax:	%8ld\n", vahdr.iauxMax);
    printf("	cbAuxOffset:	%8ld\n", vahdr.cbAuxOffset);
    printf("	itdMax:		%8ld\n", vahdr.itdMax);
    printf("	cbTdOffset:	%8ld\n", vahdr.cbTdOffset);

    vindent = 0;
    printf("\n\nSYMBOLS:\n\n");
    for (i = 0 ; i < visymMac; i++) {
	if (vrgSym[i].st == stEnd)
	    vindent--;
	PrintIndent();
	printf("%d. ", i);
	PrintSym(vrgSym + i);
    } /* for */

    printf("\n\nGLOBALS:\n\n");
    for (i= 0 ; i < visymGlMac; i++)
	PrintSym(vrgSymGlobal + i);

    printf("\n\nTYPEDEFS\n\n");
    for (i= 0, td = vrgTd; i < vitdMac; td++, i++) {
	printf("%2d: %s  ", i, SbFIss(td->iss));
	PrintSym(vrgSym + td->isym);
    } /* for */

    printf("\n\nPROCS:\n\n");
    PrintProcs();

    printf("\n\nFILES:\n\n");
    PrintFiles();
} /* PrintAll */
