/* $Header: sym.c,v 1.6 86/06/26 12:17:05 peter Exp $ */
/* (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */

#include "trans.h"

export int4	visym, visymMac, visymMax = 0;
export pSYMR	vrgSym;	/* symbol table */
export int4	visymGl, visymGlMac, visymGlMax = 0;
export pSYMR	vrgSymGlobal;	/* Global symbol table */
export pSYMR	vsym;	/* symbol associated with visym OR visymGl */

#define istackMax	100
local int4	vrgIsymStack[istackMax];
local int	vistack = 0;


/* P U S H   I S Y M */

export void PushIsym(isym)
int4	isym;
{
    if (vistack >= istackMax)
	Panic("Symbol stack overflow");

    vrgIsymStack[vistack++] = isym;
} /* PushIsym */


/* I S Y M   F   P O P */

export int4 IsymFPop()
{
    if (vistack <= 0)
	Panic("Symbol stack underflow");

    return(vrgIsymStack[--vistack]);
} /* SymFPop */


/* I S Y M   F   S Y M */

export int4 IsymFSym(sym)
pSYMR	sym;
{
    return(sym - vrgSym);
} /* IsymFSym */


/* S Y M   F   I S Y M */

export pSYMR SymFIsym(isym)
int4	isym;
{
    dprint(10, ("SymFIsym:\t%ld\t%ld\n", isym, visym-isym));
    return(vrgSym + isym);
} /* SymFIsym */


/* S Y M   F   A L L O C */

export pSYMR SymFAlloc(iss, st, sc, value, index)
int4	iss;
int2	sc, st;
int4	value, index;
{
    FAST pSYMR	sym;
    static SYMR	asymZeroes;

    if (visymMac >= visymMax)
	Panic("Symbol table overrun");
	/* "can't happen" .... */

    visym = visymMac++;
    vsym = sym = vrgSym + visym;
    sym->iss = iss;
    sym->value = value;
    sym->st = st;
    sym->sc = sc;
    sym->index = index;
    return(sym);
} /* SymFAlloc */


/* S Y M   F   G L O B A L */

export pSYMR SymFGlobal(iss, st, sc, value)
int4	iss;
int2	sc, st;
int4	value;
{
    FAST pSYMR	sym;

    if (visymGlMac >= visymGlMax) {
	visymGlMax *= 2;
	vrgSymGlobal = (pSYMR) realloc(vrgSymGlobal, visymGlMax * cbSYMR);
	if (vrgSymGlobal == symNil)
	    Panic("Global symbol table overrun");
    } /* if */

    visymGl = visymGlMac++;
    vsym = sym = vrgSymGlobal + visymGl;
    sym->iss = iss;
    sym->value = value;
    sym->st = st;
    sym->sc = sc;
    sym->index = 0;
    return(sym);
} /* SymFGlobal */
