/* (C) Copyright 1985 Third Eye Software, Inc. - All Rights Reserved */
/* $Header: type.c,v 1.26 86/09/18 07:58:04 peter Exp $ */

#include "trans.h"

export int4	vipd, vipdMac, vipdMax = 0;	
export pPDR	vrgPd;	/* procedure descriptors */
export int4	vifd, vifdMac, vifdMax = 0;
export pFDR	vrgFd;	/* file decriptors */
export int4	viline, vilineMac, vilineMax = 0;
export pLINER	vrgLine;	/* line info */
export int4	vitd, vitdMac, vitdMax = 0;
export pTDR	vrgTd;		/* typedefs */

export int4	visymProc;
export int4	visymEnd;
export FLAGT	vfWarnUndefined = false;
export ADRT	vdotStart;
export ADRT	vdotEnd;		/* adr current file ends at */
export FLAGT	vfDidLastFile;		/* obscure hack for Motorola LD */
export FLAGT	vfDidText;		/* detects files w/o file symbol */
export int4	visymFile;
export int	vlc = lcC;		/* language code for current file */

export FLAGT	vfAlsoEqual = ALSO_EQUAL;
int		vcsymProc = 0;
ADRT		vadrProc = adrNil;
int		vilnProc;


/* I A U X   F   I S Y M E N T */

export int4 IauxFIsyment(isyment)
int4	isyment;
{
    int4	iaux = iauxNil;

    /* check for garbage in the tagndx field OR the mapping array */
    if ((isyment >= vcsym) OR (isyment < 0)) {
	printf("Warning: %d: %s had its type info garbaged (isyment: %ld)\n",
		    vcsymCur, vsbEnt, isyment);
    } else if (isyment == 0) {
	iaux = iauxNil;
    } else {
	iaux = vmpIsymentIaux[isyment];
	if ((iaux < 0) OR (iaux >= viauxMac)) {
	    printf("Warning: %d: %s had its type info garbaged (iaux: %ld)\n",
		    vcsymCur, vsbEnt, iaux);
	    iaux = iauxNil;
	} /* if */
    } /* if */
    return(iaux);
} /* IauxFIsyment */


/* A D D   T D */

export void AddTd(sym)
pSYMR	sym;
{
    int4	i, iss;
    pTDR	td;

    iss = sym->iss;
    for (i = 0, td = vrgTd; i < vitdMac; i++, td++)
	if (td->iss == iss)
	    return;	/* we already have it */

    if (vitdMac >= vitdMax) {
	vrgTd = (pTDR) realloc(vrgTd, vitdMax*2*cbTDR);
	if (vrgTd == 0)
	    Panic("Ran out of memory - typedef table expansion");
	vitdMax *= 2;
    } /* if */
    vitd = vitdMac++;
    vrgTd[vitd].iss = sym->iss;
    vrgTd[vitd].isym = IsymFSym(sym);
} /* AddTd */


/* D O   T Y P E D E F */

export void DoTypedef()
{
    pSYMR	sym;
    int4	isym;
    int4	iaux;

    if (vauxent != 0) { /* we have a pointer to parent */
	iaux = IauxFIsyment(vauxent->x_sym.x_tagndx);
	if (iaux != iauxNil) {
	    isym = AuxFIaux(iaux + 1)->isym;
	    sym = SymFIsym(isym);
	    if (sym->iss == issNil)
		sym->iss = IssFSb(vsbEnt);
	} /* if */
    } /* if */
} /* DoTypedef */


/* D O   E N U M */

export void DoEnum() 
{
    /* generate the syms for beginning, ending and members of
     *	a enum and return an iaux to the type pointing at this
     *	enum.
     */
    pSYMR	sym;			/* sym for the beginning of enum */
    pSYMR	symField;		/* sym used for its fields and stEnd */
    int4	isymStart;		/* isym for this symbol */
    AUXU	aaux;

    /* get sym and init for Enum */
    sym = SymFAlloc(issNil, stBlock, scInfo, 0L, 0L);
    isymStart = visym;
    if (*vsbEnt == '.') 
	sym->iss = issNil;
     else
	sym->iss = IssFSb(vsbEnt);

    /* put out an aux that will be used when refering to this type.  */
    vmpIsymentIaux[vcsymCur] = IauxFAdd(AuxFBt(btEnum));
    aaux.isym = isymStart;
    IauxFAdd(&aaux);

    /* get the members */
    while ((NextSyment())->n_sclass == C_MOE) {
	symField = SymFAlloc(IssFSb(vsbEnt), stMember, scInfo,
			vsyment->n_value, 0L);
    } /* while */

    /*
     * put out end of enum with a link back to the front
     *	and link original sym to the next symbol.
     */

    SymFIsym(isymStart)->index = visym + 2;
    symField = SymFAlloc(issNil, stEnd, scInfo, 0L, isymStart);
} /* DoEnum */


/* D O   S T R U C T */

export void DoStruct(bt) 
int2	bt;
{
    /*
     * put out the syms and auxs for the beginning, end, and
     *	fields of a structure or union. Return an iaux that
     *	can be used refering to the struct or union.
     */
    pSYMR	sym;		/* sym for the str/un */
    FAST pSYMR	symField;	/* sym used for fields and stEnd */
    FAST int4	iauxType;	/* iaux for type of field */
    int4	isymStart;
    int2	sclass, cb;		/* size of structure/union */
    AUXU	aaux;

    /* get sym for beginning, set st as passed */
    if (vlc == lcC) {
	sym = SymFAlloc(issNil, stBlock, scInfo,
		    vauxent->x_sym.x_misc.x_lnsz.x_size, 0L);
    } else if (vlc == lcFortran) {
	sym = SymFAlloc(issNil, stCommon, scInfo, adrNil, 0L);
    } /* if */

    isymStart = visym;
    if (*vsbEnt == '.') 
	sym->iss = issNil;
     else
	sym->iss = IssFSb(vsbEnt);

    /* generate aux to be referenced when refering to this struct */
    vmpIsymentIaux[vcsymCur] = IauxFAdd(AuxFBt(bt));
    aaux.isym = isymStart;
    IauxFAdd(&aaux);

    sclass = (bt == btStruct ? C_MOS : C_MOU);

    while ( ((NextSyment())->n_sclass == sclass)
	   OR (vsyment->n_sclass == C_FIELD) ) {
	symField = SymFAlloc(IssFSb(vsbEnt), stMember, scInfo,
		vsyment->n_value, IauxFSyment(vsyment));
	if (vsyment->n_sclass == C_FIELD) {
	    symField->sc = scBits;
	    aaux.width = vauxent->x_sym.x_misc.x_lnsz.x_size;
	    IauxFAdd(&aaux);
	} else {
	    symField->value *= 8; /* need offset in BITS */
	} /* if */
    } /* while */

    /* 
     * put out end of struct with a link back to the front
     *	and link original sym to the next symbol.
     */
    SymFIsym(isymStart)->index = visym + 2;
    symField = SymFAlloc(issNil, stEnd, scInfo, 0L, isymStart);
} /* DoStruct */


/* I A U X  F  S Y M E N T */

export int4 IauxFSyment(syment)
pSYMENTR	syment;
{
    FAST int	i;
    int		type, dt, bt, cDim;
    int4	iauxRet, iaux;
    AUXU	aaux;

    static short	mpCoffBt[] = {
	    btInt,	/* bt null */
	    btNil,	/* unknown */
	    btChar, btShort, btInt, btLong, btFloat,
	    btDouble, btStruct, btUnion, btEnum, btEnum,	/* member */
	    btUChar, btUShort, btUInt, btULong
	    };

    static short mpDtTq[] = { tqNil, tqPtr, tqProc, tqArray };

    if ((syment->n_type == 0)
       AND (syment->n_sclass == C_EXT)
       AND (syment->n_scnum == 1)) {
	/* its a 'stripped' procedure name */
	return(viauxProcPhony);
    } /* if */

    bt = mpCoffBt[BTYPE(syment->n_type)];
    iauxRet = IauxFAdd(AuxFBt(bt));

    if (FComplexBt(bt)) {
	if (vauxent != 0) {
	    iaux = IauxFIsyment(vauxent->x_sym.x_tagndx);
	    if (iaux == iauxNil)
		vauxent = 0;	/* loader or someone trashed the COFF info */
	} /* if */

	if (vauxent == 0) {
	    /* This is a weird case.  We have a pointer to
	     * a structure (enum, union,.. ) that was never
	     * defined OR was forward referenced.  We handle
	     * it by changing them to a pointer to CHAR.
	     */
	    if (vfWarnUndefined)
		printf("Warning: %s references an undefined type\n", vsbEnt);
	    iauxRet = IauxFAdd(AuxFBt(btChar));
	    return(iauxRet);
	} else {
	    IauxFAdd(AuxFIaux(iaux+1));
	} /* if */
    } /* if */

    /* Pick up type qualifier information */
    cDim = 0;
    for (type = syment->n_type >> 4; type != 0; type >>= 2) {
	dt = type & 03;
	switch (dt) {
	    case DT_PTR:
		if ((vlc == lcFortran) AND (vsym->st == stParam)) {
		    PatchTq(iauxRet, tqRef);
		} else {
		    PatchTq(iauxRet, mpDtTq[dt]);
		}
		break;
	    case DT_ARY:
		cDim++;
	    case DT_FCN:
		PatchTq(iauxRet, mpDtTq[dt]);
	} /* switch */
    } /* for */

    if (vlc == lcFortran) {
	/* we stack dimensions in opposite order from C */
	for (i = 0; i < cDim; ++i)
	    AddDim(vauxent->x_sym.x_fcnary.x_ary.x_dimen[i]);
    } else {
	/* we stack dimensions in opposite order */
	for (i = cDim-1; i >= 0; i--)
	    AddDim(vauxent->x_sym.x_fcnary.x_ary.x_dimen[i]);
    } /* if */
	
    return(iauxRet);
} /* IauxFSyment */


/* E N D   F I L E */

export void EndFile(adr)
ADRT	adr;
{
    register pSYMR	sym;

    if (visymProc != isymNil)
	EndProc(adr);

    sym = SymFAlloc(issNil, stEnd, scText, adr, visymFile);
    sym = SymFIsym(visymFile);
    sym->index = visym + 1;	/* forward link */

    if ((vifdMac > 0) AND (sym->value == adrNil)) {
	sym->value = vdotStart;
	vrgFd[vifd].adr = vdotStart;
    } /* if */

    visymFile = isymNil;
    visymEnd = isymNil;
} /* EndFile */


/* D O   F I L E */

export void DoFile (adr, sbName)
ADRT	adr;
SBT	sbName;
{
    register pFDR	fd;
    register pSYMR	sym;
    int	cb;

    if ((vifdMac > 0) AND (adr == adrNil))
	adr = vdot;

    if (visymFile != isymNil)
	EndFile(adr);

    if (vifdMac >= vifdMax) {
	vifdMax *= 2;
	vrgFd = (pFDR) realloc(vrgFd, vifdMax * cbFDR);
	if (vrgFd == 0)
	    Panic("Ran out of memory - file table expansion");
    } /* if */

    vifd = vifdMac++;
    fd = vrgFd + vifd;

    cb = strlen(sbName);
    fd->iss = fd->issShort = IssFSb(sbName);
    fd->adr = adr;
    fd->ipd = ipdNil;
    fd->isym = visymMac;
    fd->iline = vilineMac;
    fd->rgLn = 0;
    vlc = (sbName[cb-1] == 'f') ? lcFortran : lcC;
    fd->lc = vlc;

    sym = SymFAlloc(fd->iss, stFile, scText, adr, 0L);

    visymFile = visym;
    viauxFile = viaux;
    vdotEnd = adrNil;
    vdotStart = adr;
    vfDidText = false;
} /* DoFile */


/* F I X  F D */

export void FixFd()
{
    register pFDR	fd;
    register pPDR	pd;
    register int	ifd;
    register int	ipd;

    if (visymFile != isymNil)
	EndFile(vdot); /* maybe adrText + cbText? */

    /* synchronize the fd's and pd's */
    fd = vrgFd + 1;
    pd = vrgPd;
    for (ipd = ifd = 0; ifd < vifdMac; ifd++, fd++) {
	if (fd->adr == adrNil)
	    continue; /* nothing there */
	while ((ipd < vipdMac) && (fd->adr > pd->adr)) {
	    ipd++;
	    pd++;
	} /* while */
	fd->ipd = ipd;
	if (SymFIsym(pd->isym)->st == stNil)
	    pd->iline = 0;
	fd->iline = pd->iline;	/* is this always correct? */
    } /* for */
} /* FixFd */


/* E N D   P R O C */

export void EndProc(adr)
ADRT	adr;
{
    int4	isymBlock;
    pSYMR	sym;
    pSYMR	symBlock;
    AUXU	aaux;

    if (vfBlockAdded) {	/* we added a block */
	isymBlock = IsymFPop();
	SymFAlloc(issNil, stEnd, scText, adr, isymBlock);
	symBlock = SymFIsym(isymBlock);
	symBlock->index = visym + 1;
	vfBlockAdded = false;
    } /* if */

    sym = SymFAlloc(issNil, stEnd, scText, adr, visymProc);
    visymEnd = visym;
    aaux.isym = visymMac;
    ChangeAux(SymFIsym (visymProc)->index, &aaux);

    if (vcsymProc != 0)
	DoProcLines();
    vcsymProc = 0;

    visymProc = isymNil;
    vfAlsoEqual = ALSO_EQUAL;
} /* EndProc */


/* D O   L I N E */

export void DoLine(iln, adr)
int	iln;
ADRT	adr;
{
    if (vilineMac >= vilineMax)
	Panic("Ran out of line entries"); /* "can't happen" ..... */
    viline = vilineMac++;

    vrgLine[viline].iln = iln;
    vrgLine[viline].dadr = adr - vrgPd[vipd].adr;
    vdot = adr;
} /* DoLine */


/* D O   P R O C   L I N E S */

export void DoProcLines()
{
    struct lineno	alineno;
    ADRT	adr;
    int		i, iline;

    if (ldlinit(vlfdLines, vcsymProc) == FAILURE)
	return;

    iline = 1;
    i = 0;
    while (ldlitem(vlfdLines, iline, &alineno) != FAILURE) {
	adr = alineno.l_addr.l_paddr;
	if ((i != 0) AND (vadrProc == adr))
	    vilineMac--;	/* throw away the previous line */

	if ( (vadrProc < adr) OR (vfAlsoEqual AND (vadrProc == adr)) ) {
	    DoLine(alineno.l_lnno + vilnProc, adr);
	    i++;
	} /* if */

	iline = alineno.l_lnno + 1;
    } /* while */
} /* DoProcLines */


/* D O   P R O C  */

export void DoProc(adr)
ADRT	adr;
{
    int4	iaux;
    pSYMR	symProc;
    pSYMR	sym;
    AUXU	aaux;

    /* this procedure is called when we hit ".bf" fcn symbol, note
     * that we assume visym points to the symbol containing the name
     * and type of the procedure we are just starting.
     */

    visymProc = visym;
    symProc = SymFIsym(visymProc);

    aaux.isym = isymNil;
    iaux = symProc->index;
    symProc->index = IauxFAdd(&aaux); 	/* leave room for isymLast */
    IauxFCopy(iaux); /* and then copy its goodies after it */
    symProc->st = stProc;

    ProcInsert(visymProc, symProc->value, vilineMac);
    vcsymProc = vcsymCur - 2;
    vadrProc = adr;
    vilnProc = vauxent->x_sym.x_misc.x_lnsz.x_lnno - 1;
} /* DoProc */


/* P R O C   I N S E R T */

export void ProcInsert(isym, adr, iline)
FAST int4	isym;
FAST ADRT	adr;
FAST int2	iline;
{
    FAST pPDR	pd;
    FAST int	ipd;
    int		ipdLast, ipdInsert;
    pSYMR	sym;

    /* first fix the last end's address */
    if (visymEnd > 0) {
	sym = SymFIsym (visymEnd);
	sym->value = adr;
	sym = SymFIsym(visymEnd-1);	/* and the guy before him, too! */
	if (sym->st == stEnd)
	    sym->value = adr;
	visymEnd = 0;
    } /* if */

    ipdLast = vipd;
    if (vipdMac >= vipdMax) {
	vipdMax *= 2;
	vrgPd = (pPDR) realloc(vrgPd, vipdMax * cbPDR);
	if (vrgPd == 0)
	    Panic("Ran out of memory - procedure table expansion");
    } /* if */

    vipd = vipdMac++;
    ipd = vipd;

    if ((vipd >= 1) AND (adr < vrgPd[ipdLast].adr)) {
	/* We must insert, not append.
	 * 	First, walk backward, find the place, move the rest up and
	 *	set up the pointer.
	 */
	pd = vrgPd;
	for (ipd = 0; pd->adr < adr; ipd++, pd++)
	    ;

/* 	ipdInsert = (ipd == 0) ? 0 : (ipd - 1); */
 	ipdInsert = ipd;

	if ((ipd >= 0)
	    AND (SymFIsym(pd->isym)->iss == SymFIsym(isym)->iss)) {
	    /* This is a duplicate of the previous entry */
	    vipdMac--;
	    vipd = ipdLast;
	    return;
	} /* if */

	for (ipd = vipdMac-1; ipd > ipdInsert; ipd--) {
	    vrgPd[ipd] = vrgPd[ipd-1];
	} /* for */

	ipd = ipdInsert;
    } /* if */

    pd = vrgPd + ipd;
    pd->isym = isym;
    pd->adr = adr;
    pd->iline = iline;
    pd->dadrRegBase = adrNil;

    if (vrgFd[vifd].adr == adrNil) {
	/* use the addr of this routine */
	SymFIsym(visymFile)->value = adr;;
	vrgFd[vifd].adr = adr;
    } /* if */
} /* ProcInsert */
