#include "uupurge.h"
#include <sys/types.h>
#include <sys/stat.h>

/* ARGSCAN - process input arguments
 *    ARGSCAN(argc,argv)
 *       args from main of course
 *    
 *----------------------------------------------------------------
 *         SYNTAX:
 *            uupurge [-h] [-x] [-R or -a] [-n<dir for news>] -d<target dir> [-s<target system>]
 *            NOTE:
 *              [] - indicates optional args
 *              all arguments are keyword, not positional.
 *              <> - indicates that info must be supplied
 *
 *             -h: print usage examples
 *
 *             -x: print debug stuff
 *
 *             -R: remove (unlink) news files (if -s is used then
 *                 only affects news files for that system)
 *                 if this command is not used, an argument
 *                 must exist for where to move the news files.
 *            
 *             -a: move all of the files. Mutually exclusive with
 *                 -R above.
 *
 *             -d: directory to where files are copied. This
 *                 argument is mandatory.
 *
 *             -s: if supplied, files for this remote system
 *                 only will be copied to the target directory.
 *                 If not suppled will default to ALL uucp files.
 *
 *             -n: if supplied, and -a NOT USED, then
 *                 this specifies the dir where the news is headed
 * 
 *             -i: ignore link and copy errors - just keep on going
 *                 This arg might be of use if uucp is running and
 *                 you want to try and move things anyway. It is
 *                 not recommended.
 *------------------------------------------------------------------
 *
 *      PURPOSE: parse input args
 *      
 *      
 *      EXTERNALS:
 *         vars:   
 *                    flags listed below as externs
 *      CALLS:       
 *
 *               syntax     -   this file
 *               fprintf    -   UPM(3)
 *               exit       -   UPM(2)
 *               strcpy     -   UPM(3)
 *               stat       -   UPM(2)
 *               printhelp  -   this file
 *               sprintf    -   UPM(3)

 *      CALLED BY:
 *                    main
 *	return codes:
 *                    none

 */

extern int dirflag;      /* target dir supplied - if not then removes
			  * files without moving them anywhere
			  */
extern int Rflag;        /* remove news */
extern int aflag;        /* move all files */
extern int sflag;        /* target system prefix has been supplied */
extern int nflag;        /* target dir for news specified */
extern int iflag;        /* IGNORE link and copy errors - dangerous */

ARGSCAN(argc,argv)
int argc;
char **argv;
{     

	struct stat buf;

        nflag = dirflag = iflag = Rflag = aflag = sflag = 0;
        
	Debug = 0;

        if (argc < 2)  {	
		syntax();
        }

	while(argc>1 && argv[1][0] == '-'){
		switch(argv[1][1]){
		case 'R':
			Rflag = 1;
			if (aflag || nflag)
			  syntax();
			break;
		case 'a':
			aflag = 1;
			if (Rflag || nflag)
			  syntax();
                        break;
		case 'n':
                        nflag = 1;
			if (aflag) { 
	                     fprintf(stderr,"-a flag overrides -n flag - everything goes to -d directory\n");
			     exit(0);
			}
			if (Rflag) 
			    syntax();
			strcpy(ndestdir,&argv[1][2]);
			stat(ndestdir,&buf);
			if ( ! (buf.st_mode & S_IFDIR ) ) {
			    fprintf(stderr," -n arg %s cannot be accessed\n",destdir);
			    exit(0);
			}
                        break;
		case 'd':
                        dirflag = 1;
			strcpy(destdir,&argv[1][2]);
			stat(destdir,&buf);
			if ( ! (buf.st_mode & S_IFDIR ) ) {
			    fprintf(stderr," -d arg %s cannot be accessed\n",destdir);
			    exit(0);
			}
                        break;
                case 'h':
			printhelp();
			exit(0);	
		case 's':
			sprintf(Rmtname,"%.7s",&argv[1][2]);
			sflag = 1;
			break;
                case 'x':
			Debug = 1;
			break;
                case 'i':
			iflag = 1;
			break;
		default:
			fprintf(stderr,"unknown flag %s\n", argv[1]);
			exit(0);
		}
		--argc;  argv++;
	}

	if ( !dirflag ) {
	   fprintf(stderr,"must have -d arg for where to move files \n");
           exit(0);
        }

}


syntax() {

	fprintf(stderr,"syntax error: uupurge [-h,-R || -a] -n<dirname>  -d<dirname> [-s<sysname>]\n");
	exit(0);
}

printhelp() {

fprintf(stdout,"1. uupurge -sbronze -n/usr/public/bnews -d/usr/public/bmail\n");
fprintf(stdout,"-- move news for bronze to bnews and rest to bmail\n");
fprintf(stdout,"2. uupurge -R -sdadla -d/usr/public/lamail\n");
fprintf(stdout,"-- remove news and move rest to lamail\n");
fprintf(stdout,"3. uupurge -a -sdadla -d/usr/public/lauucp\n");
fprintf(stdout,"-- move all uucp files for dadla to lauucp directory\n");
}
