#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#define UFILESIZ 15
/*******
 *	getdirent(p, filename) 
 *	FILE *p;        input:   file descriptor for directory
 *	char *filename; output:  filename found in directory
 *      PURPOSE:
 *               - get next file name from directory
 *      EXTERNS:
 *              constants:
 *                      UFILESIZ
 *                      DIRSIZ
 *      CALLS:
 *              fread() - UPM(3)
 *      CALLED BY:
 *              getworklist() - getwklist.c
 *	return codes:
 *		0  -  end of directory read
 *		1  -  returned name
 */


getdirent(p, filename)
FILE *p;
char *filename;
{
	static struct direct dentry;       /* structure of dir entry */
	int i;
	char *s;

	/* loop
	 * until we find a dir entry
	 * with a non zero inode
	 */

	while (1) {
		if (fread((char *)&dentry,  sizeof(dentry), 1, p) != 1)
			return(0);
		if (dentry.d_ino != 0)
			break;
	}
	/* copy the found filename into
	 * the external filename
         */

	for (i = 0, s = dentry.d_name; i <= DIRSIZ; i++)
		if ((filename[i] = *s++) == '\0')
			break;
	filename[UFILESIZ] = '\0';    /* zap the last possible
				      * char with a null
				      * just in case dir entry
				      * is full 14 chars
				      */
	return(1);
}
