h55865
s 00000/00000/00317
d D 1.2 83/05/12 15:11:34 jan 2 1
c USENIX Distribution version
e
s 00317/00000/00000
d D 1.1 82/10/06 12:23:43 jan 1 0
e
u
U
t
T
I 1
#
/*
Name:
	INITIATE Calendar System Command

Function:
	Set up all files and directories needed to use the calendar system

Algorithm:
	Create all directories and files needed for the calendar system.

Parameters:
	$HOME is the home directory.

Returns:
	ENOERR	Normal exit
	ENOENT	Bad home directory
	EBRK	Cannot create file or directory
	EACCES	Cannot open file
	ESPIPE	Bad seek

Files and Programs:
	home-dir/exec				the main calendar directory
	home-dir/exec/appointments		the appointemnts directory
	home-dir/exec/appointments/temp.appts	temporary appointment file
	home-dir/exec/auth.inputters		authorized users list
	home-dir/exec/suspenses			the suspenses directory
	home-dir/exec/dolist			the dolist directory

Installation Instructions:
	cc -o $EXECDIR/initiate initiate.c library
	Change owner to root
	Deny write permissions except for owner

History:
	Oct 79,	Release 1 Version 1, G. Maltagliati, coded in shell
	Nov 80,	Release 5 Version 1, Sgt G. Keith, coded in C for efficiency
	Jul 82, updated to use on Perkin-Elmer version 7 by L. Reed.
	Aug 82, Release 7 Version 2, J. Neyer rewrite exec support


*/
#include <stdio.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "../includes/error.h"
#include "../includes/getdef.h"
#define NOPWD "initiate:  cannot execute pwd\n"
#define NOPIPE "initiate:  cannot create needed pipe\n"
#define APPTDIR "exec/appointments"
#define TMPAPPTS "exec/appointments/temp.appts"
#define DODIR "exec/dolist"
#define DO "exec/dolist/do"
#define EXECDIR "exec"
#define AUTHIN "exec/auth.inputters"
#define SUSPDIR "exec/suspenses"
#define COMPLETE "Calendar system initiation complete\n"

char   *homedir;		/* the home directory ($HOME) */
struct stat stbuf;

char id[] = "%W% %H%";

/*

Name:
	main

Function:
	Create and initiate all directories and files needed for the calendar
	system

Algorithm:
	Make all necessary directories/files and place information in the
	files that need them

Parameters:
	None

Returns:
	ENOERR	Normal exit
	ENOENT	Bad home directory
	EBRK	Cannot create directory or file

Files and Programs:
	home-dir/exec				the main calendar directory
	home-dir/exec/appointments		the appointemnts directory
	home-dir/exec/appointments/temp.appts	temporary appointment file
	home-dir/exec/auth.inputters		authorized users list
	home-dir/exec/suspenses			the suspenses directory
	home-dir/exec/dolist			the dolist directory


*/
main( argc, argv, envp)

int argc;
char **argv, **envp;

{
    char    buffer[32],
	    *getlogin(),
           *buf_ptr;

    char in_str[10];            /* holds user respnse */
    char *answer;		/* points to user response */
    char *findenv();
    char *log_name;		/* user id login name */
    struct passwd *pw;		/* used to get login name */
    int  wstat;			/* holds status from wait call */
    FILE *fp;			/* stream i/o pointer */

    homedir = findenv("HOME", envp);
    dir_check();		/* see if we are in bad directory */
    if (chdir(homedir))	/* go to $HOME */
    {
	printf ("initiate : cannot change to $HOME\n");
	exit (ENOENT);
    }
    if (stat(EXECDIR, &stbuf) == 0) {
	printf("Already initialized.\n");
	printf("Do you wish to re-initialize, destroying all current data?\n");
	printf("Enter reinit to do so: ");
	if (strcmp("reinit\n", (answer = fgets(in_str, 10, stdin))))    {
		printf("\ninitialization cancelled\n");
		exit(EBRK);
	}
	printf("Re-initializing\n");
	if (fork() == 0) {
		execl("/bin/rm", "rm", "-rf", "exec");
		exit(EBRK);
	}
	wait(&wstat);
	if (wstat >> 8) {
		printf("Could not re-initialize\n");
		exit(EBRK);
	}
    }


    new_dir (EXECDIR, 0777);
    new_dir (DODIR, 0777);
    new_dir (APPTDIR, 0777);
    new_dir (SUSPDIR, 0777);

    new_file (TMPAPPTS, 0666);
    new_file (DEFAULT, 0666);
    new_file (DO, 0666);

    if ((log_name = getlogin()) == NULL) {
	pw = getpwuid(getuid());
	log_name = pw->pw_name;
    }
    buf_ptr = copy(log_name, buffer);
    buf_ptr = copy ("\nroot\n", buf_ptr);				/* Copy user name 'root' to buffer */
    writafile (AUTHIN, 0644, buffer, buf_ptr - buffer);
    buf_ptr = copy("/u/", buffer);
    buf_ptr = copy(log_name, buf_ptr);
    buf_ptr = copy("/exec/dolist/do\n", buf_ptr);
    writafile(DEFAULT, 0666, buffer, buf_ptr - buffer);
    fprintf(stderr, COMPLETE);                          /* Print completed message */
    exit (ENOERR);
}
/*

Name:
	writafile

Function:
	Create a new file with the given data.

Parameters:
	file		the file to be written to
	mode		the mode of the file used in creat
	string		the information to be written to the file
	len		the length of the string

Returns:
	EACCES	Cannot open file

Files and Programs:
	None


*/
writafile (file, mode, string, len)
char   *file,						/* Pointer to output file */
       *string;						/* Pointer to input string or file */
int    mode, len;
{
    int     fd;
    if ((fd = creat (file, mode)) < 0)
    {
	printf ("initiate : cannot create %s\n", file);
	exit (EACCES);
    }
    write (fd, string, len);		/* write it out */
    close (fd);
}
/*

Name:
	new_file

Function:
	Make a file entry as specified.

Parameters:
	The file name.
	The mode of the file.

*/
new_file(file, mode)

char *file;		/* the file name */
int mode;		/* the mode of the file */

{
	int fd;		/* file desc */

	if ((fd = creat(file, mode)) == -1) {
		printf("intitiate: could not create %s\n", file);
		exit(EBRK);
	}
	close(fd);
}
/*

Name:
	new_dir

Function:
	make a new directory

Parameters:
	file name
	mode of directory

Programs:
	Invokes /bin/mkdir to do the real work.

*/
new_dir(file, mode)

char *file;
int mode;

{
	int wstat;		/* wait status */
	if (fork() == 0) {
		execl("/bin/mkdir", "mkdir", file, 0);
		printf("initiate:  could not run mkdir");
		exit(EBRK);
	}
	wait(&wstat);
	if (wstat >>= 8)
		exit(EBRK);
	chmod(file, mode);
}
/*
Name:
	dir_check

Function:
	Make sure that the current directory is not in the part of
	the directory structure to be deleted.  If it is, print a
	message and exit.  Otherwise, return to the calling routine.

Algorithm:
	Fork a copy of pwd and pipe its output back to get the working
	directory.  Then see if $HOME/exec is a prefix for it.
	If it is, then we have a problem.

*/
dir_check()

{
	int pp[2];		/* the pipe */
	register char c, *h;
	static char execdir[] = EXECDIR;
	FILE *fp;

	if (pipe(pp)) {
		fprintf(stderr,NOPIPE);
		exit(EPIPE);
	}
	if (fork() == 0) {
		close (pp[0]);		/* parent will read */
		dup2(pp[1], 1);		/* pipe to stdout */
		close (pp[1]);		/* don't need this now */
		execl("/bin/pwd", "pwd", 0);
		fprintf(stderr, NOPWD);
		printf("%s/%s\n", homedir, EXECDIR);  /* cause parent fail */
		fclose (stdout);
		exit();
	}
	wait(0);
	close (pp[1]);		/* child will write */
	fp = fdopen( pp[0], "r");	/* use stream input */
	h = homedir - 1;
	while ((c = (char) getc(fp)) == *++h);
	if (*h || c == '\n') {
		fclose (fp);
		return;		/* not below home */
	}
	h = &execdir[-1];	/* will get location before string */
	while ((c = (char) getc(fp)) == *++h);
	if (*h || ( c != '/' && c != '\n')) {
		fclose (fp);
		return;
	}
	printf( "Cannot reinitiate with current directory below %s/exec\n",
		homedir);
	fclose (fp);
	exit(EPIPE);
}
E 1
