#include <stdio.h>
/*

Name:
	itoa

Function:
	Convert an integer to an ascii string

Algorithm:
	Start in the 10**4 position and work down until the first digit is
	found. From then on add an ascii '0' to the character in each position
	and place in a character array until the 10**0 position is reached.

Parameters:
	num	the integer to be converted to ascii
	places  number of places for leading zeros

Returns:
	A pointer to the beginning of the character array

Files and Programs:
	None


*/


char *itoa (num, places)
int     num, places;                                    /* The number to be converted to an  ascii string */
{                                                       /*  and the number of places it is to hold...leading zero insertion */
    static char id[] = "%W% %H%";
    static char ascii[7];                               /* The character string where the ascii number is stored */
    register int    i = 0,				/* An index into ascii */
                    flag = 0;				/* Indicates if the first digit of the number has been reached */



    if (num >= 1000000)  {
	fprintf(stderr, "itoa: conversion error...too large\n");
	return(NULL);
    }
    if (num / 100000 != 0)
    {
	flag = 1;
	ascii[i++] = num / 100000 + '0';
	num - = num / 100000 * 100000;
    }
    else
	if (places)
	    ascii[i++] = '0';
    if (num / 10000 != 0 || flag == 1)
    {
	flag = 1;
	ascii[i++] = num / 10000 + '0';
	num - = num / 10000 * 10000;
    }
    else
	if (places)
	    ascii[i++] = '0';
    if (num / 1000 != 0 || flag == 1)
    {
	flag = 1;
	ascii[i++] = num / 1000 + '0';
	num - = num / 1000 * 1000;
    }
    else
	if (places)
	    ascii[i++] = '0';
    if (num / 100 != 0 || flag == 1)
    {
	flag = 1;
	ascii[i++] = num / 100 + '0';
	num - = num / 100 * 100;
    }
    else
	if (places)
	    ascii[i++] = '0';
    if (num / 10 != 0 || flag == 1)
    {
	flag = 1;
	ascii[i++] = num / 10 + '0';
	num - = num / 10 * 10;
    }
    else
	if (places)
	    ascii[i++] = '0';
    ascii[i++] = num + '0';
    ascii[i] = '\0';
    if (places)
	return(&ascii[i-places]);
    else
	return(&ascii);
}
/*              TEST STUB       */
/*
main()
{
	char *c;

	printf("%s\n", itoa(1,6));
	printf("%s\n", itoa(1,5));
	printf("%s\n", itoa(1,4));
	printf("%s\n", itoa(1,3));
	printf("%s\n", itoa(1,2));
	printf("%s\n", itoa(1,1));
	printf("%s\n", itoa(100,0));
}
*/
