/*

Name:
	julian_date

Function:
	Determine the julian date for a specified date

Algorithm:
	Find the number of days up to the month of the date given, and then
	add the day number of the date given. Return the result.

Parameters:
	date		the date in the format ddmmm
	mo_num		the number of the month
	year		the year (yy)

Returns:
	A pointer to the ascii string holding the julian date (in ascii)

Files and Programs:
	None


*/


char *julian_date (date, mo_num, year)
char   *date;						/* The date from which the julian date is to be determined */
int     mo_num,						/* The number of the month */
        year;						/* The year */
{
    static char id[] = "%W% %H%";
    static char threedjdate[4];				/* Holds the julian date in ascii */
    register int    jdate = 0;				/* The integer julian date */
    extern char *itoa();

    switch (--mo_num)					/* Find the number of days since January up to the */
							/* current month - 1 */
    {
	case 11: 
	    jdate + = 30;
	case 10: 
	    jdate + = 31;
	case 9: 
	    jdate + = 30;
	case 8: 
	    jdate + = 31;
	case 7: 
	    jdate + = 31;
	case 6: 
	    jdate + = 30;
	case 5: 
	    jdate + = 31;
	case 4: 
	    jdate + = 30;
	case 3: 
	    jdate + = 31;
	case 2: 
	    jdate + = 28;
	    if (year / 4 * 4 == year && year != 0)
		jdate++;				/* Leap year */
	case 1: 
	    jdate + = 31;
	    break;
    }
    jdate + = atoi (date);				/* Add the number of days in the date received */
    copy (itoa (jdate, 3), threedjdate);
    return (threedjdate);
}
