#include "stdtime.h"
#include <math.h>
#include "time.h"

extern struct tm *localtime();
extern long time();

DATE curtime;		/* DATE structure used for all internal operations */


TIME date(time)		/* fill DATE structure from given time */
TIME time;
{
curtime._time = time;
_stdtime();
_ymdtime();
_bartime();
_wkday();
_carrtime();
return (curtime._time);
}

static _stdtime()		/* convert TIME to year,doy,hour... */
{
long pd,sd,modsd;
long ly,ys,dy;
sd = curtime._time/86400; pd = curtime._time - 86400.0*sd;
modsd = sd + sd/36524 - sd/146096;
ly = modsd/1461;
ys = 4*ly + (modsd + 1 - 1461*ly)/365.3;
dy = modsd + 1 - floor(365.25*ys);
curtime._year = ys + 1601;
curtime._doy = dy;
curtime._hour = pd/3600;
pd -= (long)3600*curtime._hour;
curtime._minute = pd/60;
curtime._second = pd - 60*curtime._minute;
}

static int _dgb[] = {0,31,59,90,120,151,181,212,243,273,304,334,365};


static _ymdtime()		/* compute month and day from year and doy */
{
long leap,dy,n,y;
dy = curtime._doy; y = curtime._year;
leap = ( y%4 == 0 && ( y%100 != 0 || y%400 == 0));
if (leap && dy == 60) n = 2;
else
	{
	if (leap && dy>60) dy -= 1;
	for (n=1; dy>_dgb[n]; n++);
	}
curtime._day = dy - _dgb[n-1];
curtime._month = n;
curtime._dim = _dgb[n] - _dgb[n-1];
curtime._leap = leap;
}


static _getdoy()		/* compute doy from year, month, and day */
{
long d;
d = curtime._day + _dgb[curtime._month -1];
curtime._dim = _dgb[curtime._month] - _dgb[curtime._month - 1];
if(curtime._year%4==0 &&(curtime._year%100!=0 || curtime._year%400==0))
	{
	curtime._leap = 1;
	if(curtime._month > 2)		d += 1;
	if(curtime._month == 2)		curtime._dim = 29;
	}
curtime._doy = d;
}


static _bartime()		/* compute Bartels rot and bday from TIME */
{
long d;
long r;
d = curtime._time/86400 - 6;
r = d/27;
curtime._bday = d - 27*r + 1;
curtime._brot = r - 3125;
}

static _carrtime()		/* Compute Carrinton time,rot,long from TIME */
{
long deg;
curtime._Ctime = (curtime._time/86400.0 - 92353.9357)/0.0757646111;
deg = curtime._Ctime + 0.5;
curtime._Crot  = deg/360 + 1;
curtime._Clong = 360 - deg%360;
}


static _wkday()		/* compute day of week from TIME */
{
long d;
d = curtime._time/86400;
curtime._dow = d%7 + 1;
}

static help(s)
char *s;
{
printf("%s\n",s);
exit(0);
}

		/* compute DATE from year, month, day, hour... */
TIME ymdtime(year,month,day,hour,minute,second)
int year,month,day,hour,minute,second;
{
long days, ys;
if (year < 100) year += 1900;
if (month<1 || month>12 || day<1 || day>31 || hour<0 || hour>23 ||
    minute<0 || minute>59 || second<0 || second>59) 
	{
	printf("%5d%5d%5d%5d%5d%5d ",year,month,day,hour,minute,second);
	help("ymd error");
	}
curtime._year	= year;
curtime._month	= month;
curtime._day	= day;
curtime._hour	= hour;
curtime._minute	= minute;
curtime._second	= second;
_getdoy();
ys = year - 1601;
days = ys*365.25 - ys/100 + ys/400 - 1;
curtime._time = 86400.0*(days + curtime._doy) +
	    3600.0*hour + 60*minute + second;
_bartime();
_wkday();
_carrtime();
return (curtime._time);
}

TIME bartime(brot,bday)			/* get DATE from Bartels time */
int brot,bday;
{
if (bday<1 || bday>27) help("bartime day error");
return(date(86400.0 * (111407 + bday + 27*(brot-1001))));
}

		/* gets DATE from year, doy, hour... */
TIME stdtime(year,doy,hour,minute,second)
int year,doy,hour,minute,second;
{
curtime._year = year;
curtime._doy  = doy;
_ymdtime();
return ymdtime(year,curtime._month,curtime._day,hour,minute,second);
}

TIME timenow ()			/* timenow - gets present clock time */
{
struct tm *tn;
long clock;
clock = time (0);
tn = localtime (&clock);
return ymdtime(tn->tm_year+1900, tn->tm_mon+1,
	tn->tm_mday, tn->tm_hour, tn->tm_min, tn->tm_sec);
}
