/*
 *	rjefiles.h
 *
 * names of the rje system files and directories
 * these names may be modified, however any name with a xxxxxx string
 * or a directory name which is its base must remain the same number
 * of characters unless all references to these files are tracked
 * down and fixed.
 *	8-25-80
 */

char *console	"/dev/tty8";		/* site console for printing log */
char *constemp	"/rje/constemp";	/* temporary file for console output */
char *ctrlfile  "/rje/ctrl";	/* directory in which processes store id's */
char *ctrnum	"/rje/ctrl/CTRNUM";	/* last control message number assigned */
char *datafile	"/rje/data";	/* directory with info on jobs to send */
char *dufile	"/dev/du";	/* the synchronous interface communications line */
char *garbage	"/rje/out/garbage";	/* for unrecognized output */
char *jobctrl	"/rje/data/xxxxxx";	/* base for control file name */
char *jobout	"/rje/out/xxxxxx";	/* base for output file name */
char *lockfile	"/rje/lock";	/* lock on access to data file */
char *logfile	"/rje/logfile";	/* file with all logged events and all output to our console */
char *lsentfil	"/rje/ctrl/lastsent";	/* last runid sent - as text */
char *msgfil	"/rje/user_notify";	/* file in which to write user notification message */
char *outfile	"/rje/out";	/* directory in which to file U1100 output */
char *pidfile	"/rje/ctrl/protpid";	/* file with protocol's pid */
char *progfile	"/rje/prog";   /* file where non-user accessible rje programs live */
char *runtext	"/rje/data/text.xxxxxx";  /* base for job text name */
char *rtrcfile	"/rje/rectrace";	/* trace of messages to receive routine */
char *statfile	"/rje/stat";	/* current status file for enquiry */
char *tracefil 	"/rje/trace";	/* file with communications trace */
char *trnum	"/rje/ctrl/TRNO";	/* last transmittal number used */
