#
/*
 * DU-11 Synchronous interface driver
 * Modified for full duplex operation, with a half duplex protocol
 * suitable for the Univac 1100 NTR protocol
 * by David E. Miran  8-5-80.
 */

#include "../hd/param.h"
#include "../hd/user.h"
#include "../hd/buf.h"
#include "../hd/conf.h"

/* device registers */
struct {
	int	rxcsr, rxdbuf;
	int	txcsr, txdbuf;
};

struct du {
	char	*du_ibfp;
	char	*du_obfp;
	int	du_nxmit;
	char	du_mesg;
	char	du_nxlst;  /* set to 1 if next char is last input (LRC) */
	int	du_proc;
	char	*du_ibufe;
	char	*du_obufe;
	int	du_nleft;
};

	char du_bufi[256], du_bufo[128];
int	du_addr[] {0160100};
int	du_cnt {1};
struct	du	du_du[1];

#define	DONE	0200
#define	IE	0100	/* interrupt enable */
#define	SIE	040	/* data set interrupt enable */
#define CTS	020000	/* clear to send */
#define	CARRIER	010000
#define	RCVACT	04000	/* receiver active - i.e. syncs have been recognized */
#define	DSR	01000	/* data set ready */
#define STRIP	0400	/* strip sync codes */
#define SCH	020	/* sync search */
#define RTS	04	/* request to send */
#define	DTR	02	/* data terminal ready */
#define MR	0400	/* tx master reset */
#define SEND	020	/* activate transmitter */
#define	HALF	010

#define	READ	0
#define	WRITE	1
#define PWRIT	2

#define	DUPRI	5

duopen(dev)
{
	register struct du *dp;
	register *lp;

	if (dev.d_minor >= du_cnt ||
	   ((dp = &du_du[dev.d_minor])->du_proc!=0 && dp->du_proc!=u.u_procp)) {
		/*  access restricted to one process per du-11 */
		u.u_error = ENXIO;
		return;
	}
	dp->du_proc = u.u_procp;
	lp = du_addr[dev.d_minor];
	lp->txcsr = MR;
	lp->rxdbuf = 036226;  /* 8 bit, no parity (compute in prog), internal sync (on 0226) */
	if ((lp->rxcsr&DSR) == 0) {
		u.u_error = EIO;
		return(1);
		}
	lp->rxcsr = 0;
	dp->du_ibfp = &du_bufi;
	dp->du_obfp = &du_bufo;
	dp->du_ibufe = dp->du_ibfp + 256;
	dp->du_obufe = dp->du_obfp + 128;
	dp->du_mesg =  dp->du_nleft =  dp->du_nxlst = 0;
}

duclose(dev)
{
	register struct du *dp;
	register *lp;

	dp = &du_du[dev.d_minor];
	lp = du_addr[dev.d_minor];
	lp->rxcsr = 0;
	lp->txcsr = 0;
	dp->du_proc = 0;
}

duread(dev)
{
	register char *bp;
	register struct du *dp;
	register char *n;

	dp = &du_du[dev.d_minor];
	if (dp->du_mesg == 0)
		sleep(dp, DUPRI);
	bp = &du_bufi;
	n = dp->du_ibfp;
	while  (bp != n) {
		if (passc(*bp++)<0)
			break;
		}
	dp->du_ibfp = &du_bufi;
	dp->du_mesg = 0;
}

duwrite(dev)
{
	register struct du *dp;
	register char *bp;
	int	n, *lp;

	dp = &du_du[dev.d_minor];
	lp = du_addr[dev.d_minor];
	if (u.u_count==0 )
		return;
	dp->du_obfp = bp = &du_bufo;
	lp->rxcsr = SIE|RTS|DTR|STRIP|IE|SCH;
	n = 0;
	while (u.u_count!=0) {
		*bp++ = cpass();
		n++;
		if (bp==dp->du_obufe) {
			u.u_error = E2BIG;
			return(1);
		}
	}
	duset(dev, n);
}

dustart(dev)
{
	register struct du *dp;
	register *lp;

	dp = &du_du[dev.d_minor];
	lp = du_addr[dev.d_minor];
	if (dp->du_nleft > 0) {
		dp->du_nleft--;
		lp->txdbuf = *dp->du_obfp++;
	} else {
		lp->txcsr = 0;  /* turn off transmit when mesg done */
	}
}

duset(dev, an)
{
	register struct du *dp;
	register *lp;

	dp = &du_du[dev.d_minor];
	lp = du_addr[dev.d_minor];
	while((lp->rxcsr&CTS)==0)
		sleep(dp,DUPRI);
	dp->du_nleft = an;
	lp->txcsr = IE|SIE|SEND;
	dustart(dev);
}

durint(dev)
{
	register struct du *dp;
	register c;
	int	dustat, *lp;

	dp = &du_du[dev];
	lp = du_addr[dev];
	dustat = lp->rxcsr;
	if(dustat&DONE) {
		c = lp->rxdbuf;
		if (dp->du_ibfp == dp->du_ibufe)  {
			dp->du_ibfp = &du_bufi;
			*dp->du_ibfp++ = 0377;  /* input data overran buffer */
		}
		*dp->du_ibfp++ = c;
		if (dp->du_nxlst == 1) {
			lp->rxcsr = 0;  /* turn off receive */
			dp->du_mesg = 1;
			dp->du_nxlst = 0;
			wakeup(dp);
			return;
			}
		if (c == 03)
			dp->du_nxlst = 1;
			/* This was EOM, so LRC is next and that ends message */
	}
}

duxint(dev)
{
	register struct du *dp;
	register *lp;
	register int dustat;

	dp = &du_du[dev];
	lp = du_addr[dev];
	dustat = lp->txcsr;
	if(dustat&DONE)
		dustart(dev);
}
