/*
 * lmerge [-r] letterfile [labelfile]
 * lmerge will read in and store a letter (max size 20,000 chars)
 * It will then read labelfile (or std input if no label file) and insert one
 * label into the letter in place of each '~' character, until the label file
 * is exhausted.  It will finish the letter containing the last label, unless
 * the letter requires more than one label.
 * The -r option will cause lmerge to add a line with ".bp" after each letter
 * to make the output suitable as input to roff.
 * The labels must be in 'c' format (see program labels).
 * based on an earlier version of the same program
 *
 * by David E. Miran
 * version of 3/2/83
 */

#include	<stdio.h>
#include	<myio.h>
#define		CSIZE	20000

char cspace[CSIZE];	/* letter storage area */
struct fbuf ibuf,obuf;
char	comm '[';	/* start of comment in label */
char	sig	'~';	/* mark of place to insert label in letter */
char	labend	'!';	/* mark of end of label */

main(argc,argv)
int argc;
char **argv;
{
register int i;
register char lch, ch;
int ropt, eofl, lsize, fid;

	ropt = eofl = 0;
	argv++;  argc--;
	if (strcmp(*argv, "-r") == 0) {
		ropt = 1;
		argv++;
		argc--;
	}
	if ((fid = open(*argv, 0)) < 0) {
		fprintf(stderr,"lmerge: Cannot open letter file %s\n",*argv);
		exit(1);
	}
	i = read(fid,cspace,CSIZE);
	if (i < 1) {
		fprintf(stderr,"lmerge: cannot read letter file %s\n",*argv);
		exit(1);
	}
	if (i >= CSIZE) {
		fprintf(stderr,"lmerge: letter file too big\n");
		exit(1);
	}
	close(fid);
	argc--;
	argv++;
	lsize = i;
	if (argc <= 0) {
		fid = 0;	/* std input */
	}  else {
		if ((fid = open(*argv,0)) < 0) {
			fprintf(stderr,"lmerge: cannot open label file %s\n",*argv);
			exit(1);
		}
	}
	mfinit(&ibuf,fid);
	mfinit(&obuf,1);	/* std out */
	lch = mget(&ibuf);
/* we have now set up the files and pre-read one label character */

lettlp:     /* return here to restart each letter */
	for (i=0; i<lsize; i++) {
		ch = cspace[i];
		if (ch == sig) {	/* insert label here */
lablp:
			if (lch == comm) {  /* comment in label */
				gobble();
				lch = mget(&ibuf);
				if (ibuf.nrd < 1) {
					eofl = 1;
					goto labdone;
				}
				goto lablp;
			}
			if (lch == labend) {  /* end of label */
				gobble();
				lch = mget(&ibuf);
				if (ibuf.nrd < 1) {
					eofl = 1;
				}
				goto labdone;
			}
			/* ordinary label character */
			mput(lch, &obuf);
			lch = mget(&ibuf);
			if (ibuf.nrd < 1) {
				eofl = 1;
				goto labdone;
			}
			goto lablp;
labdone:
			continue;
		}
		mput(ch,&obuf);
	}
	if (ropt) mputrec(".bp\n",4,&obuf);
	if (!eofl) goto lettlp;
	mflush(&obuf);
	close(fid);
	exit(0);
}

/* gobble - gobble label line through newline */
gobble()
{
register char c;
lp:
	c = mget(&ibuf);
	if (ibuf.nrd < 1) return;
	if (c == '\n') return;
	goto lp;
}
