/*
 * lmergel letterfile [labelfile]
 * lmergel will read a long letter and merge labels from the label file
 * (or std input if no label file) and insert one
 * label into the letter in place of each '~' character, until the label file
 * is exhausted.  It will finish the letter containing the last label, unless
 * the letter requires more than one label.
 * The labels must be in 'c' format (see program labels).
 *
 * by David E. Miran
 * version of 3/11/83
 */

#include	<stdio.h>
#include	<myio.h>

struct fbuf ibuf,obuf,lbuf;
char	comm '[';	/* start of comment in label */
char	sig	'~';	/* mark of place to insert label in letter */
char	labend	'!';	/* mark of end of label */

main(argc,argv)
int argc;
char **argv;
{
register int i;
register char lch, ch;
int ropt, eofl, lsize, fid, lfid;

	ropt = eofl = 0;
	argv++;  argc--;
	if (strcmp(*argv, "-r") == 0) {
		ropt = 1;
		argv++;
		argc--;
	}
	if ((lfid = open(*argv, 0)) < 0) {
		fprintf(stderr,"lmerge: Cannot open letter file %s\n",*argv);
		exit(1);
	}
	mfinit(&lbuf,lfid);
	argc--;
	argv++;
	lsize = i;
	if (argc <= 0) {
		fid = 0;	/* std input */
	}  else {
		if ((fid = open(*argv,0)) < 0) {
			fprintf(stderr,"lmerge: cannot open label file %s\n",*argv);
			exit(1);
		}
	}
	mfinit(&ibuf,fid);
	mfinit(&obuf,1);	/* std out */
	lch = mget(&ibuf);
/* we have now set up the files and pre-read one label character */

lettlp:
	ch = mget(&lbuf);
	if (lbuf.nrd < 1) goto letdone;
	if (ch == sig) {	/* insert label here */
lablp:
		if (lch == comm) {  /* comment in label */
			gobble();
			lch = mget(&ibuf);
			if (ibuf.nrd < 1) {
				eofl = 1;
				goto labdone;
			}
			goto lablp;
		}
		if (lch == labend) {  /* end of label */
			gobble();
			lch = mget(&ibuf);
			if (ibuf.nrd < 1) {
				eofl = 1;
			}
			goto labdone;
		}
		/* ordinary label character */
		mput(lch, &obuf);
		lch = mget(&ibuf);
		if (ibuf.nrd < 1) {
			eofl = 1;
			goto labdone;
		}
		goto lablp;
labdone:
	goto lettlp;
	}
	mput(ch,&obuf);
	goto lettlp;
letdone:
	close(lfid);
	mflush(&obuf);
	close(fid);
	exit(0);
}

/* gobble - gobble label line through newline */
gobble()
{
register char c;
lp:
	c = mget(&ibuf);
	if (ibuf.nrd < 1) return;
	if (c == '\n') return;
	goto lp;
}
