/*
 * pres		restore a print, previously killed.
 *
 * command:
 *
 *	% pres [-#] [-sm] [-t?] [-n?] [-l] prid
 *
 * where:
 *	prid = print id to restore.
 *	-# ==> set to # copies
 *	-sm ==> start 1st file on page m
 *	-t? ==> print was queued to terminal ?
 *	-n? ==> requeue print to terminal ?
 *	-l  ==> requeue print to line printer.
 *
 * Must run set-user root to send signal to tpd.
 *
 * Written by Bob Beck, 26-JAN-77.
 */

#include <stdio.h>
#include "tpdinf.h"

struct	printid	prid;
struct	control	ctl;

char	cf[] "/sptmp/data/cf%xxxxx";
char	sf[] "/sptmp/data/sf%";
char	cx[] "/sptmp/data/cf%xxxxx";
char	sx[] "/sptmp/data/sf%";
char	sfb[100],sxb[100];
int	nmode	0;
char	nterm	'%';
char	*devl	"/dev/lp";
char	*devt	"/dev/tty?";
int	tmode	0;
char	term	'%';
char	*topt	"%";
char	*progname;
int	ncop;
int	start;
char	dlook();

main(argc,argv)
int	argc;
char	**argv;
{
  register int argid;
  register char *arg;
  register int fd;
int spfd;
int i;

	/*
	 * check and get arg print id.
	 */

	if (argc < 2) {
		write(1,"Useage: pres prid\n",18);
		exit(0);
	}

	/*
	 * do args until prid number.
	 */

	progname = argv[0];
	while(--argc)
		if (*(arg = *++argv) == '-') switch(*++arg) {
			case 's':
				start = decimal(++arg);
				if (start < 1) start = 1;
				break;
			case 't':
				term = *++arg;
				termset();
				break;
			case 'n':
				nmode = 1;
				nterm = *++arg;
				cx[14] = nterm;
				sx[14] = nterm;
				break;
			case 'l':
				nmode = 1;
				nterm = '%';
				cx[14] = nterm;
				sx[14] = nterm;
				devt[8] = nterm;
				break;
			default:
				ncop = decimal(arg);
				break;
		} else {
			argid = decimal(arg);
			break;
		}

	/*
	 * if presently being printed, kill it.
	 */

	ascnum(cf+15,argid);
#ifdef VERIFY
	verify(cf,"restore");			/* check permission */
#endif
	read(open(tpdprid,0),&prid,sizeof prid);
	if (prid.prpid == argid) {
		tpdkick(L_KILL);
		sleep(2);		/* let tpd finish */
	}

	/*
	 * fix any parms, chmod of file, and re-exec tpd.
	 */

	if (ncop || start) {
		fd = open(cf,2);
		read(fd,&ctl,sizeof ctl);
		if (ncop)
			ctl.ncopies = ctl.pcopy = ncop;
		if (start)
			ctl.startat = ctl.startp = start;
		seek(fd,0,0);
		write(fd,&ctl,sizeof ctl);
		close(fd);
	}
	chmod(cf,PRTMODE);
	if (nmode) {
		topt[0] = nterm;
		devt[8] = nterm;
		tmode = 1;
		ascnum(cx+15,argid);
		link(cf,cx);
		if ((spfd = open(cf,0)) < 0) {
			printf("%s:  Can't open control file %s\n",progname,cf);
			exit(1);
		}
		read(spfd,&ctl,sizeof ctl);
		close(spfd);
		unlink(cf);
		for(i = 0; i < ctl.nfiles; i++) {
			strcpy(sfb,makefn(sf,i,ctl.sfpid));
			strcpy(sxb,makefn(sx,i,ctl.sfpid));
			link(sfb,sxb);
			unlink(sfb);
		}
		if (nterm == '%') {
			tmode = 0;
		}
	}
	printf("Id: %d restored to %s\n",argid,tmode?devt:devl);
	if (tmode)
		execl(tpd,tpd,topt,0);
	else
	execl(tpd,tpd,0);
	write(1,"Can't exec tpd.\n",16);
}
/*
 * verify	check that calling user owns spool file.
 *		If not ask if the person really wants to kill/stop/remove it
 *		By David E. Miran
 * version of 12/16/82
 */

struct	control	ctl;

verify(file,what)
char	*file, *what;
{
register int user;
int fd;
char	xbuf[20];
int	flag;

	flag = 0;

	user = getuid() & 0377;
ck:
	if ((fd = open(file,0)) < 0) {
		if (flag) {
quit:
			printf("%s:  Spool file %s not found\n",progname,file);
			exit(1);
		}
		flag++;
		/* since couldn't find it try searching directory */
		term = dlook(file);
		if (term == '\0') goto quit;
		termset();
		goto ck;
	}
	if (read(fd,&ctl,sizeof ctl) < 0) {
		printf("%s:  Can't read spool file %s\n",progname,file);
		exit(1);
	}
	close(fd);

	if ((ctl.uid & 0377) != user) {
		printf("%s: The job currently printing on %s is not yours!\n",progname,tmode?devt:devl);
		printf("Do you really want to %s it?  Type y or n.\n",what);
		read(0,xbuf,20);
		if (xbuf[0] != 'y') exit(1);
	}
}
/*
 * tpdkick	routine to send a signal to executing tpd.
 *		note: must be super user to do kill of process
 *		not same user.
 *
 * Written by Bob Beck, 21-JAN-77.
 */

tpdkick(sig)
int	sig;
{
  register int fd;
  int pid;

	if ((fd = open(tpdpid,0)) < 0) {
		write(1,"Can't read tpd pid.\n",20);
		exit(1);
	}
	read(fd,&pid,2);
	close(fd);
	kill(pid,sig);
}
termset()
{
	if (term == '%') tmode = 0;
		else tmode = 1;
	topt[0] = term;
	cf[14] = term;
	sf[14] = term;
	tpdpid[12] = term;
	tpdprid[12] = term;
	devt[8] = term;
}
char dlook(cname)
char *cname;
{
struct	{
	int	inum;
	char	fnam[15];
	} dirent;
int	*first	dirent.fnam;
int	dir, n;

	dir = open(usrtpd,0);
	seek(dir,32,0);			/* skip "." and ".." */
	while(1) {
		if ((n = read(dir,&dirent,16)) <= 0)
			return('\0');
		if (*first != 'cf' || !dirent.inum)
			continue;
		if (strcmp(&dirent.fnam[3],&cname[15]) == 0) break;	/* found matching id number */
	}
	close(dir);
	return(dirent.fnam[2]);
}
