/* syshyg
 * local system calls for the Wisconsin State Hygiene Lab
 * and other locally developed routines
 * by David E. Miran  8/30/82
 */
#include	"../hd/param.h"
#include	"../hd/systm.h"
#include	"../hd/user.h"
#include	"../hd/proc.h"
#include	"../hd/reg.h"
#include	"../hd/inode.h"
#include	"../hd/seg.h"
#include	"../hd/buf.h"
#include	"../hd/file.h"

/*
 * lock user into core as much
 * as possible. swapping may still
 * occur if core grows.
 * taken from the version 7 unix code and modified for v6
 * also further modified to only allow 1 process at a time to
 * be locked into core and queue additional requests.
 * This is to support pseudo polling and page transmit terminals.
 */

#define	MAXLOCK	16	/* number of simultaneous requests */
#define	LOCKPRI	10
int	cbipnt	0;	/* buffer incoming pointer */
int	cbopnt	0;	/* buffer removal pointer */
int	curlock	0;	/* pid of current locked process */
int	lockq[MAXLOCK];	/* circular buffer to queue requests */

syslock()
{
	register struct proc *p;
	register i;

	if (!suser()) {
		u.u_error = EPERM;
		return;
	}
	p = u.u_procp;
	i = u.u_ar0[R0];
/* argument = 1 - set lock, = 0 - clear lock of this process, = -1 - clear lock regardless */
	if (i>0) {
lp:
		if (curlock) {	/* lock is set */
			if (curlock != p->p_pid) { /* by someone else */
				cbipnt++;
				if (cbipnt >= MAXLOCK) cbipnt = 0;
				lockq[cbipnt] = p->p_pid;
				sleep(&lockq[cbipnt],LOCKPRI);
				goto lp;
			}
		}
		curlock = p->p_pid;
		p->p_flag =| SULOCK;
		return;
	}
	if (i < 0) goto lchk;
/* i = 0 so release the lock and give to next (if any) */
	if (curlock != p->p_pid) {
		u.u_error = EPERM;
		return;
	}
	p->p_flag =& ~SULOCK;
lchk:
	curlock = 0;
	if (cbipnt == cbopnt) return;
	cbopnt++;
	if (cbopnt >= MAXLOCK) cbopnt = 0;
	wakeup(&lockq[cbopnt]);
	return;
}

/* tell system call - taken from PWB/UNIX */

tell()
{
	register struct file *fp;

	if (fp = getf(u.u_ar0[R0])) {
		mapin(&fileseg);
		u.u_ar0[R0] = fp->f_offset[0];
		u.u_ar0[R1] = fp->f_offset[1];
		mapout();
	}
}

/* mapin/mapout internal routines
 * the argument is a pointer to a bufpt structure, which is
 * a par/pdr pair.  The current values of ka5 and kd5
 * are saved on a stack and the new buffer is mapped in.
 * The value returned is the mapped address of the buffer - always SEG5
 * mapout restores the top value from the stack.
 * This is the code that provides access to internal buffers mapped
 * outside of kernel space.
 * Used for disk buffers, clists, and other items.
 * by David E. Miran 2/9/82
 */

struct	bufpt	bufstk[NMSEG];
int	segstk	0;	/* bufstk position pointer */

char *mapin(xnseg)
struct bufpt *xnseg;
{
int x;
	x = spl6();
	if (segstk >= NMSEG)
		trap(035,0,0,0,0,0,0);
	bufstk[segstk].par = KISA5->r[0];
	bufstk[segstk].pdr = KISD5->r[0];
	segstk++;
	KISA5->r[0] = xnseg->par;
	KISD5->r[0] = xnseg->pdr;
	splx(x);
	return(SEG5);
}

mapout()
{
int x;
	x = spl6();
	if (segstk-- <= 0)
		trap(034,0,0,0,0,0,0);
	KISA5->r[0] = bufstk[segstk].par;
	KISD5->r[0] = bufstk[segstk].pdr;
	splx(x);
}
/* getobuf
 * will allocate a buffer outside of kernel space and return
 * various pointers to it and the segmentation register
 * prototype for use by mapin
 * Getobuf must be called only during the initialization routines
 * called from the beginning of main, since it decrements maxmem.
 * It should not be used for dynamic allocation of buffers.
 */
char *getobuf(addr, segp, size)
char **addr;
struct bufpt *segp;
int size;
{
int sz;
char *mem;
	sz = (size +63)/64;
	mem = malloc(coremap, sz);
	segp->par = mem;
	segp->pdr = ((sz-1)<<8) | 6;
	*addr = (char *) SEG5;
	maxmem -= sz;
	return(mem);
}
/*
 * crash
 * the crash system call is designed for testing of the modification
 * which makes the lower 3 segments (3 * 8192 bytes) of the kernel
 * read only.  It could also be useful if the system is sick or
 * berserk.  As a last resort a crash can be forced.  This should allow
 * the normal sync on a panic trap so the files will not be in very
 * shape.
 */
crash()
{
register char *c;
	if (!suser()) return;
	c = 0;
	*c = 0;	/* should crash */
	return;  /* if no crash then just return */
}
