/*
 * A clist structure is the head
 * of a linked list queue of characters.
 * The characters are stored in 8-word
 * blocks containing a link and 14 characters.
 * The routines getc and putc (in tty.c)
 * manipulate these structures.
 *
 * version of 4/6/82
 */
struct clist
{
	int	c_cc;		/* character count */
	char	*c_cf;		/* pointer to first char */
	char	*c_cl;		/* pointer to last char */
};

/*
 * A tty structure is needed for
 * each UNIX character device that
 * is used for normal terminal IO.
 * The routines in tty.c handle the
 * common code associated with
 * these structures.
 * The definition and device dependent
 * code is in each driver. (kl.c dc.c dh.c)
 */
struct tty
{
	struct	clist t_rawq;	/* input chars right off device */
	struct	clist t_canq;	/* input chars after erase and kill */
	struct	clist t_outq;	/* output list to device */
	int	t_flags;	/* mode, settable by stty call */
	int	*t_addr;	/* device address (register or startup fcn) */
	char	t_delct;	/* number of delimiters in raw q */
	char	t_col;		/* printing column of device */
	char	t_erase;	/* erase character */
	char	t_kill;		/* kill character */
	char	t_state;	/* internal state, not visible externally */
	char	t_char;		/* character temporary */
	int	t_speeds;	/* output+input line speed */
	int	t_dev;		/* device name */
	char	t_scnt;		/* scrolling line count */
	char	t_blk;		/* block raw mode ready block count */
	char	t_blksiz;	/* max number of block chars before wakeup */
	char	t_blkchr;	/* block raw mode wakeup char */
};

char partab[];			/* ASCII table: parity, character class */

#define	TTIPRI	5
#define	TTOPRI	8

#define	CERASE	'#'		/* default special characters */
#define	CEOT	004
#define	CKILL	'@'
#define	CQUIT	034		/* FS, cntl shift L */
#define	CINTR	0177		/* DEL */
#define	CSTOP	023		/* control S - stop output */
#define	CSTART	021		/* control Q - start output */
#define	CSCROLL	017		/* Control-O, for scrolling */
#define	NSCROLL	18		/* Number of lines to scroll at once */

/* limits */
#define	TTHIWAT	150
#define	TTLOWAT	60
#define	TTYHOG	700

/* modes */
#define	HUPCL	01
#define	XTABS	02
#define	LCASE	04	/*  inoperable at slh 3/25/80 */
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define	NLDELAY	001400
#define	TBDELAY	002000
#define	SCROLL	004000
#define	CRDELAY	030000
#define	VTDELAY	040000
#define BLOCK	0100000		/* raw mode block input */

/* Hardware bits */
#define	DONE	0200
#define	IENABLE	0100

/* Internal state bits */
#define	TIMEOUT	01		/* Delay timeout in progress */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	SSTART	010		/* Has special start routine at addr */
#define	CARR_ON	020		/* Software copy of carrier-present */
#define	BUSY	040		/* Output in progress */
#define	ASLEEP	0100		/* Wakeup when output done */
#define	SCSTOP	0200		/* Stopped in scrolling */
