/*
 *	vir
 *	Variable Information Retrieval
 *	State Hygiene Laboratory pseudo database system
 *	Data entry and Enquiry program
 *	by David E. Miran
 *	6/2/83
 */

#include	<stdio.h>
#include	"vmyio.h"
#include	<signal.h>
#include	"vir.h"
#include	"virfiles.h"


int	hfid, pfid, p1fid, p2fid, nfid, n1fid, n2fid, sfid, s1fid, s2fid, dfid, fmtfid;


extern char mget();
extern long atol(), lseek();
extern badsig(), quitsig();


struct	dexhead	hrec;		/* HFILE (header file) */
struct	fil_ent	filent[MAXFILE]; /* data file information - HFILE-3 */
char	fileok[MAXFILE];	/* set to 'w' or 'r' after auth checked */
struct	fmt_def fmtdef[MAXFMT];
struct	fmt_inf	fmtinf[MAXFMT];	/* format information (internal) */
struct	fdef	fld[MAXFLD];	/* the format field descriptors */
struct	pat_ent	prec;		/* one record from PFILE */
struct	num_ent	snrec;		/* one record from NFILE */
struct	sp_ent	srec;		/* one record from SFILE */

char	tbuf[MAXRSIZE], ibuf[MAXRSIZE];	/* terminal and internal buffers */

/* WORKING SET - current set of records */
char	afld[250];	/* source for auto copy fields */
int	apnt[10],asize[10];	/* autocopy fields start and size */
int	amax;			/* autocopy total size */
struct	pat_ent	cur;	/* current patient name and number */
int	cur_rcnt	0;	/* count of records in current set */
long	cp_off;			/* patient index offset of current patient */
long  lk_pnum;			/* patient number for lookup */
char	lk_pnam[PNSIZE];	/* patient name for lookup */
long	lk_spnum;		/* specimen number for lookup */

struct {
	struct	num_ent crec_n;
	int	nfmt_num;	/* format associated with this record */
	long	nws_loc;	/* loc of index entry for this record */
	}  crec[MAXREC];	/* pointers to records in working set */
int	wsp	-1;		/* points to current record entry during update */

struct {
	struct sp_ent cspec_n;
	int sfmt_num;		/* format associated with this record */
	long	sws_loc;	/* loc of index entry for this record */
	} cspec[MAXSPEC];	/* pointers to records via specimen number */

/* RECORD - information on current record being processed */
int	cur_type	0;	/* type of record */
int	ltype		0;	/* cur_type - 1 */
unsigned cur_fnum	0;	/* file number */
long	cur_strt	0;	/* offset to record start */
int	cur_size	0;	/* current record size (compressed in file) */
int	recsize		0;	/* current expanded record size */
long	new_strt	0;	/* new offset to record start */
int	new_size	0;	/* new record (compressed) size */
long	cur_n;			/* position of descriptor entry in nfile for current record */

/* DISPLAY control variables */
int	singpat	0;	/* set if single patient display */
int	wdisp	0;	/* set if working set display required */
int	wsdisp	0;	/* set if spec nums required for working set */
int	byspec	0;	/* set if display is by specimen number */
int	allflag	0;	/* set if lookup is by spec number, but display is all records */
int	fmtlim	0;	/* set if display limited to selected formats */
int	fmtrst[MAXFMT];	/* set if format type selected for display */
int	udmode	0;	/* 0 = display mode, 1 = update mode */

/* LOOKUP - control variables and tables (?2 files) */
char	pbase[NCPAT][16];	/* p2 file */
long	nbase[NCREC];		/* n2 file */
long	sbase[NCSPEC];		/* s2 file */
int	pbcnt, nbcnt, sbcnt;  /* counts of entries in p2, n2, s2 */
int	plookp, nlookp, slookp;  /* set if currently searching p, n, or s file */
int	plooku, nlooku, slooku;  /* set if search beyond sequential area */
struct fbuf plbuf, nlbuf, slbuf;  /* buffers for index files */
long ploc, nloc, sloc;  /* current offsets into index files */
long newnloc;
int	SN_lkp, SP_lkp, SS_lkp;		/* save [nps]lookp states */
int	SN_lku, SP_lku, SS_lku;		/* and looku */
long	SN_off, SP_off, SS_off;		/* and current file offsets */

/* STATE - general system and state definitions */
int	fmtstate	0;	/* fmt off (0) or on (1) */
int	fdexmod		0;	/* set if any changes made */
int	icnt		0;	/* size of command line (= recsize) */
int	repmode		0;	/* set if replicate command is in progress */
int	filspot;		/* current data file pointer in filent table */
int	nfmt		0;	/* format to load */
int	imode		0;	/* set if index display is in progress */
long	initoff		0L;	/* set for inital record offset in index display */
int	auto_on		0;	/* set if automatic patient number generation is on */

int	uid, gid, setid;
int	r_only	0;	/* set if read only access mode */
int	rflag	0;	/* set if -r option - all access is read only */
int	uflag	0;	/* set for -u option - dangerous simultaneous update mode */
int	f_mode	0;	/* current file state - 0=closed, 1=open */
int	acmode	2;	/* index open mode - 0=read only, 2=read/write */
char	uname[10];	/* user id for auth file checking */
char	cfile[50];	/* current directory name */
char	kfile[50];	/* name of special keyfile */
char	afile[]	"auth";	/* name of authorization file */

int	ttyorig[3],ttybraw[3],ttyraw[3],ttynorm[3];
int	hispd	0;	/* set if line is 9600 baud */

char	bell[]	"\07";

/* EXTERNAL - various externally defined items */

extern char eor, inrdy, *ok, *cls, *fmto, *ccls, *cscr;
extern int cls_l, fmto_l, ok_l, errno, cclsl, cscrl;
extern char *blkof, *blkon;
extern int blkof_l, blkon_l;
extern char *wind[];
extern int windlen[];
extern int termtype, warn;
#ifdef DUMBKEY
extern int simfunc;
#endif

#ifdef DEBUG
/*  DIAGNOSTIC */
char	*diagfile	"DIAG";
int	diagfid;
int	debflg	0;	/* debugging turned on */
#endif

/* options */
int	popt	0;	/* printing mode output */
int	fopt	0;
int	mopt	0;	/* merge mode output */
int	kopt	0;	/* set if alternate keyfile specified */
int	aopt	0;	/* set if formats and keys on concept terminal already loaded */

/* MISC - miscellaneous variables */

char	*progname;
int	nrd, maxrd, maxrec;
char	rbuf[80];	/* spare line buffer */
char	dfile[50];	/* current in use file name */
int fcnt, nspecn, specnpos[30], fnn, fsn, fn, fs;
long newloc, spn;
int	tflag	0;		/* set after terminal type checked */
int sploc, spsize;
long errloc;	/* file loc for error exit */
long errpnum;
long	errspec;
int	ntry	0;	/* retransmit request count */
char	*autost[]	{ "OFF", "ON" };
long	MEG	1000000L;	/* the constant 1 million for composite patient number generation */
char	*gens	"%D            ";	/* used for patient number generation */
long	ML	-1L;
int	scrst	0;	/* set if screen has just been cleared - cursor already home */

main(argc, argv)
int argc;
char **argv;
{
	register int i, j;
	register char c;
	int	omx;
	char	*omp;

	progname = *argv;
	uid = getuid()&0377;
	gid = getgid()&0377;
	setid = uid | (gid<<8);
	strcpy(cfile,".");
	close(2);

/* analysis of options */

	while (--argc) {
		argv++;
#ifdef DEBUG
		if (strcmp(*argv,"-d") == 0) {
			debflg = 1;
			continue;
		}
#endif
		if (strcmp(*argv,"-p") == 0) {
			popt = 1;
			continue;
		}
		if (strcmp(*argv,"-a") == 0) {
			aopt = 1;
			continue;
		}
		if (strcmp(*argv,"-u") == 0) {
			uflag = 1;
			continue;
		}
		if (strcmp(*argv,"-f") == 0) {
			popt = 1;
			fopt = 1;
			continue;
		}
		if (strcmp(*argv,"-m") == 0) {
			popt = 1;
			mopt = 1;
			continue;
		}
		if (strncmp(*argv,"-t",2) == 0) {
			termset(argv[0][2]);
			continue;
		}
		if (strcmp(*argv,"-k") == 0) {
			argc--;  argv++;
			keyfile = *argv;
			kopt = 1;
			continue;
		}
		if (strcmp(*argv,"-o") == 0) {
			argc--;  argv++;
			strcpy(cfile,*argv);
			authck();	/* no return if auth forbidden */
			continue;
		}
		if (strcmp(*argv,"-r") == 0) {
			rflag = r_only = 1;
			acmode = 0;
			continue;
		}
		/* add new options here */
	}

	if (!tflag) termset(0);  /* look up terminal type */
	if ((termtype == 4) && (!kopt)) keyfile = "CKEYTEXT";
	
	gtty(1, ttyorig);

	ttybraw[0] = ttyraw[0] = ttynorm[0] = ttyorig[0];
	ttyraw[1] = ttynorm[1] = ttyorig[1];
	ttybraw[1] = eor<<8 | IBSIZE;
	ttyraw[2] = RMODE;
	ttybraw[2] = IMODE;
	ttynorm[2] = NMODE;
	if (ttyorig[0] & 0377 > B4800) hispd = 1;

/* modification to let vir work smoothly from a shell */
	close(0);  close(1);
	open("/dev/tty",0);
	open("/dev/tty",1);
	signal(SIGHUP, &quitsig);
	signal(SIGINT, 1);
	signal(SIGQUIT, 1);
	signal(SIGBUS, &badsig);
	signal(SIGSEGV, &badsig);
	signal(SIGSYS, &badsig);

	if (termtype == 0) ttynorm[2] = PMODE;
#ifdef DEBUG
	if (debflg) {
		diagfid = creat(diagfile, 0644);
		chown(diagfile, setid);
		}
#endif
	setbuf(stdout, NULL);
	if (warn) {
		printf("\07*****  SET  BLOCK  MODE  *****\07\n");
		sleep(2);
	}
	vopen();
	goto whatb;

/********* main command interpreter cycle *****************/

whatnext:
	clr();
whatb:
	write(1,">",1);
	i = getin(0);
what2:
	j = scrst = 0;
	while (j < icnt) {
		switch (tbuf[j]) {
			case ' ':
			case '>':
			case '!':
				goto nextc;
			case '@':  goto whatnext;
			default:  goto nextp;
		}
nextc:
		j++;
	}
	goto whatnext;
nextp:
	switch (tbuf[j]) {	/* process command */

		case 'q':	quitsig(30);	/* all done */

		case 'r':
			if (tbuf[j+1] == 'n') {
				repmode = 2;
				j++;
			}  else
				repmode = 1;
			goto cr2;
		case 'c':
			repmode = 0;
cr2:
			if (popt || r_only) goto unc;
			i = create(j);
			goto where;
		case 'd':
			i = display(j);
			goto where;
		case 'u':
			if (popt || r_only) goto unc;
			i = update(j);
			goto where;

		case 'e':	/* erase screen */
			fmtoff();
			break;

		case 'i':	/* index display */
			i = index(j);
			goto where;

		case 'f':	/* change default file */
			if (r_only) goto unc;
			if (ndfile(j) < 0) goto unc;
			goto whatb;

		case 'o':	/* open new set of files */
			omx=0;  omp=cfile;
#ifdef	K.COM
			goto dof;

		case 'k':	/* specify alternate key file */
			omx = 1;  omp = kfile;
dof:
#endif
			vclose();
			j++; i=0;
			while (c = tbuf[j++]) {
				if ((c == ' ') && ( !i)) continue;
				if (c == ' ') break;
				omp[i++] = c;
			}
			omp[i] = '\0';
#ifdef	K.COM
			if (omx)
				keyfile = kfile;
			else
#endif
				authck();
			vopen();
			break;

#ifdef	W.COM
		case 'w':	/* print name of current file (directory) */
			fmtoff();
			printf("Current directory is %s\n",cfile);
			goto whatb;
#endif

			/* option changing */
		case '+':
			i = 1;  goto optset;
		case '-':
			i = 0;
optset:
			j++;
			while(tbuf[j] == ' ') {
				if (j >= icnt) goto unc;
				j++;
			}
			switch (tbuf[j]) {
				case 'f':
					fopt = i; popt = i; break;
				case 'm':
					mopt = i; popt = i; break;
				case 'p':
					popt = i;  break;
				case 'a':	/* turn auto patient number generation on or off */
					auto_on = i;
					fmtoff();
					printf("Automatic patient numbering turned %s - highest patient number is %D\n",
						autost[i],hrec.maxpnum);
					goto whatb;
				default:
					goto unc;
			}
			break;

/*************  add other commands here **************/
		default:
			goto unc;
	}
	goto whatnext;
where:
	if (i < 0) goto whatb;
	if (i > 0) goto what2;
	goto whatnext;
unc:
	fmtoff();
	printf("Invalid command or command not allowed in current mode\n%s\n",tbuf);
	goto whatb;
}

/*******************************  vopen  *************************************/

vopen()
{
register int i;
	if (uflag) goto v2;
	if (!r_only) {
		if (!flock(lockfile)) {
			r_only = 1;
			quitsig(41);
		}
	}
v2:
	vfopn(&hfid,hfile, acmode);
	vfopn(&pfid,pfile, acmode);
	vfopn(&p2fid,p2, 0);
	vfopn(&nfid,nfile, acmode);
	vfopn(&n2fid,n2, 0);
	vfopn(&fmtfid,fmtfile, 0);

	read(hfid, &hrec, sizeof hrec);
	read(hfid, &fmtdef[0], MAXFMT * sizeof (struct fmt_def));
	read(hfid, &filent[0], hrec.numfile * sizeof (struct fil_ent));
	read(fmtfid, &fmtinf[0], hrec.numfmt * sizeof (struct fmt_inf));
	read(fmtfid, &fld[0], hrec.nfmtfld*sizeof (struct fdef));
	close(hfid);
	close(fmtfid);
	i = read(n2fid, &nbase[0], NCREC*4);
	nbcnt = i/4;
	i = read(p2fid,&pbase[0][0],NCPAT * 16);
	pbcnt = i/16;
	close(p2fid); close(n2fid);
	if (!hrec.nonspec) {
		vfopn(&sfid,sfile, acmode);
		vfopn(&s2fid,s2, 0);
		i = read(s2fid, &sbase[0], NCSPEC * 4);
		sbcnt = i/4;
		close(s2fid);
	}
	for (i=0; i<MAXFILE; i++) fileok[i] = 'n';
	f_mode = 1;	/* files now open */
	fdexmod = 0;
	if (hrec.autopn != 0) auto_on = 1;
	if (termtype == 2) dofork("/usr/bin/keyset", "keyset", keyfile, 0, 0);
	if ((termtype == 4) && (!aopt)) {
		dofork("/usr/bin/ckeyset","ckeyset", "-w", keyfile, 0);
		dofork("/usr/bin/vload","vload",0, 0, 0);
	}
	if (termtype == 4)  write(1,blkon,blkon_l);
	fmtoff();
	if (uflag)
		printf("\n****** WARNING ****** WARNING ****** WARNING ******\nSimultaneous update mode - proceed at your own risk\n");

#ifdef DUMBKEY
	if (simfunc) {
		if (!funcset()) simfunc = 0;
		/* if function loading fails turn off the feature */
	}
#endif
}

/********************************  dofork  **********************************/

dofork(a,b,c,d,e)
char *a, *b, *c, *d, *e;
{
register int i;
	i=fork();
	if (i < 0) {
kzz:
		printf("%s: fork or exec failed for %s\n",progname,b);
		exit(1);
	}
	if (i == 0) {
		execl(a,b,c,d,e,0);
		goto kzz;
	}
	i = wait(&nrd);
	nrd = nrd>>8;
	if ((i < 0) || nrd) goto kzz;
}

/********************************  vfopn  ***********************************/
vfopn(fid, fn, md)
int *fid, md;
char *fn;
{
	if ((*fid = open(fn,md)) < 0) {
		strcpy(dfile,fn);
		quitsig(27);
	}
}

/********************************  vclose  ***********************************/

vclose()
{
register int i, j, k;
	fmtoff();
	if (uflag) goto v3;
	if (!f_mode) goto unlk;
	if (fdexmod && (!r_only)) {
		hfid = creat(hfile, 0664);
		i = sizeof hrec;
		j = sizeof (struct fmt_def);
		k = sizeof (struct fil_ent);
		time(&hrec.lastmod);
		write(hfid, &hrec, i);
		write(hfid, &fmtdef[0], MAXFMT * j);
		write(hfid, &filent[0], hrec.numfile * k);
		close(hfid);
		printf("INDEX updated\n");
	}
v3:
	close(pfid);
	close(nfid);
	if (!hrec.nonspec)
		close(sfid);
unlk:
	if (uflag) goto v4;
	if (!r_only)
		funlock(lockfile);
v4:
	f_mode = 0;
	auto_on = 0;
}

/*******************************  authck  ************************************/
/* check legality of access to file (cfile) and chdir to it.
 * Access may be by natural right or by auth file for read only mode
 */

authck()
{
register int i, j;
register char c;
int fidc;
struct fbuf f1;
	if (getpw(uid, rbuf))
		quitsig(39);
	i = 0;
	while ((c = rbuf[i]) != ':') uname[i++] = c;
	uname[i] = '\0';
	strcpy(dfile,cfile);
	if (chdir(cfile) < 0)
		quitsig(27);
	if (rflag) goto chk;
	r_only = 0;  acmode = 2;
chk:
	if (!uid) goto auth_ok;
	if (saccess(".",2)) goto auth_ok;
	if (saccess(".",4)) goto rd_only;
	if ((fidc = open(afile,0)) < 0)   quitsig(27);
	mfinit(&f1,fidc);
	while (i = mgetlin(rbuf, &f1)) {
		for (j=0; j<i; j++)
			if ((rbuf[j] < 'a') || (rbuf[j] > 'z')) {
				rbuf[j] = '\0';
				break;
			}
		if (strcmp(uname, rbuf) == 0) goto rd_a;
	}
	quitsig(27);
rd_a:
	close(fidc);
rd_only:
	r_only = 1;
	acmode = 0;
auth_ok:
	return;
}

/*******************************  quitsig  ***********************************/

quitsig(why)
int why;
{
int ecode;
int i, j, k;
	ecode = 1;
	lock(0);  /* just in case */
	vclose();
	if (termtype == 4) {
		sleep(1);
		write(1,wind[0],windlen[0]);
		write(1, blkof, blkof_l);
		sleep(1);
	}
	stty(0,ttyorig);
	switch (why) {
		case 27:
			printf("File/dataset %s: does not exist or access forbidden\n",dfile);
			break;
		case 28:
			printf("File table overflow\n");
			break;
		case 29:
			printf("******  bad error (bus, seg, or sys call) ****\n");
			break;
		case 30:   /* normal exit sequence */
			ecode = 0;
			break;
		case 31:
			printf("Read error - nrd=%d, errno=%d\n", nrd, errno);
			break;
		case 34:
			printf("oversize record in file %s loc %D  record=\n%-70.70s\n",
				filent[filspot].f_name, errloc, ibuf);
			break;
		case 35:
			printf("cannot find record at file %s loc %D\n*** - call system programmer\n",
				filent[filspot].f_name, errloc);
			break;
		case 36:
			printf("Cannot find patient %D in NFILE\n",errpnum);
			printf("Referred by spec %D for file, loc= %s   %D\n",
				errspec, filent[filspot].f_name, errloc);
			break;

		case 37:
			printf("Unable to read record in 3 tries. Call systems programmer\n");
			break;
		case 38:
			printf("Too many records for patient number %D - over %d\n",
				errpnum, cur_rcnt);
			break;
		case 39:
			printf("user %d unknown\n",uid);
			break;
		case 41:
			printf("Sorry - index to file %s is locked\n",cfile);
			break;

		default:
			printf("%s:  Killed by keyin\n",progname);
	}
	if (warn)
		printf("\07*****  CLEAR  BLOCK  MODE  *****\07\n");
	exit(ecode);
}

#ifdef DEBUG
/************  debug  - dw   *********************/
dw(x,y)
char *x;
int y;
{
	if (!debflg) return;
	write(diagfid, x, y);
}
#endif
