#
/*
Name:
	ACCEPTAPPT Calendar System Command

Function:
	Accept or reject temporary appointments made by other users

Algorithm:
	If there are any appointments in the temporary appointment file,
	display them one at a time and ask the user if he would like to keep 
	it. If the user wants to keep it, add it to his appointments for the
	specified day. Otherwise continue displaying the temporary appointments.

Parameters:
	None

Returns:
	ENOERR	Normal exit
	ENOENT	Bad home directory or exec/appointments directory or no temp-
		orary appointments file
	EACCES	Cannot empty appointment or temporary appoint file(s)

Files and Programs:
	home-dir/exec/appointments/(file)	appointment files
	home-dir/exec/appointments/temp.appts	temporary appointment file

Installation Instructions:
	Put in /usr/bin/exec.dir/acceptappt
	Change owner to root
	Deny write permissions except for owner
	Link to /usr/bin/exec.dir/accept

History:
	Oct 79,	Release 1 Version 1, G. Maltagliati, coded in shell
	Nov 80, Release 5 Version 1, G. Maltagliati, coded in C for efficiency
	Aug 82,

*/
#include <stdio.h>
#include "../includes/error.h"
#include "../includes/getdef.h"
#define APPOINT "exec/appointments"
#define TEMP "temp.appts"
#define NOTEMP "Temporary appointment file is empty\n"

char id[] = "%W% %H%";

/*

Name:
	main

Function:
	Accept or reject temporary appointments made by other users

Algorithm:
	Move to the user's home directory. If there are any appointments in the
	temporary appointment file, then display them one at a time. For each
	temporary appointment displayed, determine if the user has any other
	appointments on that day. If he has appointments display them. Now,
	ask the user if he would like to keep the appointment. If he does, then
	add the appointment to the appointment file for that day.

Parameters:
	None

Returns:
	ENOERR	Normal exit
	ENOENT	Bad home directory or exec/appointments directory or no temp-
		orary appointments file
	EACCES	Cannot empty temporary appoint file(s)

Files and Programs:
	home-dir/exec/appointments/(file)	appointment files
	home-dir/exec/appointments/temp.appts	temporary appointments file


*/
main (argc, argv, envp)

int argc;
char **argv, **envp;
{
    FILE     *fp_temp;		/* temp file descriptor pointer */
    char    file[15],					/* Name of the appointment file */
            buffer[512],				/* I/O buffer */
            appoint[256],				/* Holds the temporary appointment */
	    ans_buf[256],
	   *answer = ans_buf,                           /* Pointer to answer supplied by user */
	    line_buf[256],
	   *line = line_buf;                            /* Pointer to a line from the temporary appointments file */
    register int    fd,					/* Files descriptor for appointments and temporary appointment files */
                    flag = 0,				/* Indicates if there are any temporary appointments */
                    num_chars;				/* Number of characters read into I/O buffer */
    struct buf						/* Structure required for buffered input */
    {
	int     fildes;
	int     nleft;
	char   *nextp;
	char    buffer[512];
    }           iobuf;


    if (chdir (findenv("HOME", envp)))			/* move to $HOME */
    {
	printf ("bad home directory\n");
	exit (ENOENT);
    }
    if (chdir (APPOINT) == -1)				/* Move to exec/appointments directory */
    {
	printf ("acceptappt: bad directory--%s\n", APPOINT);
	exit (ENOENT);
    }
    if ( (fp_temp = fopen(TEMP, "r")) == NULL)
    {
	printf ("No tentative appointments\n");
	exit (ENOENT);
    }
    copy ("appts.", file);
    while (fgets (line ,256, fp_temp))                  /* Get one line from the temporary appointment file */
    {
	flag++;
	strncpy (&file[6], line, 5);                       /* Add the date to the end of the file name */
	printf ("You have been scheduled for the following appointment on %s\n%s\n", &file[6], line + 5);
	if ((fd = open (file, 0)) == -1)		/* Does the user have any other appointments? */
	    printf ("There are no other appointments on this day\n");
	else
	{						/* Other appointments exist */
	    printf ("Other appointments for this day are:\n");
	    while (num_chars = read (fd, buffer, 512))  /* Print out appointments for the day */
		write (1, buffer, num_chars);
	    close (fd);
	}
	printf ("Do you wish to keep this appointment? (y or n): ");
							/* Get a valid response */
	while  (!gets(answer) || (*answer != 'y' && *answer != 'n'))
		printf ("Enter y or n only: ");
	if (*answer == 'y')
	{
	    copy (line + 5, appoint);
	    writeappoint (file, appoint);		/* Write appointment out */
	}
    }
    if ((fd = creat (TEMP, 0666)) == -1)		/* Empty the temporary appointment file out */
    {
	printf ("acceptappt: cannot empty %s\n", TEMP);
	exit (EACCES);
    }
    close (fd);
    close (iobuf.fildes);
    if (!flag)
	write (1, NOTEMP, sizeof (NOTEMP));
    exit (ENOERR);
}
