h33713
s 00000/00000/00224
d D 1.2 83/05/12 15:11:07 jan 2 1
c USENIX Distribution version
e
s 00224/00000/00000
d D 1.1 82/10/06 12:23:33 jan 1 0
e
u
U
t
T
I 1
/*
Name:
	DID Calendar System Command

Function:
	Complete dolist item.

Algorithm:
	Scan the user supplied list file for the requested item and extract
	it from the list file. If no user file is supplied, look in the
	users $HOME/exec directory to find the default file. Then use the
	current default dolist. Then append the item to the appropriate
	done file. Then sort/list the new list file.

Parameters:
	item number             the line number of the list item in the list file
	user supplied list file
		or
	default file in $HOME/exec/default

Returns:
	ENOERR	Normal exit
	EFORM	Bad date format or incorrect number of command line arguments

Files and Programs:
	user supplied list file
	TEMPFILE                                        temporary file for extraction

Installation Instructions:
	Compile as follows: cc -o $EXEC.DIR/susdo susdo.c ../library
	Change owner to root
	Deny write permissions except for owner

History:
	Dec 79,	Release 2 Version 1, G. Maltagliati, coded in shell
	Nov 80,	Release 5 Version 1, G. Maltagliati, coded in C for efficiency
	Jul 82, Release 7 Version 1, L. Reed, for Perkin-Elmer
	Aug 82, Release 7 Version 2, J. Neyer...rewrite exec support


*/
#include <stdio.h>
#include "../includes/error.h"
#include "../includes/getdef.h"
#define TEMPFILE "/tmp/didXXXXXX"
#define USAGE "You must enter:  did item-number <list-file>\n"

char id[] = "%W% %H%";

/*

Name:
	main

Function:
	Validate parameters. Open the list file.
	Complete the item. List the dolist file.

Algorithm:
	Insure that the correct number of arguments were entered on the command
	line. Determine if a user supplied list file was given and open it if
	so. Otherwise, find the default dolist file in $HOME/exec/default
	and open it. Call diddo to extract the item from the dolist and
	complete it. Call dolist_call to sort and re-display the new
	dolist. Close the files and exit.

Parameters:
	item number		the line number of the dolist item in the dolist file
	user supplied list file or default list file

Returns:
	ENOERR	Normal exit
	EFORM	Bad date format or incorrect number of command line arguments

Files and Programs:
	user supplied list file or default list file


*/
main (argc, argv, envp)
int     argc;						/* Count of command line arguments */
char   *argv[];						/* Pointer to list of argument pointers */
char   **envp;                  /* the environment */
{


    char listfile[80],
	 *line,
	 *lfile = listfile;                             /* Pointer to list file name */

    FILE *fp;

    extern char *getline();
    extern char *mktemp();
    extern char *sprintf();
    extern char *strcat();
    extern char *findenv();

    if (argc < 2 || argc > 3)       {
	fprintf (stderr, USAGE);
	exit(EFORM);
    }
    if (argc == 2)      {
	strcat (lfile, (findenv("HOME", envp)));        /* Get the HOME directory */
	strcat(lfile, "/");
	strcat (lfile, DEFAULT);
	if ((fp = fopen(lfile, "r")) == NULL)   {       /* Try to open default */
	    fprintf (stderr, "did: cannot open default file %s\n", lfile);
	    exit (EACCES);
	}
	if ((line = getline(fp)) == NULL)    {         /* Get the default dolist */
	    fprintf (stderr, "did: default file empty\n");
	    exit (EACCES);
	}
	strcpy(lfile, line);
	if ((fclose(fp)) == EOF)                             {
	    fprintf (stderr,"did: cannot close file %s\n", lfile);
	    exit (EACCES);
	}
    }
    else        {
	strcpy(lfile, findenv("HOME", envp));          /* User supplied list */
	strcat(lfile, "/exec/dolist/");
	strcat(lfile, argv[2]);
    }
    diddo(lfile, argv[1], envp);
    dolist_call(lfile, findenv("USER", envp));
    exit(ENOERR);
}
/*

Name:
	diddo

Function:
	Remove the item from the dolist and add it to the done file.

Algorithm:
	Open a temp file. Extract the do item and append it to done file.
	Copy rest of list file to temp. Close the list and temp files.
	Copy the temp file back to the list file. Unlink the temp file.
	Error exit if temp file problems.

Parameters:
	list file               pointer to list file
	item number		the line number of the dolist item in the dolist file

Returns:
	ENOERR	Normal exit
	EACESS  Access error to files.

Files and Programs:
	user supplied list file or default list file


*/
diddo (lfile, item, envp)
char *lfile,
     *item,
    **envp;

{
    char   *tfile,                                      /* Pointer to temp file name */
	   *line,                                       /* Holds extracted line */
	    com_buf[CMDLEN],
	   *command = com_buf;
    char   donefile[CMDLEN],
	   *dfile = donefile;
    int     index, colcount = 0,
	    tvec[2];                        /* Time system call return info */
    FILE   *dfp, *tfp, *fp;


    if ((fp = fopen(lfile, "r")) == NULL)   {           /* Open dolist */
	fprintf (stderr, "did: cannot open dolist %s\n", lfile);
	exit (EACCES);
    }
    tfile = mktemp (TEMPFILE);
    if ((tfp = fopen(tfile, "a")) == NULL)      {
	fprintf(stderr, "did: cannot open temp file %s\n", tfile);
	exit (EACCES);
    }
    sprintf(dfile, "%s", findenv("HOME", envp));
    strcat (dfile, DONEFILE);
    if ((dfp = fopen(dfile, "a")) == NULL)      {
	fprintf (stderr, "susdo: cannot open done file %s\n", dfile);
	exit (EACCES);
    }
    for (index = 1; ((line = getline(fp)) != NULL); index++)
	if (index != atoi(item))        {
	    fputs (line, tfp);
	    fputc ('\n', tfp);
	}
	else    {
	    while (*line != FIELDCHAR || colcount < 5)        {
		fputc(*line, dfp);
		if (*line == FIELDCHAR)
		    colcount++;
		line++;
	    }
	    time(tvec);                                   /* Get current time */
	    fprintf(dfp , "%s", (cnv_time(tvec)));        /* Put converted time */
	    fputs (line, dfp);
	    fputc ('\n', dfp);
	}
    if ((fclose(tfp)) == EOF)     {
	fprintf (stderr, "cannot close file %s\n", tfile);
	exit (EACCES);
    }
    if ((fclose(fp)) == EOF)      {
	fprintf (stderr, "cannot close file %s\n", lfile);
	exit (EACCES);
    }
    sprintf(command, "cp %s %s", tfile, lfile);
    if ((system(command)) != 0)             {                /* Copy the temp file */
	fprintf (stderr, "did: error on system call\n");
	exit (ESYSTEM);
    }
    if ((unlink (tfile)) == -1)         {
	fprintf (stderr, "did: error unlinking temp file %s\n", tfile);
	exit (EUNLINK);
    }
    return;
}
E 1
