h52688
s 00167/00000/00000
d D 1.1 83/02/01 17:13:03 jan 1 0
e
u
U
t
T
I 1
#include <stdio.h>
#define   ALPHA  01
#define   NUMER  02
#define   DELIM  04
#define   COLON 010

/*

Name:
	gettime

Function:
	To produce a character string of the form HHNN when passed a variety
of input strings representing the time.

Algorithm:
	Keep two buffers, one for alphabetic values and another for numeric
values.  Determine each character type and place it in the appropriate buffer.
If the character is a delimiter (e.g. a space) or a colon, simply skip it and
examine the next character.  Return with an error on any invalid character.
Convert the numeric buffer into an integer and return with error if it is over
2400.  Extract the hours and minutes from this combination time.  If there
are more than two characters in the alphabetic buffer (representing a.m. or
p.m.) return with error.  If the alphabetic buffer contains two characters,
the first being a 'p', increment the hour value by 12.  If the alphabetic
buffer contains two characters and the hour value is over 12, return with error.
If the alphabetic buffer is empty assume military time and do not modify hour
or minute values.  Build a string with the ascii conversions of these two
values.

Parameters:
	A character pointer representing a raw time format, one of the following:

	1) HH:NN a.m.  -- For morning times.  All spaces, colons, periods are 
	   ignored; order of alpha and numeric fields are irrelevant.  Therefore,
	   am1030 is also a valid parameter.

	2) HH:NN p.m. -- For evening times.

	3) HHNN -- Military 24 hour clock.  Delimiters and colons ignored.
	   This form may not include any alphabetic characters (a.m. or p.m.)

Returns:
	A pointer to a four character string, of the form HHMM.

Files and Programs:
	None.

History:



*/
   static char ID[] = "%W% %H%";
   extern int typeof();
   extern char *itoa();
	  int   atoi();

char *gettime (rawtime,tm_flag)
char   *rawtime;
int     tm_flag;
{
	static char     hourbuf[5];
	char   *hourptr = hourbuf;
	char    numbuf[10];
	char   *numptr = numbuf;
	char    alphabuf[5];
	char   *alphaptr = alphabuf;
	int     alphaindex  = 0;
	int     comb_time,
		minutes = 0,
		hours = 0,
		hrs = 0,
		num = 0,
		flag = 0;
	char    ans_buf[256],
	       *answer = ans_buf,
	       *ans;
	char    temp;
	while (*rawtime){
		switch (typeof (*rawtime)) {
			case NUMER: 
				*numptr++ = *rawtime++;
				num += 1;
				break;
			case ALPHA: 
				*alphaptr++ = *rawtime++;
				alphaindex++;
				break;
			case DELIM: 
			case COLON: 
				*rawtime++;
				break;
			default: 
				return (NULL);
		}
	}
	if (alphaindex == 0 && num != 4) {
	   if (tm_flag == 1) {
	      printf("\nFor Starting time, please enter  a  or  p only: ");
	      ans = gets(answer);
	      while (*ans != 'a' && *ans != 'p' ){
		printf("\nINVALID OPTION!! :, please enter  a  or  p only: ");
		ans = gets(answer);
	      }
	   }
	   else {
	      printf("\nFor Ending time, please enter a or p only: ");
	      ans = gets(answer);
	      while (*ans != 'a' && *ans != 'p' ){
		printf("\nINVALID OPTION!! :, please enter  a  or  p only: ");
		ans = gets(answer);
	      }
	   }
	   *alphaptr = *ans;
	   alphaindex++;
	}
	temp = alphabuf[0];
	*numptr = *alphaptr = '\0';
	if ((comb_time = atoi (numbuf)) > 2400)
		return (NULL);
	else {
		if (comb_time <= 12)
		   hours = comb_time;
		else
		   {
		    hours = comb_time / 100;
		    if ((minutes = comb_time - (hours * 100)) >= 60)
			return (NULL);
		   }
		hrs = hours;
		if (alphaindex > 0) {
			if (hrs > 12)
				return (NULL);
			else
			    if (temp == 'p' && hrs < 12)
				hrs += 12;
		}
		else
			if (alphaindex != 0)
				return (NULL);

		if (hrs == 0 ) {
		   hrs = 12;
		   minutes = 0;
		   flag = 1;
		}
		hourptr = copy (itoa (hrs), hourptr);
		if (minutes < 10){
		    *hourptr++ = '0';
		}
		hourptr = copy (itoa (minutes), hourptr);
		if (atoi(hourbuf) < 1200)
		   flag = 1;
		if (num != 4)
		   *hourptr = temp;
		else {
		     if (atoi(hourbuf) >= 1200 && !flag)
			temp = 'p';
		     else
			if (atoi(hourbuf) <= 1200 && flag)
			   temp = 'a';
		     *hourptr = temp;
		     }
	}
	return (hourbuf);
}
E 1
