/*
Name:
	SUSACT Calendar System Command

Function:
	Move a suspense item to the proper dolist

Algorithm:
	Cycle through the /u directory looking for users with suspense
	files for the current date. If found, move the items to the
	appropriate list files.

Parameters:
	NONE

Returns:
	ENOERR	Normal Exit
	ENOENT	Bad home directory or no dolist file

Files and Programs:
	user suspense files
	user list files

Installation Instructions:
	Compile cc -o exec.dir/susact susact.c ../library
	Change owner to root
	Deny write permissions except for owner

History:
	Aug 82, Release 7 Version 2, J. Neyer...original version


*/
#include <time.h>
#include <stdio.h>
#include <pwd.h>
#include "../includes/error.h"
#include "../includes/getdef.h"
#include <sys/types.h>
#include <sys/stat.h>

char    date_array[8];                              /* The date in the week for dailycal to start in */
char   *date = date_array;                          /* Points to date */
char    tdate[10];                                  /* Holds default date */
char   *tempdate = tdate;
char    sus_name[10],
       *sus_file = sus_name;
int     tloc[2];                              /* Return from time system call */
struct tm *tp;

char id[] = "%W% %H%";

/*

Name:
	main

Function:
	Activate suspense items for the day.

Algorithm:
	Setup suspense file name using todays date.
	Loop through password file getting user home directories.
	For each home directory, if there is an "exec" directory, look
	for "suspenses" sub-directory. If found, look for a file matching
	the previously built suspense file name. If found, call do_it to
	move items from the suspense list to the proper do list.

Parameters:
	None

Returns:
	ENOERR	Normal exit

Files and Programs:
	None


*/
main( argc, argv, envp)

int argc;
char *argv[];
char **envp;
{
    int     index;

    struct passwd *pw;

    if (setuid(0) == -1)        {            /*     Become super user  */
	fprintf(stderr, "susact: cannot setuid\n");
	exit();
    }

    time(tloc);                                 /* Get the current time */
    tp = localtime(tloc);
    tp->tm_yday += 1;
    tempdate = copy(itoa(tp->tm_year,2),tempdate);
    tempdate = copy(itoa(tp->tm_yday,3),tempdate);
    if (!valid_date (tdate, date, 1)) {
	    fprintf(stderr, "susact: serious system error in date conversion\n");
	    exit(EFORM);
    }
    strcat(sus_file, "sus.");
    strcat(sus_file, date);
    for (index = 0; index < MAXUSERS; index++)
	if ((pw = getpwuid(index)) != NULL)
	    do_it(pw);
    exit(ENOERR);
}
/*

Name:
	do_it

Function:
	Activate suspense items for the day for a given user.

Algorithm:
	Given a password file structure, change to the home directory and
	check for "exec" subdirectory. If found, changes to it and look
	for "suspenses" directory. If found, change to it and look for
	file namematching sus_file. If found, for each record in sus_file,
	determine its proper dolist and place it there. Remove the sus_file
	when done.

Parameters:
	Password structure from getpwuid

Returns:
	ENOERR	Normal exit

Files and Programs:
	Suspense and list files.


*/
do_it(pw)
struct passwd *pw;
{
    int index;
    char linebuf[256];
    char *line, *save;
    struct stat *stat_buf;
    FILE *sfp, *dfp;

    if (chdir(pw->pw_dir) == -1)
	return;                                 /* No directory...forget it */
    if (chdir("exec") == -1)
	return;                                 /* Can't access exec */
    if (chdir("suspenses") == -1)
	return;                                 /* No suspense directory */
    if (stat(sus_file, stat_buf) == -1)
	return;                                 /* No suspenses for today */
    if ((sfp = fopen(sus_file, "r")) == NULL)
	return;                                 /* Can't open susfile */
    fprintf(stderr, "susact: processng suspenses for %s for %s\n", sus_file, pw->pw_name);
    while (line = getline(sfp)) {
	save = line;
	for (index = 0; index < 7; index++)
	    while (*line++ != ':');
	if ((dfp = fopen(line, "a")) == NULL)   {
	    fprintf(stderr, "susact: cannot open list file %s for %s\n", line, pw->pw_name);
	    return;                             /* Can't open list file */
	}
	line = save;
	for (index = 0; index < 5; index++)     {       /* Copy item until get to current date field */
	    while (*line != ':')
		fputc(*line++, dfp);
	    fputc(*line++, dfp);
	}
	for (; *line != ':'; line++);                   /* Eat up old time stamp */
	fputs(cnv_time(tloc), dfp);                     /* Put in current date */
	fputs(line, dfp);
	fputc('\n', dfp);
	fclose(dfp);
    }
    fclose(sfp);
    unlink(sus_file);
}
